; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=x86_64-linux -mcpu=nehalem < %s | FileCheck %s --check-prefix=LIN
; RUN: llc -mtriple=x86_64-win32 -mcpu=nehalem < %s | FileCheck %s --check-prefix=WIN
; RUN: llc -mtriple=i686-win32 -mcpu=nehalem < %s | FileCheck %s --check-prefix=LIN32
; rdar://7398554

; When doing vector gather-scatter index calculation with 32-bit indices,
; use an efficient mov/shift sequence rather than shuffling each individual
; element out of the index vector.

define <4 x double> @foo(double* %p, <4 x i32>* %i, <4 x i32>* %h) nounwind {
; LIN-LABEL: foo:
; LIN:       # %bb.0:
; LIN-NEXT:    movdqa (%rsi), %xmm0
; LIN-NEXT:    pand (%rdx), %xmm0
; LIN-NEXT:    pextrq $1, %xmm0, %rax
; LIN-NEXT:    movq %xmm0, %rcx
; LIN-NEXT:    movslq %ecx, %rdx
; LIN-NEXT:    sarq $32, %rcx
; LIN-NEXT:    movslq %eax, %rsi
; LIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; LIN-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; LIN-NEXT:    sarq $32, %rax
; LIN-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; LIN-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; LIN-NEXT:    retq
;
; WIN-LABEL: foo:
; WIN:       # %bb.0:
; WIN-NEXT:    movdqa (%rdx), %xmm0
; WIN-NEXT:    pand (%r8), %xmm0
; WIN-NEXT:    pextrq $1, %xmm0, %rax
; WIN-NEXT:    movq %xmm0, %rdx
; WIN-NEXT:    movslq %edx, %r8
; WIN-NEXT:    sarq $32, %rdx
; WIN-NEXT:    movslq %eax, %r9
; WIN-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; WIN-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; WIN-NEXT:    sarq $32, %rax
; WIN-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; WIN-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; WIN-NEXT:    retq
;
; LIN32-LABEL: foo:
; LIN32:       # %bb.0:
; LIN32-NEXT:    pushl %edi
; LIN32-NEXT:    pushl %esi
; LIN32-NEXT:    movl {{[0-9]+}}(%esp), %eax
; LIN32-NEXT:    movl {{[0-9]+}}(%esp), %ecx
; LIN32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; LIN32-NEXT:    movdqa (%edx), %xmm0
; LIN32-NEXT:    pand (%ecx), %xmm0
; LIN32-NEXT:    pextrd $1, %xmm0, %ecx
; LIN32-NEXT:    pextrd $2, %xmm0, %edx
; LIN32-NEXT:    pextrd $3, %xmm0, %esi
; LIN32-NEXT:    movd %xmm0, %edi
; LIN32-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; LIN32-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; LIN32-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; LIN32-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; LIN32-NEXT:    popl %esi
; LIN32-NEXT:    popl %edi
; LIN32-NEXT:    retl
  %a = load <4 x i32>, <4 x i32>* %i
  %b = load <4 x i32>, <4 x i32>* %h
  %j = and <4 x i32> %a, %b
  %d0 = extractelement <4 x i32> %j, i32 0
  %d1 = extractelement <4 x i32> %j, i32 1
  %d2 = extractelement <4 x i32> %j, i32 2
  %d3 = extractelement <4 x i32> %j, i32 3
  %q0 = getelementptr double, double* %p, i32 %d0
  %q1 = getelementptr double, double* %p, i32 %d1
  %q2 = getelementptr double, double* %p, i32 %d2
  %q3 = getelementptr double, double* %p, i32 %d3
  %r0 = load double, double* %q0
  %r1 = load double, double* %q1
  %r2 = load double, double* %q2
  %r3 = load double, double* %q3
  %v0 = insertelement <4 x double> undef, double %r0, i32 0
  %v1 = insertelement <4 x double> %v0, double %r1, i32 1
  %v2 = insertelement <4 x double> %v1, double %r2, i32 2
  %v3 = insertelement <4 x double> %v2, double %r3, i32 3
  ret <4 x double> %v3
}

; Check that the sequence previously used above, which bounces the vector off the
; cache works for x86-32. Note that in this case it will not be used for index
; calculation, since indexes are 32-bit, not 64.
define <4 x i64> @old(double* %p, <4 x i32>* %i, <4 x i32>* %h, i64 %f) nounwind {
; LIN-LABEL: old:
; LIN:       # %bb.0:
; LIN-NEXT:    movdqa (%rsi), %xmm0
; LIN-NEXT:    pand (%rdx), %xmm0
; LIN-NEXT:    pextrq $1, %xmm0, %rax
; LIN-NEXT:    movq %rax, %rdx
; LIN-NEXT:    shrq $32, %rdx
; LIN-NEXT:    movq %xmm0, %rsi
; LIN-NEXT:    movq %rsi, %rdi
; LIN-NEXT:    shrq $32, %rdi
; LIN-NEXT:    andl %ecx, %esi
; LIN-NEXT:    andl %ecx, %eax
; LIN-NEXT:    andq %rcx, %rdi
; LIN-NEXT:    andq %rcx, %rdx
; LIN-NEXT:    movq %rdi, %xmm1
; LIN-NEXT:    movq %rsi, %xmm0
; LIN-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; LIN-NEXT:    movq %rdx, %xmm2
; LIN-NEXT:    movq %rax, %xmm1
; LIN-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; LIN-NEXT:    retq
;
; WIN-LABEL: old:
; WIN:       # %bb.0:
; WIN-NEXT:    movdqa (%rdx), %xmm0
; WIN-NEXT:    pand (%r8), %xmm0
; WIN-NEXT:    pextrq $1, %xmm0, %r8
; WIN-NEXT:    movq %r8, %rcx
; WIN-NEXT:    shrq $32, %rcx
; WIN-NEXT:    movq %xmm0, %rax
; WIN-NEXT:    movq %rax, %rdx
; WIN-NEXT:    shrq $32, %rdx
; WIN-NEXT:    andl %r9d, %eax
; WIN-NEXT:    andl %r9d, %r8d
; WIN-NEXT:    andq %r9, %rdx
; WIN-NEXT:    andq %r9, %rcx
; WIN-NEXT:    movq %rdx, %xmm1
; WIN-NEXT:    movq %rax, %xmm0
; WIN-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; WIN-NEXT:    movq %rcx, %xmm2
; WIN-NEXT:    movq %r8, %xmm1
; WIN-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; WIN-NEXT:    retq
;
; LIN32-LABEL: old:
; LIN32:       # %bb.0:
; LIN32-NEXT:    pushl %ebp
; LIN32-NEXT:    movl %esp, %ebp
; LIN32-NEXT:    pushl %esi
; LIN32-NEXT:    andl $-16, %esp
; LIN32-NEXT:    subl $32, %esp
; LIN32-NEXT:    movl 20(%ebp), %eax
; LIN32-NEXT:    movl 16(%ebp), %ecx
; LIN32-NEXT:    movl 12(%ebp), %edx
; LIN32-NEXT:    movaps (%edx), %xmm0
; LIN32-NEXT:    andps (%ecx), %xmm0
; LIN32-NEXT:    movaps %xmm0, (%esp)
; LIN32-NEXT:    movl (%esp), %ecx
; LIN32-NEXT:    andl %eax, %ecx
; LIN32-NEXT:    movl {{[0-9]+}}(%esp), %edx
; LIN32-NEXT:    andl %eax, %edx
; LIN32-NEXT:    movl {{[0-9]+}}(%esp), %esi
; LIN32-NEXT:    andl %eax, %esi
; LIN32-NEXT:    andl {{[0-9]+}}(%esp), %eax
; LIN32-NEXT:    movd %edx, %xmm1
; LIN32-NEXT:    movd %ecx, %xmm0
; LIN32-NEXT:    punpcklqdq {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; LIN32-NEXT:    movd %eax, %xmm2
; LIN32-NEXT:    movd %esi, %xmm1
; LIN32-NEXT:    punpcklqdq {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; LIN32-NEXT:    leal -4(%ebp), %esp
; LIN32-NEXT:    popl %esi
; LIN32-NEXT:    popl %ebp
; LIN32-NEXT:    retl
  %a = load <4 x i32>, <4 x i32>* %i
  %b = load <4 x i32>, <4 x i32>* %h
  %j = and <4 x i32> %a, %b
  %d0 = extractelement <4 x i32> %j, i32 0
  %d1 = extractelement <4 x i32> %j, i32 1
  %d2 = extractelement <4 x i32> %j, i32 2
  %d3 = extractelement <4 x i32> %j, i32 3
  %q0 = zext i32 %d0 to i64
  %q1 = zext i32 %d1 to i64
  %q2 = zext i32 %d2 to i64
  %q3 = zext i32 %d3 to i64
  %r0 = and i64 %q0, %f
  %r1 = and i64 %q1, %f
  %r2 = and i64 %q2, %f
  %r3 = and i64 %q3, %f
  %v0 = insertelement <4 x i64> undef, i64 %r0, i32 0
  %v1 = insertelement <4 x i64> %v0, i64 %r1, i32 1
  %v2 = insertelement <4 x i64> %v1, i64 %r2, i32 2
  %v3 = insertelement <4 x i64> %v2, i64 %r3, i32 3
  ret <4 x i64> %v3
}
