/*****************************************************************************
 * 
 *  jsMath: Mathematics on the Web
 *  
 *  This jsMath package makes it possible to display mathematics in HTML pages
 *  that are viewable by a wide range of browsers on both the Mac and the IBM PC,
 *  including browsers that don't process MathML.  See
 *  
 *            http://www.math.union.edu/locate/jsMath
 *
 *  for the latest version, and for documentation on how to use jsMath.
 *
 *  Copyright 2004-2007 by Davide P. Cervone
 * 
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *  
 *****************************************************************************/

if (!window.jsMath) {jsMath = {}}
if (!jsMath.Script) {jsMath.Script = {}}

jsMath.Script.Uncompress = function (data) {
  for (var k = 0; k <  data.length; k++) {
    var d = data[k]; var n = d.length;
    for (var i = 0; i < n; i++) {if (typeof(d[i]) == 'number') {d[i] = d[d[i]]}}
    data[k] = d.join('');
  }
  eval(data.join(''));
}

//start = new Date().getTime();
jsMath.Script.Uncompress([
  ['if(!','window','.jsMath','||!',1,'.','jsMath.','loaded','){var ','jsMath_old','=',1,2,';',0,'document.','getElementById','||!',15,'childNodes||!',15,'createElement','){','alert("','The',' mathematics ','on this page requires W3C DOM support in its JavaScript. "+"Unfortunately, your ','browser',' doesn\'t seem to have this.")}','else{',1,2,'={version:"3.4f",document:document,',1,':',1,',','platform',':(','navigator.',37,'.match(/','Mac/)?"mac":',39,37,41,'Win/)?"pc":"unix"),','sizes',':[50,60,70,85,100,120,144,173,207,249],','styles',':{".math','":"font-family:serif; font-style:normal; font-weight:normal','",".typeset',51,'; ','line-height:normal','","div.','typeset','":"text-align',':center; margin:1em 0px;","span.',57,58,':left',52,' span',58,62,'; border:','0px; margin:0px; ','padding:0px','",".typeset .','normal',51,70,'size0','":"font-size:','50','%",".typeset .','size1',75,'60',77,'size2',75,'70',77,'size3',75,'85',77,'size4',75,'100',77,'size5',75,'120',77,'size6',75,'144',77,'size7',75,'173',77,'size8',75,'207',77,'size9',75,'249',77,'cmr10','":"font-family:jsMath-','cmr10, serif',70,'cmbx10',115,118,', ','jsMath-cmr10',70,'cmti10',115,124,', ',122,70,'cmmi10',115,130,70,'cmsy10',115,134,70,'cmex10',115,138,70,'textit":"','font-family',':serif; ','font-style:italic',70,'textbf":"',143,':serif; font-weight:bold',70,'link":"','text-decoration:none',70,'error',75,'10pt; ',145,'; "+"','background-color',':#FFFFCC; padding:1px',158,'border:','1px solid',' #CC0000',70,'blank":"','display:inline-block','; ','overflow:hidden',67,'0px none; width:0px','; height:','0px;",".',57,' .','spacer','":"',167,'","#jsMath_hiddenSpan":"','visibility',':','hidden','; ','position:absolute','; top:0px',';left:0px',158,55,'; text-indent:0px","#','jsMath_message','":"','position:fixed','; bottom:','1px; left:2px; ',159,':#E6E6E6','; "+"border:solid 1px #959595; margin:0px; padding:','1px 8px','; "+"z-index:102; color',': black','; font-size:','small; ','width:auto',';","#','jsMath_panel','":"',192,193,'1.5em; right:1.5em','; padding:.8em 1.6em',158,159,':#DDDDDD',67,'outset 2px',158,'z-index:103; ',203,'; color:black',201,'10pt; font-style:normal","#',205,' .disabled":"color:#888888","#',205,' .infoLink',75,'85%","#',205,' *":"','font-size:inherit; font-style:inherit; font-family:inherit','; ',55,'","#',205,' div":"',159,':inherit; color:inherit;","#',205,' span":"',159,237,205,' td','":"border:0px; padding:0px; margin:0px; background-color:inherit; color:inherit;","#',205,' tr',244,205,' table',244,'jsMath_button','":"',192,193,'1px; right:2px; ',159,':white',197,'0px 3px 1px 3px',199,':black; ',152,201,'x-small',158,203,'; cursor:hand;","#',251,229,69,67,68,55,158,230,'","#jsMath_global":"',145,';","#jsMath_float','":"',184,185,'; left:0px; max-width:80%; "+"z-index:101; ',203,'; height:auto',278,' .drag":"',159,':#DDDDDD',67,'outset 1px',172,'12px',201,'1px',278,' .close":"',159,196,67,'inset 1px; width:8px',172,'8px; margin:1px 2px',278,' .source":"',159,':#E2E2E2',67,290,158,203,284,'; padding:8px 15px',158,143,':courier, fixed',201,'90%","#jsMath_noFont .message',58,': center',210,67,'3px solid #DD0000',158,159,':#FFF8F8; color: #AA0000',201,202,203,204,'jsMath_noFont .link','":"',69,' 5px 2px 5px',67,'2px outset; ',159,':#E8E8E8',158,'color:black',201,'80%; ',203,267,'jsMath_PrintWarning',' .message',58,':center',210,67,'3px solid #DD0000',158,159,': #FFF8F8; color: #AA0000',201,'x-',202,203,';","@media print":"#',251,' {display:none','}\\n"+"#jsMath_Warning',360,'}","@media screen":"#',344,360,'}"},Element',':function(','A){return ',6,15,16,'("jsMath_"+A)},','BBoxFor',367,'A','){this.','hidden.innerHTML','="<nobr><','span class=\\"',57,'\\"><',379,'scale\\">"+A+"</span></span></nobr>";var B={w:this.',182,'.offsetWidth',',h:this.',182,'.offsetHeight','};this.',377,'="";return B},EmBoxFor',367,'B){var A=',6,'Global.cache.R;if(!A[this.em]){A[this.em]={}}if(!A[this.em][B]){var C=this.BBoxFor(B);','A[this.em][B]={w:C.w/this.em,h:C.h/this.em}}return A[this.em][B]},','EmBoxForItalics',367,393,6,395,'if(B.match(/<i>|class=\\"(icm|italic|igreek|iaccent)/i)){C.w=C.Mw','=this.BBoxFor','(B+',6,'Browser.','italicString',').w-',6,406,'italicCorrection','}',396,'Init',':function(){','if(',6,'Setup.inited','!=1){',0,6,418,'){',6,'Setup.','Body()}if(',6,418,'!=1){if(',6,418,'==-100','){return }',23,'It looks like jsMath failed to set up properly (error code "+',6,418,'+").  "+"I will try to keep going, but it could get ugly.");',6,418,'=1}}this.em',403,'("<span style=\\""+',6,406,'block+";','width:13em;height:1em','\\"></span','>").w/13;','if(this.','em==0',376,'em',403,'("<img src=\\""+',6,'blank+"\\" style=\\"',447,'\\"/>").w/13}','var A=',6,'Global.cache','.B;',0,'A[this.em]){A[this.em]={};','A[this.em].','bb',403,'("x");','var C=',466,'bb.h;',466,'d',403,'("x"+',6,'HTML.Rule(1,','C/',6,'em)).h-C;if(',6,406,407,'){',466,'ic=',6,373,'(',6,406,407,').w}}',6,406,411,'=',466,'ic;var F=',466,'bb;var D=F.h;var E=',466,'d;this.h=(D-E)/this.em;this.d=E/this.em;this.hd=this.h+this.d;this.xWidth=F.w;this.',425,'TeXfonts','();var B=this.EmBoxFor("<',379,'cmr10\\">M</span>").w/2;this.TeX.M_height=B*(26/14);this.TeX.h=this.h;this.TeX.d=this.d;this.TeX.hd=this.hd;this.Img.Scale();',0,'this.initialized',376,425,'Sizes','();this.','Img.UpdateFonts()}this.p_height=(','this.TeX.cmex10[0].','h+',517,'d)/0.85;',511,'=1},ReInit',415,'var A',403,'("x").w;if(A!=this.xWidth',376,'Init()}},Loaded',415,'if(',9,8,'B=["Process","ProcessBeforeShowing","ConvertTeX","ConvertTeX2","ConvertLaTeX","ConvertCustom","CustomSearch","Synchronize","Macro","document"];','for(var A=0;A<','B','.length;A++){','if(',9,'[B[A]]){','delete ',9,'[B[A]]}}}if(',9,376,'Insert(jsMath,',9,')}',9,'=null;',6,7,'=1},Add',367,'C,A){for(var B in A){','C[B]=A[B]}},Insert',367,554,'if(C[B]&&typeof (A[B])=="object"&&(','typeof (C[B])=="','object"||',559,'function")){this.Insert(C[B],A[B])}',29,'C[B]=A[B]}}},Package',367,'B,A',376,'Insert(B.prototype,A)}};',6,'Global={isLocal:1,cache:{','T:{},D:{},R:{},B',':{}},ClearCache',415,6,462,'={',571,':{}}},GoGlobal',367,393,'String(',6,1,'.','location);var C','=(',6,'isCHMmode','?"#":"?");if(B){A=A.replace(/\\?.*/,"")+"?"+B}',6,'Controls.','Reload(',6,'root+"jsMath-','global.html"+C+escape(A))},Init',415,'if(',6,'Controls.cookie.','global=="always"&&!',6,'noGoGlobal','){','if(navigator.','accentColorName',433,0,6,1,'){',6,1,'=',1,'}',6,591,7,'=1;',6,591,'defaults.hiddenGlobal',549,'this.GoGlobal(',6,591,'SetCookie(2))}},Register',415,460,6,1,'.parent;',0,6,'isCHMode){',6,588,'=(',6,1,'.','location.','protocol=="mk:")}try{',0,6,588,376,'Domain()}if(A',2,'&&A.',6,'isGlobal){A.',6,'Register(',6,1,')}}catch(B){',6,602,'=1}},Domain',415,604,'appName=="Microsoft Internet Explorer"&&',6,37,'=="mac"&&',39,'userProfile','!=null',433,'if(',1,'==parent',433,'var B=',6,15,'domain;try{while(true){try{if(parent.',15,'title',669,'){return }}','catch(A){}',0,15,'domain.match(/\\..*\\./)){break}',6,15,'domain=',6,15,'domain.replace(/^[^.]*\\./,"")}}',683,6,15,689,'B}};',6,'Script={request:null,Init',415,'if(!(',6,599,'asynch&&',6,599,'progress',')){if(',1,'.XMLHttpRequest','&&!(',6,15,'URL&&',6,15,'URL.match(/^file:\\/\\/.*\\\\/))){try{','this.request','=new XMLHttpRequest}catch(C){}}',0,718,'&&',1,'.','ActiveXObject',8,'A=["MSXML2.XMLHTTP.5','.0","MSXML2.XMLHTTP','.4',728,'.3',728,'","Microsoft.XMLHTTP"];','for(var B=0;B<','A.length&&!',718,';B++){try{',718,'=new ',725,'(A[B])}catch(C){}}}}',0,718,'||',6,425,'domainChanged',376,'Load=this.delayedLoad;this.needsBody=1}},Load',367,'B,A){','if(A){',6,'Message.Set("Loading "+','B);',6,'Script.','Delay(1);',6,'Script.Push(','this,"xmlRequest",B',');',6,760,6,'Message',',"Clear")}',29,6,760,761,')}},xmlRequest',367,'url){','this.blocking','=1;try{',718,'.open("GET",url,false);',718,'.send(null)}catch(err){',775,'=0;if(',6,'Translate.','restart&&',6,'Translate.asynchronous){return""}throw"jsMath can\'t load the file \'"+url+"\'\\n"+"',766,': "+err.message}if(',718,'.status','&&',718,791,'>=400){',775,782,6,784,'restart&&',6,787,'Error status: "+',718,791,'}',0,'url','.match(/\\.js$/)){','return(',718,'.responseText',')}var tmpQueue','=this.queue;this.queue','=[];',6,1,'.eval(',718,812,');',775,'=0;','this.queue=this.queue.','concat(','tmpQueue);this.Process();return""},cancelTimeout:30*1000,iframe:null,blocking:0,cancelTimer:null,needsBody:0,queue:[],Synchronize',367,'A,B){','if(typeof (','A)!="string"){',6,760,'null,A,B)}',29,6,760,6,1,',"eval",A)}},Push',367,'A,C,B',376,'queue[','this.queue.length',']=[A,C,B];if(!(',775,'||(this.needsBody&&!',6,15,'body))){this.Process()}},Process',415,'while(',844,'&&!',775,8,'C=this.queue[0];',824,'slice(1);',460,'this.SaveQueue();var B=C[0];var E=C[1];var D=C[2];if(B){B[E](D)}',29,'if(E){E(D)}}this.','RestoreQueue','(A)}},SaveQueue',415,'var A',814,'=[];return A},',864,367,'A){',824,825,'A)},delayedLoad',367,'A',376,'Push(this,"startLoad",A)},startLoad',367,'A){','this.iframe','=',6,15,21,'("iframe");','this.iframe.style.',180,'="',182,'";',888,'position="absolute";',888,'width="0px";',888,'height="0px','";if(',6,15,'body.firstChild','){',6,15,'body.insertBefore(',882,',',6,15,902,')}',29,6,15,'body','.appendChild(',882,')}',775,'=1;this.','url=A;',0,'A',809,882,'.src=A}',29,882,'.src=',6,594,'loader.html"}if(A.substr(0,',6,'root.length',')==',6,'root){A=A.substr(',6,935,')}',6,754,'A);','this.cancelTimer','=setTimeout("',6,757,'cancelLoad','()",this.cancelTimeout)},endLoad',367,'A){if(',945,'){clearTimeout(',945,');',945,'=null}',6,766,'.Clear();if(A!="cancel"){',775,'=0;this.Process','()}},Start',415,'this.tmpQueue',814,'=[]},End',415,824,825,966,');',540,966,'},',949,415,945,549,6,766,'.Set("Can\'t load file");this.endLoad("cancel")},Delay',367,'A){',775,'=1;setTimeout("',6,757,'endDelay','()",A)},',990,415,775,963,'()},','imageCount',':0,WaitForImage',367,'B){',775,921,997,'++;',450,'img==null',376,'img=[]}',460,'new Image',515,'img[this.img.length]=A;A.onload=function(){if(--',6,757,997,'==0){',6,757,990,'()}};A.onerror=A.onload;A.onabort=A.onload;A.src=B},Uncompress',367,'data){for(var k=0;k<data.length;k++){var d=data[k];var n=d.length;for(var i=0;i<n;i++){',829,'d[i])=="number"){d[i]=d[d[i]]}}data[k]=d.join("")}',1,818,'data.join(""))}};',6,766,'={blank:null,message:null,text:null,clear:null,Init',415,0,6,15,'body||!',6,599,707,433,'if(',6,425,'stylesReady){','this.message','=',6,'Setup.DIV("message",{visibility:"hidden','"})}',29,1044,'=',6,1047,'",position:"absolute",','bottom:"1px",left:"2px",','backgroundColor',':"#E6E6E6",border:"solid 1px #959595",margin:"0px",padding:"1px 8px",zIndex:102,color:"black",fontSize:"small",width:"auto"})}','this.text','=',6,15,'createTextNode','("");',1044,917,1058,');',1044,'.onmousedown=',6,784,'Cancel},Set',367,751,'if(this.clear){clearTimeout(this.clear',');this.clear=null}if(',6,599,707,'){',0,1058,376,'Init();',0,1058,682,'if(',6,406,'textNodeBug','){',1044,'.innerHTML','=B}',29,1058,'.nodeValue','=B}','this.message.style.',180,'="visible";',752,1100,'cursor="pointer";',0,1100,'cursor){',1100,'cursor="hand"}',1044,'.title=" Cancel Processing of Math "}',29,1100,'cursor="";',1044,'.title=""}}',29,'if(B.substr(0,8)!="Loading "){',6,1,791,'=B}}},Clear',415,1075,')}this.clear=setTimeout("',6,766,'.doClear()",1000)},doClear',415,450,'clear',376,'clear',549,6,1,791,'="";if(',1058,'){',1058,1098,'=""}if(',1044,'){',1100,180,'="',182,'"}}},Blank',415,'if(','this.blank','||!',6,15,'body',433,1154,'=',6,425,'DIV("blank",{position:(',6,406,'msiePositionFixedBug','?"absolute":"fixed"),top:"0px",left:"0px",bottom:"0px",right:"0px",zIndex:101,',1056,':"white"});if(',6,406,'msieBlankBug){',1154,1094,'="&nbsp;";',1154,'.style.width="110%";',1154,'.style.height="110%"}},UnBlank',415,'if(',1154,'){',6,15,'body.removeChild(',1154,')}',1154,'=null}};',6,'Setup={',7,':[],DIV',367,'D,B',8,'C=',6,15,21,'("div");C.id="jsMath_"+D;','for(var A in ','B){C.style[A]=B[A]}',0,6,15,'body.hasChildNodes){',6,15,'body',917,'C)}',29,6,15,906,'C,',6,15,902,')}return C},Script',367,751,450,7,'[B]){return }',29,'this.',7,'[B]=1}',0,'B.match("^([a-zA-Z]+:/?)?/")){B=',6,'root+B}',6,757,'Load(B,A)},Hidden',415,6,182,'=this.DIV("Hidden",{',180,':"',182,1054,'top:0,left:0,border:0,padding:0,margin:0});',6,'hiddenTop=',6,182,';return },Source',415,'if(',6,'Autoload','&&',6,1257,'.root){',6,'root=',6,1257,'.','root}',29,6,'root="";',460,6,15,'getElementsByTagName("','script");',752,734,'A.','length;B++){','var D=A[B].src;if(D&&D.match("(^|/|\\\\\\\\)',6,'js$")){',6,1263,'D.','replace(/',6,'js$/,"");break}}}}if(',6,'root.charAt(','0)=="\\\\"){',6,1263,6,'root.replace','(/\\\\/g,"/")}if(',6,1290,'0)=="/"){if(',6,1290,'1)!="/"){if(',6,15,642,'port){',6,'root=":"+',6,15,642,'port+',6,1267,6,'root="//"+',6,15,642,'host+',6,1267,6,1263,6,15,642,'protocol+',6,1267,29,0,6,'root.match','(/^[a-z]+:/i)){var D=','new String(',6,15,585,'=new RegExp("/[^/]*/\\\\.\\\\./");',6,1263,'D.replace(new RegExp("[^/]*$"),"")+',6,'root;while(',6,1334,'(C)){',6,1263,6,1295,'(C,"/")}}}',6,'Img.',1263,6,'root+"fonts/";',6,'blank=',6,'root+"blank.gif";this.Domain()},Domain',415,'try{',6,15,'domain}catch(D',433,'var C="";',460,6,15,'domain;if(',6,1334,'("://([^/]*)/")){C=RegExp.$1}C=C.replace(/:\\d+$/,"");if(C==""||C==A',433,604,'appName=="Microsoft Internet Explorer"&&',6,37,'=="mac"&&',39,'onLine&&',39,668,'&&',6,15,'all',433,'C=C.split(/\\./);A=A.split(/\\./);if(C.length<2||A.length<2||','C[C.length-','1',']!=A[A.length-','1]||',1393,'2',1395,'2]){this.','DomainWarning','();return }var E=',1393,'2]+"."+',1393,'1];for(var B=3;B<=C.length&&B<=A.',1279,'if(',1393,'B',1395,'B]){break}E=',1393,'B]+"."+E}',6,15,689,'E;this.',747,'=1},',1401,415,23,'In order for jsMath to be able to load the additional "+"components that it may need, the ',6,'js file must be "+"',7,' from a server in the same domain as the page that "+"contains it.  Because that is not the case for this page, "+"the',25,'displayed here may not appear correctly.")},','EncodeFont',367,'C',8,'B=',6,'TeX[C];if(B','[0].c',669,433,534,'128;A++){var D=B[A];B[A]=D[3];if(B[A]==null){B[A]={}}B[A].w=D[0];B[A].h=D[1];if(D[2]!=null){B[A].d=D[2]}B[A].c=',6,'TeX.encoding[A]}},Fonts',415,734,6,'TeX.fam.length;','B++){',460,6,'TeX.fam[','B];if(A',376,1431,'(A)}}},TeXfont',367,'C',8,'B=',6,1437,'==null',433,460,6,'EmBoxFor("<span class=\\""+C+"\\">"+B[65].c','+"</span>");B.hd=A.h;B.dh=0.05;B.d=',6,1467,'+',6,478,'B.hd)+"</span>").h-B.hd;B.h=B.hd-B.d;','if(C=="',130,'"){B.skewchar=','127}',29,1475,134,1477,'48}}},',506,415,534,6,1448,'A++){if(',6,1452,'A]){this.TeXfont(',6,1452,'A])}}},Sizes',415,6,'TeXparams','=[];var B;var A;for(A=0;A<',6,47,536,6,1498,'[A]={}}for(B in ',6,'TeX){',829,6,'TeX[B])!="object"){for(A=0;A<',6,47,536,6,1498,'[A][B]=',6,47,'[A]*',6,'TeX[B]/100}}}},Styles',367,'A){',0,'A){A=',6,49,';A[".',57,' .scale"]="font-size:"+',6,599,'scale+"%";this.stylesReady=1}',6,760,'this,"','AddStyleSheet','",A);if(',6,406,'styleChangeDelay','){',6,760,6,'Script,"Delay",1)}},',1537,367,'D',8,'B=',6,15,1274,'head")[0];var A="";for(var E in D){A+=E+" {"+D[E]+"}\\n"}if(',6,15,'createStyleSheet){B.insertAdjacentHTML("beforeEnd","<','span style=\\"','display:none\\">x</span>"+"<style type=\\"text/css\\">"+A+"</style>")}',29,470,6,15,21,'("style");C.type="text/css";C',917,6,15,1062,'(A));B',917,'C)}},Body',415,450,'inited',433,'this.inited=-','1;',6,425,'Hidden();',1578,'2;',6,406,1084,1578,'3;if(',6,599,'blank){',6,766,'.Blank()}',1578,'4;',6,425,'Styles();',1578,'5;',6,591,1084,1578,'6;',6,760,6,'Setup,"User","pre-font");',1578,'7;',6,760,6,'Font,"Check");if(',6,'Font.register.length){',6,760,6,'Font,"LoadRegistered")}this.inited=1},User',367,952,6,'Setup.UserEvent[A',']){(',6,1627,'])()}},UserEvent:{"pre-font":null,"onload":null}};',6,'Update={',506,367,'D){',1204,'D){for(var B in D[A]){for(var C in D[A][B]){',6,'TeX[A][B][C]=D[A][B][C]}}}},TeXfontCodes',367,'C){',1204,'C){',734,'C[A].',1279,6,'TeX[A][B].c=C[A][B]}}}};',6,'Browser={allowAbsolute:1,allowAbsoluteDelim:0,separateSkips:0,valignBug:0,operaHiddenFix:"",','msieCenterBugFix',':"",','msieInlineBlockFix',':"",','msieSpaceFix',':"",imgScale:1,renameOK:1,',1541,':0,delay:1,version:0,','TestSpanHeight',415,6,377,'="<span','><','span style=\\""+this.block+";','height:2em;width:','1px',448,'></span>";var B=',6,'hidden.firstChild;',460,'B.firstChild;','this.spanHeightVaries','=(B',388,'>=A',388,'&&B',388,'>0);','this.spanHeightTooBig','=(B',388,'>A',388,');',6,377,'=""},','TestInlineBlock',415,'this.block','="display:-moz-inline-box";','this.hasInlineBlock','=',6,'BBoxFor("<span style=\\""+this.block+";','width:10px;height:5px\\"></span>").w>0;if','(',1696,'){',6,'styles[".typeset .','blank"]=',6,1705,'blank','"].replace(/',167,'/,',1694,');',6,1705,176,'"]=',6,1705,176,1710,167,'/,"")}',29,1694,'="',167,'";',1696,'=',6,1699,1700,'(!',1696,682,1694,'+=";',169,'";',460,6,373,'("x").h;this.mozInlineBlockBug=',6,1699,'height:"+A+"px;width:1px',448,'>x"+"<',1666,1748,';vertical-align:-"+A+"px',448,'>").h>2*A;this.widthAddsBorder=',6,1699,169,';height:1px;width:10px',';border-left:','10px solid',448,'>").w>10;','this.msieBorderBug','=',6,1699,1748,448,'>x").h!=',6,1699,1748,1760,163,448,'>x").h;','this.blankWidthBug=',1764,'||',6,1699,1667,'0px',448,'>").h==0},','TestRenameOK',415,6,377,1664,'></span>";',460,6,1672,'A.setAttribute("name","','jsMath_test','");this.renameOK=(',6,15,'getElementsByName("',1797,'").length>0);',6,377,1691,'TestStyleChange',415,6,377,1664,' ID=\\"',1797,'\\">x</span>";var B=',6,1672,460,'B',385,';',6,425,1537,'({"#',1797,75,'200%"});this.',1541,'=(B',385,'==A);',6,377,1691,'VersionAtLeast',367,393,1336,'this.version',').split(".");','B=',1336,'B',1840,'if(B[1]==null){B[1]="0"}return A[0]>B[0]||(A[0]==B[0]&&A[1]>=B[1])},Init',415,6,27,'="unknown";this.',1692,515,1660,515,1787,515,1807,515,'MSIE',515,'Mozilla',515,'Opera',515,'OmniWeb',515,'Safari',515,'Konqueror','();if(','this.allowAbsoluteDelim','){',6,'Box.DelimExtend=',6,'Box.DelimExtendAbsolute;',6,'Box.Layout=',6,'Box.LayoutAbsolute}',29,6,'Box.DelimExtend=',6,'Box.DelimExtendRelative;',6,'Box.Layout=',6,'Box.LayoutRelative}if(','this.separateSkips','){',6,'HTML.Place=',6,'HTML.','PlaceSeparateSkips',';',6,'Typeset.prototype.','Place=',6,1898,1895,'}},MSIE',415,'if(',1675,'&&!',1683,'){',6,27,'="MSIE',899,6,37,'=="pc"){this.','IE7=(',1,710,669,');','this.quirks','=(',6,15,'compatMode=="BackCompat");this.msieStandard6=!',1922,'&&!','this.IE7',';',1870,'=1;',1889,'=1',';this.buttonCheck=1;this.','msieBlankBug=1;this.','msieAccentBug',921,'msieRelativeClipBug','=1;this.msieDivWidthBug=1;this.',1167,921,'msieIntegralBug',921,'waitForImages',921,'msieAlphaBug=!',1929,';this.','alphaPrintBug','=!',1929,';this.',1652,'="position:relative; ";this.',1654,'=" ',167,';";this.msieTeXfontBaselineBug=!',1922,';',1764,'=',1778,'1;',0,1929,376,1656,'="<',1559,167,448,'>"}',6,'Macro("joinrel","\\\\mathrel{\\\\kern-5mu}"),',6,'Parser.prototype.mathchardef.','mapstocharOrig','=',6,1978,'mapstochar;',540,6,1978,1983,6,'Macro("mapstochar","\\\\rlap{\\\\',1979,'\\\\,}\\\\kern1mu"),',6,1705,'arial"]="',143,': \'Arial unicode MS\'";',0,1929,'||',1922,'){',6,'styles["#',190,'"]=',6,2003,190,1710,192,'/,"',184,'").',1286,203,'/,"");',6,2003,205,'"]=',6,2003,205,1710,192,'/,"',184,'").',1286,203,'/,"");',6,2003,251,'"]="width:','1px; "+',6,2003,251,1710,192,'/,"',184,'").',1286,203,'/,"");',6,1,'.attachEvent("','onscroll",',6,591,'MoveButton',');if(',1929,'){',6,1,2050,'onresize",',6,591,2054,')}this.msieMoveButtonHack=',1929,'}',6,2003,330,'"]+=" ','display: inline-block',';";',6,1705,176,'"]=',6,1705,176,1710,167,'/,"");',6,49,'[".tex2math_div"]=',6,49,'["div.',57,'"]+"; width: 100%; ',2072,899,'screen.deviceXDPI','&&','screen.logicalXDPI','&&',2094,'!=',2096,376,'imgScale*=',2096,'/',2094,';',6,599,'alpha=0}this.',407,'="<i>x</i>";',6,'EmBoxFor=',6,397,'}',29,'if(',6,37,'=="mac"){this.msieAbsoluteBug',921,'msieButtonBug',1940,1936,'quirks=1;',6,425,'Script("jsMath-msie-mac.js");',6,'Parser.prototype.macros.angle=["Replace","ord","<font face=\\"Symbol\\">&#x8B;</font>","normal"];',6,2003,205,2035,'42em; "+',6,2003,205,1710,203,'/,"");',6,599,'printwarn=0}}',6,'Macro("not","\\\\mathrel{\\\\rlap{\\\\kern3mu','/}}")}},',1860,415,'if(',6,182,'.ATTRIBUTE_NODE){',6,27,'="',1860,899,6,37,1916,1950,'=1}',1870,'=1;',6,2003,251,'"]=',6,2003,251,1710,'cursor:hand','/,"cursor:pointer");',6,2003,330,'"]=',6,2003,330,1710,2175,'/,"cursor:pointer");',6,2147,'/}}");',604,'vendor=="Firefox"){',1839,'=',39,'vendorSub}',29,604,'userAgent.match','(" Firefox/([0-9.]+)( |$)")){',1839,'=RegExp.$1}}}},',1864,415,604,'accentColorName){',6,27,'="',1864,'";','this.allowAbsolute','=',1696,';',1870,'=',2211,';this.valignBug=!',2211,1935,1091,'=1;',6,'noChangeGlobal=1;',0,1696,'){',6,'Setup.Script("jsMath-old-browsers.js','")}}},Opera',415,'if(',1683,'){',6,27,'="Opera";',460,39,2198,'("Opera 7");',2211,'=0;this.delay=10;this.operaHiddenFix="[Processing]";',752,6,2229,'")}}},Safari',415,604,'appVersion',41,'Safari\\//)){',6,27,'="Safari";',460,39,2198,'("Safari/([0-9]+)");A=(A)?A[1]:400;',734,6,1448,'B++){if(',6,1452,'B]&&',6,'TeX[',6,1452,'B]]){',6,'TeX[',6,1452,'B]].dh=0.1}}',6,'TeX.axis_height+=0.05;',6,'TeX.default_rule_thickness+=0.025;',1870,'=A>=125;this.safariIFRAMEbug=A>=312&&A<412;this.safariButtonBug=A<412;this.safariImgBug',921,1091,'=1',1935,1541,'=1}},',1868,415,604,'product&&',39,'product.match("',1868,'")){',6,27,'="',1868,'";',2211,'=0;',1870,'=0;',604,2198,'(/',1868,'\\/(\\d+)\\.(\\d+)/)){if(RegExp.$1<3||(RegExp.$1==3&&RegExp.$2<3)){',1889,921,'valignBug=1;',6,2229,'")}}',6,'Add(',6,49,',{".',57,' .cmr10":"',143,': ',122,', jsMath cmr10, serif'],
  ['",".typeset .','cmbx10','":"','font-family: ','jsMath','-',1,', ',4,' ',1,', ',4,'-cmr10, ',4,' cmr10',0,'cmti10":"',3,4,'-cmti10, ',4,' cmti10, ',4,'-cmr10, ',4,' cmr10',0,'cmmi10','":"',3,4,'-',28,', ',4,' ',28,0,'cmsy10','":"',3,4,'-',39,', ',4,' ',39,0,'cmex10','":"',3,4,'-','cmex10, ',4,' ',50,'"});',4,'.Font.testFont','="',4,'-',55,4,' ',50,'"}}};',4,'.Font={testFont:"',4,'-',50,'",fallback:"symbol",register:[],message:"<b>No ',4,' TeX fonts ','found</b> -- using',' image fonts instead','.<br/>\\n"+"','These may be slow and might not print well',80,'Use the ',4,' control panel to get additional information.",','extra_message',':"Extra',77,'not found: <b><span id=\\"jsMath_ExtraFonts\\"></span></b><br/>"+"Using',79,'.  This may be slow and might not print well',80,'Use the ',4,85,'print_message',':"To print higher-resolution math symbols, click the<br/>\\n"+"<b>Hi-Res Fonts for Printing</b> button on the ',4,' control panel.<br/>\\n",','alpha_message',':"If the math symbols print as black boxes, turn off <b>image alpha channels</b><br/>\\n"+"using the <B>Options</B> pane of the ',4,99,'Test1',':function(','C',',F,D,E){if(F==null){F=124}if(D==null){D=2}if(E==null){E=""}var B=jsMath.BBoxFor("<span style=\\"font-family: "+E+C+", serif\\">"+jsMath.TeX[C][F].c+"</span>");var A=jsMath.BBoxFor("<span style=\\"font-family: serif\\">"+jsMath.TeX[C][F].c+"</span>");return','(B.w>D*A.w&&B.h!=0)},Test2',105,'C',107,'(A.w>D*B.w&&B.h!=0)},CheckTeX',':function(){var A=',4,'.BBoxFor("<','span style=\\"','font-family: "+',4,61,'+", serif\\">"+',4,'.TeX.',50,'[1','].c+"</span>");',4,'.nofonts=((A.w*3>A.h||A.h==0)&&!this.Test1("cmr10','",null,null,"',4,'-"));if(',4,'.nofonts','&&(',4,'.platform','!="mac"||',4,'.browser!="Mozilla"||!',4,'.Browser.','VersionAtLeast(1.5))){A=',4,'.BBoxFor("<',116,3,55,'serif\\">"+',4,122,50,'[1',125,4,127,'"));if(!',4,132,'){',4,'.Setup.','Script','("',4,'-BaKoMa-fonts.js")}}},Check',113,4,'.Controls','.cookie',';this.CheckTeX();if(',4,132,'){if(A.autofont||A','.font=="tex"){','A.font=this.fallback;if(A.warn){',4,'.nofontMessage=1;A.warn=0;',4,167,'.SetCookie(0);if','(',4,'.window.NoFontMessage','){',4,182,'()}else{','this.Message(this.','message)}}}}else{if(A.autofont){A.font="tex"}if(A',173,'return }}if(',4,'.noImgFonts){','A.font="unicode"}if(A','.font=="unicode','"){',4,160,161,'("',4,'-fallback','-"+',4,135,'+".js");',4,'.Box.TeXnonfallback=',4,'.Box.TeX',';',4,209,'=',4,'.Box.TeXfallback;return }','if(!A.print&&A.printwarn){this.','PrintMessage','((',4,140,'alphaPrintBug&&',4,167,168,'.alpha)?this.',96,'+this.',100,':this.',96,')}if(',4,140,'waitForImages){',4,'.Script.','Push(',4,'.',161,',"WaitForImage",',4,'.blank)}if(A.font=="symbol"){',4,160,161,'("',4,201,'-symbols.js");',4,'.Box.TeXnonfallback=',4,209,';',4,209,'=',4,215,4,'.Img.SetFont','({cmr10',':["all"],',28,264,39,264,50,264,1,264,'cmti10:["all"]});',4,'.Img.LoadFont','("cm-fonts")},Message',105,'A){if(',4,'.Element("','Warning")){','return }var ','B=',4,160,'DIV("Warning','",{});B.innerHTML="<center><table><tr><td>"+"<div ','id=\\"jsMath_noFont\\"><div ','class=\\"message\\">"+A','+"<div style=\\"text-align:left\\"><',116,'float:left; ','margin: 8px ','0px 0px 20px\\">"+"<span onclick=\\"',4,167,'.Panel()\\" ','title=\\" Open ','the ',4,' Control Panel',' \\" class=\\"link\\">',4,301,'</span>"+"</span','><',116,293,'20px 0px 0px; float:right\\">"+"<span onclick=\\"',4,'.Font.','HideMessage','()\\" title=\\" Remove this font warning message',302,'Hide this Message',305,'></div><div style=\\"height:6px\\"></div><br clear=\\"all\\"/></div></','div>"+"<div style=\\"width:22em; height:1px\\"></div>"+"</td></tr></table></center><hr/>"},',312,113,4,280,'Warning");if(A','){A.style.display="none"}},',217,105,278,4,280,'PrintWarning','")){',282,'B=',4,160,'DIV("',330,287,289,'+"</',318,'Register',105,'H,B){if(typeof (H)=="string"){H={name:H}}if(!',4,160,'inited&&!B){','this.register','[',348,'.length]=H;',282,'I=H.name;var A=I.replace(/10$/,"");var F=',4,122,'fam.length;if(H.prefix==null){H.prefix=""}if(!H.style){H.style="',117,'H.prefix+I+", serif"}if(!H.styles){H.styles={}}if(!H.macros){H.macros={}}',4,122,'fam[F]=I;',4,122,'famName[I]=F;H.macros[A]=["HandleFont",F];',4,'.Add(',4,'.Parser.prototype.macros,H.macros);H.styles[".typeset ."+I]=H.style;',4,160,'Styles(H.styles);if(',4,'.initialized){',4,236,'Push(',4,'.Setup,"TeXfont",I)}var C=',4,167,168,';var E=!',4,132,'&&H.test(I,H.testChar,H.testFactor,H.prefix);if(E&&C',173,'if(H.tex){H.tex(I,F,H)}return }if(!E&&C.warn&&C.font=="tex"&&!',4,132,'){if(!C.fonts.match("/"+I+"/")){C.fonts+=I+"/";',4,167,179,'(!',4,280,281,187,86,')}var G=',4,280,'ExtraFonts");if(G){if(G','.innerHTML','!=""){G',404,'+=","}G',404,'+=" "+H.prefix+I}}}if(C',194,'"||',4,192,'if(H.fallback){H.fallback(I,F,H)}',282,'D={};D[I]=["all"];',4,262,'(D);',4,275,'(I);if(',4,'.initialized){',4,236,'Push(',4,'.Img,"Scale");',4,236,'Push(',4,'.Img,"UpdateFonts")}},LoadRegistered',113,'0;while(A<',348,'.length){this.Register(',348,'[A++],1)}',348,'=[]},Load',105,'A){',4,160,161,'(this.URL(A))},URL',105,'A){','return ',4,'.Img.root+A+"/def.js"}};',4,167,'={cookie:{scale:100,font:"tex",autofont:1,scaleImg:0,alpha:1,warn:1,fonts:"/",printwarn:1,stayhires:0,button:1,progress:1,asynch:0,blank:0,print:0,keep:"0D",global:"auto",hiddenGlobal:1},cookiePath:"/",','noCookiePattern',':/^(file|mk):$/,Init',':function(){','this.panel=',4,160,'DIV("panel",{display:"none"});if(!',4,140,'msieButtonBug){this.Button',186,'setTimeout("',4,167,'.Button()",500)}},Panel',459,4,'.Translate.Cancel();if(this.loaded){this.Main',186,4,236,'delayedLoad(',4,'.root+"',4,'-controls.html")}},Button',113,4,160,'DIV("button",{});A.title=" Open ',4,301,' ";A',404,'="<span onclick=\\"',4,167,'.Panel()\\">',4,'</span>";if(!',4,'.Global.','isLocal&&!',4,'.noShowGlobal){A',404,'+="<span id=\\"jsMath_global\\" ',298,4,' Global Panel \\" "+"onclick=\\"',4,498,'Show(1)\\">Global&nbsp;</span>"}if(A.offsetWidth<30){A.style.width="auto"}if(!','this.cookie','.button',324,'MoveButton',459,'var C=',4,167,';if(!C.button){C.button=',4,280,'button")}if(C.button','){C.MoveElement(C.','button,3,2)}var B=20;var A=20;if(C.button){A=C.button.offsetHeight+6;B=A+5}if(C.panel',522,'panel,B,A)}},MoveElement',105,'D,C,B){if(',4,140,'IE7){var A=document.body;D.style.right','="auto";D.style.','bottom',531,'left=A.clientWidth+A.scrollLeft-D.offsetWidth-C+"px";D.style.top=A.clientHeight+A.scrollTop-D.offsetHeight-B+"px"}else{','D.style.visibility="','hidden";',535,'visible"}},GetCookie',459,'if(','this.defaults','==null){',541,'={}}',4,366,541,',',510,');this.userSet={};var C=',4,'.document.cookie',';if(',4,'.window.location','.protocol.match(this.',457,')){C=this.','localGetCookie','();','this.isLocalCookie','=1}if(C.match(/',4,'=([^;]+)/)){var D=unescape(RegExp.$1).split(/,/);for(var B=0;B<D.length;B++){var A=D[B].match(/(.*):(.*)/);if(A[2].match(/^\\d+$/)){A[2]=1*A[2]}',510,'[A[1]]=A[2];this.userSet[A[1]]=1}}},',559,459,451,4,555,'.search.substr(1)},SetCookie',105,'F){var B=[];for(var E in ',510,'){if(',541,'[E]==null||',510,'[E]!=',541,'[E]){B[B.length]=E+":"+',510,'[E]}}B=B.join(",");if(',561,'){if(F==2){return"',4,'="+escape(B)}','this.','localSetCookie','(B,F)}else{B=escape(B);if(B==""){F=0}if(','this.cookiePath','){B+="; path="+',592,'}if(','this.cookieDomain','){B+="; domain="+',596,'}if(',510,'.keep!="0D"){var A={D',':1000*60*60*24',',W',602,'*7,M',602,'*30,Y',602,'*365};var D=new Date;D.setTime(D.getTime()+',510,'.keep.substr(','0,1)*A[',510,611,'1,1)]);B+="; expires="+D.toGMTString()}if(B!=""){',4,552,'="',4,'="+B;var C=',4,552,';if(F&&!C.match(/',4,'=/)){alert("Cookies must be enabled in order to save ',4,' options")}}}',451,'null},',590,105,'B,C){if(!C){',282,'A=String(',4,555,').replace(/\\?.*/,"");if(B!=""){A+="?',4,588,'if(A!=',4,555,'.href){this.Reload(A)}},Reload',105,'A){if(!this.loaded){return }this.loaded=0;',4,160,'inited=-100;',4,498,'ClearCache();if(A){',4,555,'.replace(A)}else{',4,555,'.reload()}}};',4,'.Click={CheckClick',105,'A){if(!A){A=',4,'.window.event}if','(A.altKey){',4,167,'.Panel()}},CheckDblClick',105,'B){if(!B){B=',4,663,'(!',4,'.Click.DblClick){',4,'.Extension.Require("double-click",1);var A=B;B={};for(var C in A){B[C]=A[C]}}',4,236,'Push(',4,'.Click,"DblClick",[B,this.alt])}};',4,'.TeX={thinmuskip:3/18,medmuskip:4/18,thickmuskip:5/18,x_height:0.430554,quad:1,num1:0.676508,num2:0.393732,num3:0.44373,denom1:0.685951,denom2:0.344841,sup1:0.412892,sup2:0.362892,sup3:0.288888,sub1:0.15,sub2:0.247217,sup_drop:0.386108,sub_drop:0.05,delim1:2.39,delim2:1,axis_height:0.25,default_rule_thickness:0.06,big_op_spacing1:0.111111,big_op_spacing2:0.166666,big_op_spacing3:0.2,big_op_spacing4:0.6,big_op_spacing5:0.1,integer:6553.6,scriptspace:0.05,nulldelimiterspace:0.12,delimiterfactor:901,delimitershortfall:0.5,scale:1,atom:["ord","op","bin","rel","open","close","punct","ord"],fam:["cmr10","',28,'","',39,'","',50,'","cmti10","","',1,'",""],famName:{cmr10:0,',28,':1,',39,':2,',50,':3,cmti10:4,',1,':6},encoding:["&#xC0;","&#xC1;","&#xC2;","&#xC3;","&#xC4;","&#xC5;","&#xC6;","&#xC7;","&#xC8;","&#xC9;","&#xCA;","&#xCB;","&#xCC;","&#xCD;","&#xCE;","&#xCF;","&#xB0;","&#xD1;","&#xD2;","&#xD3;","&#xD4;","&#xD5;","&#xD6;","&#xB7;","&#xD8;","&#xD9;","&#xDA;","&#xDB;","&#xDC;","&#xB5;","&#xB6;","&#xDF;","&#xEF;","!","&#x22;","#","$","%","&#x26;","&#x27;","(",")","*","+",",","-",".","/","0","1","2","3","4","5","6","7","8","9",":",";","&#x3C;","=","&#x3E;","?","@","A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z","[","&#x5C;","]","^","_","`","a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z","{","|","}","&#x7E;","&#xFF;"],cmr10:[[0.625',',0.683],[0.','833',700,'778',700,'694',700,'667',700,'75',700,'722',700,'778',700,'722',700,'778',700,'722',700,'583',',0.694,0,{ic:0.0778,krn:{"39":0.0778,"63":0.0778,"33":0.0778,"41":0.0778,"93":0.0778},lig:{"105":','14,"108":15}}],[0.556',',0.694],[0.','556',724,'833',724,'833',724,'278',',0.431],[0.','306',',0.431,0.194],[0.','5',724,'5',724,'5,0.628],[0.5',724,'5,0.568],[0.75',724,'444,0,0.17],[0.5',724,'722',732,'778',732,'5,0.528,0.0972],[0.903,0.683],[1.01',700,'778,0.732,0.0486],[0.278',',0.431,0,{','krn:{"108":-0.278,"76":-0.319}}],[0.278',',0.694,0,{','lig:{"96":','60}}],[0.5',724,'833',',0.694,0.194],[','0.5',',0.75,0.0556],[0.','833',761,'778',724,'278',754,'krn:{"63":0.111,"33":0.111},lig:{"39":34}}],[0.389',',0.75,0.25],[0.','389',769,'5,0.75],[','0.778,0.583,0.0833],[','0.278,0.106',',0.194],[0.','333',752,'lig:{"45":','123}}],[',774,'],[0.5',769,'5,0.644','],[0.5,0.644],[0.5,0.','644',784,'644',784,'644',784,'644],[0.5,0.644],[0.278',732,'278',734,'278,0.5',775,'778',',0.367,-0.133],[','0.472,0.5',775,'472',754,755,'62}}],[0.778',724,'75',',0.683,0,{krn:{"','116','":-0.0278,"','67',809,'79',809,'71',809,'85',809,'81',809,'84":-0.0833,"89":-0.0833,"86":-0.111,"87":-0.111}}],[0.','708',700,'722',700,'764',807,'88',809,'87',809,'65',809,'86',809,'89":-','0.0278}}],[0.','681',700,'653',',0.683,0,{','krn:{"111":-0.0833,"101":-0.0833,"117":-0.0833,"114":-0.0833,"97":-0.0833,"65":-0.111,"79":-0.0278,"67":-0.0278,"71":-0.0278,"81":-0.0278}}],[','0.785',700,'75',700,'361',807,'73":',836,'514',700,'778',807,'79',809,'67',809,'71',809,'81":-',836,'625',807,820,'917',700,'75',700,'778',807,'88',809,'87',809,'65',809,'86',809,'89":-',836,'681',807,'65','":-0.0833,"','111',809,'101',809,'97',809,'46',884,'44":-0.','0833}}],[0.','778,0.683',775,'736',807,'116',809,'67',809,'79',809,'71',809,'85',809,'81',809,820,'556',700,'722',807,'121',809,'101',884,'111',884,'114',884,'97',884,'65',884,'117":-0.',894,'75',700,'75',',0.683,0,{ic:0.','0139,',841,'1.03',933,'0139,',841,'0.75',807,'79',809,'67',809,'71',809,'81":-',836,'75',933,'025,krn:{"101',884,'111',884,'114',884,'97',884,'65',884,928,894,'611',700,'278',769,'5',724,'278',769,'5',724,'278,0.668],[0.','278',754,755,'92}}],[0.5',752,'krn:{"118',809,'106":0.0556,"121',809,'119":-',836,'556,0.','694,0',',{krn:{"101":0.0278,"111":0.0278,"120":-0.0278,"100":0.0278,"99":0.0278,"113":0.0278,"118":-0.0278,"106":0.0556,"121":-0.0278,"119":-0.0278}}],[0.','444',752,'krn:{"104',809,'107":-',836,'556',724,'444',732,'306',722,'12,"102":11,"108":13}}],[0.5',',0.431,0.194,{','ic:0.','0139,krn:{"','106":',836,'556',754,'krn:{"116',809,'117',809,'98',809,'121',809,'118',809,'119":-',836,974,'306,0.668',775,'528',754,'krn:{"97','":-0.0556,"','101',809,'97',809,'111',809,'99":-',836,'278',724,'833',752,'krn:{"116',809,'117',809,'98',809,'121',809,'118',809,'119":-',836,'556',752,'krn:{"116',809,'117',809,'98',809,'121',809,'118',809,'119":-',836,'5,0.431,0',988,986,'431,0.194',988,'528',734,'392',732,'394',732,'389,0.615,0,{krn:{"121',809,'119":-',836,'556',752,'krn:{"119":-',836,'528',',0.431,0,{ic:0.',1004,'97',1027,'101',809,'97',809,'111',809,'99":-',836,'722',1086,1004,'101',809,'97',809,'111',809,'99":-',836,'528',732,'528',1002,'ic:0.',1004,'111',809,'101',809,'97',809,'46',884,'44":-0.',894,'444',732,'5',1086,'0278,',778,'124}}],[1',1086,'0278}],[0.','5',724,'5,0.668],[0.5,0.668]],',28,':[[0.615',933,'139',',krn:{"61":-0.0556,"59":-0.111,"58":-0.111,"127":0.',894,'833',807,'127":0.167}}],[0.','763',933,1129,'krn:{"127":0.0833}}],[0.','694',807,1145,'742',933,'0757,',1149,'831',933,'0812,krn:{"61',1027,'59":-0.0556,"58":-0.0556,"127":0.','0556}}],[0.','78',933,'0576,',1149,'583',933,'139',1141,1162,'667',840,1149,'612',933,'11,krn:{"61',1027,1161,1162,'772',933,'0502,',1149,'64',1086,'0037,','krn:{"127":',836,'566',',0.694,0.194,{ic:0.','0528,',1149,'518',1002,'ic:0.0556','}],[0.444',754,'ic:0.0378,krn:{"',1161,1162,'406',752,'krn:{"127":0.0556}}],[0.','438',1191,'0738,',1149,'497',1002,'ic:0.0359',',',1204,'469',754,'ic:0.',1129,1149,'354',752,1204,'576',732,'583',724,'603',1002,1188,836,'494',1086,'0637,krn:{"',1161,'0278}}],[0.','438',1191,'046,',1188,'0.111}}],[0.','57',1086,'0359}],[0.','517',1002,1149,'571',1086,'0359,krn:{"59',1027,'58":-0.',1162,'437',1086,'113,krn:{"',1161,1234,'54',1086,'0359,',1188,836,'596,0.694,0.194,{',1149,'626',1002,1204,'651',1191,'0359,',1188,1239,'622',1086,1242,'466',752,1149,'591',754,1149,'828',1086,1133,'517',1002,1149,'363,0.431,0.0972,{ic:0.0799,',1149,'654',1002,1188,'0.0833}}],[1',798,'1',798,'1',798,'1',798,'0.278',',0.464,-0.0363],[','0.278',1301,'0.5,0.465,-0.0347],[',1304,'0.5',732,'5',732,'5',732,'5',734,'5',734,'5,0.',1069,784,1069,784,'431',775,'278,0.106],[',774,775,'778',',0.539,0.0391],[','0.5,0.75,0.25,{krn:{"1',1027,'65',1027,'77',1027,'78',1027,'89":0.0556,"90":-0.',1162,'778',1327,1304,'0.531',754,1196,',',1149,'75',807,'127":','0.','139}}],[0.','759',933,'0502,',1149,'715',933,'0715,krn:{"61',809,1161,894,'828',933,1129,1204,'738',933,'0576,',1149,'643',933,'139',1141,894,'786',840,1149,'831',933,'0812,krn:{"61',1027,1161,1162,'44',933,'0785,',1188,1239,'555',933,'0962',1141,'167}}],[0.','849',933,'0715,krn:{"61',1027,1161,1162,'681',807,1348,836,'97',933,'109,krn:{"','61',1027,1161,894,'803',933,1405,'61',884,'61',809,1161,894,'763',933,1129,1149,'642',933,'139',1141,894,'791,0.683,0.194,{',1149,'759',933,'00773,',1149,'613',933,'0576,krn:{"61',1027,1161,894,'584',933,'139,krn:{"61',809,1161,894,'683',933,1405,'59":-0.111,"',1250,'111,"61',1027,1348,836,'583',933,'222',',krn:{"59":-0.167,"58":-0.167,"61":-0.111}}],[0.','944',933,'139',1458,'828',933,'0785,krn:{"61',884,'61',809,1161,894,'581',933,'222',1458,'683',933,'0715,krn:{"61',1027,1161,894,'389,0.75],[0.389',759,'0.389',759,'1,0.358,-0.142],[',1485,'0.417',754,1188,1239,'529',732,'429',724,'433',752,1204,'52',754,'krn:{"89":0.0556,"90',1027,'106":-0.111,"102":-0.167,"',1145,'466',752,1204,'49',1191,'108,krn:{"',1161,1392,'477',1002,1211,',',1188,836,'576',754,'krn:{"127":-',836,'345,0.66],[0.412,0.66,0.194,{ic:0.0572,krn:{"59',1027,1250,1162,'521',754,'ic:0.0315}],[0.298',754,'ic:0.0197,',1149,'878',732,'6',732,'485',752,1204,'503',1002,1149,'446',1002,1211,',',1149,'451',1086,1129,'krn:{"',1161,1162,'469',752,1204,'361,0.615,0,{',1149,'572',752,1188,836,'485',1086,'0359,',1188,836,'716',1086,'0269,',1149,'572',752,1188,836,'49',1002,1211,',',1204,'465',1086,'044,',1204,'322',752,1188,836,'384',1002,1149,'636',1002,1188,1239,'5,0.714,0,{ic:0.154}],[0.278',754,'ic:0.399}]],',39,':[[',773,'0.278,0.444,-0.0556],[',773,1304,773,'0.5,0.444,-0.0556],[',773,773,773,773,773,773,773,'1',759,1605,1605,'0.778',1301,'0.778,0.464,-0.0363','],[0.778,0.636,0.136',1620,1620,1620,1620,1620,'],[0.778',798,'0.778,0.483,-0.0169],[0.778',1327,'0.778',1327,'1',1327,'1',1327,'0.778',1327,'0.778',1327,'1',798,'1',798,'0.5',759,'0.5',759,'1',798,'1',759,'1',759,'0.778',1301,'1',798,'1',798,'0.611',759,'0.611',759,'1',798,'1',759,'1',759,'0.778',732,'275,0.556],[1',732,'667',1327,'0.667',1327,'0.889',759,'0.889',759,'0',759,'0',798,'0.556',724,'556',724,'667',732,'5',761,'722',724,'722',724,'778',724,'778',724,'611',724,'798',807,'48":0.','194}}],[0.657',933,'0304',',krn:{"48":0.',1350,'527',933,'0583',1710,1350,'771',933,'0278',1710,894,'528',933,'0894',1710,'111}}],[0.','719',933,'0993',1710,1726,'595',',0.683,0.0972,{ic:0.','0593',1710,1726,'845',933,'00965',1710,1726,'545',933,'0738,krn:{"48":',836,'678',1733,'185',1710,1392,'762',933,'0144',1710,1162,'69',807,1706,'139}}],[1.2',807,1706,1350,'82',933,'147',1710,894,'796',933,1719,1710,1726,'696',933,'0822',1710,894,'817,0.683,0.0972,{krn:{"48":',1239,'848',807,1706,894,'606',933,'075',1710,1350,'545',933,'254,krn:{"48":',836,'626',933,'0993',1710,894,'613',933,'0822,krn:{"48":',836,'988',933,'0822',1710,894,'713',933,'146',1710,1350,'668',1733,'0822',1710,894,'725',933,'0794',1710,1350,'667,0.556],[0.',1822,1822,1822,1822,'611',724,'611',724,'444',769,'444',769,'444',769,'444',769,'5',769,'5',769,'389',769,'389',769,'278',769,'5',769,'5',769,'611',769,'5',769,'278',759,'0.833,0.04,0.96],[0.75',700,'833',700,'417',1191,'111}],[0.',1822,'667,0.556',1620,1620,'],[0.444',759,'0.444',759,'0.444',759,'0.611',759,'0.778,0.694,0.13','],[',1878,'],[',1878,'],[',1878,']],',50,':[[0.458',',0.04,1.16,{n:','16}],[0.458',1888,'17}],[0.417',1888,'104}],[0.417',1888,'105','}],[0.472,0.04,1.16,{n:','106',1896,'107',1896,'108',1896,'109}],[0.583',1888,'110}],[0.583',1888,'111',1896,'68',1896,'69}],[0.333',',0,0.6,{delim:{rep:','12}}],[0.556',1912,'13}}],[0.578',1888,'46}],[0.578',1888,'47}],[0.597',',0.04,1.76,{n:','18}],[0.597',1920,'19}],[0.736',',0.04,2.36,{n:','32}],[0.736',1924,'33}],[0.528',1924,'34}],[0.528',1924,'35}],[0.583',1924,'36}],[0.583',1924,'37}],[0.583',1924,'38}],[0.583',1924,'39}],[0.75',1924,'40}],[0.75',1924,'41}],[0.75',1924,'42}],[0.75',1924,'43}],[1.04',1924,'44}],[1.04',1924,'45}],[0.792',',0.04,2.96,{n:','48}],[0.792',1952,'49}],[0.583',1952,'50}],[0.583',1952,'51}],[0.639',1952,'52}],[0.639',1952,'53}],[0.639',1952,'54}],[0.639',1952,'55}],[0.806',1952,'56}],[0.806',1952,'57}],[0.806',',0.04,2.96],[','0.806',1972,'1.28',1972,'1.28',1972,'0.811',1920,'30}],[0.811',1920,'31}],[0.875',',0.04,1.76,{delim:{top:','48,bot:64,rep:66}}],[0.875',1984,'49,bot:65,rep:67}}],[0.667',1984,'50,bot:52,rep:54}}],[0.667',1984,'51,bot:53,rep:55','}}],[0.667,0.04,1.76,{delim:{bot:','52,rep:54',1992,'53,rep:55','}}],[0.667,0,0.6,{delim:{top:','50,rep:54',1996,'51,rep:55','}}],[0.889,0,0.9,{delim:{top:','56,mid:60,bot:58,rep:62',2000,'57,mid:61,bot:59,rep:62',2000,'56,bot:58,rep:62',2000,'57,bot:59,rep:62','}}],[0.889,0,1.8,{delim:{rep:','63',2008,'119}}],[0.889,0,0.3,{delim:{rep:62',1996,'120,bot:121,rep:63}}],[0.875',1984,'56,bot:59,rep:62}}],[0.875',1984,'57,bot:58,rep:62}}],[0.875',1912,'66}}],[0.875',1912,'67}}],[0.611',1920,'28}],[0.611',1920,'29','}],[0.833,0,1,{n:','71}],[1.11',',0.1,1.5],[','0.472,0,1.11,{ic:0.194,n:','73}],[','0.556,0,2.22,{ic:0.444}],[1.11,0',',1,{n:75}],[1.51,0','.1,1.5],[1.11,0',',1,{n:77}],[1.51,0',2033,',1,{n:79}],[1.51',2028,'1.06,0,1,{n:88}],[0.944,0,1,{n:89}],[',2029,'90',2026,'91',2026,'92',2026,'93',2026,'94',2026,'95}],[1.44',2028,'1.28',2028,2031,2033,2033,2033,2033,'.1,1.5],[0.944,0,1,{n:97}],[1.28',2028,'0.556,0.722,0,{n:','99','}],[1,0.75,0,{n:','100}],[1.44,0.75],[',2061,'102',2063,'103}],[1.44,0.75],[0.472',1920,'20}],[0.472',1920,'21}],[0.528',1920,'22}],[0.528',1920,'23}],[0.528',1920,'24}],[0.528',1920,'25}],[0.667',1920,'26}],[0.667',1920,'27}],[1',1888,'113}],[1',1920,'114}],[1',1924,'115}],[1',1952,'116}],[1.06,0,1.8,{delim:{top:118,b'],
  ['ot:116,rep:117}}],[1.06,0,0.6],[1.06,0.04,0.56],[0.778',',0,0.6,{delim:{','top:126,','bot:127,rep:119','}}],[0.','667',1,'top:120,rep:63',4,'667',1,'bot:121,rep:63',4,'45,0.12],[0.',13,13,13,'778',1,2,'rep:119',4,'778',1,3,'}}]],cmti10:[[0.627',',0.683,0,{ic:0.','133}],[0.818,0.683],[0.767',26,'094}],[0.','692,0.683],[0.664',26,'153}],[0.743',26,'164}],[0.','716',26,'12}],[0.','767',26,'111}],[0.716',26,'0599}],[0.767',26,'111}],[0.716',26,'103}],[0.','613',',0.694',',0.194,{ic:0.','212,krn:{"39":0.104,"63":0.104,"33":0.104,"41":0.104,"93":0.104},lig:{"105":','14,"108":15',4,'562',48,49,46,'588',48,49,46,'882',48,49,46,'894',48,49,46,'307',',0.431,0,{ic:0.','0767}],[0.','332,0.431',49,'0374}],[0.511',',0.694],[0.','511',',0.694,0,{ic:0.','0969','}],[0.511,0.','628',',0,{ic:0.','083}],[0.511',77,'108',79,'562',81,46,'831',75,'46,0,0.17],[0.537',48,49,'105}],[0.','716',70,'0751','}],[0.716',70,97,79,'528,0.0972,{ic:0.0919}],[0.883',26,37,'985',26,37,'767,0.732,0.0486,{ic:0.',29,'256,0.431,0,{krn:{"108":-0.256,"76":-0.321',4,'307',77,'124,lig:{"96":','60',4,'514',77,'0696}],[0.818',48,49,'0662}],[0.769',75,'818',',0.75,0.0556',',{ic:0.136}],[0.','767',77,'0969}],[0.307',77,'124',',krn:{"','63":0.102,"33":0.102},lig:{"39":34',4,'409',',0.75,0.25,{ic:0.','162}],[0.409',136,'0369',79,'75',81,'149}],[0.767,0.562,0.0567,{ic:0.0369','}],[0.307,0.','106',',0.194],[0.','358',70,'0283,lig:{"45":123',4,'307,0.106],[0.511',136,'162',79,'644,0',',{ic:0.136}],[0.511,0.644,0',156,156,156,'.194',156,156,156,160,156,156,126,'307',70,'0582',144,'431',49,'0582',144,'5',49,'0756}],[0.767,0.367,-0.133,{ic:0.0662',79,'5',146,'511',77,'122,lig:{"96":62',4,'767',77,'096}],[0.743,0.683,0,{','krn:{"110":-0.0256,"108":-0.0256,"114":-0.0256,"117":-0.0256,"109":-0.0256,"116":-0.0256,"105":-0.0256,"67":-0.0256,"79":-0.0256,"71":-0.0256,"104":-0.0256,"98":-0.0256,"85":-0.0256,"107":-0.0256,"118":-0.0256,"119":-0.0256,"81":-','0.0256,"84','":-0.0767,"','89',191,'86','":-0.102,"','87',195,'101":-0.0511,"97":-0.0511,"111":-0.0511,"100":-0.0511,"99":-0.0511,"103":-0.0511,"113":-0.0511}}],[0.','704',26,46,'716',26,'145}],[0.','755',26,'094',132,'88','":-0.0256,"','87',210,'65',210,'86',210,'89','":-0.0256',4,'678',26,37,'653',26,'133',132,'111',191,'101',191,'117','":-0.0767,"114":-0.0767,"97":-0.0767,"','65',195,'79":-0.0256,"67":-0.0256,"71":-0.0256,"81":-0.0256}}],[0.','774',26,'0872}],[0.743',26,34,'386',26,'158}],[0.525',26,'14}],[0.769',26,'145',132,235,'627,0.683,0,{krn:{"84',191,'89',191,'86',195,'87',195,198,'897',26,34,'743',26,34,'767',26,'094',132,'88',210,'87',210,'65',210,'86',210,'89',218,4,'678',26,'103',132,'65":-0.0767}}],[0.','767,0.683',49,29,'729',26,'0387,',189,'0.0256,"84',191,'89',191,'86',195,'87',195,198,'562',26,37,'716',26,'133',132,'121',191,'101',191,'111',232,'117',191,284,'743',26,34,'743',26,'184',132,'111',191,'101',191,'117',232,'65',195,235,'999',26,'184',132,284,'743',26,'158',132,235,'743',26,'194',132,'101',191,'111',232,'117',191,284,'613',26,204,'307',136,'188}],[0.514',77,'169}],[0.307',136,94,'511',77,'0665',144,'668',81,'118}],[0.307',77,114,'92',4,'511',70,71,'46',77,'0631',132,198,'46',70,'0565',132,198,'511',77,'103',',krn:{"108":0.0511}}],[0.','46',70,97,132,198,'307',48,49,50,'12,"102":11,"108":13}}],[0.','46,0.431',49,'0885}],[0.','511',77,71,'307,0.655',81,'102',144,'655',49,204,'46',77,'108}],[0.','256',77,'103',391,'818',70,71,'562',70,'0767',132,'39":-0.102',4,'511',70,'0631',132,198,'511,0.431',49,'0631',132,198,'46,0.431',49,404,'422',70,'108',132,198,'409',70,'0821}],[0.332,0.615',81,'0949}],[0.537',70,71,'46',70,417,'664',70,'108',391,'464',70,37,'486,0.431',49,404,'409',70,'123}],[0.511',70,'0921',',lig:{"45":124}}],[1.','02',70,'0921}],[0.511',77,'122',79,'668',81,'116',79,'668',81,'105}]],cmbx10:[[0.692',',0.686],[0.','958',488,'894',488,'806',488,'767',488,'9',488,'831',488,'894',488,'831',488,'894',488,'831',488,'671',77,'109,krn:{"39":0.109,"63":0.109,"33":0.109,"41":0.109,"93":0.109},lig:{"105":','14,"108":15',4,'639',75,'639',75,'958',75,'958',75,'319',',0.444],[0.','351,0.444',146,'575',75,'575',75,'575,0.','632],[0.575',75,530,'596],[0.869',75,'511,0,0.17],[0.597',75,'831',523,'894',523,530,'542,0.0972],[1.04,0.686],[1.17',488,'894,0.735,0.0486],[0.319',',0.444,0,{krn:{"','108":-0.319,"76":-0.378',4,'35',',0.694,0,{lig:{"96":','60',4,'603',75,'958',48,146,'575',125,'],[0.958',125,'],[0.894',75,'319',',0.694,0,{krn:{"','63":0.128,"33":0.128},lig:{"39":34',4,'447',',0.75,0.25],[0.','447',569,530,'75],[0.894,0.633,0.133],[0.','319,0.156',146,'383,0.444,0,{lig:{"45":123',4,574,'],[0.575',569,530,'644],[','0.575,0.644],[0.575,0.644],[',583,583,583,'0.',530,'644],[0.319',523,'319,0.444',146,'35,0.5',146,'894,0.391,-0.109],[0.543,0.5',146,'543',550,'62',4,'894',75,'869',',0.686,0,{krn:{"','116','":-0.0319,"','67',606,'79',606,'71',606,'85',606,'81',606,'84":-0.0958,"89":-0.0958,"86":-0.128,"87":-0.128}}],[','0.818',488,'831',488,'882',604,'88',606,'87',606,'65',606,'86',606,'89','":-0.0319}}],[0.','756',488,'724,0.686,0,{','krn:{"111":-0.0958,"101":-0.0958,"117":-0.0958,"114":-0.0958,"97":-0.0958,"65":-0.128,"79":-0.0319,"67":-0.0319,"71":-0.0319,"81":-0.0319}}],[','0.904',488,'9',488,'436',604,'73":0.0319',4,'594',488,'901',604,'79',606,'67',606,'71',606,'81',633,'692',604,617,'1.09',488,'9',488,'864',604,'88',606,'87',606,'65',606,'86',606,'89',633,'786',604,'65":-0.0958,"111',606,'101',606,'97',606,'46":-0.0958,"44":-0.0958}}],[0.','864,0.686',146,'862',604,'116',606,'67',606,'79',606,'71',606,'85',606,'81',606,617,'0.639',488,'8',604,'121',606,'101":-0.0958,"111":-0.0958,"114":-0.0958,"97":-0.0958,"65":-0.0958,"117":-0.0958}}],[0.','885',488,'869,0.686',81,'016,',637,'1.19,0.686',81,'016,',637,'0.869',604,'79',606,'67',606,'71',606,'81',633,'869,0.686',81,'0287',132,709,'703',488,'319',569,'603',75,'319',569,'575',75,'319',75,'319',550,'92',4,'559',546,'118',606,'106":0.0639,"121',606,'119',633,'639',48,',0',',{krn:{"101":0.0319,"111":0.0319,"120":-0.0319,"100":0.0319,"99":0.0319,"113":0.0319,"118":-0.0319,"106":0.0639,"121":-0.0319,"119":-0.0319}}],[0.','511',546,'104',606,'107',633,'639',75,'527',523,'351',77,511,401,530,'444',49,'016',132,'106":0.0319',4,'639',565,'116',606,'117',606,'98',606,'121',606,'118',606,'119',633,'319',75,'351',48,146,'607',565,'97":-0.0639,"101',606,'97',606,'111',606,'99',633,'319',75,'958',546,'116',606,'117',606,'98',606,'121',606,'118',606,'119',633,'639',546,'116',606,'117',606,'98',606,'121',606,'118',606,'119',633,530,'444,0',762,'639,0.444,0',160,762,'607,0.444',146,'474',523,'454',523,'447,0.635,0,{krn:{"121',606,'119',633,'639',546,'119',633,849,81,'016',132,'97":-0.0639,"101',606,'97',606,'111',606,'99',633,'831,0.444',81,'016',132,'101',606,'97',606,'111',606,'99',633,'607',523,849,49,'016',132,'111',606,'101',606,'97',606,685,'511',523,530,'444',81,'0319',474,'15,0.444',81,'0319}],[0.575',75,'575',75,'575',48,']]};','jsMath.Img','={fonts:[50,60,70,85,100,120,144,173,207,249,298,358,430],w:{"50":6.9,"60":8.3,"70":9.7,"85":11.8,"100":13.9,"120":16.7,"144":20,"173":24,"207":28.8,"249":34.6,"298":41.4,"358":49.8,"430":59.8},best:4,update:{},factor:1,loaded:0,SetFont',':function(','B){for(var A in B){if(!','this.update[A',']){',920,']=[]}',920,']=',920,'].concat(B[A])}},AddFont',918,'A,B){if(!',916,'[A]){',916,'[A]={}}jsMath.Add(',916,'[A],B)},UpdateFonts',':function(){','var D=this.update;','if(!this.loaded){','return }for(var A in D){for(var B=0;B<D[A].length;B++){var C=D[A][B];if(C=="all"){for(C in ','jsMath.TeX[','A]){',940,'A][C].img','={}}}else{',940,943,'={}}}}this.update={}},BestSize',936,'var B=jsMath.em*this.factor;var A=','this.w[this.fonts[','0]];for(var C=1;C<this.fonts.length;C++){if(B<(',950,'C]]+2*A)/3){return C-1}A=',950,'C]]}return C-1},Scale',936,938,'return }this.best=this.BestSize();this.em=',916,'.w[this.fonts[this.best]];','this.scale','=(jsMath.em/this.em);','if(Math.abs(',961,'-1)<0.12){',961,'=1}},URL',918,'A,B,E){var D=(','jsMath.Controls.cookie.','alpha)?"/alpha/":"/plain/";','if(E==null','){E="def.js"}else{E="char"+E+".png"}if(B!=""){B+="/"}','return this.','root+A+D+B+E},LoadFont',918,'A){',938,'this.Init()}jsMath.Setup.Script(this.URL(A,""))},Init',936,'if(',970,'print||',970,'stayhires','){',970,'print=',970,985,';this.factor*=3;if(!','jsMath.Controls.','isLocalCookie||!jsMath.Global.isLocal){',992,'SetCookie(0)}if(','jsMath.Browser.','alphaPrintBug){',970,'alpha=0}}var B="0123456789ABCDEF";this.HexCode=[];for(var C=0;C<128;C++){var D=Math.floor(C/16);var A=C-16*D;this.HexCode[C]=B.charAt(D)+B.charAt(A)}this.loaded=1}};jsMath.HTML={Em',918,'A){var C=','5;if(A<0){C++}',963,'A)<0.000001){A=0}var B=String(A);B=B.replace(/(\\.\\d\\d\\d).+/,"$1");return B+"em"},Spacer',918,'A){if(A==0){return""}return ',996,'msieSpaceFix+"<','span class=\\"spacer\\" style=\\"margin-','left:"+this.Em(','A)+"\\"></span>"},Blank',918,'B,E,G,F){var A="";var D="";if(F){D+="border-',1010,'B)+" solid;";if(',996,'widthAddsBorder){B=0}}if(B==0){if(',996,'blankWidthBug){if(',996,'quirks','){D+="width:1px',';";A="<',1009,'right:-1px\\"></span>"}else{if(!F',1022,';margin-right:-1px;"}}}}else{D+="width',':"+this.Em','(B)+";"}if(G==null){G=0}if(E){var C=this.Em(E+G);if(F&&E*jsMath.em<1.5){C="1px";E=1/jsMath.em}D+="height:"+C+";"}if(',996,'mozInlineBlockBug){G=-E}if(',996,'msieBorderBug&&!F){G-=jsMath.d}if(G){D+="vertical-align',1028,'(-G)}return A+"<span class=\\"blank\\" ','style=\\""+','D+"\\"></span>"},Rule',918,'A,B){if(B==null){B','=jsMath.TeX.default_rule_thickness}',974,'Blank(A,B,0,1)},Class',918,'A,B){return"<span class=\\""+A','+"\\">"+B+"</span','>"},Place',918,'B,A,D){',963,'A',')<0.0001){','A=0}',963,'D',1051,'D=0}if(A||D){var C="<','span style=\\"position',': relative',';";if(A){C+=" margin-',1010,'A)+";"}if(D){C+=" top',1028,'(-D)+";"}B=C',1045,'>"}return ','B},PlaceSeparateSkips',918,'E,G,F,I,A,H){',963,'G',1051,'G=0}',963,'F',1051,'F=0}if(F){var D=0;var C=0;var B="";if(I!=null){C=A-H;D=I;B=" width',1028,'(A-I)+";"}E=','this.Spacer','(D-C)+"<',1057,1058,'; "+"top',1028,'(-F)+";"+"',1010,'C)+";"+B+"\\">"+',1079,'(-D)+E+',1079,'(C)+"</span>"}if(G){E=',1079,'(G)+E}return E},PlaceAbsolute',918,'E,B,H,G,D,C){',963,'B',1051,'B=0}',963,'H',1051,'H=0}var F="";var A="";if(',996,'msieRelativeClipBug&&G!=null){F=',1079,'(-G);B+=G;A=',1079,'(D-C)}E="<',1057,':absolute','; ',1010,'B)+"; "+"top',1028,'(H)+";\\">"+F+E+A','+"&nbsp;"+"</span','>";return ','E},','Absolute',918,'B,A,C,D,E){if(E!="none"){',963,'E',1051,'E=0}B="<',1057,1111,'; "+"top:"+','jsMath.HTML.','Em(E)+"; left:0em;\\">"+B',1117,'>"}if(D=="none"){D=0}B+=this.Blank(A,C-D,D);if(',996,'msieAbsoluteBug){B="<',1057,':relative',';\\">"+B+"</span>"}B="<',1057,1137,';"+',996,'msieInlineBlockFix',1045,1118,'B}};','jsMath.Box','=function(C,E,A,B,D){if(D==null){D=jsMath.d}this.type="typeset";this.w=A;this.h=B;this.d=D;this.bh=B;this.bd=D;this.x=0;this.y=0;this.mw=0;this.Mw=A;this.html=E;this.format=C};jsMath.Add(',1147,',{defaultH:0,Null',936,'return new ',1147,'("null","",0,0,0)},Text',918,'J,I,A,K,H,G){var E=','jsMath.Typeset.AddClass(','I,J);E=','jsMath.Typeset.','AddStyle(','A,K,E);var B','=jsMath.EmBoxFor(','E);var C=',1159,'TeX(A,K);var F=((I=="cmsy10"||I=="cmex10")?B.h-C.h:C.d*B.h/C.hd);var D=new ',1147,'("text",J,B.w,B.h-F,F);D.style=A;D.size=K;D.tclass=I;if(G!=null){D.d=G*C.scale}else{D.d=0}if(H==null||H==1){D.h=0.9*C.M_height}else{D.h=1.1*C.x_height+C.scale*H}return D},TeX',918,'H,A,E,B){var I=',940,'A][H];','if(I.d==null){I.d=0}','if(I.h==null){I.h=','0}if(I.img!=null&&I.c!=""){this.TeXIMG(A,H,',1159,'StyleSize(E,B))}var G=',1159,'TeX(E,B).scale;var D=I.h+',940,'A].dh;var F=new ',1147,'("text",I.c,I.w*G,D*G,I.d*G);F.style=E;F.size=B;if(I.tclass){F.tclass=I.tclass;if(I.img){F.bh=I.img.bh;F.bd=I.img.bd}else{F.bh=G*jsMath.h;F.bd=G*jsMath.d}}else{F.tclass=A;F.bh=G*',940,'A].h;F.bd=G*',940,'A].d;if(',996,'msieFontBug&&','F','.html.match(/&#/)){','F','.html+="<span style=\\"display:none\\">x</span','>"}}return F},TeXfallback',918,'A,D,B,L){var J=',940,'D][A];if(!J.tclass){J.tclass=D}if(J.img!=null){',974,'TeXnonfallback(A,D,B,L)}if(J.h!=null&&J.a==null){J.a=J.h-1.1*jsMath.TeX.x_height}var K=J.a;var I=J.d;var H=this.Text(J.c,J.tclass,B,L,K,I);var E=',1159,'TeX(B,L).scale;if(J.bh!=null){H.bh=J.bh*E;H.bd=J.bd*E}else{var G=H.bd+H.bh;var F=',1157,'H.tclass,H.html);F=',1159,1160,'B,L,F);H.bd',1162,'F+',1130,'Blank(1,G)).h-G;H.bh=G-H.bd;if(E==1){J.bh=H.bh;J.bd=H.bd}}if(jsMath.',1188,'H',1190,'H',1192,1065,'H},TeXIMG',918,'E,A,R){var M=',940,'E][A];if(M.img.size!=null&&M.img.size==R&&M.img.best!=null&&M.img.best==','jsMath.Img.best','){return }var F=(',916,'.scale!=1);var B=',1222,'+R-4;if(B<0){B=0;F=1','}else{if(','B>=','jsMath.Img.fonts','.length){','B=',1230,'.length-1',';F=1}}var Q=',916,'[',1230,'[B]];var I=Q[E][A];var G=1/',916,'.w[',1230,'[B]];if(B!=',1222,'+R-4){if(M.w!=null){G=M.w/I[0]}else{G*=',1230,'[R]/',1230,'[4]*',1230,'[',1222,']/',1230,'[B]}}var N=I[0]*G;var J=I[1]*G;var L=-I[2]*G;var O;var H=(M.w==null||Math.abs(M.w-N)<0.01)?"":" margin-right:"+',1130,'Em(M.w-N)+";";var D="";A=',916,'.HexCode[A];if(!F&&!',970,'scaleImg){if(2*N<J||(',996,'msieAlphaBug&&',970,'alpha)){D="height',':"+(I[1]*',996,'imgScale',')+"px;"}D+=" width:"+(I[0]*',996,1268,')+"px;";O=-I[2]+"px"}else{if(2*N<J||(',996,'msieAlphaBug&&',970,1265,':"+',1130,'Em(J*',996,1268,')+";"}D+=" width:"+',1130,'Em(N*',996,1268,')+";";O=',1130,'Em(L)}var P=(Math.abs(L)<0.01&&!',996,'valignBug)?"":" vertical-align:"+O+";";var K=',916,'.URL(E,',1230,'[B],A);if(',996,'msieAlphaBug&&',970,'alpha){','M.c="<img src=\\""+','jsMath.blank+"\\" "+"',1036,996,'msieCenterBugFix+D+P+H','+" filter:progid:DXImageTransform.Microsoft.AlphaImageLoader(src="+"\'"+K+"\', sizingMethod=\'scale\'"+");\\" />"}else{',1300,'K+"\\" ',1036,996,1304,'+"\\" />"}M.tclass="normal";M.img.bh=J+L;M.img.bd=-L;M.img.size=R;M.img.best=',1222,'},Space',918,'A){return ','new jsMath.Box("html",',1130,'Spacer(A),A,0,0)},Rule',918,'A,C){if(C','==null){C',1040,'var B=',1130,'Rule(A,C);return ',1316,'B,A,C,0)},GetChar',918,'B,',1001,940,'A][B];','if(C.img!=null){this.TeXIMG(A,B',',4)}if(C.tclass',1321,'.tclass=A}if(!C.computedW){C.w',1162,1157,'C.tclass,C.c)).w',';if(C.h',1321,'.h=',1147,'.defaultH}if(C.d',1321,'.d=0}C.computedW=1}return C},DelimBestFit',918,'E,J,D,G){if(J==0&&D==0){return null}var I;var F;D','=jsMath.TeX.fam[','D];var A=(G.charAt(1)=="S");var B=(G.charAt(0)=="S");while(J!=null){I=',940,'D][J];',1173,1147,'.defaultH}',1172,'F=I.h+I.d;if(I.delim){return[J,D,"",E]}if(A&&0.5*F>=E','){return[J,D,"','SS",0.5*F]}if(B&&0.7*F>=E',1358,'S",0.7*F]}if(F>=E||I.n==null',1358,'T",F]}J=I.n}return null},DelimExtendRelative',918,'I,T,O,V,D){var P=',940,'O][T];var N','=this.GetChar(','P.delim.','top?P','.delim.top:','P.delim.rep,O);var ','A',1368,1372,'M',1368,1369,'bot?P','.delim.bot:',1372,'E=',1157,'A.tclass,A.c);','var J=A.w;var S=A.h+A.d;var F;var B;var K;var L;var R;var Q;if(',1369,'mid){var U',1368,1369,'mid,O);Q','=Math.ceil((I-(','N.h+N.d)-(','U.h+U.d)-(M.h+M.d','))/(2*(A.h+A.d',')));I=2*','Q*(A.h+A.d)+(N.h+N.d)+(','U.h+U.d)+(M.h+M.d);if(D){F=0}else{F=I/2+V}B=F;K=','jsMath.HTML.Place(',1157,'N.tclass,N.c),0,F-N.h',')+',1398,1157,'M.tclass,M.c),-(','N.w+M.w)/2,F-(I-M.d))+',1398,1157,'U.tclass,U.c),-(M.w+U.w)/2,F-(I+U.h-U.d)/2);L=(J-U','.w)/2;if(Math.abs(L)<0.0001){L=0}if(L){K+=jsMath.HTML.Spacer(L)}F-=N.h+N.d+A.h;for(R=0;R<Q;R++){K+=jsMath.HTML.Place(E,-J,F-R*S)}','F-=I/2-A.h/2;for(R=0;R<Q;R++){K+=',1398,'E,-J,F-R*S)}}else{Q',1391,1392,'M.h+M.d))/(A.h+A.d));if(N.h+N.d<0.9*(A.h+A.d)){Q=Math.max(1,Q)}I=',1396,'M.h+M.d);if(D){F=0}else{F=I/2+V}B=F;K=',1398,1157,1400,');L=(J-N',1409,'K+=',1398,1157,1404,'J+M.w)/2,B-(I-M.d))}if(D){S=N.h}else{S=I/2+V}var G=',1316,'K,A.w,S,I-S);G.bh=',940,'O].h;G.bd=',940,'O].d;return G},DelimExtendAbsolute',918,'I,S,M,U,B){var R=',940,'M];var N=R[S];var J;var L',1368,'N.delim.top?N',1371,'N.delim.rep,M);var ','A',1368,1441,'K',1368,'N.delim.bot?N',1380,1441,'O;var Q;var E;var D;var P;if(N.delim.mid){var T',1368,'N.delim.mid,M);O',1391,'L.h+L.d)-(','T.h+T.d-0.05',')-(','K.h+K.d-0.05',1394,'-0.05',1395,'O*(A.h+A.d-0.05)+(L.h+L.d)+(',1455,')+(',1457,');J=','jsMath.HTML.PlaceAbsolute(',1157,'L.tclass,L.c),0,0);Q=A.h+A.d-0.05;E=L.d-0.05+A.h;D=',1157,'M,A.c);for(P=0;P<O;P++){J+=',1466,'D,0,E+P*Q)}J+=',1466,1157,'T.tclass,T.c),0,E+O*Q-A.h+T.h);E+=O*Q+',1455,';for(P=0;P<O;P++){J+=',1466,'D,0,E+P*Q)}J+=',1466,1157,'K.tclass,K.c),0,E+O*Q-A.h+K.h)}','else{O',1391,1454,1457,'))/(A.h+A.d-0.05));I=',1461,1457,');J=',1466,1157,'L.tclass,L.c),0,0);Q=A.h+A.d-0.05;E=L.d-0.05+A.h;D=',1157,1384,'for(P=0;P<O;P++){J+=',1466,'D,0,E+P*Q)}J+=',1466,1157,1482,'var G=L.w;if(B){Q=L.h;E=0}else{Q=I/2+U;E=Q-L.h}J=',1130,1120,'(J,G,R.h,"none",-E);var F=',1316,'J,A.w,Q,I-Q);F.bh=',940,'M].h;F.bd=',940,'M].d;return F},Delimiter',918,'B,I,C,G){var A=4;var F=',1159,'TeX(C,A);if(!I','){return this.Space(F.nulldelimiterspace)}','var ','E=this.DelimBestFit(B,I[','2],I[1],C);',972,'||E[3]<B){',1518,'4],I[3],C)}',972,1516,'if(E[2]==""){',974,'DelimExtend(B,E[0],E[1],F.axis_height,G)}var D=',1147,'.TeX(E[0],E[1],E[2],A).Styled();if(G){D.y=-',940,'E[1]].dh*F.scale}else{D.y=-((D.h+D.d)/2-D.d-F.axis_height)}',963,'D.y',1051,'D.y=0}if(D.y){D=',1147,'.SetList([D],E[2],A)}return D},GetCharCode',918,'B){var A',1349,'B[0]];var D=',940,'A];var C=D[B[1]];',1333,'[1],4)}if(C.w',1321,'.w',1162,1157,1339,'}if(C.font',1321,'.font=A}return C},AddClass',918,'B,C,A){if(B==null){B=A}return ',1157,'B,C)},LayoutRelative',918,'V,f,Y,I,J,N,c,X){if(Y==null){Y=[]}if(I==null){I=[]}if(J==null){J=[]}if(c==null){c=1}','if(X==null){X=1}','var k=jsMath.sizes[V]/100;var G=[];var T=[];var U=[];var E=-1000;var F=E;var K=E;var a;var Z;var M',';for(a=0;a<f.length;a++){','if(J[a]==null){J[a]=0}M=f[a];T[a]=c*jsMath.h*k;U[a]=c*jsMath.d*k;for(Z=0;Z<M.length;Z++){M[Z]=M[Z','].Remeasured();if(','M[Z].h>T[a]){T[a]=M[Z].h}if(M[Z].d>U[a]){U[a]=M[Z].d}if(Z>=G',1231,'G[Z]=M[Z].w',1228,'M[Z].w>G[Z]){',1568,'}}if(M[Z].bh>F){F=M[Z].bh}if(M[Z].bd>K){K=M[Z].bd}}}if(J[f','.length]==null){','J[f.length]=0}if(F==E){F=0}if(K==E){K=0}var A=c','*(jsMath.hd-0.01)*','k;var S=(N||1)*k/6;var R="";var L=0;var e=0;var Q;var b;var O;var P;var C;var B;for(Z=0;Z<G.length;Z++){C=[];O=-T[0]-J[0];L=0',1563,'B=f[a][Z','];if(B&&B.format!="null"){if(','Y[Z]=="l"){Q=0',1228,'Y[Z]=="r"){Q=G[Z]-B.w}else{Q=(G[Z]-B.w)/2}}B.x=Q-L;L=B.w+Q;B.y=O;C[C.length]=B}if(a+1<f',1231,'O-=Math.max(A,U[a]+T[a+1])+S+J[a+1]}}if(I[Z]==null){I[Z]=k}if(C.length>0){P=',1147,'.SetList(C,"T",V);R+=',1398,'P.html,e,0);e=G[Z]-P.w+I[Z]}else{e+=I[Z]}}Q=-I[G',1234,'];O=(T',1234,')*S+J[0];for(a=0;a<G.length;a++){Q+=G[a]+I[a]}for(a=0;a<T.length;a++){O','+=Math.max(A,','T[a]+U[a])+J[a+1]}b=O','/2+jsMath.TeX.axis_height;var ','g=O-b;R+=',1130,'Spacer(e-I[G',1234,']+X*k/6);R=',1398,'R,X*k/6,b);P=',1316,'R,Q+X*k/3,b,g);P.bh=F;P.bd=K;return P},LayoutAbsolute',918,'R,Z,U,E,F,I,X,S){if(U==null){U=[]}',972,'){E=[]}if(F==null){F=[]}',1561,'if(S==null){S=1}var b=jsMath.sizes[R]/100;var A=X',1575,'b;var N=(I||1)*b/6;var C=[];var O=[];var Q=[];var P=0;var Y;var L;var J;var V;var T;var G;','for(V=0;V<Z.length;V++){','if(F[V]==null){F[V]=0}G=Z[V];O[V]=X*jsMath.h*b;Q[V]=X*jsMath.d*b;for(T=0;T<G.length;T++){G[T]=G[T',1565,'G[T].h>O[V]){O[V]=G[T].h}if(G[T].d>Q[V]){Q[V]=G[T].d}if(T>=C',1231,'C[T]=G[T].w',1228,'G[T].w>C[T]){',1618,'}}}}if(F[Z',1573,'F[Z.length]=0}J=(O',1234,')*N+F[0];for(V=0;V<O.length;V++){J',1593,'O[V]+Q[V])+F[V+1]}Y=J',1595,'a=J-Y;var M="";var B;P=S*b/6;for(T=0;T<C.length;T++){J=O[0]-Y+F[0];',1613,'B=Z[V][T',1579,'U[T]&&U[T]=="','l"){L=0',1228,1634,'r"){L=C[T]-B.w}else{L=(C[T]-B.w)/2}}M+=',1466,'B.html,P+L,J-Math.max(0,B.bh-jsMath.h*b),B.mw,B.Mw,B.w)}if(V+1<Z',1231,'J',1593,'Q[V]+O[V+1])+N+F[V+1]}}if(E[T]==null){E[T]=b}P+=C[T]+E[T]}P=-E[C',1234,']+S*b/3;for(V=0;V<C.length;V++){P+=C[V]+E[V]}M=',1130,'Spacer(S*b/6',')+M+',1130,1648,');if(',996,'spanHeightVaries){J=Y-jsMath.h}else{J=0}M=',1130,1120,'(M,P,Y+a,a,J);var K=',1316,'M,P+S*b/3,Y,a);return K},InternalMath',918,'G,E){G=G.replace(/@\\(([^)]*)\\)/g,"<$1>");if(!G.match(/\\$|\\\\\\(/)){',974,'Text(G,"normal","T",E).Styled()}var D=0;var B=0;var H;var C="";var A=[];var F;while(D<G',1231,'H=G.charAt(D++);if(H','=="$"){if(C=="$"){','F=jsMath.Parse(G.slice(B,D-','1','),null,E);if(F.error){A[A.length]=this.Text(F.error,"error","T",E,1,0.2)}else{F.Atomize();A[A.length]=F.mlist.Typeset("T",E).Styled()}C="";B=D','}else{','A[A.length]=this.Text(G.slice(B',',D-1','),"normal","T",E,1,0.2);','C="$";B=D}}else{if(H=="\\\\"){',1665,'=="("&&C==""){',1671,',D-2',1673,'C=")";B=D',1228,'H==")"&&C==")"){',1667,'2',1669,'}}}}}',1671,1673,974,'SetList(A,"T",E)},Set',918,'C,B,A,D){if(C&&C.type){if(C.type=="typeset"){return C}if(C.type=="mlist"){C.mlist.Atomize(B,A);return C.mlist.Typeset(B,A)}if(C.type=="text"){C=this.Text(C.text,C.tclass,B,A,C.ascend||null,C.descend||null);if(D!=0){C.Styled()}return C}C=this.TeX(C.c,C.font,B,A);if(D!=0){'],
  ['C','.Styled()}','return ','C}',2,'jsMath.Box.','Null()},','SetList',':function(','D,F,C){var A=[];var G;','for(var B=0;B<','D.length',';B++){','G=D[B];if(G','.type=="','typeset"){G=','jsMath.mItem','.','Typeset','(G)}A[A','.length]=','G}','var E=','new ','jsMath.Typeset','(A);',2,'E.',18,'(F,C)}});','jsMath.Package(jsMath.','Box,{Styled',':function(){','if(this.','format=="text"){','this.html','=',24,'.AddClass(','this.tclass',',',35,');',35,'=',24,'.AddStyle(','this.style',',this.size,',35,');delete ',39,';delete ',47,';this.format="html"}',2,'this},','Remeasured',32,33,'w>0){this.w=jsMath.EmBoxFor(',35,').w}',2,'this}});',16,'=function(A',',B','){this.type','=A;','jsMath.Add(','this,B)};',70,16,',{Atom',8,'B,A){',2,'new ',16,'(B,{','atom:1,nuc:A})},','TextAtom',8,'C,F,B,A,E){var D=new ',16,'(C',',{atom:1,nuc:{type:"','text",text:F,tclass:B}});if(A','!=null){D.nuc.','ascend=A}if(E',89,'descend=E}',2,'D},TeXAtom',8,'B,','C,A){',2,'new ',16,'(B',87,'TeX",c:C,font:A}})},Fraction',8,'B,A,F,D,E,C){',2,'new ',16,'("fraction",{from:B,num:A,den:F,','thickness',':D,left:E,right:C})},Space',8,'A){',2,'new ',16,'("space",{w:A})},',18,8,'A){',2,'new ',16,'("ord",{',81,'HTML',8,'A){',2,'new ',16,'("html",{html:A})}});','jsMath.mList','=function(D,A,B,C){','if(D){','this.mlist','=D}else{',136,'=[]}','if(C==null){C','="T"}if(B==null){B=4}','this.data','={openI:null,overI:null,overF:null,font:A,','size:B,style:C','};this.init={',144,'}};',30,'mList,{Add',8,'A){return(',136,'[','this.mlist.length',']=A)},Get',8,'A){',2,136,'[A]},Length',32,2,154,'},Last',32,'if(',154,'==0){',2,'null}',2,136,'[',154,'-1]},Range',8,76,'if(A==null){A=',154,'}',2,'new jsMath.','mList(',136,'.slice(B,A+1))},Delete',8,'D,C){',140,'=D}if(',136,'.splice){',136,'.splice(D,C-D+1)}else{var A=[];',10,154,12,'if(B<D||B>C){A[A',20,136,'[B]}}',136,'=A}},Open',8,'D){var C=','this.Add(','new ',16,'("boundary",{','data:',142,'}));','var A=',142,';',142,'={};for(var B in A){',142,'[B]=A[B]}delete ',142,'.overI',52,142,'.overF;',142,'.openI','=',154,'-1;if(D!=null){C.left=D}',2,'C},Close',8,'C){if(C!=null){C=new ',16,208,'right:C})}var E;','var B=',142,225,';var F=',142,'.overI;','var G=',142,223,142,'=',136,'[B].data;if(F){E=',16,'.Fraction(','G.name,{','type:"mlist",mlist:this.Range(','B+1,F-1)},{',252,'F)},G.',110,',G.left,G.right);if(C){',212,182,'mList([',136,'[B],E,C]);E=',16,'.Atom("inner",{type:"mlist",mlist:A})}}else{var D=B+1;if(C){',205,'C);D--}E=',16,'.Atom((C)?"inner":"ord",{',252,'D)})}this.Delete(B,this.Length());',2,205,'E)},Over',32,236,142,241,'var C=',142,223,212,16,250,'C.name,{',252,'open+1,B-1)},{',252,'B)},C.',110,',C.left,C.right);',136,'=[A]},Atomize',8,187,'var A;var E="";',47,'=D;this.size=C;',10,154,12,'A=',136,'[B];A.delta=0;if(A',14,'choice"){',136,'=this.Atomize.choice(',47,',A,B,',136,');B--}else{',33,'Atomize[A.type',']){var F=this.',313,'];F(',47,48,'A,E,this,B)}}E=A}if(A&&A',14,'bin"){A','.type="ord"}','if(',154,'>=2&&A',14,'boundary"&&',136,'[0].type=="boundary"){this.','AddDelimiters','(D,C)}},',330,8,'A,N){var M=-10000;',22,'M;',242,'M;for(var D=0;D<',154,';D++){var F=',136,'[D];if(F.atom||F',14,'box"){E','=Math.max(','E,F.nuc.h+F.nuc.y);G',345,'G,F.nuc.d-F.nuc.y)}}var C=jsMath.TeX;var I=',24,'.TeX(A,N).','axis_height',';var L',345,'E-I,G+I);var K',345,'Math.floor(C.integer*L/500)*C.delimiterfactor,C.integer*(2*L-C.delimitershortfall))/C.integer;',236,136,'[0];var J=',136,'[',154,'-1];B.nuc=',5,'Delimiter(','K,B.left,A);J.nuc=',5,365,'K,J.right,A);B.type="open";B.atom=1',52,'B.left;J.type="close";J.atom=1',52,'J.right},',18,8,97,236,'new ',24,'(',136,');',2,'B.',18,'(C,A)}});',70,133,'.prototype.Atomize,{style',8,'D,C,A,E,B){B.','style=A.style},size',8,391,'size=A.size},phantom',8,'C,B,A){var D=','A.nuc=',5,'Set(','A.phantom',',C,B);if(A.h){D.',57,'();D.html=','jsMath.HTML.Spacer','(D.w)}else{D.html="",D.w=D.Mw=D.mw=0}if(!A.v){','D.h=D.d=0','}D.bd=D.bh=0',52,401,';A.type="box"},','smash',8,397,398,5,'Set(A.smash,C,B',').Remeasured();',407,52,'A.smash',411,'raise',8,'C,B,A){',398,5,'Set(A.nuc,','C,B);var D=A.raise;','A.nuc.html','=jsMath.HTML.','Place(',430,',0,D,A.nuc.mw,A.nuc.Mw,A.nuc.w);A.nuc.h+=D;A.nuc.d-=D;A','.type="ord";','A.atom=1},lap',8,'D,',97,22,5,428,'D,C',418,'var B=[E];if(A.lap=="llap"){E.x=-E.w}','else{if(A.lap=="','rlap"){B[1]=',16,'.Space(-E.w)}',446,'ulap"){E.y=E.d;E.h=E.d=0}',446,'dlap"){E.y=-E.h;E.h=E.d=0}}}}',398,5,7,'(B,D,C);if(A.lap=="ulap"||A.lap=="dlap"){A.nuc.h=A.nuc.d=0}A.type="box";delete A.atom},bin',8,'D,B,A,E){if(E&&E.type){var C=E.type;if(C=="bin"||C=="op"||C=="rel"||C=="open"||C=="punct"||C==""||(C=="',327,'E.left!="")){A.type="ord"}}else{A',322,'jsMath.mList.prototype.Atomize.SupSub(','D,B,A)},rel',8,'C,B,A,D){if(D.type&&D',14,'bin"){D',322,463,'C,B,A)},','close',8,'C,B,A,D){if(D.type&&D',14,'bin"){D',322,463,471,'punct',8,'C,B,A,D){if(D.type&&D',14,'bin"){D',322,463,471,'open',8,425,463,471,'inner',8,425,463,471,'vcenter',8,397,5,428,'C,B);',22,24,'.TeX(C,B);D.y=E.',351,'-(D.h-D.d)/2;',398,'D;A',435,463,471,'overline',8,'D,',97,242,24,'.TeX(D,','C);',22,5,428,24,'.PrimeStyle(','D),C',418,236,'G','.default_rule_thickness',239,5,'Rule(E.w,B);F.x=-F.w;F.y','=E.h+3*B;',398,5,7,'([E,F],D,C);A.nuc.','h+=B;A',435,463,'D,C,A)},','underline',8,'D,',97,242,24,520,'C);',22,5,428,24,526,'D),C',418,236,'G',531,239,5,534,'=-E.d-3*B-B;',398,5,7,539,'d+=B;A',435,463,543,'radical',8,'B,M,G){var D=',24,'.TeX(B,M);var K=',24,526,'B);var F=',5,'Set(G.nuc,K,M',418,'var L=D',531,';var C=L;if(B=="D"||B=="D\'"){C=D.x_height}',212,'L+C/4;',22,5,365,'F.h+F.d+A+L,[0,2,112,3,112],B,1);if(E.d>F.h+F.d+A){A=(A+E.d-F.h-F.d)/2}E.y=F.h+A;var J=',5,'Rule(F.w,L);J.y=E.y-L/2;J.h+=3*L/2;F.x=-F.w;var I=',24,'.UpStyle(',24,597,'B));var H=',5,'Set(G.root||null,I,M',418,'if(G.root){H.y=0.55*(F.h+F.d+3*L+A)-F.d;E.x',345,'H.w-(11/18)*E.w,0);J.x=(7/18)*E.w;H.x=-(H.w+J.x)}G.nuc=',5,7,'([E,H,J,F],B,M);G',435,463,'B,M,G)},accent',8,'B,P,I){',22,24,'.TeX(B,P);var L=',24,526,'B);var H=',5,'Set(I.nuc,L,P);var N=H.w;var O;var J;var C=0;if(I.nuc',14,'TeX"){','J=','jsMath.TeX[','I.nuc.font];if(J[I.nuc.c].krn&&J.skewchar){O=J[I.nuc.c].krn[J.skewchar]}C=J[I.nuc.c].ic;',140,'=0}}if(O==null){O=0}var K=I.accent[2];var D=jsMath.TeX.fam[I.accent[1]];J=',626,'D];while(J[K].n&&J[J[K].n].w<=N){K=J[K].n}var M=Math.min(H.h,E.x_height);if(I.nuc',14,624,242,16,'.Atom("ord",I.nuc);G.sup=I.sup;G.sub=I.sub;G.delta=0;',463,'B,P,G);M+=(G.nuc.h-H.h);H=I.nuc=G.nuc',52,'I.sup',52,'I.sub}var F=',5,'TeX(K,D,B,P);F.y=H.h-M;F.x=-H.w+O+(N-F.w)/2;if(jsMath.Browser.msieAccentBug){F.html+=',405,'(0.1);F.w+=0.1;F.Mw+=0.1}if(J[K].ic||C){F.x+=(C-(J[K].ic||0))*E.scale}I.nuc=',5,7,'([H,F],B,P);if(I.nuc.w!=H.w){',212,16,'.Space(','H.w-I.nuc.w);I.nuc=',5,7,'([I.nuc,A],B,P)}I',435,463,'B,P,I)},op',8,'D,O,J){',242,24,520,'O);var I;J.delta=0;var N=(D','.charAt(0)=="','D");if(J.limits==null&&N){J.limits=1}if(J.nuc',14,624,236,626,'J.nuc.font][','J.nuc.c];if(N&&B.n){J.nuc.c=B.n;B=',626,672,'B.n]}I=J.nuc=',5,'Set(J.nuc,D,O',');if(B.ic){J.delta=B.ic*G.scale;if(J.limits||!J.sub||','jsMath.Browser.msieIntegralBug','){I=J.nuc=',5,7,'([I,',16,652,'J.delta)],D,O)}}I.y=-((I.h+I.d)/2-I.d-G.',351,');if(Math.abs(I.y)<0.0001){I.y=0}}if(!I){I=J.nuc=',5,678,').',57,'()}if(J.limits){var F=I.w;var L=I.w;var E=[I];var K=0;var M=0;if(J.sup){var H=',5,'Set(J.sup,',24,597,'D),O',418,'H.x=((I.w-H.w)/2+J.delta/2)-L;K=G.big_op_spacing5;F',345,'F,H.w);L+=H.x+H.w;H.y=I.h+H.d+I.y+Math.max(G.big_op_spacing1,G.big_op_spacing3-H.d);E[E',20,'H',52,'J.sup}if(J.sub){',212,5,'Set(J.sub,',24,'.DownStyle(','D),O',418,'A.x=((I.w-A.w)/2-J.delta/2)-L;M=G.big_op_spacing5;F',345,'F,A.w);L+=A.x+A.w;A.y=-I.d-A.h+I.y-Math.max(G.big_op_spacing2,G.big_op_spacing4-A.h);E[E',20,'A',52,'J.sub}if(F>I.w){I.x=(F-I.w)/2;L+=I.x}if(L<F){E[E',20,16,652,'F-L)}J.nuc=',5,7,'(E,D,O);J.nuc.h+=K;J.nuc.d+=M','}else{if(',680,'&&J.sub&&B&&B.ic){J.nuc=',5,7,'([I,',5,'Space(-B.ic*G.scale)],D,O)}else{if(I.y){J.nuc=',5,7,'([I],D,O)}}',463,'D,O,J)}},ord',8,'A,I,G,B,F,E){if(G.nuc',14,'TeX"&&!G.sup&&!G.sub){var D=F.mlist[E+1];if(D&&D.atom&&D.type&&(D',14,'ord"||D',14,'op"||D',14,'bin"||D',14,'rel"||D',14,'open"||D',14,'close"||D',14,'punct")){if(D.nuc',14,'TeX"&&D.nuc.font==G.nuc.font){G.textsymbol=1;var H=',626,'G.nuc.font][G.nuc.c].krn;H*=',24,'.TeX(A,I).scale;if(H&&H[D.nuc.c]){for(var C=F.mlist.length-1;C>E;C--){F.mlist[C+1]=F.mlist[C]}F.mlist[E+1]=',16,652,'H[D.nuc.c])}}}}',463,'A,I,G)},fraction',8,'R,N,B){var U=',24,'.TeX(R,N);var L=0;if(B.',110,'!=null){L=B.',110,729,'B.from.match(/over/)){L=U',531,'}}var Q=(R',666,'D");var F=(R=="D")?"T":(R=="D\'")?"T\'":',24,597,'R);var P=(Q)?"T\'":',24,712,'R);',22,5,'Set(B.num,F,N',418,'var D=',5,'Set(B.den,P,N',418,'var K;var J;var I;var O;var M;var G=(Q)?U.delim1:U.delim2;var A=[',5,365,'G,B.left,R)];var S=',5,365,'G,B.right,R);if(E.w<D.w){E.x=(D.w-E.w)/2;D.x=-(E.w+E.x);I=D.w;A[1]=E;A[2]=D}else{D.x=(E.w-D.w)/2;E.x=-(D.w+D.x);I=E.w;A[1]=D;A[2]=E}if(Q){K=U.num1;J=U.denom1}else{K=(L!=0)?U.num2:U.num3;J=U.denom2}if(L==0){O=(Q)?7*U',531,':3*U',531,';M=(K-E.d',')-(D.h-J);if(M<O){','K+=(O-M)/2;J+=(O-M)/2}}else{O=(Q)?3*L:L;var T=U.',351,';M=(K-E.d)-(T+L/2);if(M<O){K+=O-M}M=(T-L/2',809,'J+=O-M}var C=',5,'Rule(I,L);C.x=-I;C.y=T-L/2;A[A',20,'C}E.y=K;D.y=-J;A[A',20,'S;B.nuc=',5,7,'(A,R,N);B',435,'B.atom=1',52,'B.num',52,'B.den;',463,'R,N,B)},SupSub',8,'F,R,L){var H=',24,'.TeX(F,R);var P=L.nuc;var K=L.nuc=',5,'Set(L.nuc,F,R,0);if(K.format=="null"){K=L.nuc=',5,'Text("","normal",F,R)}if(P',14,624,'if(!L.textsymbol){',22,626,'P.font][P.c];if(E.ic){L.delta=E.ic*H.scale;if(!L.sub){K=L.nuc=',5,7,'([K,',5,'Space(L.delta)],F,R);L.delta=0}}}else{L.delta=0}}if(!L.sup&&!L.sub){return }L.nuc.Styled();var I=',24,712,'F);var M=',24,597,'F);var D=',24,'.TeX(M,R).','sup_drop;',236,24,'.TeX(I,R).','sub_drop;var O=0;var N=0;var G;if(P.type&&P.type!="text"&&P.type!="TeX"&&P.type!="null"){O=K.h-D;N=K.d+B}if(L.sub){',212,5,'Set(L.sub,I,R);A=',5,7,'([A,',16,'.Space(H.scriptspace)],F,R',')}if(!L.sup){A.y=-Math.max(N,H.sub1,A.h-(4/5)*',24,862,'x_height);L.nuc=',5,7,'([K,A],F,R).Styled();delete L.sub;return }var J=',5,'Set(L.sup,M,R);J=',5,7,'([J,',16,871,');if(F=="D"){G=H.sup1',729,'F','.charAt(','F','.length-1)=="\'"){','G=H.sup3}else{G=H.sup2}}O',345,'O,G,J.d+',24,858,'x_height/4);if(!L.sub){J.y=O;L.nuc=',5,7,'([K,J],F,R',50,'L.sup;return }N',345,'N,',24,862,'sub2);var Q=H',531,';if((O-J.d)-(A.h-N)<4*Q){N=4*Q+A.h-(O-J.d);G=(4/5)*H.x_height-(O-J.d);if(G>0){O+=G;N-=G}}J.',57,'();A.',57,'();J.y=O;A.y=-N;J.x=L.delta;if(J.w+J.x>A.w){J.x-=A.w;L.nuc=',5,7,'([K,A,J],F,R)}else{A.x-=(J.w+J.x);L.nuc=',5,7,'([K,J,A],F,R)}delete L.sup',52,'L.sub}});',24,66,68,'="typeset";',136,'=A};',70,24,',{upStyle:{D:"S",T:"S","','D\'":"S\'","T\'":"S\'",S:"SS','",SS:"SS","','S\'":"SS\'","SS\'":"SS\'"},','downStyle:{D:"S\'",T:"S\'","',931,'\'",SS:"SS\'","',933,'UpStyle',8,'A){',2,'this.upStyle[A]},DownStyle',8,'A){',2,'this.downStyle[A]},PrimeStyle',8,'A){if(A',889,'A',891,2,'A}',2,'A+"\'"},StyleValue',8,76,'if(B=="S"||B=="S\'"){',2,'0.7*A}if(B=="SS"||B=="SS\'"){',2,'0.5*A}',2,'A},StyleSize',8,'B,A){if(B=="S"||B=="S\'"){A=Math.max(0,A-2)}else{if(B=="SS"||B=="SS\'"){A=Math.max(0,A-4)}}return ','A},TeX',8,966,'jsMath.TeXparams[A]},AddStyle',8,425,'if(C=="S"||C=="S\'"){B',345,'0,B-2)}else{if(C=="SS"||C=="SS\'"){B',345,'0,B-4)}}if(B!=4){A="<span class=\\"size"+B+"\\">"+A+"</span>"}',2,'A},AddClass',8,'A,B){if(A!=""&&A!="normal"){B',431,'Class(A,B)}',2,'B}});jsMath.Package(',24,',{DTsep:{ord',':{op:1,bin:2,rel:3,inner:1},','op',':{ord:1,op:1',',rel:3,inner:1},bin:{ord:2,op:2,open:2,inner:2},rel:{ord:3,op:3,open:3,inner:3},open:{},close',988,'punct',990,',rel:1,open:1,close',':1,punct:1,inner:1','},inner',990,',bin:2,rel:3,open',996,'}},SSsep:{ord:{op:1},op',990,'},bin:{},rel:{},open:{},close:{op:1},punct:{},inner:{op:1}},sepW:["","thinmuskip","medmuskip","thickmuskip"],','GetSeparation',8,'A,D,B){if(A&&A.atom&&D.atom){var C=this.DTsep;if(B',666,'S"){C=this.SSsep}',22,'C[A.type];if(E&&E[D.type]!=null){',2,626,'this.sepW[E[D.type]]]}}',2,'0},',18,8,187,47,297,'var G=-10000;this.w=0;this.mw=0;this.Mw=0;this.h=G;this.d=G;this.bh=this.h;this.bd=this.d;this.tbuf="";this.tx=0;',39,'="";','this.cbuf','="";this.hbuf="";this.hx=0;',212,'null;var F;this.x=0;','this.dx=0;',10,154,12,'F=A;A=',136,'[B];switch(A.type){case"size":','this.FlushClassed();','this.size=A.size;','A=F;break;case"','style":',1035,'if(',47,889,47,891,47,'=A.style+"\'"}else{',47,'=A.style}',1037,'space":if(typeof (A.w)=="object"){if(',47,889,'1)=="S"){A.w=0.5*A.w[0]/18',729,47,666,'S"){A.w=0.7*A.w[0]/18}else{A.w=A.w[0]/18}}}this.dx+=A.w-0;',1037,'html":',1035,'if(this.hbuf==""){this.hx=this.','x}','this.hbuf+=','A.html;A=F;break;default:if(!A.atom&&A.type!="box"){break}A.nuc.x+=this.dx+this.',1004,'(F,A,',47,');','if(A.nuc.x||A.nuc.y){','A.nuc',1,1028,'this.x=this.x+this.w;',33,'x','+A.nuc.x+A.nuc.','mw','<this.mw){this.mw=this.','x',1076,'mw}',33,'w',1076,'Mw','>this.Mw){this.Mw=this.w',1076,'Mw}this.w+=A.nuc.w+A.nuc.x;if(A.nuc.',34,'if(',39,'!=A.nuc.tclass&&',39,'!=""){','this.FlushText','()}',33,'tbuf==""&&',1024,'==""){this.tx=this.x}this.tbuf+=',430,';',39,'=A.nuc.tclass}else{',1035,1069,'this.Place(A.nuc)}',1061,'x}',1063,430,'}this.h',345,'this.h,A.nuc.h+A.nuc.y);this.bh',345,'this.bh,A.nuc.bh);this.d',345,'this.d,A.nuc.d-A.nuc.y);this.bd',345,'this.bd,A.nuc.bd);break}}',1035,33,'dx){',1063,405,'(this.dx);this.w+=this.dx;',33,'w',1086,'}',33,'w',1078,'w}}',33,'hbuf==""){',2,5,'Null()}',33,'h==G){this.h=0}',33,'d==G){this.d=0}',22,182,'Box("html",this.hbuf,this.w,this.h,this.d);E.bh=this.bh;E.bd=this.bd;E.mw=this.mw;E.Mw=this.Mw;',2,'E},FlushText',32,33,'tbuf','==""){return }',1024,'+=',24,'.AddClass(',39,',this.tbuf);this.tbuf="";',39,'=""},FlushClassed',32,1095,'();',33,'cbuf',1152,1061,'tx}',1063,24,'.AddStyle(',47,48,1024,');',1024,'=""},Place',8,'B){var A="<','span style=\\"position: relative',';";if(B.x){A+=" margin-left',':"+jsMath.HTML.Em','(B.x)+";"}if(B.y){A+=" top',1182,'(-B.y)+";"}B.html=A+"\\">"+B.html+"</span>";','B.h+=B.y;B.d-=B.y;B.x=0;B.y=0','},PlaceSeparateSkips',8,'B){if(B.y){var D=B.Mw-B.w;var C=B.mw;',212,'B.Mw-B.mw;B.html=',405,'(C-D)+"<',1180,'; "+"top',1182,'(-B.y)+";"+"left',1182,'(D)+"; width',1182,'(A)+";\\">"+',405,'(-C)+B.html+',405,'(D)+"</span>"}if(B.x){B.html=',405,'(B.x)+B.html}',1186,'}});jsMath.Parse',134,22,182,'Parser(D,A,B,C);E.Parse();',2,'E};jsMath.Parser',134,'this.string=D;this.i=0;',136,'=',182,183,'null,A,B,C)};',30,'Parser,{cmd:"\\\\",open:"{",close:"}",letter:/[a-z]/i,number:/[0-9]/,scriptargs:/^((math|text)..|mathcal|[hm]box)$/,mathchar:{"!":[5,0,33],"(":[4,0,40],")":[5,0,41],"*":[2,2,3],"+":[2,0,43],",":[6,1,59],"-":[2,2,0],".":[0,1,58],"/":[0,1,61],":":[3,0,58],";":[6,0,59],"<":[3,1,60],"=":[3,0,61],">":[3,1,62],"?":[5,0,63],"[":[4,0,91],"]":[5,0,93],"|":[0,2,106]},special:{"~":"Tilde","^":"HandleSuperscript","_":"HandleSubscript"," ":"Space","\\x01','":"Space","\\','t',1225,'r',1225,'n":"Space","\'":"Prime","%":"HandleComment","&":"HandleEntry","#":"Hash"},mathchardef:{braceld:[0,3,122],bracerd:[0,3,123],bracelu:[0,3,124],braceru:[0,3,125],alpha:[0,1,11],beta:[0,1,12],gamma:[0,1,13],delta:[0,1,14],epsilon:[0,1,15],zeta:[0,1,16],eta:[0,1,17],theta:[0,1,18],iota:[0,1,19],kappa:[0,1,20],lambda:[0,1,21],mu:[0,1,22],nu:[0,1,23],xi:[0,1,24],pi:[0,1,25],rho:[0,1,26],sigma:[0,1,27],tau:[0,1,28],upsilon:[0,1,29],phi:[0,1,30],chi:[0,1,31],psi:[0,1,32],omega:[0,1,33],varepsilon:[0,1,34],vartheta:[0,1,35],varpi:[0,1,36],varrho:[0,1,37],varsigma:[0,1,38],varphi:[0,1,39],Gamma:[7,0,0],Delta:[7,0,1],Theta:[7,0,2],Lambda:[7,0,3],Xi:[7,0,4],Pi:[7,0,5],Sigma:[7,0,6],Upsilon:[7,0,7],Phi:[7,0,8],Psi:[7,0,9],Omega:[7,0,10],aleph:[0,2,64],imath:[0,1,123],jmath:[0,1,124],ell:[0,1,96],wp:[0,1,125],Re:[0,2,60],Im:[0,2,61],partial:[0,1,64],infty:[0,2,49],prime:[0,2,48],emptyset:[0,2,59],nabla:[0,2,114],surd:[1,2,112],top:[0,2,62],bot:[0,2,63],triangle:[0,2,52],forall:[0,2,56],exists:[0,2,57],neg:[0,2,58],lnot:[0,2,58],flat:[0,1,91],natural:[0,1,92],sharp:[0,1,93],clubsuit:[0,2,124],diamondsuit:[0,2,125],heartsuit:[0,2,126],spadesuit:[0,2,127],coprod:[1,3,96],bigvee:[1,3,87],bigwedge:[1,3,86],biguplus:[1,3,85],bigcap:[1,3,84],bigcup:[1,3,83],intop:[1,3,82],prod:[1,3,81],sum:[1,3,80],bigotimes:[1,3,78],bigoplus:[1,3,76],bigodot:[1,3,74],ointop:[1,3,72],bigsqcup:[1,3,70],smallint:[1,2,115],triangleleft:[2,1,47],triangleright:[2,1,46],bigtriangleup:[2,2,52],bigtriangledown:[2,2,53],wedge:[2,2,94],land:[2,2,94],vee:[2,2,95],lor:[2,2,95],cap:[2,2,92],cup:[2,2,91],ddagger:[2,2,122],dagger:[2,2,121],sqcap:[2,2,117],sqcup:[2,2,116],uplus:[2,2,93],amalg:[2,2,113],diamond:[2,2,5],bullet:[2,2,15],wr:[2,2,111],div:[2,2,4],odot:[2,2,12],oslash:[2,2,11],otimes:[2,2,10],ominus:[2,2,9],oplus:[2,2,8],mp:[2,2,7],pm:[2,2,6],circ:[2,2,14],bigcirc:[2,2,13],setminus:[2,2,110],cdot:[2,2,1],ast:[2,2,3],times:[2,2,2],star:[2,1,63],propto:[3,2,47],sqsubseteq:[3,2,118],sqsupseteq:[3,2,119],parallel:[3,2,107],mid:[3,2,106],dashv:[3,2,97],vdash:[3,2,96],leq:[3,2,20],le:[3,2,20],geq:[3,2,21],ge:[3,2,21],lt:[3,1,60],gt:[3,1,62],succ:[3,2,31],prec:[3,2,30],approx:[3,2,25],succeq:[3,2,23],preceq:[3,2,22],supset:[3,2,27],subset:[3,2,26],supseteq:[3,2,19],subseteq:[3,2,18],"in":[3,2,50],ni:[3,2,51],owns:[3,2,51],gg:[3,2,29],ll:[3,2,28],not:[3,2,54],sim:[3,2,24],simeq:[3,2,39],perp:[3,2,63],equiv:[3,2,17],asymp:[3,2,16],smile:[3,1,94],frown:[3,1,95],Leftrightarrow:[3,2,44],Leftarrow:[3,2,40],Rightarrow:[3,2,41],leftrightarrow:[3,2,36],','leftarrow',':[3,2,32],gets:[3,2,32],rightarrow:[3,2,33],to:[3,2,33],','mapstochar',':[3,2,55],leftharpoonup:[3,1,40],','leftharpoondown',':[3,1,41],rightharpoonup:[3,1,42],rightharpoondown:[3,1,43],nearrow:[3,2,37],searrow:[3,2,38],nwarrow:[3,2,45],swarrow:[3,2,46],minuschar:[3,2,0],hbarchar:[0,0,22],lhook:[3,1,44],rhook:[3,1,45],ldotp:[6,1,58],cdotp:[6,2,1],colon:[6,0,58],"#":[7,0,35],"$":[7,0,36],"%":[7,0,37],"&":[7,0,38]},delimiter:{"(":[0,0,40,3,0],")":[0,0,41,3,1],"[":[0,0,91,3,2],"]":[0,0,93,3,3],"<":[0,2,104,3,10],">":[0',',2,105,3,11],"\\\\','lt":[0',',2,104,3,10],"\\\\','gt":[0,2,105,3,11],"/":[0,0,47,3,14],"|":[0,2,106,3,12],".":[0,0,0,0,0],"\\\\":[','0,2,110,3,15],"\\\\','lmoustache":[4,3,122,3,64],"\\\\rmoustache":[5,3,123,3,65],"\\\\lgroup":[4,6,40,3,58],"\\\\rgroup":[5,6,41,3,59],"\\\\arrowvert','":[0,2,106,3,','60],"\\\\Arrowvert":[0,2,107,3,61],"\\\\bracevert',1243,'62],"\\\\Vert":[0,2,107,3,13],"\\\\|":[0,2,107,3,13],"\\\\vert',1243,'12],"\\\\uparrow":[3,2,34,3,120],"\\\\downarrow":[3,2,35,3,121],"\\\\updownarrow":[3,2,108,3,63],"\\\\Uparrow":[3,2,42,3,126],"\\\\Downarrow":[3,2,43,3,127],"\\\\Updownarrow":[3,2,109,3,119],"\\\\backslash":[',1241,'rangle":[5',1237,'langle":[4',1239,'rbrace":[5,2,103,3,9],"\\\\lbrace":[4,2,102,3,8],"\\\\}":[5,2,103,3,9],"\\\\{":[4,2,102,3,8],"\\\\rceil":[5,2,101,3,7],"\\\\lceil":[4,2,100,3,6],"\\\\rfloor":[5,2,99,3,5],"\\\\lfloor":[4,2,98,3,4],"\\\\lbrack":[0,0,91,3,2],"\\\\rbrack":[0,0,93,3,3]},macros:{displaystyle',':["HandleStyle","','D"],textstyle',1255,'T"],scriptstyle',1255,'S"],scriptscriptstyle',1255,'SS"],rm',':["HandleFont",','0],mit',1263,'1],oldstyle',1263,'1],cal',1263,'2],it',1263,'4],bf',1263,'6],font',':["Extension","','font"],left:"HandleLeft",right:"HandleRight",arcsin',':["NamedOp",0],','arccos',1277,'arctan',1277,'arg',1277,'cos',1277,'cosh',1277,'cot',1277,'coth',1277,'csc',1277,'deg',1277,'det',':"NamedOp",','dim',1277,'exp',1277,'gcd',1297,'hom',1277,'inf',1297,'ker',1277,'lg',1277,'lim',1297,'liminf',':["NamedOp",null,"lim<span style=\\"margin-left: "+1/6+"em\\"></span>','inf"],limsup',1315,'sup"],ln',1277,'log',1277,'max',1297,'min',1297,'Pr',1297,'sec',1277,'sin',1277,'sinh',1277,'sup',1297,'tan',1277,'tanh',1277,498,':["HandleAtom","',498,'"],',514,1341,514,'"],',544,1341,544,'"],over',':"HandleOver",','overwithdelims',1352,'atop',1352,'atopwithdelims',1352,'above',1352,'abovewithdelims',1352,'brace',':["HandleOver','","\\\\{","\\\\}"],brack',1364,'","[","]"],choose',1364,'","(",")"],overbrace',':["Extension","leaders"],','underbrace',1370,'overrightarrow',1370,'underrightarrow',1370,'overleftarrow',1370,'underleftarrow',1370,'overleftrightarrow',1370,'underleftrightarrow',1370,'overset',':["Extension","underset-overset"],','underset',1386,'llap',':"HandleLap",','rlap',1390,'ulap',1390,'dlap',1390,'raise:"RaiseLower",lower:"RaiseLower",moveleft',':"MoveLeftRight",','moveright',1398,'frac:"Frac",root:"Root",sqrt:"Sqrt",hbar',':["Macro","\\\\','hbarchar\\\\kern-.5em h"],ne',1402,'not="],neq',1402,'not="],notin',1402,'mathrel{\\\\','rlap{\\\\kern2mu/}}\\\\in"],cong',1402,1409,'lower2mu{\\\\mathrel{{\\\\rlap{=}\\\\raise6mu\\\\sim}}}}"],bmod',1402,'mathbin{\\\\rm mod}"],pmod',1402,'kern 18mu ({\\\\rm mod}\\\\,\\\\,#1)",1],"int":["Macro","\\\\intop\\\\nolimits"],oint',1402,'ointop\\\\nolimits"],doteq',1402,'buildrel\\\\textstyle.\\\\over="],ldots',1402,'mathinner{\\\\','ldotp\\\\ldotp\\\\ldotp}"],cdots',1402,1423,'cdotp\\\\cdotp\\\\cdotp}"],vdots',1402,1423,'rlap{\\\\raise8pt{.\\\\rule 0pt 6pt 0pt}}\\\\rlap{\\\\raise4pt{.}}.}"],ddots',1402,1423,'kern1mu\\\\raise7pt{\\\\rule 0pt 7pt 0pt .}\\\\kern2mu\\\\raise4pt{.}\\\\kern2mu\\\\raise1pt{.}\\\\kern1mu}"],joinrel',1402,1409,'kern-4mu}"],relbar',1402,1409,'smash-}"],Relbar',1402,'mathrel="],bowtie',1402,'mathrel\\\\triangleright\\\\joinrel\\\\mathrel\\\\triangleleft"],models',1402,'mathrel|\\\\joinrel="],mapsto',1402,1409,1233,'\\\\rightarrow}"],rightleftharpoons',1402,498,'{\\\\',1409,'rlap{\\\\raise3mu{\\\\rightharpoonup}}}\\\\',1235,'}"],hookrightarrow',1402,'lhook','\\\\joinrel\\\\rightarrow','"],hookleftarrow',1402,'leftarrow\\\\joinrel\\\\','rhook"],Longrightarrow',1402,'Relbar\\\\joinrel\\\\','Rightarrow"],','longrightarrow',1402,'relbar',1459,'"],longleftarrow',1402,1462,'relbar"],Longleftarrow',1402,'Leftarrow\\\\joinrel\\\\','Relbar"],longmapsto',1402,1409,1233,'\\\\minuschar',1459,'}"],longleftrightarrow',1402,1231,1459,'"],','Longleftrightarrow',1402,1476,1466,'iff:["Macro","\\\\;\\\\',1488,'\\\\;"],mathcal',':["Macro","{\\\\','cal #1}",1],mathrm',1495,'rm #1}",1],mathbf',1495,'bf #1}",1],','mathbb',1495,1500,'mathit',1495,'it #1}",1],textrm',1402,'mathord{\\\\hbox{#1}}",1],textit',1402,'mathord{\\\\class{','textit','}{\\\\hbox{#1}}}",1],','textbf',1402,1510,1513,1512,'pmb',1402,'rlap{#1}\\\\kern1px{#1}",1],TeX:["Macro","T\\\\kern-.1667em\\\\lower.5ex{E}\\\\kern-.125em X"],limits:["Limits",1],nolimits:["Limits",0],",":["Spacer",1/6],":":["Spacer",1/6],">":["Spacer",2/9],";":["Spacer",5/18],"!":["Spacer",-1/6],enspace:["Spacer",1/2],quad:["Spacer",1],qquad:["Spacer",2],thinspace:["Spacer",1/6],negthinspace:["Spacer",-1/6],hskip:"Hskip",kern:"Hskip",rule:["Rule","colored"],space:["Rule","blank"],big',':["MakeBig","','ord",0.85],Big',1521,'ord",1.15],bigg',1521,'ord",1.45],Bigg',1521,'ord",1.75],bigl',1521,'open",0.85],Bigl',1521,'open",1.','15],biggl',1521,1532,'45],Biggl',1521,1532,'75],bigr',1521,'close",0.85],Bigr',1521,'close",1.','15],biggr',1521,1543,'45],Biggr',1521,1543,'75],bigm',1521,'rel",0.85],Bigm',1521,'rel",1.15],biggm',1521,'rel",1.45],Biggm',1521,'rel",1.75],mathord',1341,'ord"],mathop',1341,'op"],mathopen',1341,'open"],mathclose',1341,'close"],mathbin',1341,'bin"],mathrel',1341,'rel"],mathpunct',1341,'punct"],mathinner',1341,'inner"],','mathchoice',1275,1575,'"],buildrel:"BuildRel",hbox:"HBox",text:"HBox",mbox:"HBox",fbox',1275,'fbox"],strut:"Strut",mathstrut',1402,'vphantom{(}"],phantom:["Phantom",1,1],vphantom:["Phantom",1,0],hphantom:["Phantom",0,1],smash:"Smash",acute:["MathAccent",[7,0,19]],gr'],
  ['ave',':["MathAccent",[','7,0,','18]],ddot',1,2,'127]],tilde',1,2,'126]],bar',1,2,'22]],breve',1,2,'21]],check',1,2,'20]],hat',1,2,'94]],vec',1,'0,1,126]],dot',1,2,'95]],widetilde',1,'0,3,101]],widehat',1,'0,3,98]],"_":["Replace","ord","_","normal",-0.4,0.1]," ":["Replace","','ord","&nbsp;","normal','"],angle:["Replace","ord","&#x2220;","normal"],matrix:"Matrix",array:"Matrix",pmatrix:["Matrix','","(",")","c"],','cases:["Matrix","\\\\{",".",["l","l"],null,2],eqalign',':["Matrix",null,null,["','r","l"],[','5/18],3,"D"],','displaylines',35,'c"],null,3,"D"],cr:"','HandleRow','","\\\\":"',41,'",newline:"',41,'",noalign:"','HandleNoAlign','",eqalignno',35,'r","l","r"],[5/8,3],3,"D"],','leqalignno',35,50,'begin:"Begin",end:"End",tiny',':["HandleSize",','0],Tiny',55,'1],scriptsize',55,'2],small',55,'3],normalsize',55,'4],large',55,'5],Large',55,'6],LARGE',55,'7],huge',55,'8],Huge',55,'9],dots:["Macro","\\\\ldots"],newcommand',':["Extension","','newcommand"],','newenvironment',75,76,'def',75,76,'color',75,'HTML"],','href',75,'HTML"],"class":["','Extension','","',85,'style',75,85,'cssId',75,85,'unicode',75,85,'bbox',75,'bbox"],require:"Require","char":"Char"},','environments',':{array:"Array",matrix',':["Array",null,null,"','c"],pmatrix',':["Array',33,'bmatrix',108,'","[","]","c"],Bmatrix',108,'","\\\\{","\\\\}","c"],vmatrix',108,'","\\\\vert","\\\\vert","c"],Vmatrix',108,'","\\\\Vert","\\\\Vert","c"],cases',108,'","\\\\{",".","ll",null,2],eqnarray',106,'rcl",[5/18,',37,'align',75,'AMSmath"],"',124,'*":["Extension","AMSmath','"],','multline',75,126,130,128,'"],split',75,'AMSmath"],','gather',75,126,138,128,'"]},AddSpecial',':function(','A){for(var B in A){','jsMath.Parser.prototype','.special[',146,'[B]]=A[B]}},Error',144,'A){this.i=','this.string.length',';if(A','.error){','this.error','=A.error}else{if(!this',154,155,'=A}}},nextIsSpace',':function(){','return ','this.string.charAt(this.i',')==" "},trimSpaces',144,'A){','if(typeof (','A)!="string"){',161,'A}',161,'A.replace(/^\\s+|\\s','+/g,"")},','Process',144,'A){var ','C=','this.mlist.','data;','A','=jsMath.Parse(','A,C.font,C.size,C.style',');if(A',154,'this.Error(','A);','return null','}if(A.mlist.Length()==','0){',186,187,'1','){var B=','A.mlist.','Last();if(','B.atom&&B.type=="ord"&&B.nuc&&!B.sub&&!B.sup&&(B.nuc.type=="text"||B.nuc.type=="TeX")){',161,'B.nuc}}return{type:"mlist",mlist:A.mlist}},GetCommand',':function(){var ','A=/^([a-z]+|.) ?/i;var B=A.exec(','this.string.slice(','this.i));','if(B){this.i+=B[1].','length;',161,'B[1]}this.i++;return" "},GetArgument',144,'B,C){while','(this.nextIsSpace()){this.i','++}','if(this.','i>=',152,'){','if(!C){','this.Error("','Missing',' argument for "+B)}',186,'}if(',162,')==this.close){',214,215,'Extra close brace','")}',186,'}if(',162,')==','this.cmd','){this.i++;',161,'this.cmd+','this.GetCommand','()}if(',162,')!=','this.open){',161,162,'++)}var A=++this.i;var D=1;var E="";','while(this.i<this.string.length){','E=',162,'++);if(','E','==this.cmd){this.i++}else{if(','E==',238,'D++}else{if(E','==this.close){','if(D==0){',215,224,'");',186,'}if(--D==0){',161,200,'A,this.i-1)}}}}}',215,'Missing close brace','");',186,'},','ProcessArg',144,'B){var ','A=','this.GetArgument(','B);','if(this.error){return',' null}','return this.Process(A)},','ProcessScriptArg',144,'C){var A=',270,'C);',272,273,'if(A.charAt(0)==',230,192,'A.substr(1);if(B=="frac"){A+="{"+',270,'B)+"}";',272,273,'A+="{"+',270,'B)+"}";',272,' null}}else{if(B','=="sqrt"){A+="["+','this.GetBrackets(','B)+"]";',272,273,'A+="{"+',270,'B)+"}";',272,294,'.match(this.scriptargs)){A+="{"+',270,'B)+"}";',272,' null}}}}}',274,'GetDelimiter',144,'A){while',208,'++}var B=',162,');',210,'i<',152,231,'if(B==',230,'){B="\\\\"+',234,'(A);',272,' null}}','if(','this.delimiter[','B]!=null){',161,330,'B]}}',215,216,' or unrecognized delimiter for "+A);',186,'},GetDimen',144,'A,D){var ','B;var C=0;if',208,'++}if(',162,')=="{"){B=',270,'A)}else{B=',200,'this.i);C=1}',161,'this.ParseDimen(','B,A,C,D)},ParseDimen',144,'C,B,D,E){var A=C.match(/^\\s*([-+]?(\\.\\d+|\\d+(\\.\\d*)?))(pt|em|ex|mu|px)/);if(!A){',215,216,' dimension or its units for "+B);',186,'}if(D){this.i+=A[0].',203,'if',208,'++}}var F=A[1]-0;if(A[4]=="px"){F/=jsMath.em','}else{if(A[4]=="','pt"){F/=10',365,'ex"){F*=','jsMath.TeX','.x_height',365,'mu"){if(E){F=F/18}else{F=[F,"mu"]}}}}}',161,'F},GetNext',160,'while',208,'++}',161,162,')},GetBrackets',144,175,'D','=this.GetNext();if(','D!="["){return""}var C=++this.i;var B=0;',242,'D=',162,245,'D=="{"){B++}else{if(D=="}"){','if(B==0){',215,224,' while looking for',' \']\'");',186,'}B--}else{if(D',247,'D=="]"){',392,161,200,'C,this.i-1)}}}}}}',215,'Couldn\'t find',' closing \']\' for argument to "+',233,'A);',186,'},GetUpto',144,'B,C){while',208,'++}var F=this.i;var D=0;',242,'var E=',162,245,'E=="{"){',250,'=="}"){',252,215,224,395,' "+',233,'C);',186,'}D--}else{if(E==',230,'){if(',200,'this.i,this.i+','5)=="begin"){D++;this.i+=4}else{if(',200,435,'3)=="end"){if(D>0){D--;this.i+=2}}}',252,'if(',200,435,'C.length)==C){E=',162,'+C.length);if(E.match(/[^a-z]/i)||!C.match(/[a-z]/i)){var A=',200,'F,this.i-1);this.i+=C.',203,161,'A}}}this.i++}}}}',215,406,' "+',233,'C+" for "+B);',186,'},','ProcessUpto',144,'B,C){var ','A=this.GetUpto(B,C);',272,273,274,'GetEnd',144,'C){var A="";var B="";while(B!=C){A+=this.GetUpto("begin{"+C+"}","end");',272,273,'B=','this.GetArgument(this.cmd','+"end");',272,328,161,'A},Space',':function(){},','Prime',144,'C',192,177,194,'B==null||(!B.atom&&B','.type!="box"&&','B','.type!="frac")){','B=','this.mlist.Add(jsMath.mItem.','Atom("ord",{type:null}))}','if(B.sup){',215,'Prime causes double exponent',': use braces to clarify");return',' }var A','="";while(C=="\'"){A+=',230,'+"prime";C',385,'C=="\'"){this.i++}}B','.sup=this.',173,'(A);B.sup.isPrime=1},RaiseLower',144,175,'B','=this.GetDimen(this.cmd+','A,1);',272,' }var C=this.',275,'(',233,'A);',272,' }if(A=="lower"){B=-B}',177,'Add(new jsMath.mItem("','raise",{nuc:C,raise:B}))},MoveLeftRight',144,268,'A',508,'B,1);',272,' }var ','C','=this.ProcessArg(this.cmd+','B);',272,' }if(B=="moveleft"){A=-A}',490,'Space(A','));',490,'Atom("ord",C));',490,'Space(-A))},Require',144,175,'B=',472,'+A);',272,' }B=','jsMath.Extension','.URL(B);if(','jsMath.Setup.','loaded[B]){','return }','this.Extension(null,[','B])},',89,144,'A,B){','jsMath.Translate','.restart=1;if(A','!=null){','delete ',146,'[B[1]||"macros"][A]}',547,'.Require(B[0],',557,'.asynchronous',');throw"restart"},Frac',144,268,'A',529,'B);',272,527,'C',529,'B);',272,' }',490,'Fraction("over",A,C))},Sqrt',144,268,'D=',296,233,'B);',272,496,529,'B);',272,' }var C=jsMath.mItem.Atom("','radical",A);','if(D!=""){C.root=this.',173,'(D);',272,' }}',177,'Add(C)},','Root',144,268,'D=this.',459,'(',233,'B,"of");',272,496,529,'B);',272,593,594,'C.root=D;',177,601,'BuildRel',144,175,'B=this.',459,'(',233,'A,"over");',272,527,'D',529,'A);',272,593,'op",D);C.limits=1;C.sup=B;',177,601,'MakeBig',144,341,'C=D[0];var B=D[1]*jsMath.p_height;var E','=this.GetDelimiter(this.cmd+','A);',272,' }',490,'Atom(C,','jsMath.Box.Delimiter(','B,E,"T")))},Char',144,268,'A=',472,'+B);',272,527,'C=',472,'+B);',272,' }if(!',369,'[A]){',369,'[A]=[];',552,'jsMath.Font.URL(A',')])}else{',490,'Typeset(','jsMath.Box.TeX(C-0,A,"T",',177,'data.size',')))}},Matrix',144,'B,H){var E=',177,'data;var A=',472,'+B);',272,527,'G=','new jsMath.','Parser(A+',230,'+"\\\\",null,','E.size,H[5]||"T");G.matrix=B;G.row=[];G.table=[];G.rspacing=[];G.Parse();if(G',154,184,'G);',551,'G.',41,'(',525,'var D','=jsMath.Box.','Layout(E.size,G.table,H[2]||null,H[3]||null,G.rspacing,H[4]||null);if(H[0]&&H[1]){var F=',648,'D.h+D','.d-jsMath.hd/4,this.delimiter[','H[0]],"T");var C=',648,'D.h+D',702,'H[1]],"T");D',698,'SetList([','F,D,C],E.style,E.size)}',490,'Atom((H','[0]?"inner":"ord"),','D))},HandleEntry',144,'B){','if(!this.','matrix){',184,'B','+" can only appear in a matrix or array");return }if(',177,'data.openI',559,'var A=',177,'Get(',177,723,182,'.left){',215,216,' "+this.cmd+"right','")}else{',215,262,'")}}if(',177,'data.overI',559,177,'Over()}var D=',177,178,177,'Atomize(','D.style,D.size);','var C=',177,670,748,'C.entry=D.entry;delete D.entry;if(!C.entry){C.entry={}}this.row[','this.row.length',']=C;this.mlist=',684,'mList(null,null,D.size,D.style)},',41,144,'A,C){var B;',717,'matrix){',184,233,'A',721,'A=="\\\\"){B=',296,233,'A);',272,' }if(B){B=',352,'B,',233,'A,0,1)}}this.HandleEntry(A);if(!C||',754,'>1||this.row[0].format!="null"){this.table[this.table.length]=this.row}if(B){','this.rspacing[this.table.length',']=B}this.row=[]},',47,144,268,'A=',472,'+B);',272,527,'C=A.replace(/^.*(vskip|vspace)([^a-z])/i,"$2");if(C.length==A','.length){',551,'var D=',352,'C,',233,'RegExp.$1,0,1);',272,' }',779,']=(',779,']||0)+D},Array',144,461,'E=C[2];var I=C[3];if(!E){E=',472,'+"begin{"+B+"}");',272,' }}E=E.replace(/[^clr]/g,"");E=E.split("");var G=',177,678,'C[5]||"T";var K=this.GetEnd(B);',272,527,'F=',684,'Parser(K+',230,687,'G.size,A);F.matrix=B;F.row=[];F.table=[];F.rspacing=[];F.Parse();if(F',154,184,'F);',551,'F.',41,'(',525,'var H',698,'Layout(G.size,F.table,E,I,F.rspacing,C[4],C[6],C[7]);if(C[0]&&C[1]){var D=',648,'H.h+H',702,'C[0]],"T");var J=',648,'H.h+H',702,'C[1]],"T");H',698,709,'D,H,J],G.style,G.size)}',490,'Atom((C',713,'H))},Begin',144,175,'B=',472,544,272,' }if(B.match(/[^a-z*]/i)){',215,'Invalid environment name \\""+B+"\\"");',551,717,104,'[B]){',215,'Unknown environment \\""+B+"\\"");return',511,104,'[B];',166,'C',')=="string"){','C=[C]}this[C[0]](B,C.slice(1))},End',144,175,'B=',472,544,272,' }',184,233,'A+"{"+B+"} without matching "+',230,'+"begin")},Spacer',144,'B,A){',490,534,'-0))},Hskip',144,268,'A',508,'B);',272,' }',490,534,'))},HBox',144,175,'C=',472,544,272,527,'B',698,'InternalMath(C,',177,673,');',490,670,'B))},Rule',144,'B,E){var A',508,525,272,527,'D',508,525,272,527,'F',508,525,272,' }D+=F;var C;if(D!=0){D=Math.max(1.05/jsMath.em,D)}if(D==0||A==0||E=="blank"){C=','jsMath.HTML.','Blank(A,D)}else{C=',928,'Rule(A,D)}if(F){C="<span style=\\"','vertical-align:"+',928,'Em(-F)+"\\">"+C','+"</span>"}',490,670,684,'Box("html",C,A,D-F,F)))},Strut',198,'A=',177,673,';var B',698,'Text("","normal","T",A).Styled();B.bh=B.bd=0;B.h=0.8;B.d=0.3;B.w=B.Mw=0;',490,670,'B))},Phantom',144,461,'A',529,'B);',272,' }',177,519,'phantom",{phantom:A,v:C[0],h:C[1]}))},Smash',144,461,'A',529,'B);',272,' }',177,519,'smash",{smash:A}))},MathAccent',144,'B,',175,'D',529,'B);',272,593,'accent",D);C.accent=A[0];',177,601,'NamedOp',144,'B,D){var ','A=(B.match(/[^acegm-su-z]/))?1:0;var E=(B.match(/[gjpqy]/))?0.2:0;if(D[1]){B=D[1]}var C=jsMath.mItem.','TextAtom("','op",B,"cmr10",A,E);if(D[0]!=null){C.limits=D[0]}',177,601,'Limits',144,'A,C',192,177,'Last();if(!B||B.type!="op"){',184,233,'A+" is allowed only on operators");',551,'B.limits=C[0]},Macro',144,983,'E=D[0];if(D[1]){var A=[];for(var C=0;C<D[1];C++){A[A.length]=',472,'+B);',272,' }}E=this.','SubstituteArgs','(A,E)}this.string=','this.AddArgs(','E,',200,201,'this.i=0},',1007,144,'B,',175,'E="";var D="";var F;var C=0;while(C<A',790,'F=A.charAt(C++);if(F','==',230,'){E+=F+A.charAt(C++)}else{if(F=="#"){',1020,'=="#"){E+=F}else{if(!F.match(/[1-9]/)||F>B',790,215,'Illegal ','macro parameter ','reference");',186,'}D=',1009,1009,'D,E),B[F-1]);E=""}}else{E+=F}}}',161,1009,'D,E)},AddArgs',144,'B,A){if(','A.match(/^[a-z]/i)&&B.match(/(^|[^\\\\])(\\\\\\\\)*\\\\[a-z]+$/i)){B+=" "}',161,'B+A},Replace',144,556,490,'TextAtom(','B[0],B[1],B[2','],B[3]))},Hash',144,'A){',215,'You can\'t use \'',1029,'character #\' in math mode")},Tilde',144,'A){',490,985,31,'"))},HandleLap',144,175,623,266,'();',272,546,177,519,'lap",{nuc:B,lap:A}))},HandleAtom',144,461,'A',529,'B);',272,' }',490,'Atom(C[0],A))},HandleMathCode',144,'A,B','){this.HandleTeXchar(',1048,'])},HandleTeXchar',144,'B,A,C){if(B==7&&',177,'data.font',559,'A=',177,1089,'}A=',369,'.fam[A];if(!',369,'[A]){',369,'[A]=[];',552,667,')])}else{',490,'TeXAtom(',369,'.atom[B],C,A))}},','HandleVariable',144,'A',1083,'7,1,','A.charCodeAt(0))},','HandleNumber',144,'A',1083,2,1113,'HandleOther',144,'A){',490,985,'ord",A,"normal"))},HandleComment',198,'A;',242,'A=',162,245,'A=="\\r"||A=="\\n"){return }}},HandleStyle',144,556,177,'data.style=B[0];',177,519,'style",{style:B[0]}))},HandleSize',144,556,177,673,'=B[0];',177,519,'size",{size:B[0]}))},HandleFont',144,882,177,1089,'=A[0]},HandleCS',198,'B=',234,'();',272,' }',210,'macros[B]){var A=this','.macros','[B];',166,'A',867,'A=[A]}this[A[0]](B,A.slice(1));',551,210,'mathchardef','[','B]){this.HandleMathCode(B,this.',1169,'[B]);',551,'if(',330,233,1171,'delimiter[',233,'B].slice(0,3));',551,215,'Unknown control sequence \'"+',233,'B+"\'")},HandleOpen',160,177,'Open()},HandleClose',160,'if(',177,723,'==null){',215,224,'");return',496,'=',177,'Get(',177,723,');if(!A||A.left',1194,177,'Close()}else{',215,224,' or missing',734,1197,' }},HandleLeft',144,175,'B',642,'A);',272,' }',177,'Open(B)},HandleRight',144,268,'C',642,'B);',272,496,'=',177,'Get(',177,723,182,'&&A.left',559,177,'Close(C)}else{',215,'Extra open brace or missing "+',230,'+"left")}},HandleOver',144,556,'if(',177,740,559,215,'Ambiguous use of "+',233,'A);',551,177,740,'=',177,'Length();',177,'data.overF={name:A};if(B.length>0){',177,'data.overF.','left=',330,'B[0]];',177,1263,'right=',330,'B[1]]}else{if(A.match(/withdelims$/)){',177,1263,'left',642,'A);',272,' }',177,1263,'right',642,'A);',272,' }}else{',177,1263,'left=null;',177,1263,1269,'null}}if(A.match(/^above/)){',177,1263,'thickness',508,'A,1);',272,' }}else{',177,1263,'thickness=null}},HandleSuperscript',198,'A=',177,194,177,740,'==',177,'Length()){A=null}if(A==null||(!A.atom&&A',486,'A',488,'A=',490,491,'if(A.sup){if(A.sup.isPrime){A=',490,491,'else{',215,'Double exponent',495,' }}A',502,275,'("superscript");',272,' }},HandleSubscript',198,'A=',177,194,177,740,'==',177,'Length()){A=null}if(A==null||(!A.atom&&A',486,'A',488,'A=',490,491,'if(A.sub){',215,'Double subscripts',495,' }A.sub=this.',275,'("subscript");',272,' }},Parse',198,'B;',242,'B=',162,'++);',210,'mathchar[',1171,'mathchar[B])}else{',210,'special[B]){this[this',147,'B]](B)}else{',210,'letter','.test(B)){this.',1108,'(B)}else{',210,'number',1371,1114,1373,'this.',1120,'(B)}}}}}if(',177,723,559,'var A=',177,'Get(',177,723,182,'.left){',215,216,734,735,215,262,'")}}if(',177,740,559,177,'Over()}},Atomize',198,'A=',177,'init;if(!this',154,177,747,'A.style,A.size)}},Typeset',198,'F=',177,'init;var D=this.typeset=',177,670,'F.style,F.size);',272,'"<','span class=\\"','error\\">"+',155,935,'if(D.format=="null"){return""}D.Styled().Remeasured();var E=0;var C=0;if(D.bh>D.h&&','D.bh>jsMath.h+0.001){','E=1}if(D.bd>D.d&&D.bd>jsMath.d+0.001){E=1}if(D.h>jsMath.h||D.d>jsMath.d){C=1}var B=D.html;if(E){if(','jsMath.Browser.','allowAbsolute){var G=0;if(',1426,'G=jsMath.h-D.bh}B=',928,'Absolute(B,D.w,jsMath.h,0,G)}else{if(',1428,'valignBug){','B="<span style=\\"line-height:"+jsMath.HTML.Em(jsMath.d',')+";\\">"+B',935,'else{var A=',928,'Em(Math.max(0,D.bd-jsMath.hd)/3);',1436,')+";"+" position:relative; top:"+A+"; ',932,'A+"\\">"+B+"</span>"}}C=1}if(C){B+=',928,'Blank(0,D.h+0.05,D.d+0.05)}return"<nobr><',1421,'scale\\">"+B+"</span></nobr>"}});',146,'.AddSpecial({cmd:"HandleCS",open:"HandleOpen",close:"HandleClose"});','jsMath.Add(jsMath,{','Macro',144,175,'C=',146,1161,';C[A]=["Macro"];for(var B=1;B<arguments.',203,'B++){C[A][C[A].length]=arguments[B]}}});',547,'={safeRequire:1,Macro',144,'A,',268,'C=',146,1161,';if(B',1194,'B=A}C[A]=["',89,'",B]},LaTeX',144,'B,',175,'C=',146,'.',104,';C[B]=["Extension",','A,"',104,'"]},Font',144,1040,'A',1194,'A=B+"10"}var C=',146,1161,1482,667,')]},MathChar',144,'C,',175,'D=',369,'.famName[C','];if(D',1194,'D=',369,'.fam.',203,369,'.fam[D]=C;',369,1501,']=D}var B=',146,'.',1169,';for(var E in A){B[E]=[A[E][0],D,A[E][1]]}},Require',144,1040,'this.safeRequire&&(B.match(/\\.\\.\\/|[^-a-z0-9.\\/:_+=%~]/i)||(B.match(/:/)&&B.substr(0,jsMath.root.length)!=jsMath.root))){',549,'loaded[B]=1;',551,549,'Script(this.URL(B),A)},URL',144,'A){A=',171,'+$/g,"");if(!A.match(/^([a-z]+:|\\/|fonts|extensions\\/)/i)){A="extensions/"+A}if(!A.match(/\\.js$/)){A+=".js"}',161,'A}};',1452,173,144,'A){',549,'Body();','jsMath.Script.','Push(',557,',"','Asynchronous','",A)},','ProcessBeforeShowing',144,'A){',549,1536,'var B=(','jsMath.Controls.cookie.','asynch?"',1541,'":"','Synchronous','");',1537,1538,557,',B,A)}});',557,'={element:[],cancel:0,Parse',144,'D,C,',175,'B=','jsMath.Global.','cache[D];if(!','B[jsMath.em',']){',1567,']={}}var F=',1567,'][C];if(!F||',175,'E',180,'C,null,null,D);E.Atomize();F=E.Typeset();if(!A){',1567,'][C]=F}}',161,'F},TextMode',144,'B,A){this.Parse("','T",B,A)},DisplayMode',144,1582,'D",B,A)},GetElementText',144,175,623,'recursiveElementText','(A);A.alt=B;if(B.search("&")>=0){','B=B.replace(/&','lt;/g,"<");',1592,'gt;/g,">");',1592,'quot;/g,"\\"");',1592,'amp;/g,"&")}',161,'B},',1590,144,'B){if(','B.nodeValue',559,161,1605,'}if(','B.childNodes.length','==0){return" "}var C="";for(var A=0;A<',1610,';A++){C+=this.',1590,'(B.childNodes[A])}',161,'C},ResetHidden',144,'A){A.innerHTML="<',1421,'jsMath_hiddenSpan\\" style=\\"position:absolute\\"></span>"+',1428,'operaHiddenFix;A.className="";','jsMath.hidden','=A.firstChild;if(!jsMath.BBoxFor("x").w){','jsMath.hidden=jsMath.hiddenTop','}jsMath.ReInit()},','ConvertText',144,'B,A){var C=this.GetElementText(B);this.ResetHidden(B);if(C.match(/^\\s*\\\\nocache([^a-zA-Z])/)){A=true;C=C.replace(/\\s*\\\\nocache/,"")}C=this.Parse("','T','",C,A);B.className="typeset";B.innerHTML=C},','ConvertDisplay',144,1630,'D',1632,'ProcessElement',144,'C){this.restart=0;if(!','C.className','.match(/(^| )math( |$)/)){return',496,'=(',1641,'.toLowerCase().match(/(^| )nocache( |$)/)!=null);try','{if(C.tagName.toLowerCase()=="','div"){this.',1633,'(C,A);C.onclick=jsMath.Click.CheckClick;C.ondblclick=jsMath.Click.CheckDblClick','}else',1647,'span"){this.',1628,1650,'}}}catch(D){if(C.alt',192,'C.alt;B=B.replace(/&/g,"&amp',';");B=B.replace','(/</g,"&lt',1659,'(/>/g,"&gt;");C.innerHTML=B;',1641,'="math";if(A){',1641,'+=" nocache"}}',1626,'}},','ProcessElements',144,'B){',1537,'blocking=','1;if(B>=','this.element.length','||this.cancel){this.','ProcessComplete','();',210,'cancel){','jsMath.Message.','Set("',173,' Math: Canceled");',1681,'Clear()}',1537,1673,'0;',1537,173,'()}else{var A=',1537,'SaveQueue();','this.ProcessElement(this.element[','B]);',1537,'RestoreQueue(A);',210,'restart){',1537,1538,'this,"',1669,'",B);',1537,1673,'0;setTimeout("',1537,173,'()",',1428,'delay)}else{B++;var C=Math.floor(100*B/',1675,');','jsMath.Message.Set("Processing Math',': "+C+"%");setTimeout("',557,'.',1669,'("+B+")",',1428,'delay)}}},',1541,144,'A','){if(!jsMath.initialized){jsMath.Init()}this.element=this.GetMathElements(','A);',1537,1673,'1;this.cancel=0;this',566,'=1;',1716,': 0%",1);setTimeout("',557,'.',1669,'(0)",',1428,'delay)},',1553,144,1040,'A==null',1727,'B);A=0}this',566,'=0;while(A<',1675,'){',1695,'A]);',210,'restart){','jsMath.Synchronize','("',557,'.',1553,'(null,"+A+")");',1537,173,'();',551,'A++}this.',1677,'(1)},GetMathElements',144,'D){var B=[];var A;if(!D){D=','jsMath.document','}',166,'D',867,'D=',1771,'.getElementById(D)}if(!','D.getElementsByTagName','){',186,'}var C=',1779,'("div','");for(A=0;A<C.length;A++){if(C[A].className&&C[A].className.match(/(^| )math( |$)/)){if(jsMath.Browser.renameOK&&D.getElementsByName){C[A].setAttribute("name","_jsMath_")}else{B[B.length]=C[A]}}}','C=',1779,'("span',1785,'if(',1428,'renameOK','&&D','.getElementsByName','){B=D',1794,'("_jsMath_',735,'if(',1624,'.sourceIndex','){B.sort(function(F,E){',161,'F',1801,'-E',1801,'})}}',161,'B},',1677,144,'C){if(',1428,1792,192,1771,1794,1797,'");for(var A=B.length-1;A>=0;A--){B[A].removeAttribute("name")}}',1626,';this.element=[];this.restart=null;',214,1716,': Done");',1681,'Clear()}',1681,'UnBlank();if(',1428,'safariImgBug&&(',1549,'font=="symbol"||',1549,'font=="image")){',210,'timeout){clearTimeout(this.timeout)}this.timeout=setTimeout("','jsMath.window.resizeBy','(-1,0); "+"',1838,'(1,0); "+"',557,'.timeout = null",2000)}},Cancel',160,557,'.cancel=1;if(',1537,'cancelTimer){',1537,'cancelLoad()}}};',1452,'ConvertTeX',144,'A){',1537,'Push(jsMath.tex2math,"',1852,1542,'ConvertTeX2',144,'A){',1537,1856,1859,1542,'ConvertLaTeX',144,'A){',1537,1856,1866,1542,'ConvertCustom',144,'A){',1537,1856,1873,1542,'CustomSearch',144,'C,B,A,D){',1537,1538,'null,function(){jsMath.tex2math.',1880,'(C,B,A,D)})},tex2math:{',1852,478,1859,478,1866,478,1873,478,1880,':function(){}}});',1756,'=',1537,'Synchronize;try{if(','window.parent','!=window&&window.jsMathAutoload){',1902,'.jsMath=jsMath;',1771,'=',1902,'.document;jsMath.window=',1902,'}}catch(err){}',1565,'Register();jsMath.Loaded();jsMath.Controls.GetCookie();',549,'Source();',1565,'Init();',1537,'Init();',549,'Fonts();if(',1771,'.body){',549,'Body()}',549,'User("onload")}}']

]);
//end = new Date().getTime();
//alert(end-start);
