#!/usr/bin/python

import vobject
import glob
import os
import mx.DateTime
import jppy

class icalLoader(jppy.core.Component):
    def parse(self, stream):
        records = []
        try:
            for v in vobject.readComponents(stream):
                c = self.env.calendar.new()

                c['description'] = v.vevent.summary.value

                if hasattr(v.vevent,'location'):
                    location = v.vevent.location.value
                    if len(location) > 21:
                        location = location[0:21-3] + "..."
                    c['location'] = location

                if hasattr(v.vevent,'description'):
                    description = v.vevent.description.value
                    if len(description) > 256:
                        location = location[0:256-3] + "..."
                    c['description'] = description

                # @todo support alarm, dates, begin, end, final, timezone
                # (waiting on support in pytype_events.c)
                
                records.append(c)
        except vobject.base.ParseError, e:
            print "Failed to parse iCal: %s" % e
        return records

if __name__ == "__main__":
    jppyenv = jppy.environment.Environment()
    loader  = icalLoader(jppyenv)
    for ics_filename in glob.glob(os.path.expanduser("~/OWA-files/Calendar/*.ics")):
        print ics_filename
        for event in loader.parse(open(ics_filename,'r')):
            print event
