import sys
import unittest
import jppy
import string
import types
import baseclass

class jppyTest(baseclass.baseTest):
    def setUp(self):
        baseclass.baseTest.setUp(self)
    
    def testCheckMethods(self):
        t = self.newrecord()
        assert(hasattr(t,'archived'))
        assert(hasattr(t,'keys'))
        assert(hasattr(t,'items'))
        assert(hasattr(t,'values'))        

    def testSetCategory(self):
        t = self.newrecord()
        for cat in [3,10,5,14,2,15,0,4]:
            assert len(self.book.records()) == 0
            t.category = cat
            assert cat == t.category
            t[t.keys()[0]] = "1234"
            self.book.save(t)
            assert len(self.book.records(search="1234")) == 1
            assert cat == self.book.records(search="1234")[0].category
            self.book.delete(t)
            assert len(self.book.records(search="1234")) == 0            
        def setCategory(t, v):
            t.category = v
        self.assertRaises(ValueError, setCategory, t, 20)

    def testKeysReturnsList(self):
        assert type(self.newrecord().keys()) == types.ListType

    def testValuesReturnsList(self):
        assert type(self.newrecord().values()) == types.ListType

    def testItemsReturnsListofTuples(self):
        items = self.newrecord().items()
        assert type(items) == types.ListType
        pair = items[0]
        assert type(pair) == types.TupleType
        assert len(pair) == 2

    def testValuesReturnsValue(self):
        record = self.newrecord()
        record[record.keys()[0]] = "My record"
        assert "My record" in record.values()

    def testSaving(self):
        record = self.newrecord()
        assert record.unsaved_changes == 0
        record[record.keys()[0]] = "My record"
        assert record.unsaved_changes == 1
        self.book.save(record)
        assert len(self.book.fetch(record.unique_id)) == 1
        assert record.unsaved_changes == 0        

    def testSearching(self):
        record = self.newrecord()
        record[record.keys()[0]] = "12345"
        self.book.save(record)
        record = self.newrecord()
        record[record.keys()[0]] = "67890"
        self.book.save(record)
        assert len(self.book.records(search='123')) == 1

    def testUpdating(self):
        record = self.newrecord()
        record[record.keys()[0]] = "12345"
        self.book.save(record)
        record[record.keys()[0]] = "67890"
        self.book.save(record)
        assert len(self.book.records()) == 1
        assert len(self.book.records(deleted=True)) == 2

    def testSizelimit(self):
        record = self.newrecord()
        try:
            record[record.keys()[0]] = "1" * 65000
        except ValueError:
            return
        self.fail()

class todoBasicTest(jppyTest):
    def __init__(self, method):
        jppyTest.__init__(self, method)
        self.newrecord = jppy.Todo
        self.book = jppy.taskList()

class memoBasicTest(jppyTest):
    def __init__(self, method):
        jppyTest.__init__(self, method)
        self.newrecord = jppy.Memo
        self.book = jppy.memoList()

class contactBasicTest(jppyTest):
    def __init__(self, method):
        jppyTest.__init__(self, method)
        self.newrecord = jppy.Contact
        self.book = jppy.addressBook()

def suite():
    suite = unittest.TestSuite((unittest.makeSuite(todoBasicTest),
                                unittest.makeSuite(memoBasicTest),
                                unittest.makeSuite(contactBasicTest),))
    
    return suite
