import java.util.Date;
import java.util.TimeZone;

public class CifsTime {

    // Observed dates reporting ServerTimeZone=240
    // file last modified date = { low, high };

    // Mon Mar 26 23:14:42 EST 2001 (no DST)
    static final int[] D = { 0x10BE3D00, 0x01C0B66C };

    // Mon Apr 30 03:17:14 EST 2001 (in DST)
    //static final int[] D = { 0x9474B900, 0x01C0D145 };

    static final long MILLISECONDS_BETWEEN_1970_AND_1601 = 11644473600000L;

    static long calcDate() {
        int lo, hi;
        long t;

        t = ((long)D[1] << 32 ) | ( (long)D[0] & 0xFFFFFFFFL );
        t = ( t / 10000L - MILLISECONDS_BETWEEN_1970_AND_1601 );

        if( TimeZone.getDefault().inDaylightTime( new Date() )) {
            // in dst

            if( TimeZone.getDefault().inDaylightTime( new Date( t ))) {
                // t was also generated in dst too so no correction
                return t;
            }
            // t was not generated during dst so add 1 hour
            return t + 3600000L;
        } else {
            // not in dst

            if( TimeZone.getDefault().inDaylightTime( new Date( t ))) {
                // t was generated in dst so subtract 1 hour
                return t - 3600000L;
            }
            // t was also not generated in dst so no correction
            return t;
        }
    }
    public static void main( String[] argv ) throws Exception {
        System.out.println( new Date( calcDate() ));
    }
}
