/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome Team Members:
 *   Jean Van Wyk <jeanvanwyk@iname.com>
 *   Jeffrey S. Morgan <jeffrey.morgan@bristolwest.com>
 *   Dan Bornstein <danfuzz@milk.com>
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 *
 * This file was orriginally generated by the Java-GNOME Code Generator
 * Please do not modify the code that is identified as generated.  Also,
 * please insert your code above the generated code.
 */

#include <jni.h>
#include <sys/types.h>
#include <libgtkhtml/gtkhtml.h>

#ifndef _Included_org_gnu_gtkhtml_HTMLDocument
#define _Included_org_gnu_gtkhtml_HTMLDocument
#ifdef __cplusplus
extern "C" {
#endif
/* Inaccessible static: evtMap */
/* Inaccessible static: class_00024org_00024gnu_00024gtkhtml_00024event_00024HTMLDocumentListener */
/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_get_type
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1get_1type
  (JNIEnv *env, jclass cls)
{
  return (jint) html_document_get_type();
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_new
 * Signature: ()I
 */
JNIEXPORT jint JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1new
  (JNIEnv *env, jclass cls)
{
  return (jint) html_document_new();
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_open_stream
 * Signature: (ILjava/lang/String;)Z
 */
JNIEXPORT jboolean JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1open_1stream
  (JNIEnv *env, jclass cls, jint doc, jstring mType)
{
  HtmlDocument *document = (HtmlDocument*)doc;
  const gchar *mimeType = NULL;
  jboolean result;
	
  if (mType != NULL)
    mimeType = (gchar*)(*env)->GetStringUTFChars(env, mType, 0);
  
  result = html_document_open_stream(document, mimeType);
  
  if (mType != NULL)
    (*env)->ReleaseStringUTFChars(env, mType, mimeType);
  
  return result;
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    htm_document_write_stream
 * Signature: (ILjava/lang/String;I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLDocument_htm_1document_1write_1stream
  (JNIEnv *env, jclass cls, jint doc, jstring buff, jint len)
{
  HtmlDocument *document = (HtmlDocument*)doc;
  const gchar *buffer = NULL;
	
  if (buff != NULL)
    buffer = (gchar*)(*env)->GetStringUTFChars(env, buff, 0);
		
  html_document_write_stream(document, buffer, (gint)len);
	
  if (buff != NULL)
    (*env)->ReleaseStringUTFChars(env, buff, buffer);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_close_stream
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1close_1stream
  (JNIEnv *env, jclass cls, jint doc)
{
  html_document_close_stream((HtmlDocument *)doc);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_clear
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1clear
  (JNIEnv *env, jclass cls, jint doc)
{
  html_document_clear((HtmlDocument *)doc);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_update_hover_node
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1update_1hover_1node
  (JNIEnv *env, jclass cls, jint doc, jint node)
{
  html_document_update_hover_node((HtmlDocument *)doc, (DomNode *) node);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_update_active_node
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1update_1active_1node
  (JNIEnv *env, jclass cls, jint doc, jint node)
{
  html_document_update_active_node((HtmlDocument *)doc, (DomNode *)node);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_update_focus_element
 * Signature: (II)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1update_1focus_1element
  (JNIEnv *env, jclass cls, jint doc, jint element)
{
  html_document_update_focus_element((HtmlDocument *)doc, (DomElement *)element);
}

/*
 * Class:     org_gnu_gtkhtml_HTMLDocument
 * Method:    html_document_find_anchor
 * Signature: (ILjava/lang/String;)V
 */
JNIEXPORT void JNICALL Java_org_gnu_gtkhtml_HTMLDocument_html_1document_1find_1anchor
  (JNIEnv *env, jclass cls, jint doc, jstring anch)
{
  const gchar *anchor = NULL;
	
  if (anch != NULL)
    anchor = (gchar*)(*env)->GetStringUTFChars(env, anch, 0);
		
  html_document_find_anchor((HtmlDocument*)doc, anchor);
	
  if (anch != NULL)
    (*env)->ReleaseStringUTFChars(env, anch, anchor);
}

#ifdef __cplusplus
}
#endif
#endif
