/****************************************************************************
 *                           StimulusItem.cc
 *
 * Author: Matthew Ballance
 * Desc:   The StimulusItem class describes an event in a sequence. The event
 *         may be a single value change or a sequence of value changes...
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#include "StimulusItem.h"

/********************************************************************
 * StimulusItem()
 ********************************************************************/
StimulusItem::StimulusItem(BitVector *val, Uint32 del) :
    value(val), sequence(0), delay(del)
{
   ; 
}


/********************************************************************
 * StimulusItem()
 ********************************************************************/
StimulusItem::StimulusItem(StimulusSeq *seq, Uint32 del) :
    value(0), sequence(seq), delay(del)
{
   ;
}


