/****************************************************************************
 *                                Fifo.h
 *
 * Author: Matthew Ballance
 * Desc:   Defines a basic FIFO... Not the best implementation, but workable
 * <Copyright> (c) 2001-2003 Matthew Ballance (mballance@users.sourceforge.net)
 *
 *    This source code is free software; you can redistribute it
 *    and/or modify it in source code form under the terms of the GNU
 *    General Public License as published by the Free Software
 *    Foundation; either version 2 of the License, or (at your option)
 *    any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA
 *
 * </Copyright>
 ****************************************************************************/
#ifndef INCLUDED_FIFO_H
#define INCLUDED_FIFO_H
#include "types.h"

class Fifo {
    public:
        Fifo(void);
        void append(Char *str);
        void operator << (Char *str);
        Uint32 dequeue(Char *buf, Uint32 buf_len);
        Uint32 length(void);

    private:
        Char        *buffer;
        Uint32       max_len;
        Uint32       len;
};

#endif /* INCLUDED_FIFO_H */
