/*      
 * iroffer by PMG
 * Copyright (C) 1999 PMG
 * 
 * By using this file, you agree to the terms and conditions set
 * forth in the GNU General Public License.  More information is    
 * available in the README file.
 * 
 */

/* include the headers */
#define GEX 
#include "defines.h"
#include "headers.h"
#include "globals.h"

/* main */
int main(int argc, char *argv[]) {
   
   if      ( argc == 2 && !strcmp(argv[1],"-v") ) {
      printf("Version " VERSION " [" VERSIONDATE "]\n");
      exit(0);
      }
   else if ( argc == 3 && !strcmp(argv[1],"-b") )
      background = 1;
   else if ( argc == 2 &&  strcmp(argv[1],"-b") )
      background = 0;
   else {
      printf ("\nUsage: %s -v               (Display Version)"
              "\n       %s <config file>    (Normal Operation)"
              "\n       %s -b <config file> (Background Operation)\n\n",
              argv[0],argv[0],argv[0]);
      exit(1);
      }
   
   initvars();
   
   startupiroffer(argv);
   
   mainloop();
   
   return(0);
   }


void debugmsg (char* msg) {
      printf("[0;31m*** DEBUG2: %s[0m\n",msg);
   }


void mainloop () {
   char tempbuffa[maxtextlength*4];
   char templine[maxtextlength*4];
   char tempstr[maxtextlength];
   char tempstr2[maxtextlengthshort];
   struct timeval timestruct;
   int i,j,length,changesec,changehour,linecut,count,efficency;
   long lasttime, lasthour, last5sec, last20sec, lastxminplist;
   long lastxminautosave, last3min, last2min, lastignoredec;
   userinput *pubplist;
   userinput *urehash;
   
   timestruct.tv_sec = 0;
   timestruct.tv_usec = 50000;
   FD_ZERO(&readset);
   FD_ZERO(&writeset);
   changehour=changesec=0;
   linecut=0;
   lasttime=time(NULL);
   lasthour=(lasttime/60/60)-1;
   last5sec=lasttime;
   lastxminplist=lasttime;
   lastxminautosave=lasttime;
   last3min=lasttime;
   last20sec=lasttime;
   last2min=lasttime;
   lastignoredec=lasttime;
   efficency=0;
   
   highmeminfo = 0;
   
   while(1) {
      
      if (LOOPDEBUG) {
         if (!attop) gototop();
         printf("TOP "); fflush(stdout);
         }
      
      FD_ZERO(&readset);
      FD_ZERO(&writeset);
      
      FD_SET(ircserver, &readset);
      
      if (serverstatus == 'T')
         FD_SET(ircserver, &writeset);
      
      if (!background)
         FD_SET(0, &readset);
      
      if (dccchat != 1000)
         FD_SET(dccchat, &readset);

      if (dccchatlisten != 1000)
         FD_SET(dccchatlisten, &readset);
      
      for (i=0; i<MAXTRANS; i++)
         if (trans[i] != NULL) {
            if (trans[i]->status == 'L')
               FD_SET(trans[i]->listensocket, &readset);
            if (trans[i]->status == 'S' || trans[i]->status == 'E') {
               FD_SET(trans[i]->clientsocket, &writeset);
               FD_SET(trans[i]->clientsocket, &readset);
               }
            if (trans[i]->status == 'W')
#if defined(_OS_BSD_ANY) || defined(_OS_SunOS) 
               FD_SET(trans[i]->clientsocket, &writeset);
#elif defined(_OS_Linux_ANY)
               FD_SET(trans[i]->clientsocket, &readset);
#endif
            }
      
      if (select(highests+1, &readset, &writeset, NULL, &timestruct) < 0);
         ;
/*         outerror(2,"Select returned an error"); */
      
      /*----- one second check ----- */
      
      if (LOOPDEBUG) { printf("A"); fflush(stdout); }
      
      curtime = time(NULL);
      if (curtime != lasttime) {
         lasttime = curtime;
         changesec = 1;
         
         if (SHOWEFF && !(curtime%10)) {
            if (!attop) gototop();
               printf("*** Checks/10sec: %i/%i\n",efficency,10000/WAITTIME);
            efficency = 0;
            }
         }
      
      if (changesec && lasttime/60/60 != lasthour) {
         lasthour = lasttime/60/60;
         changehour = 1;
         }
      
      if (LOOPDEBUG) { printf("B"); fflush(stdout); }
      efficency++;
      
      if (changesec) {
         j = 0;
         for (i=0; i<120; i++)
            j += xdccsent[i];
         if (((float)j)/120.0/1024.0 > sentrecord)
            sentrecord = ((float)j)/120.0/1024.0;
         xdccsent[getbeg(120,curtime%120+1)] = 0;
         }
      
      if (LOOPDEBUG) { printf("C"); fflush(stdout); }
      
      /*----- see if anything waiting on stdin ----- */
      needsclear = 0;
      if (!background && FD_ISSET(0, &readset))
         parsestdin();
      
      if (LOOPDEBUG) { printf("D"); fflush(stdout); }
      /*----- see if ircserver is sending anything to us ----- */
      if (serverstatus == 'C' && FD_ISSET(ircserver, &readset)) {
         lastservercontact = curtime;
         servertime = 0;
         for (i=0; i<maxtextlength*4; i++) tempbuffa[i] = '\0';
         length = read (ircserver, &tempbuffa, maxtextlength*4);
         
         if (length < 0) {
            ioutput1(0,OUT_S|OUT_L|OUT_D,"0;31","Closing Server Connection: Connection Lost.");
            if (exiting)
               recentsent = 0;
            else {
               FD_CLR(ircserver, &readset);
               close(ircserver);
               serverstatus = 'N';
               }
            }
         else {
            i=0; j=linecut;
            while (i<maxtextlength*4 && tempbuffa[i] != '\0') {
               while (i<maxtextlength*4 && tempbuffa[i] != '\n' && tempbuffa[i] != '\0') {
                  templine[j]=tempbuffa[i];
                  i++; j++;
                  }
               templine[j]='\0';
               if (tempbuffa[i] != '\n')
                  linecut=j;
               else {
                  if ( templine[ strlen(templine) -1 ] == 13 )
                     /* chop ^M off end of line if there */
                     templine[ strlen(templine) -1 ] = '\0';
                  parseline(templine);
                  linecut=0;
                  }
               j=0; i++;
               }
            }
         }
      
      if (serverstatus == 'T' && FD_ISSET(ircserver, &writeset)) {
         if ( write (ircserver, "\n", 1) < 0 ) {
            ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"Server Connection Failed");
            FD_CLR(ircserver, &writeset);
            close(ircserver);
            serverstatus = 'N';
            }
         else {
            ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"Server Connection Established, Logging In");
            serverstatus = 'C';
            FD_CLR(ircserver, &writeset);
            if (fcntl(ircserver, F_SETFL, 0) < 0 ) outerror(2,"Couldn't Set Blocking");
            initirc();
            }
         }
      
      if (changesec && serverstatus == 'T' && lastservercontact + CTIMEOUT < curtime) {
         ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"Server Connection Timed Out");
         FD_CLR(ircserver, &readset);
         close(ircserver);
         serverstatus = 'N';
         }
      
      if (serverstatus == 'S') {
         
         char *tempstr233 = mycalloc(maxtextlengthshort,"mainloop_tempstr233");
         strcpy(tempstr233, "QUIT :Changing Servers");
         writeserver2(tempstr233,1);
         mydelete(tempstr233);
         
         FD_CLR(ircserver, &readset);
         close(ircserver);
         serverstatus = 'N';
         }
      
      if (LOOPDEBUG) { printf("E"); fflush(stdout); }
      /*----- see if dccchat is sending anything to us ----- */
      if (FD_ISSET(dccchat, &readset)) {
         for (i=0; i<maxtextlength*4; i++) tempbuffa[i] = '\0';
         length = read (dccchat, &tempbuffa, maxtextlength*4);
         
         if (length < 0) {
            ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"DCC Chat Lost");
            FD_CLR(dccchat, &readset);
            close(dccchat);
            dccchat = 1000;
            highestsock();
            }
         
         i=0; j=linecut;
         while (i<maxtextlength*4 && tempbuffa[i] != '\0') {
            while (i<maxtextlength*4 && tempbuffa[i] != '\n' && tempbuffa[i] != '\0') {
               templine[j]=tempbuffa[i];
               i++; j++;
               }
            templine[j]='\0';
            if (tempbuffa[i] != '\n')
               linecutd=j;
            else {
               parsedccchat(templine);
               linecutd=0;
               }
            j=0; i++;
            }
         }
      
      if (LOOPDEBUG) { printf("F"); fflush(stdout); }
      /*----- see if dccchatlisten has a connection ----- */
      if (FD_ISSET(dccchatlisten, &readset)) {
         setupdccchataccept();
         }

      if (LOOPDEBUG) { printf("G"); fflush(stdout); }
      for (i=0; i<MAXTRANS; i++)
         if (trans[i] != NULL) {
         
      /*----- look for listen reminders ----- */
         if (changesec && trans[i]->status == 'L' && (curtime - trans[i]->lastcontact) >= 30 && trans[i]->reminded == 0)
            t_remind(trans[i]);
         if (changesec && trans[i]->status == 'L' && (curtime - trans[i]->lastcontact) >= 90 && trans[i]->reminded == 1)
            t_remind(trans[i]);
         if (changesec && trans[i]->status == 'L' && (curtime - trans[i]->lastcontact) >= 150 && trans[i]->reminded == 2)
            t_remind(trans[i]);
         
      /*----- look for listen->connected ----- */
         if (trans[i]->status == 'L' && FD_ISSET(trans[i]->listensocket, &readset))
            t_establishcon(trans[i]);
         
      /*----- look for transfer some -----  send at least once a second, or more if necessary */
         if (trans[i]->status == 'S' && (changesec || FD_ISSET(trans[i]->clientsocket, &writeset)))
            t_transfersome(trans[i]);
         
      /*----- look for junk to read ----- */
         if (changesec && (trans[i]->status == 'S'
                        || trans[i]->status == 'W'
                        || trans[i]->status == 'E') && FD_ISSET(trans[i]->clientsocket, &readset))
            t_readjunk(trans[i]);
         
      /*----- look for done flushed status ----- */
         if (changesec && trans[i]->status == 'W')
            t_flushed(trans[i]);
         
      /*----- look for lost transfers ----- */
         if (changesec)
            t_istimeout(trans[i]);
         
      /*----- look for finished transfers ----- */
         if (changesec && trans[i]->status == 'D') {
            mydelete(trans[i]);
            highestsock();
            slotsfull--;
            if (!exiting && (inqueue || inslotsmaxqueue) && (slotsfull < slotsmax)) sendaqueue(0);
            }
         }
      
      /*----- time for a delayed shutdown? ----- */
      if (changesec && delayedshutdown) {
         for (count=i=0; i<MAXTRANS; i++)
            if (trans[i] != NULL) count++;
         
         if (!count) {
            ioutput1(0,OUT_S|OUT_L|OUT_D,NULL,"Delayed Shutdown Activated, No Transfers Remaining");
            shutdowniroffer(0);
            }
         
         }
      
      if (LOOPDEBUG) { printf("H"); fflush(stdout); }
      /*----- send server stuff ----- */
      if (changesec) {
         sendserver();
         if (curtime%10 == 9)
            inamnt[0] = 0;
         else
            inamnt[curtime%10+1] = 0;
         }
      
      /*----- see if we can send out some xdcc lists */
      if (changesec) {
         if (serverq[0] == NULL)
            sendxdlqueue();
         }
      
      /*----- see if its time to change maxb */
      if (changehour) {
         maxb = overallmaxspeed;
         if (overallmaxspeeddayspeed != overallmaxspeed) {
            time_t Tp;
            struct tm *localt;
            time(&Tp);
            localt = localtime(&Tp);

            if (localt->tm_hour >= overallmaxspeeddaytimestart
                && localt->tm_hour < overallmaxspeeddaytimeend
                && ( overallmaxspeeddaydays & (1 << localt->tm_wday)) )
               maxb = overallmaxspeeddayspeed;
            }
         }

      /* time to rotate log ? */
      if (changehour && logrotate && logfile)
         isrotatelog();

      /*----- IGN_TL seconds ----- */
      if (changesec && (curtime - lastignoredec > IGN_TL)) {
         lastignoredec += IGN_TL;
         for (i=0; i<MAXIGNL && ignorelist[i]; i++) {
            if (!attop) gototop();
            ignorelist[i]->bucket--;
            if (ignorelist[i]->ignoring && ignorelist[i]->bucket < IGN_OFF) {
               ignorelist[i]->ignoring = ignorelist[i]->firstignore = 0;
               ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"Ignore removed for *!*@",ignorelist[i]->hostname);
               }
            if (ignorelist[i]->bucket < 0) {
               mydelete(ignorelist[i]);
               for (; i<MAXIGNL; i++) ignorelist[i] = ignorelist[i+1];
               ignorelist[MAXIGNL-1] = NULL;
               
               }
            }
         }
      
      if (LOOPDEBUG) { printf("I"); fflush(stdout); }
      
      /*----- 5 seconds ----- */
      if (changesec && (curtime - last5sec > 4)) {
         last5sec = curtime;
         
         if (LOOPDEBUG) { printf("J"); fflush(stdout); }
         /*----- server timeout ----- */
         if (curtime - lastservercontact > SRVRTOUT) {
            if (servertime < 3) {
               char *tempstr3 = mycalloc(maxtextlength,"mainloop_tempstr3");
               snprintf(tempstr3,maxtextlength-2,"PING %s\n",curserverip);
               write(ircserver, tempstr3, strlen(tempstr3));
               if (debug) ioutput2(0,OUT_S,"0;35","<NORES<: ",tempstr3);
               mydelete(tempstr3);
               servertime++;
               }
            else if (servertime == 3) {
               ioutput1(0,OUT_S|OUT_L|OUT_D,"0;31","Closing Server Connection: No Response for 4 minutes.");
               FD_CLR(ircserver, &readset);
               close(ircserver);
               serverstatus = 'N';
               servertime = 0;
               }
            }
         
         
         /*----- ping server ----- */
         if (recentsent) {
            pingserver();
            recentsent--;
            }
         
         /*----- update lastspeed, check minspeed ----- */
         for (i=0; i<MAXTRANS; i++)
            if (trans[i] != NULL) {
               trans[i]->lastspeed = 
                  (trans[i]->lastspeed)*DCL_SPDW + 
                  ((float)((trans[i]->bytessent-trans[i]->lastspeedamt)/1024))*(1.0-DCL_SPDW)/5.0
                  ;
               trans[i]->lastspeedamt = trans[i]->bytessent;
               
               t_checkminspeed(trans[i]);
               
               }
         
         }

      if (LOOPDEBUG) { printf("K"); fflush(stdout); }
      /*----- check for size change ----- */
      if (changesec)
         checktermsize();
      
      if (LOOPDEBUG) { printf("L"); fflush(stdout); }
      /*----- plist stuff ----- */
      if (serverstatus == 'C' && changesec && (curtime - lastxminplist > plisttime*60)) {
         lastxminplist = curtime;
         if (plist && numpacks) {
            ioutput2(0,OUT_S|OUT_D,NULL,"Plist sent to ",plistchans);
            pubplist = mycalloc(sizeof(userinput),"mainloop_pubplist");
            u_fillwith_msg(pubplist,plistchans,"A A A A A xdl");
            pubplist->method = 4;
            u_parseit(pubplist);
            mydelete(pubplist);
            }
         }
      
      if (LOOPDEBUG) { printf("M"); fflush(stdout); }
      /*----- xdcc autosave stuff ----- */
      if (changesec && (curtime - lastxminautosave > xdccautosavetime*60)) {
         lastxminautosave = curtime;
         xdccsave(1);
         }
      
      if (LOOPDEBUG) { printf("N"); fflush(stdout); }
      /*----- low bandwidth send / queue notify ----- */
      if (changesec && (curtime - last3min > 180)) {
         last3min = curtime;
         
         count = 0;
         for (i=0; i<120; i++)
            count += xdccsent[i];
         count = count/120/1024;
         
       /*  if ( (inqueue || inslotsmaxqueue) && (count < lowbdwth) ) */
         if (count < lowbdwth)
            sendaqueue(1);
         
         notifyqueued();
         
         notifybandwidth();
         }
      
      if (LOOPDEBUG) { printf("O"); fflush(stdout); }
      /*----- log stats / remote admin stats ----- */
      if ( logstats && changesec && logfile && (curtime - last2min > 119)) {
         last2min += 120;
         logstat();
         
         if ( dccchat != 1000 && dccchatin )
            writestatus();
         
         }
      
      if (LOOPDEBUG) { printf("P"); fflush(stdout); }
      
#if !defined _IROFFER_NOPLUGINS
      /*----- plugin ----- */
      plugin_everyloop();
      if (changesec)
         plugin_every1sec();
#endif
      
      if (LOOPDEBUG) { printf("Q"); fflush(stdout); }
      /*----- 20 seconds ----- */
      if (changesec && (curtime - last20sec > 19)) {
         
#if !defined _IROFFER_NOPLUGINS
         plugin_every20sec();
#endif
         
         /* try rejoining channels not on */
         for (i=0; i<MAXCHNLS; i++)
         if (serverstatus == 'C' && channel[i] && !onchan[i]) {
            snprintf(tempstr,maxtextlength-2,"JOIN %s",channel[i]);
            writeserver(tempstr);
            }
         
         if (! USESCREEN )
            break;
         last20sec = curtime;
         
         if (!background) {
            if (attop) gotobot();
            
            printf("[s");
            
            getstatusline(tempstr);
            tempstr[min2(maxtextlength-2,termcols-4)] = '\0';
            snprintf(tempstr2,maxtextlengthshort-2,"[%d;1H[ %%-%ds ]",termlines-1,termcols-4);
            printf(tempstr2,tempstr);
            
            printf("[%d;%dH][u",termlines,termcols);
            
            fflush(stdout);
            }

         }
      
      if (exiting && serverstatus != 'C') {
         
         log1(0,"iroffer exited\n\n");

         if (!background) printf("[r[%i;1H\n",termlines);
         if (pidfile) unlink(pidfile);
         exit(0);
         }
      
      if (serverstatus == 'N') switchserver();
      
      if (needsrehash) {
         needsrehash = 0;
         urehash = mycalloc(sizeof(userinput),"mainloop_urehash");
         u_fillwith_msg(urehash,plistchans,"A A A A A rehash");
         urehash->method = 6;  /* just OUT_S|OUT_L|OUT_D it */
         u_parseit(urehash);
         mydelete(urehash);
         }
      
      if (LOOPDEBUG) { printf("R"); fflush(stdout); }
      if (needsclear) clearbot();
      if (attop) gotobot();
      
      /*----- sleep WAITTIME ms so we don't use excessive cpu time ----- */
#ifndef _OS_SunOS
      msleep( WAITTIME );
#endif _OS_SunOS

      changehour=changesec=0;
      
/*      sleep(5); */
      
      }
   
   /* should never get here, but doesn't matter */
   
   }

void parseline(char *line) {
   char *tempstr = mycalloc(50,"parseline");
   char *tempstr2 = mycalloc(50,"parseline");
   char *part2, *part3, *part4;
   int i;
   
   if (debug)
      ioutput2(0,OUT_S,"0;36",">IRC>: ",line);
   
   part2 = getpart(line,2,"parseline");
   part3 = getpart(line,3,"parseline");
   part4 = getpart(line,4,"parseline");
   
   if (part2 == NULL) {
      mydelete(tempstr);
      mydelete(tempstr2);
      mydelete(part2);
      mydelete(part3);
      mydelete(part4);
      return;
      }
   
 /* misc server msgs */
 /*  snprintf(tempstr,maxtextlength-2, ":%s",curserverip); */
 /*  if (strcmppart(line, tempstr)) */
 /*     ; */
   
 /* NOTICE AUTH */
 /*  if (strcmppart(line, "NOTICE AUTH")) */
 /*     ; */

 /* NOTICE nick */
   /* make sure notice isn't coming from server too! */
   snprintf(tempstr,maxtextlength-2, ":%s",curserverip);
   if (!strcmp(caps(part2),"NOTICE") && !strcmp(caps(part3),caps_nick) && !strcmppart(line,tempstr))
      privmsgparse("NOTICE",line);
 
 /* :server 451  xxxx :Register first. */
   if ( !strcmp(part2,"451") ) {
      if (debug)
         ioutput2(0,OUT_S,NULL,"Register first: ",line);
      initirc();
      }
   
 /* ERROR :Closing Link */
   if (strcmppart(line, "ERROR :Closing Link")) {
      if (exiting)
         recentsent = 0;
      else {
         ioutput2(0,OUT_S|OUT_L|OUT_D,"0;31","Server Closed Connection: ",line);
         
          FD_CLR(ircserver, &readset);
          close(ircserver);
          serverstatus = 'N';
         
         }
      }
   
 /* server ping */
   if (PING_SRVR && strcmppart(line, "PING :")) {
      if (debug)
         ioutput2(0,OUT_S,NULL,"Server Ping: ",line);
      snprintf(tempstr,maxtextlength-2,"%s",line);
      tempstr[1] = 'O';
      writeserver2(tempstr,1);
        /* ping for austnet verification */
     /* snprintf(tempstr,maxtextlength-2,"MODE %s %s",user_nick,user_modes); */
     /* writeserver2(tempstr,1); */
      }

 /* JOIN */
   if (!strcmp(part2,"JOIN")) {
      char* nick;
      int i,found;
      nick = mycalloc(maxtextlengthshort,"parseline");
      i=1;
      nocon = 0;
      found = 0;
      while(line[i] != '!' && i<sstrlen(line) && i<maxtextlengthshort-1) {
         nick[i-1] = line[i];
         i++;
         }
      nick[i-1]='\0';
      if (!strcmp(caps(nick),caps_nick)) {
         for (i=1; i<=sstrlen(part3); i++) {
            part3[i-1]=part3[i];
            }
         ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"Joined ",part3);
         for (i=0; i<MAXCHNLS; i++)
            if (channel[i] && !strcmp(part3,channel[i])) {
               onchan[i] = 1;
               found=1;
               }
         if (!found)
            ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,part3," is not a known channel!");
         }
      mydelete(nick);
      }

 /* KICK */
   if (!strcmp(part2,"KICK")) {
      for (i=0; i<MAXCHNLS; i++)
         if (channel[i] && !strcmp(caps(part3),caps(channel[i]))
         && !strcmp(caps(part4),caps_nick)) {
            ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"Kicked, Rejoining: ",line);
            snprintf(tempstr,maxtextlength-2,"JOIN %s",channel[i]);
            writeserver(tempstr);
            onchan[i] = 0;
            }
      }
   
   
#if !defined _IROFFER_NOPLUGINS
 /* plugin */
   plugin_ircinput(line,part2,part3,part4);
#endif
   
 /* PRIVMSG */
   if (!strcmp(part2,"PRIVMSG")) {
      tempstr[0] = '\0';
      if (autosend)
         snprintf(tempstr,maxtextlength-2,":%s",caps(autoword));
      
      if (autosend && !strcmp(caps(part4),tempstr))
         autosendf(line);
      else
         privmsgparse("PRIVMSG",line);

      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   mydelete(part2);
   mydelete(part3);
   mydelete(part4);
   }


void privmsgparse(char* type, char* line) {
   char *nick, *hostname, *hostmask, *msg1, *msg2, *msg3, *msg4, *msg5, *dest;
   char *tempstr = mycalloc(maxtextlength,"privmsgparse");
   char *tempstr2 = mycalloc(maxtextlength,"privmsgparse");
   int i,j,k;
   userinput ui;
   
   floodchk();
   
   hostmask = caps(getpart(line,1,"privmsgparse"));
   for (i=1; i<=sstrlen(hostmask); i++)
      hostmask[i-1] = hostmask[i];
   
   dest = caps(getpart(line,3,"privmsgparse"));
   msg1 = getpart(line,4,"privmsgparse");
   msg2 = getpart(line,5,"privmsgparse");
   msg3 = getpart(line,6,"privmsgparse");
   msg4 = getpart(line,7,"privmsgparse");
   msg5 = getpart(line,8,"privmsgparse");
   
   
   nick = mycalloc(maxtextlengthshort,"privmsgparse");
   hostname = mycalloc(maxtextlength,"privmsgparse");
   
   
   i=1; j=0;
   while(line[i] != '!' && i<sstrlen(line) && i<maxtextlengthshort-1) {
      nick[i-1] = line[i];
      i++;
      }
   nick[i-1]='\0';
   
   while(line[i] != '@' && i<sstrlen(line)) { i++; }
   i++;
   
   while(line[i] != ' ' && i<sstrlen(line) && j<maxtextlength-1) {
      hostname[j] = line[i];
      i++;
      j++;
      }
   hostname[j]='\0';
   
   if (isthisforme(dest, msg1)) {
      /* add/increment ignore list */
      j=0;
      for (i=0; i<MAXIGNL && ignorelist[i]; i++)
         if (!strcmp(ignorelist[i]->hostname,hostname)) {
            /* already in list */
            j=1;
            ignorelist[i]->bucket++;
            ignorelist[i]->lastcontact = curtime;
            if ( !(ignorelist[i]->ignoring) && ignorelist[i]->bucket >= IGN_ON ) {
               ignorelist[i]->ignoring = ignorelist[i]->firstignore = 1;
               ioutput4(0,OUT_S|OUT_L|OUT_D,NULL,"Auto-ignore activated for ",nick," *!*@",hostname);
               }
            }
      if (!j) { /* not in list */
         j = curtime+10;
         k=0;
         for (i=0; i<MAXIGNL && ignorelist[i]; i++)
            if (ignorelist[i]->lastcontact < j)
               k = i;
         if ( i == MAXIGNL ) {
            mydelete(ignorelist[k]);
            for (i=k; i<MAXIGNL; i++) ignorelist[i] = ignorelist[i+1];
            ignorelist[MAXIGNL-1] = NULL;
            }
      
         for (i=0; i<MAXIGNL && ignorelist[i]; i++);
         if ( i == MAXIGNL ) outerror(1,"Out of ignore slots!, This shouldn't happen");
            ignorelist[i] = mycalloc(sizeof(igninfo),"privmsgparse_ignorelist[i]");
         strcpy(ignorelist[i]->hostname,hostname);
         ignorelist[i]->bucket = 1;
         ignorelist[i]->ignoring = ignorelist[i]->firstignore = ignorelist[i]->manual = 0;
         ignorelist[i]->lastcontact = curtime;
         
         }
   
      /* see if we are ignoreing this person */
      for (i=0; i<MAXIGNL && ignorelist[i]; i++)
         if (!strcmp(ignorelist[i]->hostname,hostname) && ignorelist[i]->ignoring) {
            if (ignorelist[i]->firstignore) {
                privmsg3(nick,"Auto-ignore activated, ignoring *!*@",hostname," until you calm down");
                ignorelist[i]->firstignore = 0;
                }
            ignorelist[i]->lastcontact = curtime;
            mydelete(dest); mydelete(nick); mydelete(hostname); mydelete(hostmask);
            mydelete(msg1); mydelete(msg2); mydelete(msg3); mydelete(msg4); mydelete(msg5);
            mydelete(tempstr); mydelete(tempstr2);
            return;
            }
      }
   
   /*----- CLIENTINFO ----- */
   if ( !ignore && (!strcmp(msg1,":\1CLIENTINFO")
          || !strcmp(msg1,":\1CLIENTINFO\1") )) {
      inamnt[curtime%10]++;
      if (!msg2) {
         notice1(nick,"CLIENTINFO DCC PING VERSION XDCC UPTIME "
         "Use CTCP CLIENTINFO <command> to get information about specific command");
         }
      else if (strcmppart(caps(msg2),"PING"))
         notice1(nick,"CLIENTINFO PING shows if user is still online");
      else if (strcmppart(caps(msg2),"DCC"))
         notice1(nick,"CLIENTINFO DCC requests a direct client connection for chatting or filetransfer");      
      else if (strcmppart(caps(msg2),"VERSION"))
         notice1(nick,"CLIENTINFO VERSION shows information about client version");
      else if (strcmppart(caps(msg2),"XDCC"))
         notice1(nick,"CLIENTINFO XDCC LIST|SEND list and DCC file(s) to you");
      else if (strcmppart(caps(msg2),"UPTIME"))
         notice1(nick,"CLIENTINFO UPTIME shows how long user has been running");
      
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,nick," CLIENTINFO'ed Us.");
      }
   
   /*----- PING ----- */
   else if ( !ignore && (!strcmp(msg1,":\1PING")
          || !strcmp(msg1,":\1PING\1") )) {
      inamnt[curtime%10]++;
/*      msg2 = getpart(line,5,""); */
      tempstr[0] = '\0';
      snprintf(tempstr,maxtextlength-2,"NOTICE %s %s%s%s",nick,msg1,msg2?" ":"",msg2?msg2:"");
      writeserver(tempstr);
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,nick," Pinged Us.");
      }
   
   /*----- VERSION ----- */
   else if ( !ignore && (!strcmp(msg1,":\1VERSION")
          || !strcmp(msg1,":\1VERSION\1") )) {
      inamnt[curtime%10]++;
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :\1VERSION iroffer v%s [%s] By PMG, http://centerclick.org/iroffer/ - %s\1"
              ,nick,VERSION,VERSIONDATE,osstring);
      writeserver(tempstr);
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,nick," Version'ed Us.");
      }
   
   /*----- UPTIME ----- */
   else if ( !ignore && (!strcmp(msg1,":\1UPTIME")
          || !strcmp(msg1,":\1UPTIME\1") )) {
      inamnt[curtime%10]++;
      tempstr2 = getuptime(tempstr2,0);
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :\1iroffer has been running for %s\1"
              ,nick,tempstr2);
      writeserver(tempstr);
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,nick," Uptime'ed Us.");
      }
   
   /*----- STATUS ----- */
   else if ( !ignore && (!strcmp(msg1,":\1STATUS")
          || !strcmp(msg1,":\1STATUS\1") )) {
      inamnt[curtime%10]++;
      tempstr2 = getstatuslinenums(tempstr2);
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :\1%s\1",nick,tempstr2);
      writeserver(tempstr);
      ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,nick," Status'ed Us.");
      }
   
   /*----- DCC CHAT/RESUME ----- */
   else if ( !ignore && !strcmp(caps_nick,dest) && !strcmp(caps(msg1),":\1DCC")) {
      if (!attop) gototop();
/*      msg2 = getpart(line,5,""); */
      if (!strcmp(caps(msg2),"RESUME")) {
/*         msg3 = getpart(line,6,""); */
/*         msg4 = getpart(line,7,""); */
/*         msg5 = getpart(line,8,""); */
         inamnt[curtime%10]++;
         
         for (i=0; i<MAXTRANS; i++)
            if (trans[i] != NULL && trans[i]->status == 'L'
                && !strcmp(trans[i]->nick,nick)
                && trans[i]->listenport == atoi(msg4) )
               t_setresume(trans[i],msg5);
         
         snprintf(tempstr,maxtextlength-2,"PRIVMSG %s :\1DCC ACCEPT %s %s %s\1",nick,msg3,msg4,msg5);
         writeserver(tempstr);
         ioutput3(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC Resume Requested (",nick,")");
         }
      if (!strcmp(caps(msg2),"CHAT")) {
         if ( verifyadmin(hostmask) )
            setupdccchat(line);
         else {
            snprintf(tempstr,maxtextlength-2,"NOTICE %s :DCC Chat Denied (%s is not allowed to DCC Chat)",nick,hostmask);
            writeserver(tempstr);
            ioutput3(0,OUT_S|OUT_L|OUT_D,"0;35","Incorrect DCC CHAT Hostmask (",hostmask,")");
         }

         }
      }
   
   /*----- ADMIN ----- */
   else if ( !ignore && !strcmp(caps_nick,dest) && !strcmp(caps(msg1),":ADMIN") ) {
/*      msg2 = getpart(line,5,""); */
      if (!attop) gototop();
      
      if ( verifyadmin(hostmask) ) {
         if (adminpass != NULL && msg2 != NULL && !strcmp(caps(msg2),adminpass)) {
/*            msg3 = getpart(line,6,""); */
/*            msg4 = getpart(line,7,""); */
            u_fillwith_msg(&ui,nick,line);
            u_parseit(&ui);
            /*remoteadmin(nick,msg3,msg4,line); */

            }
         else {
            snprintf(tempstr,maxtextlength-2,"NOTICE %s :ADMIN: Incorrect Password",nick);
            writeserver(tempstr);
            ioutput5(0,OUT_S|OUT_L|OUT_D,"0;35","Incorrect ADMIN Password (",nick," ",hostname,")");
            }
         }
      else {
         snprintf(tempstr,maxtextlength-2,"NOTICE %s :ADMIN: %s is not allowed to issue admin commands",nick,hostmask);
         writeserver(tempstr);
         ioutput3(0,OUT_S|OUT_L|OUT_D,"0;35","Incorrect ADMIN Hostname (",hostmask,")");
         }
      }
   
   /*----- XDCC ----- */
   else if ( !ignore && !strcmp(caps_nick,dest) && (!strcmp(caps(msg1),":XDCC") || !strcmp(msg1,":\1XDCC") )) {
      inamnt[curtime%10]++;
      
      caps(msg2);
      
      if (msg3 && msg3[strlen(msg3)-1] == '\1')
         msg3[strlen(msg3)-1] = '\0';
      
      if ( msg2 && ( !strcmp(msg2,"LIST") || !strcmp(msg2,"LIST\1"))) {
         if (!attop) gototop();
         
         for (i=0,j=0; i<MAXXLQUE; i++) 
            if (xlistqueue[i] && !strcmp(xlistqueue[i],nick))
               j = 1; /* already in queue */
         
         if (!j) {
            for (i=0; i<MAXXLQUE && xlistqueue[i]; i++) ;
            
            if (i == MAXXLQUE-1) {
               sendxdlqueue();
               for (i=0; i<MAXXLQUE && xlistqueue[i]; i++) ;
               }
            
            xlistqueue[i] = mycalloc(maxtextlengthshort,"privmsgparse");
            strcpy(xlistqueue[i],nick);
            
            }
         
         ioutput6(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC LIST ",(j?"ignored: ":"queued: "),nick," (",hostname,") ");
         
         }
      else if ( msg2 && msg3 && !strcmp(msg2,"SEND")) {
         if (!attop) gototop();
         ioutput2(1,OUT_S|OUT_L|OUT_D,"0;33","XDCC SEND ",msg3);
         sendxdccfile(nick, hostname, packnumtonum(msg3), NULL);
         }
      else if ( msg2 && !strcmp(msg2,"REMOVE")) {
         if (!attop) gototop();
         k=0;
         for (i=0; i<MAXQUEUE && mainqueue[i]; i++)
            if (!strcmp(mainqueue[i]->nick,nick)) {
               snprintf(tempstr,maxtextlength-2,
                  "Removed you from the queue for \"%s\", you waited %li minute%s.",
                  mainqueue[i]->xpack->desc,(curtime-mainqueue[i]->queuedtime)/60,((curtime-mainqueue[i]->queuedtime)/60)!=1?"s":"");
               privmsg1(nick,tempstr);
               mydelete(mainqueue[i]);
               for (j=i+1; j<inqueue; j++)
                  mainqueue[j-1] = mainqueue[j];
               mainqueue[j] = NULL;
               inqueue--;
               k=1;
               }
         for (i=0; i<MAXQUEUE && packqueue[i]; i++)
            if (!strcmp(packqueue[i]->nick,nick)) {
               snprintf(tempstr,maxtextlength-2,
                  "Removed you from the queue for \"%s\", you waited %li minute%s.",
                  packqueue[i]->xpack->desc,(curtime-packqueue[i]->queuedtime)/60,((curtime-packqueue[i]->queuedtime)/60)!=1?"s":"");
               privmsg1(nick,tempstr);
               mydelete(packqueue[i]);
               for (j=i+1; j<inslotsmaxqueue; j++)
                  packqueue[j-1] = packqueue[j];
               packqueue[j] = NULL;
               inslotsmaxqueue--;
               k=1;
               }
         if (!k) privmsg1(nick,"You Don't Appear To Be In A Queue");
         ioutput5(0,OUT_S|OUT_L|OUT_D,"0;33","XDCC REMOVE ",nick," (",hostname,") ");
         
         }
      }
   
   else if (!strcmp(type,"PRIVMSG")) {
      if (dest && !strcmp(dest,caps_nick)) {
#if !defined _IROFFER_NOPLUGINS
         plugin_ircprivmsg(line,nick,hostname,dest,msg1,msg2,msg3,msg4,msg5);
#endif
         if (messagefile) {
            ioutput3(0,OUT_S|OUT_D,NULL,"MSG from ",nick," logged, use MSGREAD to display it.");
            msglog_add(hostmask,line);
            }
         else
            ioutput2(0,OUT_S|OUT_L|OUT_D,NULL,"*** MSG: ",line);
         
/*         snprintf(tempstr,maxtextlength-2,"NOTICE %s :Unknown Command, Did you mistype?",nick); */
/*         writeserver(tempstr);          */
         }
      }
   
   mydelete(dest);
   mydelete(nick);
   mydelete(hostname);
   mydelete(hostmask);
   mydelete(msg1);
   mydelete(msg2);
   mydelete(msg3);
   mydelete(msg4);
   mydelete(msg5);
   mydelete(tempstr);
   mydelete(tempstr2);
   }

void autosendf(char* line) {
   char *nick, *hostname;
   char *tempstr = mycalloc(maxtextlength,"autosendf");
   int i,j;
   
   floodchk();
   
   nick = mycalloc(maxtextlengthshort,"autosendf");
   hostname = mycalloc(maxtextlength,"autosendf");
      
   i=1; j=0;
   while(line[i] != '!' && i<sstrlen(line) && i<maxtextlengthshort-1) {
      nick[i-1] = line[i];
      i++;
      }
   nick[i-1]='\0';
   
   while(line[i] != '@' && i<sstrlen(line)) { i++; }
   i++;
   
   while(line[i] != ' ' && i<sstrlen(line) && j<maxtextlength-1) {
      hostname[j] = line[i];
      i++;
      j++;
      }
   hostname[j]='\0';
   
   if ( !ignore ) {
      inamnt[curtime%10]++;
      
      if (!attop) gototop();
      
      ioutput1(1,OUT_S|OUT_L|OUT_D,"0;33","AutoSend ");

      snprintf(tempstr,maxtextlength-2," :*** Sending You %s by DCC",automsg);
   
      sendxdccfile(nick, hostname, autopack, tempstr);
      }
   
   mydelete(nick);
   mydelete(hostname);
   mydelete(tempstr);

   }

void sendxdccfile(char* nick, char* hostname, int pack, char* msg) {
   char *tempstr = mycalloc(maxtextlength,"sendxdccfile");
   char *tempstr2 = mycalloc(maxtextlength,"sendxdccfile");
   int i, temp1, usertrans, userpackok, p, man;
   xdcc *userxfr;
   
   usertrans = 0;
   userpackok = 1;
   man = 0;
   
   if (!strcmp(hostname,"man"))
      man = 1;
   
   for (i=0, p=0; i<pack; i++, p++)
      while ( p<(MAXXDCCS-1) && (xdccs[p] == NULL || xdccs[p]->offered == 0))
         p++;
   userxfr = xdccs[p-1];
   
   for (i=0; i<MAXTRANS; i++)
      if (!man && trans[i] != NULL && !strcmp(trans[i]->hostname,hostname)) {
         usertrans++;
         if (userxfr == trans[i]->xpack)
            userpackok = 0;
         }
   
   if (USER_MAXS && !man && usertrans && !userpackok) {
      ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (dup): ");
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** You already requested that pack",nick);
      writeserver(tempstr);
      }
   else if ( !man && usertrans >= maxtransfersperperson) {
      ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (user): ");
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** You can only have %d transfer%s at a time",nick,maxtransfersperperson,maxtransfersperperson!=1?"s":"");
      writeserver(tempstr);
      }
   else if (!man && (pack > numpacks || pack < 1)) {
      ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," (Bad Pack Number): ");
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Invalid Pack Number, Try Again",nick);
      writeserver(tempstr);
      }
   else if (!man && nonewcons > curtime ) {
      ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," (No New Cons): ");
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** The Owner Has Requested That No New Connections Are Made In The Next %li Minute%s",nick,(nonewcons-curtime+1)/60,((nonewcons-curtime+1)/60)!=1?"s":"");
      writeserver(tempstr);
      }   
   else if (!man && pack == slotsmaxpack && slotsmaxslots-slotsfull <= 0) {
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Sorry Pack %i Has a Slot Limitation, ",nick,pack);
      addtoqueue(tempstr, nick, hostname, pack);
      writeserver(tempstr);
      }
   else if (!man && slotsmax-slotsfull <= 0) {
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** All Slots Full, ",nick);
      addtoqueue(tempstr, nick, hostname, pack);
      writeserver(tempstr);
      }
   else {
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<MAXTRANS); i++)
         if (trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(1,"Out of Transfer IDs! (This Shouldn't Happen, There Are 100 Of Them)");
         mydelete(tempstr);
         mydelete(tempstr2);
         return;
         }
      
      trans[temp1] = mycalloc(sizeof(transfer),"sendxdccfile");
      t_initvalues(trans[temp1]);
      trans[temp1]->id = temp1;
      strcpy(trans[temp1]->nick,nick);
      strcpy(trans[temp1]->hostname,hostname);
      trans[temp1]->whichtransfer = temp1;
      
      trans[temp1]->xpack = userxfr;
      
      if (!man)
         ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," requested: ");
      slotsfull++;
      snprintf(tempstr,maxtextlength-2,"NOTICE %s",nick);
      if (!msg)
         snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Sending You Pack #%i Which Is %sB. (Resume Supported)",
            nick,pack,sizestr(0,tempstr2,trans[temp1]->xpack->size));
      else
         snprintf(tempstr,maxtextlength-2,"NOTICE %s%s Which Is %sB. (Resume Supported)",
            nick,msg,sizestr(0,tempstr2,trans[temp1]->xpack->size));
      writeserver(tempstr);

      t_setuplisten(trans[temp1]);

      snprintf(tempstr,maxtextlength-2,"PRIVMSG %s :\1DCC SEND %s %lu %i %lu\1",
         nick,
         getfilename(tempstr2,trans[temp1]->xpack->file),
         ourip,
         trans[temp1]->listenport,
         trans[temp1]->xpack->size);
      writeserver(tempstr);
      }
   if (!man)
      ioutput4(3,OUT_S|OUT_L|OUT_D,"0;33",nick," (",hostname,")");

   mydelete(tempstr);
   mydelete(tempstr2);

   }
   
void addtoqueue(char* srvmsg, char* nick, char* hostname, int pack) {
   char *tempstr = mycalloc(maxtextlength,"addtoqueue");
   pqueue *tempq;
   xdcc *tempx;
   int i,p,inq;
   
   inq=0;
   for (i=0; i<MAXQUEUE; i++)
      if ( (mainqueue[i] != NULL && !strcmp(mainqueue[i]->hostname,hostname))
        || (packqueue[i] != NULL && !strcmp(packqueue[i]->hostname,hostname)) )
         inq++;
   
   if (USER_QUE && inq) {
      ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (user/queue): ");
      snprintf(tempstr,maxtextlength-2,
         "%sDenied, You Are Already in A Queue, Try Again Later",
         srvmsg);
      strcpy(srvmsg,tempstr);
      mydelete(tempstr);
      return;
      }
   
   for (i=0, p=0; i<pack; i++, p++)
      while ( p<(MAXXDCCS-1) && (xdccs[p] == NULL || xdccs[p]->offered == 0))
         p++;
   tempx = xdccs[p-1];
   
   if (pack == slotsmaxpack) {
      if (inslotsmaxqueue >= slotsmaxqueue) {
         ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (pack/queue): ");
         snprintf(tempstr,maxtextlength-2,
            "%sQueue for pack %d of size %d is Full, Try Again Later",
            srvmsg,pack,slotsmaxqueue);
         strcpy(srvmsg,tempstr);
         }
      else {
         ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," Queued (pack): ");
         tempq = mycalloc(sizeof(pqueue),"addtoqueue");
         tempq->queuedtime = curtime;
         strcpy(tempq->nick,nick);
         strcpy(tempq->hostname,hostname);
         tempq->xpack = tempx;
         packqueue[inslotsmaxqueue] = tempq;
         snprintf(tempstr,maxtextlength-2,
            "%sAdded to pack %d queue in position %d of %d. To Remove youself at "
            "a later time type \"/msg %s xdcc remove\".",
            srvmsg,pack,inslotsmaxqueue+1,slotsmaxqueue,user_nick);
         strcpy(srvmsg,tempstr);
         inslotsmaxqueue++;
         }
      }
   else {
      if (inqueue >= queuesize) {
         ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," Denied (slot/queue): ");
         snprintf(tempstr,maxtextlength-2,
            "%sQueue of size %d is Full, Try Again Later",
            srvmsg,queuesize);
         strcpy(srvmsg,tempstr);
         }
      else {
         ioutput1(2,OUT_S|OUT_L|OUT_D,"0;33"," Queued (slot): ");
         tempq = mycalloc(sizeof(pqueue),"addtoqueue");
         tempq->queuedtime = curtime;
         strcpy(tempq->nick,nick);
         strcpy(tempq->hostname,hostname);
         tempq->xpack = tempx;
         mainqueue[inqueue] = tempq;

         snprintf(tempstr,maxtextlength-2,
            "%sAdded queue in position %d of %d. To Remove youself at "
            "a later time type \"/msg %s xdcc remove\".",
            srvmsg,inqueue+1,queuesize,user_nick);
         strcpy(srvmsg,tempstr);
         inqueue++;
         }
      }
   mydelete(tempstr);
   }

void notifyqueued() {
   char *tempstr = mycalloc(maxtextlength,"notifyqueued");   
   char *tempstr2 = mycalloc(maxtextlengthshort,"notifyqueued");   
   int i,count;
   
   if ( !exiting && (inqueue || inslotsmaxqueue)) {
      count = 0;
      for (i=0; i<120; i++)
         count += xdccsent[i];
      
      ioutput1(1,OUT_S|OUT_D,"0;33","Notifying ");
      ioutputi (OUT_S|OUT_D,inqueue + inslotsmaxqueue);
      ioutput1(2,OUT_S|OUT_D,"0;33"," Queued People (");
      ioutputi (OUT_S|OUT_D,count/120/1024);
      ioutput1(2,OUT_S|OUT_D,"0;33","K/sec used, ");
      ioutputi (OUT_S|OUT_D,lowbdwth);
      ioutput1(3,OUT_S|OUT_D,"0;33","K/sec limit)");

      }
   
   for (i=0; i<inqueue; i++) {
      if ((curtime-mainqueue[i]->queuedtime)/60 > 59)
         snprintf(tempstr,maxtextlength-2,"NOTICE %s :You have been queued for %li hour%s %li minute%s, currently in main queue position %i of %i.  To remove yourself type \"/msg %s xdcc remove\".",
            mainqueue[i]->nick,
            (curtime-mainqueue[i]->queuedtime)/60/60,
            ((curtime-mainqueue[i]->queuedtime)/60/60)!=1?"s":"",
            ((curtime-mainqueue[i]->queuedtime)/60)%60,
            (((curtime-mainqueue[i]->queuedtime)/60)%60)!=1?"s":"",
            i+1,
            queuesize,
            user_nick);
      else
         snprintf(tempstr,maxtextlength-2,"NOTICE %s :You have been queued for %li minute%s, currently in main queue position %i of %i.  To remove yourself type \"/msg %s xdcc remove\".",
            mainqueue[i]->nick,
            (curtime-mainqueue[i]->queuedtime)/60,
            ((curtime-mainqueue[i]->queuedtime)/60)!=1?"s":"",
            i+1,
            queuesize,
            user_nick);
      writeserver(tempstr);
      }
   for (i=0; i<inslotsmaxqueue; i++) {
      if ((curtime-packqueue[i]->queuedtime)/60 > 59)
         snprintf(tempstr,maxtextlength-2,"NOTICE %s :You have been queued for %li hour%s %li minute%s, currently in pack queue position %i of %i.  To remove yourself type \"/msg %s xdcc remove\".",
            packqueue[i]->nick,
            (curtime-packqueue[i]->queuedtime)/60/60,
            ((curtime-packqueue[i]->queuedtime)/60/60)!=1?"s":"",
            ((curtime-packqueue[i]->queuedtime)/60)%60,
            (((curtime-packqueue[i]->queuedtime)/60)%60)!=1?"s":"",
            i+1,
            slotsmaxqueue,
            user_nick);
      else
         snprintf(tempstr,maxtextlength-2,"NOTICE %s :You have been queued for %li minute%s, currently in pack queue position %i of %i.  To remove yourself type \"/msg %s xdcc remove\".",
            packqueue[i]->nick,
            (curtime-packqueue[i]->queuedtime)/60,
            ((curtime-packqueue[i]->queuedtime)/60)!=1?"s":"",
            i+1,
            slotsmaxqueue,
            user_nick);
      writeserver(tempstr);
      }
   
   
   mydelete(tempstr);
   mydelete(tempstr2);
   }

void notifybandwidth() {
   char *tempstr;   
   int i,j;
   
   if (exiting) return;
   if (!maxb) return;
   
   
   j = 0;
   for (i=0; i<120; i++)
      j += xdccsent[i];
   j /= 1024;
   
   tempstr = mycalloc(maxtextlength,"notifybandwidth");   
   /* send if over 90% */
   if ( (j*10) > (maxb*30*9) ) {
      for (i=0; i<MAXTRANS; i++)
         if (trans[i] != NULL) {
         snprintf(tempstr,maxtextlength-2,"NOTICE %s :%s has a bandwidth limit. %2.1fKB/sec of %2.1fKB/sec is being used right now. You may be experiencing slow performance.",trans[i]->nick,user_nick,((float)j)/120.0,((float)maxb)/4.0);
         writeserver(tempstr);
         }
      }
   
   mydelete(tempstr);
   }

void sendaqueue(int type) {
   char *tempstr = mycalloc(maxtextlength,"sendaqueue");
   char *tempstr2 = mycalloc(maxtextlength,"sendaqueue");
   int i, temp1;
   
   if (!attop) gototop();
   
   if (inqueue) {
      
      if (type == 1)
         ioutput5(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (low bandwidth): ",mainqueue[0]->nick," (",mainqueue[0]->hostname,")");
      else
         ioutput5(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND: ",mainqueue[0]->nick," (",mainqueue[0]->hostname,")");
      
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<MAXTRANS); i++)
         if (trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(1,"Out of Transfer IDs! (This Shouldn't Happen)");
         mydelete(tempstr);
         mydelete(tempstr2);
         return;
         }
      
      trans[temp1] = mycalloc(sizeof(transfer),"sendaqueue");
      t_initvalues(trans[temp1]);
      trans[temp1]->id = temp1;
      strcpy(trans[temp1]->nick,mainqueue[0]->nick);
      strcpy(trans[temp1]->hostname,mainqueue[0]->hostname);
      
      trans[temp1]->xpack = mainqueue[0]->xpack;
      
      slotsfull++;
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Sending You Your Queued Pack Which Is %sB. (Resume Supported)",
         mainqueue[0]->nick,sizestr(0,tempstr2,trans[temp1]->xpack->size));
      writeserver(tempstr);
      
      t_setuplisten(trans[temp1]);
      
      snprintf(tempstr,maxtextlength-2,"PRIVMSG %s :\1DCC SEND %s %lu %i %lu\1",
         mainqueue[0]->nick,
         getfilename(tempstr2,trans[temp1]->xpack->file),
         ourip,
         trans[temp1]->listenport,
         trans[temp1]->xpack->size);
      writeserver(tempstr);

      mydelete(mainqueue[0]);
      for (i=0; i<inqueue; i++)
         mainqueue[i-1] = mainqueue[i];
      mainqueue[i] = NULL;
      inqueue--;
      }
   
   else if (inslotsmaxqueue && slotsmaxslots-slotsfull > 0) {
      if (type == 1)
         ioutput5(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (PACK) (low bandwidth): ",packqueue[0]->nick," (",packqueue[0]->hostname,")");
      else
         ioutput5(0,OUT_S|OUT_L|OUT_D,"0;33","QUEUED SEND (PACK): ",packqueue[0]->nick," (",packqueue[0]->hostname,")");
      
      /* find a transfer slot */
      temp1=-1;
      for (i=0; (temp1<0 && i<MAXTRANS); i++)
         if (trans[i] == NULL)
            temp1=i;
      if ( temp1 == -1 ) {
         outerror(1,"Out of Transfer IDs! (This Shouldn't Happen)");
         mydelete(tempstr);
         mydelete(tempstr2);
         return;
         }
      
      trans[temp1] = mycalloc(sizeof(transfer),"sendaqueue");
      t_initvalues(trans[temp1]);
      trans[temp1]->id = temp1;
      strcpy(trans[temp1]->nick,packqueue[0]->nick);
      strcpy(trans[temp1]->hostname,packqueue[0]->hostname);
      
      trans[temp1]->xpack = packqueue[0]->xpack;
      
      slotsfull++;
      snprintf(tempstr,maxtextlength-2,"NOTICE %s :*** Sending You Your Queued Pack Which Is %sB. (Resume Supported)",
         packqueue[0]->nick,sizestr(0,tempstr2,trans[temp1]->xpack->size));
      writeserver(tempstr);
      
      t_setuplisten(trans[temp1]);
      
      snprintf(tempstr,maxtextlength-2,"PRIVMSG %s :\1DCC SEND %s %lu %i %lu\1",
         packqueue[0]->nick,
         getfilename(tempstr2,trans[temp1]->xpack->file),
         ourip,
         trans[temp1]->listenport,
         trans[temp1]->xpack->size);
      writeserver(tempstr);

      mydelete(packqueue[0]);
      for (i=0; i<inslotsmaxqueue; i++)
         packqueue[i-1] = packqueue[i];
      packqueue[i] = NULL;
      inslotsmaxqueue--;
      }
   
   mydelete(tempstr);
   mydelete(tempstr2);
   
   }








   
