/*************************************************************************
 * $Id: mod_autoshutdown.c,v 1.2 2001/03/14 23:29:04 dpotter Exp $
 *
 * mod_autoshutdown.c - a module to automatically terminate IRMP3
 * 			after a period of inactivity.
 *
 * Copyright (C) 2000 by David E. Potter <dp-irmp3@dpotter.com>
 *
 */

#if MOD_IDLE != 1
#error mod_idle must be included for mod_autoshutdown to work
#endif

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <signal.h>
#include <fcntl.h>
#include <malloc.h>

#include "tools.h"
#include "config.h"
#include "log.h"
#include "mod.h"
#include "mod_autoshutdown.h"


/*************************************************************************
 * GLOBALS AND STATICS
 */

static unsigned int	shutdown_seconds = 0;


/*************************************************************************
 * MODULE INFO
 */
mod_t mod_autoshutdown = {
	mod_autoshutdown_deinit,	// deinit
	NULL,						// reload
	&blank_fd,					// watch_fdset
	NULL,						// poll
	NULL,						// update
	mod_autoshutdown_message, 	// message
	NULL,						// SIGCHLD handler
};

void mod_autoshutdown_message (int msgtype, char *msg)
{
	unsigned long idle_time=0;
	
	if(msgtype == MSGTYPE_IDLE) {
		idle_time=strtol(msg,(char **)NULL,10);
		if (idle_time >= shutdown_seconds) {
			log_printf(LOG_NORMAL, "mod_autoshutdown_alarm(): autoshutdown timeout reached. Shutting down...\n");
			terminate=1;
		}
	}
}


/*************************************************************************
 * MODULE INIT FUNCTION
 */
char *mod_autoshutdown_init (void)
{
	char minutes[15];

	// register our module
	log_printf(LOG_DEBUG, "mod_autoshutdown_init(): initializing.\n");
	mod_register(&mod_autoshutdown);

	shutdown_seconds = 60 * config_getnum("autoshutdown_time",0);
	if (!shutdown_seconds) {
		log_printf(LOG_ERROR, "mod_autoshutdown_init(): Cannot find autoshutdown_time.\n");
	} else {

		if (shutdown_seconds > 60) 
			strcpy(minutes,"minutes");
		else 
			strcpy(minutes,"minute");

		log_printf(LOG_DEBUG, "mod_autoshutdown_init(): shutdown time is %d %s.\n",shutdown_seconds/60,minutes);
	}
	return NULL;
}

/*************************************************************************
 * MODULE DEINIT FUNCTION
 */
void mod_autoshutdown_deinit (void)
{
	log_printf(LOG_DEBUG, "mod_autoshutdown_deinit(): deinitialized\n");
}


/*************************************************************************
 * EOF
 */
