/*  Inti-GL: Integrated Foundation Classes
 *  Copyright (C) 2003 The Inti Development Team.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

//! @file inti/inti-gl.h
//! @brief The main Inti-GL header file.

//! @defgroup inti_group The Inti Namespace
//! @namespace Inti
//! @brief Primary Namespace.

//! @defgroup gdk_group The Gdk Namespace
//! @namespace Inti::Gdk
//! @ingroup inti_group
//! @brief C++ framework for the GTK+ Drawing Kit and the GdkPixbuf library.
//!
//! Provides an API that can be used to add two-dimensional graphics
//! to your program. GDK itself is the abstraction layer that allows
//! GTK+ to support multiple windowing systems. GDK provides drawing
//! and window system facilities on X11, Windows, and the Linux
//! framebuffer device.

//! @defgroup gdk_gl_group The Gdk Namespace
//! @namespace Inti::Gdk::GL
//! @ingroup gdk_group
//! @brief C++ framework for the GdkGLExt Open-GL extension.
//!
//! Provides the GDK objects which support OpenGL rendering in GTK.

//! @defgroup gtk_group The Gtk Namespace
//! @namespace Inti::Gtk
//! @ingroup inti_group
//! @brief C++ framework for the GTK GUI library.
//!
//! Provides a set of graphical objects called widgets which serve as
//! the GUI component, such as Gtk::Button and Gtk::Textview.

//! @defgroup gtk_gl_group The Gtk Namespace
//! @namespace Inti::Gtk::GL
//! @ingroup gtk_group
//! @brief C++ framework for the GtkGLExt Open-GL extension.
//!
//! Provides the Gtk::Widget API add-ons to make Gtk::Widgets OpenGL-capable.

#ifndef INTI_GL_H
#define INTI_GL_H

extern const unsigned int inti_gl_major_version;
//!< libinti-gl major version  number.

extern const unsigned int inti_gl_minor_version;
//!< libinti-gl minor version  number.

extern const unsigned int inti_gl_micro_version;
//!< libinti-gl micro version  number.

#endif // INTI_GL_H

