/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * ProductsPanel.java
 *
 * Created on Mar 30, 2011, 7:44:18 PM
 */

package com.ggasoftware.indigo.legio;

import com.ggasoftware.indigo.Indigo;
import com.ggasoftware.indigo.IndigoObject;
import com.ggasoftware.indigo.IndigoRenderer;
import com.ggasoftware.indigo.controls.BeanBase;
import com.ggasoftware.indigo.controls.FileOpener;
import com.ggasoftware.indigo.controls.MolClicker;
import com.ggasoftware.indigo.controls.MolRenderer;
import com.ggasoftware.indigo.controls.MolSaver;
import com.ggasoftware.indigo.controls.MultiLineCellRenderer;
import java.util.ArrayList;
import javax.swing.SwingConstants;

/**
 *
 * @author achurinov
 */
public class ProductsPanel extends BeanBase {
   private Indigo _indigo;
   private IndigoRenderer _indigo_renderer;
   private LegioData _legio;
   private FileOpener _fopener = new FileOpener();
   private ArrayList<RenderableIndigoObject> _reactions =
               new ArrayList<RenderableIndigoObject>();

    /** Creates new form ProductsPanel */
    public ProductsPanel() {
        initComponents();
    }

    public void init( Indigo indigo, IndigoRenderer indigo_renderer,
             LegioData new_legio )
    {
       this._indigo = indigo;
       this._indigo_renderer = indigo_renderer;

       MolTableModel model = (MolTableModel)products_table.getModel();

       products_table.getColumn("Id").setCellRenderer(new MultiLineCellRenderer(SwingConstants.CENTER,
                                   SwingConstants.CENTER));
       products_table.getColumn(model.getColumnName(1)).setCellRenderer(new MolRenderer(indigo, _indigo_renderer,
               getSize().width - 70, 160, true));

       setName("Number of products - ");
       setBorder(javax.swing.BorderFactory.createTitledBorder(_name));

       products_table.getColumn(model.getColumnName(1)).setPreferredWidth(getSize().width - 30);
       products_table.getColumn("Id").setPreferredWidth(30);
       products_table.addMouseListener(new MolClicker(_indigo, _indigo_renderer, products_table, true));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {

      scroll_panel = new javax.swing.JScrollPane();
      products_table = new javax.swing.JTable();
      save_panel = new javax.swing.JPanel();
      save_reactions_button = new javax.swing.JButton();
      save_products_button = new javax.swing.JButton();

      products_table.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
      products_table.setModel(new MolTableModel(true));
      products_table.setRowHeight(160);
      scroll_panel.setViewportView(products_table);

      save_reactions_button.setText("Save Reactions");
      save_reactions_button.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            save_reactions_buttonActionPerformed(evt);
         }
      });

      save_products_button.setText("Save Products");
      save_products_button.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            save_products_buttonActionPerformed(evt);
         }
      });

      javax.swing.GroupLayout save_panelLayout = new javax.swing.GroupLayout(save_panel);
      save_panel.setLayout(save_panelLayout);
      save_panelLayout.setHorizontalGroup(
         save_panelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addGroup(save_panelLayout.createSequentialGroup()
            .addComponent(save_reactions_button, javax.swing.GroupLayout.PREFERRED_SIZE, 110, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(save_products_button, javax.swing.GroupLayout.PREFERRED_SIZE, 110, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addContainerGap(174, Short.MAX_VALUE))
      );
      save_panelLayout.setVerticalGroup(
         save_panelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addComponent(save_reactions_button, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
         .addComponent(save_products_button, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      );

      javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
      this.setLayout(layout);
      layout.setHorizontalGroup(
         layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addComponent(scroll_panel, javax.swing.GroupLayout.DEFAULT_SIZE, 400, Short.MAX_VALUE)
         .addComponent(save_panel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
      );
      layout.setVerticalGroup(
         layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
            .addComponent(scroll_panel, javax.swing.GroupLayout.DEFAULT_SIZE, 271, Short.MAX_VALUE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(save_panel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
      );
   }// </editor-fold>//GEN-END:initComponents

    private void save_reactions_buttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_save_reactions_buttonActionPerformed
       MolSaver mol_saver = new MolSaver(_indigo);
       mol_saver.addExtension("rdf");
       mol_saver.saveMols(_reactions);
    }//GEN-LAST:event_save_reactions_buttonActionPerformed

    private void save_products_buttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_save_products_buttonActionPerformed
       MolSaver mol_saver = new MolSaver(_indigo);
       mol_saver.addExtension("cml");
       mol_saver.addExtension("smi");
       mol_saver.addExtension("sdf", "sd");
       ArrayList<RenderableIndigoObject> products = new ArrayList<RenderableIndigoObject>();
       for (RenderableIndigoObject rend_obj : _reactions)
       {
          IndigoObject prod_iter = rend_obj.getObject().iterateProducts();
          for (IndigoObject product : prod_iter)
          {
             products.add(new RenderableIndigoObject(product));
             break;
          }
       }
       mol_saver.saveMols(products);
    }//GEN-LAST:event_save_products_buttonActionPerformed


    public void setMols( ArrayList<IndigoObject> reactions )
    {
       MolTableModel model = (MolTableModel)products_table.getModel();
       model.setMols(reactions);
       setBorder(javax.swing.BorderFactory.createTitledBorder(_name + model.getMolsCount()));
       _reactions.clear();
       for (IndigoObject obj : reactions)
          _reactions.add(new RenderableIndigoObject(obj));
    }

    public void clear()
    {
        MolTableModel model = (MolTableModel)products_table.getModel();
        model.clear();
       _reactions.clear();
    }

   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JTable products_table;
   private javax.swing.JPanel save_panel;
   private javax.swing.JButton save_products_button;
   private javax.swing.JButton save_reactions_button;
   private javax.swing.JScrollPane scroll_panel;
   // End of variables declaration//GEN-END:variables
}
