/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * MonomerPanel.java
 *
 * Created on Mar 25, 2011, 8:48:41 PM
 */

package com.ggasoftware.indigo.legio;

import com.ggasoftware.indigo.Indigo;
import com.ggasoftware.indigo.IndigoObject;
import com.ggasoftware.indigo.IndigoRenderer;
import com.ggasoftware.indigo.controls.BeanBase;
import com.ggasoftware.indigo.controls.FileOpener;
import com.ggasoftware.indigo.controls.IndigoEventSource;
import com.ggasoftware.indigo.controls.CommonUtils;
import com.ggasoftware.indigo.controls.MolClicker;
import com.ggasoftware.indigo.controls.MolRenderer;
import com.ggasoftware.indigo.controls.MolSaver;
import com.ggasoftware.indigo.controls.MultiLineCellRenderer;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableCellRenderer;

/**
 *
 * @author achurinov
 */
public class MonomerPanel extends BeanBase {
   private Indigo _indigo;
   private IndigoRenderer _indigo_renderer;
   private LegioData _legio;
   private FileOpener _fopener = new FileOpener();
   public IndigoEventSource<String> add_event =
        new IndigoEventSource<String>(this);
   public IndigoEventSource<Integer> clear_event =
        new IndigoEventSource<Integer>(this);


   public MonomerPanel() {
       initComponents();
   }

    public MonomerPanel( Indigo indigo, IndigoRenderer indigo_renderer,
             LegioData new_legio, int new_reactant_idx )
    {
       this._indigo = indigo;
       this._indigo_renderer = indigo_renderer;
       this._legio = new_legio;

       initComponents();

       _fopener.addExtension("cml", "smi", "sdf", "sd", "mol");

       MolTableModel model = (MolTableModel)monomers_table.getModel();

       monomers_table.getColumn("Id").setCellRenderer(new MultiLineCellRenderer(SwingConstants.CENTER,
                                   SwingConstants.CENTER));
       monomers_table.getColumn(model.getColumnName(1)).setCellRenderer(new MolRenderer(indigo, _indigo_renderer,
               getPreferredSize().width - 50, 160, false));

       setName("Monomers group #" + (new_reactant_idx + 1));
       setBorder(javax.swing.BorderFactory.createTitledBorder(_name));

       monomers_table.getColumn(model.getColumnName(1)).setPreferredWidth(getPreferredSize().width - 30);
       monomers_table.getColumn("Id").setPreferredWidth(30);
       monomers_table.addMouseListener(new MolClicker(_indigo, _indigo_renderer, monomers_table, false));
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
   // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
   private void initComponents() {

      button_panel = new javax.swing.JPanel();
      add_button = new javax.swing.JButton();
      clear_button = new javax.swing.JButton();
      scroll_panel = new javax.swing.JScrollPane();
      monomers_table = new javax.swing.JTable();

      setBorder(javax.swing.BorderFactory.createTitledBorder(javax.swing.BorderFactory.createTitledBorder("Monomers")));

      add_button.setText("Add");
      add_button.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            add_buttonActionPerformed(evt);
         }
      });

      clear_button.setText("Clear");
      clear_button.addActionListener(new java.awt.event.ActionListener() {
         public void actionPerformed(java.awt.event.ActionEvent evt) {
            clear_buttonActionPerformed(evt);
         }
      });

      javax.swing.GroupLayout button_panelLayout = new javax.swing.GroupLayout(button_panel);
      button_panel.setLayout(button_panelLayout);
      button_panelLayout.setHorizontalGroup(
         button_panelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addGroup(button_panelLayout.createSequentialGroup()
            .addGap(144, 144, 144)
            .addComponent(add_button)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(clear_button)
            .addContainerGap(161, Short.MAX_VALUE))
      );
      button_panelLayout.setVerticalGroup(
         button_panelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addGroup(button_panelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
            .addComponent(add_button)
            .addComponent(clear_button))
      );

      monomers_table.setModel(new MolTableModel(false));
      monomers_table.setRowHeight(160);
      scroll_panel.setViewportView(monomers_table);

      javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
      this.setLayout(layout);
      layout.setHorizontalGroup(
         layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addComponent(button_panel, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
         .addComponent(scroll_panel, javax.swing.GroupLayout.DEFAULT_SIZE, 419, Short.MAX_VALUE)
      );
      layout.setVerticalGroup(
         layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
         .addGroup(layout.createSequentialGroup()
            .addComponent(button_panel, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
            .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
            .addComponent(scroll_panel, javax.swing.GroupLayout.DEFAULT_SIZE, 247, Short.MAX_VALUE))
      );
   }// </editor-fold>//GEN-END:initComponents

    private ArrayList<IndigoObject> _loadMonomers() throws Exception
    {
       ArrayList<IndigoObject> monomers_portion = new ArrayList<IndigoObject>();
       
       if (_fopener.openFile("Open") == null)
          return null;

       IndigoObject iterator = CommonUtils.getIterator(_indigo, _fopener.getFilePath());
       int index;
       for (IndigoObject monomer : iterator)
          monomers_portion.add(monomer.clone());

       return monomers_portion;
    }

    private void add_buttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_add_buttonActionPerformed

      try {
         ArrayList<IndigoObject> monomers = _loadMonomers();
         if (monomers != null)
            addMols(monomers);
      } catch (Exception ex) {
         JOptionPane.showMessageDialog(JFrame.getOwnerlessWindows()[0],
             ex.getMessage(), "Error", JOptionPane.ERROR_MESSAGE);
      }
    }//GEN-LAST:event_add_buttonActionPerformed

    private void clear_buttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clear_buttonActionPerformed
       clear();
    }//GEN-LAST:event_clear_buttonActionPerformed

    public void addMols( ArrayList<IndigoObject> mols )
    {
        MolTableModel model = (MolTableModel)monomers_table.getModel();
        model.addMols(mols);
        setBorder(javax.swing.BorderFactory.createTitledBorder(_name + " - " +
                      model.getMolsCount() + " Molecules"));

        add_event.fireEvent(_fopener.getFilePath());
    }

    public void setMols( ArrayList<IndigoObject> mols )
    {
        MolTableModel model = (MolTableModel)monomers_table.getModel();
        model.setMols(mols);
    }

    public void clear()
    {
        MolTableModel model = (MolTableModel)monomers_table.getModel();
        model.clear();
        setBorder(javax.swing.BorderFactory.createTitledBorder(_name));
        clear_event.fireEvent(0);
    }

   // Variables declaration - do not modify//GEN-BEGIN:variables
   private javax.swing.JButton add_button;
   private javax.swing.JPanel button_panel;
   private javax.swing.JButton clear_button;
   private javax.swing.JTable monomers_table;
   private javax.swing.JScrollPane scroll_panel;
   // End of variables declaration//GEN-END:variables
}
