/* 
   drvHPGL.cpp : This file is part of pstoedit
   HPGL / HPGL2 Device driver

   Copyright (C) 1993,1994,1995,1996,1997,1998 Peter Katzmann p.katzmann@thiesen.com
   Copyright (C) 2000  Katzmann & Glunz (fill stuff)
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/
#include "drvhpgl.h"
#include I_stdio
#include I_string_h
#include I_iostream


drvHPGL::derivedConstructor(drvHPGL):
	constructBase,
	fillinstruction("FT1")
   {
   // driver specific initializations
   // and writing of header to output file

		bool show_usage_line = false;

		for (unsigned int i = 0; i < d_argc ; i++ ) {
               if (verbose) outf << "% " << d_argv[i] << endl;
               if (strcmp(d_argv[i],"-xx") == 0) {
                       
               } else if (strcmp(d_argv[i], "-fill") == 0) {
                       i++;
                       if (i >= d_argc) {
                               errf << "-fill requires a string argument "
                                       << endl;
                               show_usage_line = true;
                       } else {
                               fillinstruction = d_argv[i];
                       }
					   /*
Fill Type (FT) Command 
========================================= 
This command selects the shading pattern used to fill polygons ( FP ), rectangles 
( RA or RR ), wedges ( WG ), or characters ( CF ). The Fill Type command ( FT 
), can use solid, shading, parallel lines (hatching), cross hatching, patterned 
(raster) fill, or PCL user-defined patterns. For more information see the PCL 5 
Printer Language Technical Reference Manual. The syntax for this command is 
as follows: 
   
FT fill type,[option1,[option2]]; or FT; 
*/
// known fill types:
					   // FT 1 - solid black
					   // FT 3 - parallel lines FT 3[,delta,angle]
					   // FT 4 - cross hatching FT 4[,delta,angle]
					   // FT 10 - shading FT 10,[percentage]
               } else if (strcmp(d_argv[i], "-help") == 0) {
                       errf << "-help    Show this message" << endl;
                       errf << "-fill fillstring (default FT1)" << endl;
    //                   errf << "-depth # Set the page depth in inches" << endl;
                       show_usage_line = true;
               } else {
                       errf << "Unknown fig driver option: " << d_argv[i] << endl;
					   show_usage_line = true;
               }
       }
	   if (show_usage_line) {
               errf << "Usage -f 'hpgl: [-help] [-fill fillstring] '" << endl;
       }
		if (0) {
			const char esc = (char) 27;
			outf << esc << ".(;" ;
		}
		outf << "IN;SC;PU;PU;SP1;LT;VS10\n";
		scale = 10;
   //	float           x_offset;
   //	float           y_offset;
   }

   drvHPGL::~drvHPGL() {
   // driver specific deallocations
   // and writing of trailer to output file
      outf << "PU;PA0,0;SP;EC;PG1;EC1;OE\n";
   }

   void drvHPGL::print_coords()
   {
	  const unsigned int elems = numberOfElementsInPath();
	  if (elems) {
      for (unsigned int n = 0; n < elems; n++) {
         const basedrawingelement & elem = pathElement(n);
         switch (elem.getType()) {
         case moveto: 
            {
               const Point & p = elem.getPoint(0);
               outf << "PU";
               outf << p.x_ + x_offset << "," 
					<< p.y_ + y_offset << ";" ;
            }
            break;
         case lineto: 
            {
				const Point & p = elem.getPoint(0);
				outf << "PD";
				outf << p.x_ + x_offset << "," 
					 << p.y_ + y_offset << ";" ;
				if (isPolygon() && (n==elems)) {
					outf << "PD";
					const basedrawingelement & elemnull = pathElement(0);
					const Point & pnull = elemnull.getPoint(0);
					outf << pnull.x_ + x_offset << ","
						 << pnull.y_ + y_offset << ";" ;
				}
            }
            break;
         case closepath: 
			 {
         // outf << "\t\tclosepath ";
			const Point & p = pathElement(0).getPoint(0);
			outf << "PD";
			outf << p.x_ + x_offset << "," 
				 << p.y_ + y_offset << ";" ;
			 }
            break;
         case curveto:
            errf << "\t\tFatal: unexpected case curveto in drvhpgl " << endl;
            abort();
            break;
         default:
            errf << "\t\tFatal: unexpected case default in drvhpgl " << endl;
            abort();
            break;
         }
      }
	  }
   }


   void drvHPGL::open_page()
   {
      outf << "IN;SC;PU;PU;SP1;LT;VS10\n";
   }

   void drvHPGL::close_page()
   {
      outf << "PU;SP;EC;PG1;EC1;OE\n";
   }

   void drvHPGL::show_text(const TextInfo & textinfo)
   {
	unused(&textinfo);
	// outf << "textttt " << textinfo.thetext.value() << endl;
   }

   void drvHPGL::show_path()
   {
	   if (numberOfElementsInPath()) {
      switch (currentShowType() ) {
      case drvbase::stroke : 
         break;
      case drvbase::eofill :
      // Probably Wrong, but treat eoffil like fill
      case drvbase::fill :
		  {
   			const Point & p = pathElement(0).getPoint(0);
			outf << "PU";
			outf << p.x_ + x_offset << "," 
				 << p.y_ + y_offset << ";" ;
			outf << fillinstruction << ";PM0;";
		  }
         break;
      default:       // cannot happen
         outf << "unexpected ShowType " << (int) currentShowType() ;
         break;
      }
      outf << "PW" << currentLineWidth() / 10 << ";" ;
      print_coords();
   
      switch (currentShowType() ) {  // To check which endsequenz we need
      case drvbase::stroke : 
         break;
      case drvbase::eofill :
      // Probably Wrong, but treat eoffil like fill
      case drvbase::fill :
		 outf << "PM2;FP;EP;"; // EP also draws path
         break;
      default:       // cannot happen
         outf << "unexpected ShowType " << (int) currentShowType() ;
         break;
      }
	  outf << endl;
	   }
   };

   void drvHPGL::show_rectangle(const float llx, const float lly, const float urx, const float ury)
   {
	unused(&llx);
	unused(&lly);
	unused(&urx);
	unused(&ury);
   // just do show_path for a first guess
      show_path();
   }

static DriverDescriptionT<drvHPGL> D_hpgl(
			"hpgl","HPGL code","hpgl",
		false, // backend supports subpathes
		   // if subpathes are supported, the backend must deal with
		   // sequences of the following form
		   // moveto (start of subpath)
		   // lineto (a line segment)
		   // lineto 
		   // moveto (start of a new subpath)
		   // lineto (a line segment)
		   // lineto 
		   //
		   // If this argument is set to false each subpath is drawn 
		   // individually which might not necessarily represent
		   // the original drawing.

		false, // backend supports curves
		false, // backend supports elements which are filled and have edges
		false, // backend supports text
		false, // backend supports Images
		DriverDescription::normalopen,	
		false); // backend support multiple pages

 
 
