""" Batch editor implementation

    begin                : Sat Dec 14 2002
    author               : (C) 2002 by Ricardo Niederberger Cabral
    email                : nieder|at|mail.ru
    $Id: CSVImportWnd.py,v 1.11 2003/09/07 14:00:05 niederberger Exp $        

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
"""
__version__ = "$Revision: 1.11 $"

from string import *
import os,traceback

try:
    from CSVImportForm import *
    from dbExportCSV import dbImportDSV
except:
    print "CSVImportWnd: Unable to import some imgSeek modules. Some features will not work."


class CSVImportWnd(CSVImportForm):
    def __init__(self, parent,cdb):
        CSVImportForm.__init__(self,parent)
        self.curdb = cdb
    def morebtn_clicked(self):
        filename = str(QFileDialog.getOpenFileName("", "*.*", self, "Choose delimiter separated values file to import"))
        if not filename: return
        if not os.path.exists(filename): return
        self.pathedit.setText(filename)
    def previewbtn_clicked(self):
        dbI = dbImportDSV(self.curdb,self)
        data = dbI.previewFile()
        if not data:
            self.table.setNumRows(1)
            self.table.setNumCols(1)
            self.table.horizontalHeader().setLabel( 0, "Error" )
            self.table.setText(0,0,"Error importing the first 10 lines.")
            return
        hdr = data[0]
        data = data[1:]
        self.table.setNumRows(len(data))
        self.table.setNumCols(len(hdr))
        self.keycombo.clear()
        try:
            for fld in range(len(hdr)):
                self.table.horizontalHeader().setLabel( fld,hdr[fld] )
                self.keycombo.insertItem(hdr[fld])
            for dt in range(len(data)):
                for fld in range(len(hdr)):
                    self.table.setText(dt,fld,data[dt][fld])
        except:
            QMessageBox.information( self, "imgSeek","Error populating table with preview data.")            
            traceback.print_exc()
    def datadedit_textChanged(self,a0):
        pass

    def textqedit_textChanged(self,a0):
        pass

    def importbtn_clicked(self):
        if not self.keycombo.count():
            QMessageBox.information( self, "imgSeek","Before importing you must first click the \"Preview\" button and choose a proper key column.")
            return
        dbI = dbImportDSV(self.curdb,self)
        data = dbI.previewFile()
        if not data:
            QMessageBox.information( self, "imgSeek","Error importing data.")
            return
        hdr = data[0]
        data = data[1:]
        resp = self.curdb.importMeta(header=hdr,data=data,fullpath=self.fullpathcheck.isChecked(),key=self.keycombo.currentItem())
        QMessageBox.information( self, "imgSeek",resp)
    def pathedit_textChanged(self,a0):
        pass
