import sys
import traceback

class testmodule:
  def __init__(self, confignode):
    pass

  def registerCallbacks(self, cli):
    cli.registerCallback("handleMessageReceive", cli.PRE, self.myHandleMessageReceivePRE)
    cli.registerCallback("handleMessageReceive", cli.POST, self.myHandleMessageReceivePOST)

  def unRegisterCallbacks(self, cli):
    cli.unRegisterCallback("handleMessageReceive", cli.PRE, self.myHandleMessageReceivePRE)
    cli.unRegisterCallback("handleMessageReceive", cli.POST, self.myHandleMessageReceivePOST)

  def getName(self):
    return "testmodule"

  # You MUST implement a printShortDescription()  it gets called when the module is loaded to print out version/short description/whatever
  def printShortDescription(self):
    print "Test module loaded"

  def getConfigurationString(self, prependString):
    return prependString + "<testmodule type='4'/>\n"

  # You MUST implement a configureModuleCLI(self, cli) function.
  # cli is a reference to a CLI object.
  # No special return value
  # This function is called to give the user an interactive way to configure settings of this module.
  def configureModuleCLI(self, cli):
    print "No configuration required"

  def myHandleMessageReceivePRE(self, cli, ffrom, body, thread, delay, resource):
    try:
      #cli.output("in my handle message receive pre")
      if ffrom == "airog@floobin.cx":
        self.oldcolor = cli.overrideColor("messagebodycolor", cli.prefs.colors.brightred)
      else:
        self.oldcolor = None
    except:
      traceback.print_exc()

  def myHandleMessageReceivePOST(self, cli, ffrom, body, thread, delay, resource):
    try:
      #cli.output("in my handle message receive post")
      if self.oldcolor != None:
        cli.overrideColor("messagebodycolor", self.oldcolor)
    except:
      traceback.print_exc()
