#This is a minimalistic module which doesn't really do anything other than the minimum requirements.

# Modules are loaded in the order they are listed in your profile.
# Modules are saved in the order they are loaded.
# If you unload a module mid run and then save, that module will nolonger be loaded automatically.

# use /eval self.loadModule("modname") to load a module
# and /eval self.unloadModule("modname") to unload a module  -- until I add real commands
import sys
import traceback

# You MUST name your module the same name as the file its in, minus the extension.
class examplemodule:
  def __init__(self, confignode):
    pass

  # You MUST implement a registerCallbacks(self, cli) function.
  # cli is a reference to an CLI object.
  # The purpose of this call is to register your callbacks.
  # Make a bunch of calls to cli.registerCallback
  def registerCallbacks(self, cli):
    cli.registerCallback("handleMessageReceive", cli.PRE, self.myHandleMessageReceivePRE)
    cli.registerCallback("handleMessageReceive", cli.POST, self.myHandleMessageReceivePOST)
    cli.registerCommand("/exampleCommand", "examplecommand", "This is an example command", self.exampleCommand)


  # You MUST implement an unRegisterCallbacks(self, cli) function.
  # cli is a reference to an CLI object.
  # The purpose of this call is to unregister your callbacks.
  # Make a bunch of calls to cli.unRegisterCallback
  def unRegisterCallbacks(self, cli):
    cli.unRegisterCallback("handleMessageReceive", cli.PRE, self.myHandleMessageReceivePRE)
    cli.unRegisterCallback("handleMessageReceive", cli.POST, self.myHandleMessageReceivePOST)
    cli.unRegisterCommand("examplecommand")

  # You MUST implement a getName() function which returns a string containing the name of this module.
  def getName(self):
    return "examplemodule"

  # You MUST implement a printShortDescription()  it gets called when the module is loaded to print out version/short description/whatever
  def printShortDescription(self):
    print "Example Module loaded. -- I'm just an example module"

  # You MUST implement a getConfigurationString(self, prependString) function.
  # it returns None if there is no configuration
  # it returns a string containing the XML for your configuration. ESCAPE IT PROPERLY!
  # the return string MUST end with a newline
  # each line in the return string MUST be prepended by the prependString, this is for proper spacing in the config file.
  def getConfigurationString(self, prependString):
    return prependString + "<examplemodule type='4'/>\n"


  # You MUST implement a configureModuleCLI(self, cli) function.
  # cli is a reference to a CLI object.
  # No special return value
  # This function is called to give the user an interactive way to configure settings of this module.
  def configureModuleCLI(self, cli):
    print "No configuration required"


  # it is good habit to contain all your callback functions in
  # try-except blocks so that they don't poison the rest of the
  # system.
  # Return -1 if you don't want the rest of the callbacks or the function itself called.
  # returning a list of the exact same length as the number of args in the callback results on those becoming the args.
  # returning anything else is meaningless.
  def myHandleMessageReceivePRE(self, cli, ffrom, body, thread, delay, resource):
    try:
      cli.output("in my handle message receive pre")
      if(ffrom == "test2@floobin.cx"):
        return [cli,ffrom,"hacked by examplemodule:" + body ,thread,delay,resource]
    except:
      traceback.print_exc()

  def myHandleMessageReceivePOST(self, cli, ffrom, body, thread, delay, resource):
    try:
      cli.output("in my handle message receive post")
    except:
      traceback.print_exc()


  def exampleCommand(self, line):
    print "This is an example command (args: ", line, ")"
