dnl figure out the path to our python libraries
dnl this macro takes no arguments
AC_DEFUN([AC_PY_LIB_PATH], 
[ac_cv_py_lib_path="`python -c "import sys; import string; print string.join(sys.path,' ')"`"; 
PY_LIB_PATH=$ac_cv_py_lib_path;
])


dnl param is the name of a python module that should 
dnl exist in the sys.path
dnl note: we do not pass in the extension...
dnl may be used in configure.in like:
dnl
dnl     AC_PY_CHECK_LIB(threading)
dnl 

AC_DEFUN([AC_PY_CHECK_LIB],[ dnl
AC_MSG_CHECKING([Python module $1])
dnl AC_PY_LIB_PATH
ac_cv_py_have_$1=false;
if [[ $# -eq 2 ]] ; then
   if python -c "from $2 import $1"; then
        ac_cv_py_have_$1=true;
   fi
else
   for d in $PY_LIB_PATH; do
        if [[ -e $d/$1.py ]] || [[ -e $d/$1.so ]]; then
             ac_cv_py_have_$1=true;
        fi
   done
fi
   
AC_MSG_RESULT([$ac_cv_py_have_$1])
HAVE_PY_LIB_$1=$ac_cv_py_have_$1;
])


dnl wrapper for AC_PY_CHECK_LIB 
dnl that aborts the configure if
AC_DEFUN([AC_PY_CHECK_REQUIRED], [dnl
if [[ $# -eq 2 ]]; then
   AC_PY_CHECK_LIB([$1], [$2])
else
   AC_PY_CHECK_LIB([$1])
fi
if [[ $HAVE_PY_LIB_$1 == false ]]; then
{
    echo "$1 is a required module... aborting.";
    exit
}
fi;
])
