#include <qpainter.h>
#include "IIIMText.hh"
#include "IIIMPreedit.hh"

void
IIIMPreeditWidget::drawContents(
    QPainter *p
)
{
    int cpos;
    IIIMCF_text text;
    IIIMF_status st;

    if (!ctx) return;
    st = iiimcf_get_preedit_text(ctx, &text, &cpos);
    if (st != IIIMF_STATUS_SUCCESS) return;
    IIIMText imt(text);
    currentsize = imt.draw(p, this, contentsRect());

    adjustSize();
}

QSize
IIIMPreeditWidget::sizeHint() const
{
    return currentsize;
}

void
IIIMPreeditWidget::update_im()
{
    int cpos;
    IIIMF_status st;
    IIIMCF_text text;

    st = iiimcf_get_preedit_text(ctx, &text, &cpos);
    if (st == IIIMF_STATUS_SUCCESS) {
	show();
	repaint();
    } else {
	hide();
    }
}

IIIMPreeditWidget::IIIMPreeditWidget(
    IIIMCF_context x_ctx,
    QWidget *parent,
    const char *name,
    WFlags f
) : QFrame(parent, name, f)
{
    ctx = x_ctx;
    setBackgroundMode(Qt::PaletteBase);
}

IIIMPreeditWidget::~IIIMPreeditWidget()
{
}

/* Local Variables: */
/* c-file-style: "iiim-project" */
/* End: */
