#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <EIMIL.h>

static unsigned char* evtype;
static int evval;
static int evmod;
static int evchar;
static unsigned char* evmtext;

static int
store_event(
    EIMIL_handle eh,
    EIMIL_event *pev
)
{
    if (evtype) free(evtype);
    evtype = strdup(pev->type);
    if (pev->pv_val)
	evval = pev->pv_val->v.number;
    else
	evval = -1;

    if (pev->pv_mod)
	evmod = pev->pv_mod->v.number;
    else
	evmod = -1;

    if (pev->pv_char)
	evchar = pev->pv_char->v.ch;
    else
	evchar = -1;

    if (evmtext) free(evmtext);

    if (pev->pv_mtext) {
	evmtext = EIMIL_convert_UTF32_to_UTF8(pev->pv_mtext->v.mtext.ustr);
    } else {
	evmtext = NULL;
    }

    return 1;
}

void
sendev(
    EIMIL_handle eh,
    unsigned char *type,
    int val,
    int mod,
    unsigned char *text
)
{
    EIMIL_value *pev;

    pev = EIMIL_construct_event(type,
				EIMIL_construct_number(val),
				EIMIL_construct_number(mod),
				NULL,
				EIMIL_construct_mtext_from_UTF8(text));

    EIMIL_send_event(eh, pev);
}

int
main(
    int argc,
    char **argv
)
{
    char buf[1024];
    unsigned char *pfn;
    EIMIL_handle eh, eh2;
    EIMIL_value *pv;

    getcwd(buf, sizeof(buf));

    EIMIL_initialize();

    EIMIL_register_class("org.OpenI18N.test", buf);
    pfn = EIMIL_find_file("org.OpenI18N.test", "flowtest.xml");

    if (!EIMIL_parse_file(&eh, pfn)) goto error;
    EIMIL_register_handler(eh, store_event, NULL, NULL);

    fprintf(stderr, "1st test");
    /* first test */
    /* if */
    sendev(eh, "test", 1, 0, "test");
    ASSERT(evval == 1);
    /* select */
    sendev(eh, "test", 0, 0, "Test1");
    ASSERT(evval == 1);
    /* while */
    sendev(eh, "test", 0, 1, "test");
    ASSERT(evval == 0);
    fprintf(stderr, "...done.\n");

    /* reset by sending an event. */
    sendev(eh, "test", 0, 0, "");

    fprintf(stderr, "2nd test");
    /* second test */
    /* if */
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 0);
    /* select */
    sendev(eh, "test", 0, 0, "Test2");
    ASSERT(evval == 2);
    /* while */
    sendev(eh, "test", 0, 2, "test");
    ASSERT(evval == 0);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 1);
    fprintf(stderr, "...done.\n");

    /* reset by sending an event. */
    sendev(eh, "test", 0, 0, "");

    fprintf(stderr, "3rd test");
    /* third test */
    /* if */
    sendev(eh, "test", 1, 10, "test");
    ASSERT(evval == 1);
    /* select */
    sendev(eh, "test", 0, 0, "Test3");
    ASSERT(evval == 3);
    /* while */
    sendev(eh, "test", 0, 3, "test");
    ASSERT(evval == 0);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 1);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 2);
    fprintf(stderr, "...done.\n");

    /* reset by sending an event. */
    sendev(eh, "test", 0, 0, "");

    fprintf(stderr, "4th test");
    /* forth test */
    /* if */
    sendev(eh, "test", 0, 10, "XXX");
    ASSERT(evval == 0);
    /* select */
    sendev(eh, "test", 0, 0, "Test4");
    ASSERT(evval == 4);
    /* while */
    sendev(eh, "test", 0, 4, "test");
    ASSERT(evval == 0);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 1);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 2);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 3);
    fprintf(stderr, "...done.\n");

    /* reset by sending an event. */
    sendev(eh, "test", 0, 0, "");

    fprintf(stderr, "5th test");
    /* fifth test */
    /* if */
    sendev(eh, "test", 100, 10, "XXX");
    ASSERT(evval == 0);
    /* select */
    sendev(eh, "test", 0, 0, "XXXX");
    ASSERT(evval == 5);
    /* while */
    sendev(eh, "test", 0, 5, "test");
    ASSERT(evval == 0);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 1);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 2);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 3);
    sendev(eh, "test", 0, 0, "test");
    ASSERT(evval == 4);
    fprintf(stderr, "...done.\n");

    if (!EIMIL_send_event(eh, NULL)) goto error;

    return 0;

error:
    EIMIL_get_errormsg(eh, &pfn);
    fprintf(stderr, "%s\n", pfn);
    return 255;
}

