/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include "dayi_data.h"

int DayiData_Init(char *dayi_config_file, TDayiData *pDayiData)
{
	int ret;

	pDayiData->data_file = NULL;

	pDayiData->pDayiSymbolList = (TDayiSymbolList *)calloc(1, sizeof(TDayiSymbolList));
	if (pDayiData->pDayiSymbolList == NULL) {
		return(DAYI_ERROR);
	}
	DayiSymbolList_Init(pDayiData->pDayiSymbolList);

	pDayiData->pCodetableHeader = (CodeTableStruct *)calloc(1, sizeof(CodeTableStruct));
	if (pDayiData->pCodetableHeader == NULL) {
		return(DAYI_ERROR);
	}

	ret = DayiData_Read_Config(dayi_config_file, pDayiData);
	if (ret == DAYI_ERROR) {
		return(DAYI_ERROR);
	}

	if (pDayiData->data_file == NULL) {
		return(DAYI_ERROR);
	}

	ret = LoadCodeTableHeader(pDayiData->data_file, pDayiData->pCodetableHeader);
	if (ret == -1) {
		return(DAYI_ERROR);
	}

	return(DAYI_OK);
}

int DayiData_Free(TDayiData *pDayiData)
{
	if (pDayiData->data_file != NULL) {
		free((char *)pDayiData->data_file);
	}

	if (pDayiData->pDayiSymbolList) {
		DayiSymbolList_Free(pDayiData->pDayiSymbolList);
		free((char *)pDayiData->pDayiSymbolList);
	}

	if (pDayiData->pCodetableHeader) {
		UnloadCodeTable(pDayiData->pCodetableHeader);
		free((char *)pDayiData->pCodetableHeader);
	}

	return(DAYI_OK);
}

int DayiData_Open(TDayiData *pDayiData)
{
	int ret;

	if (pDayiData->data_file == NULL) {
		return(DAYI_ERROR);
	}

	if (pDayiData->pCodetableHeader == NULL) {
		return(DAYI_ERROR);
	}

	ret = LoadCodeTable(pDayiData->data_file, pDayiData->pCodetableHeader);
	if (ret == -1) {
		return(DAYI_ERROR);
	}

	return(DAYI_OK);
}

int DayiData_Print(TDayiData *pDayiData)
{
	if (pDayiData->data_file != NULL) {
		printf("data_file: %s\n", pDayiData->data_file);
	}

	if (pDayiData->pDayiSymbolList) {
		DayiSymbolList_Print(pDayiData->pDayiSymbolList);
	}
}
