/*
Copyright 1990-2003 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xmd.h>
#include <Xm/Xm.h>
#include <signal.h>
#include <wait.h>
#include <unistd.h>
#include <sys/types.h>

#include "xaux_locale.h"
#include "xaux_common.h"
#include "xaux_ext_common.h"
#include "hzinput.h"

/* Define Aux class */
xaux_class_t *xc_ = 0;
int im_ = 0;
int ic_ = 0;

/* Define Aux class */
xaux_class_t xaux_class = {
	XAUX_ACTION_CLASS_NAME, 1,
	NULL,
	(Window)0, (Window)0,
	(Atom) 0, (Atom) 0, (Atom) 0, 
	{ (Atom)0 }, ATOM_NUM_ACTIONAUX, 0,
	{ (Atom)0 }, ATOM_NUM_ACTIONAUX, 0,
	NULL,
};

extern Display		*gDisplay;
extern int 		gLocaleID;

void xaux_ext_event_handler(Widget, XtPointer, XEvent *, Boolean *);
void ActionAux_Register_SigChld_Handler();
void ActionAux_SigChld_Handler(int sig, siginfo_t * info, void * ucontext);
void ActionAux_Proc_LE_Notify();
void ActionAux_Proc_LE_StartAction_Notify(aux_ext_data_t *);
void ActionAux_Connect_To_LE_Request(int);

/*   
	Event Handler 
*/
void xaux_ext_event_handler(Widget w, XtPointer client_data, XEvent * event, Boolean * b)
{
	switch (event->type) {
		case ClientMessage:
			xaux_ext_process_client_message(XtDisplay(w),
				(XClientMessageEvent *) event);
			break;
	}
	return;
}

/*
	xaux_ext_init_classes(): Initialize the Atom of Auxiliary Window.
	It is in ../xaux_common/xaux_ext_common.c
*/
int xaux_ext_register_classes(Widget shell)
{
	/* Register SIGCHLD Handler */
	ActionAux_Register_SigChld_Handler();

	/* Register aux class */
	if (xaux_ext_init_classes(XtDisplay(shell), &xaux_class, XtWindow(shell)) == False)
		return(-1);

	/* Register event handler */
	XtAddEventHandler(shell, PropertyChangeMask, False,
		xaux_ext_event_handler, NULL);
	XtAddEventHandler(shell, NoEventMask, True,
		xaux_ext_event_handler, NULL);

	return(0);
}

/* 
Note:
     xaux_ext_Start(), xaux_ext_Draw(), xaux_ext_Done() 
     These three functions are all called by xaux_ext_process_client_message()

     xaux_ext_SetValue() will send auxiliary window information to language engine;
*/

/* Method - Start */
Bool xaux_ext_Start(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Start: im:%d, ic:%d\n", aux_ext_data->im, aux_ext_data->ic);
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	xc_ = xc;

	ActionAux_Connect_To_LE_Request(gLocaleID);
	return True;
}

/* Method - Draw */
Bool xaux_ext_Draw(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Draw == im:0x%x, ic:0x%x\n",aux_ext_data->im, aux_ext_data->ic);
	im_ = aux_ext_data->im;
	ic_ = aux_ext_data->ic;
	xc_ = xc;

        ActionAux_Proc_LE_Notify(aux_ext_data);
	return True;
}

/* Method - Done */
Bool xaux_ext_Done(xaux_class_t *xc, aux_ext_data_t *aux_ext_data)
{
	DEBUG_printf("ext_Done im:0x%x, ic_id:0x%x\n", aux_ext_data->im, aux_ext_data->ic);
	return True;
}

/* ================================================================= */
/*       Register handler function for signal SIGCHLD                */
/* ================================================================= */
void ActionAux_Register_SigChld_Handler()
{
	struct sigaction act;

	act.sa_handler = NULL;
	act.sa_sigaction = ActionAux_SigChld_Handler;
	sigfillset(&act.sa_mask);
	act.sa_flags = SA_SIGINFO;

	sigaction(SIGCHLD, &act, NULL);
}

void ActionAux_SigChld_Handler(int sig, siginfo_t * info, void * ucontext)
{
	pid_t   pid;
	int     status;

	while ((pid = waitpid(info->si_pid, &status, WNOHANG|WUNTRACED)) > 0) {
		DEBUG_printf("pid %d: die\n", pid);
	}
}

/* ================================================================= */
/*       Process Notify information From Language Engine             */
/* ================================================================= */
void ActionAux_Proc_LE_Notify(aux_ext_data_t *aux_ext_data)
{
	int nIntegerCount, notifyType;

	nIntegerCount = aux_ext_data->integer_count;
	if (nIntegerCount <= 0) return;

	notifyType = aux_ext_data->integer_list[0];

	switch (notifyType)
	{
		case ACTIONAUX_START_ACTION_NOTIFY:
			DEBUG_printf("ACTIONAUX_STARTACTION_NOTIFY Notify Received\n");
			ActionAux_Proc_LE_StartAction_Notify(aux_ext_data);
			break;
	}
}

void ActionAux_Proc_LE_StartAction_Notify(aux_ext_data_t *aux_ext_data)
{
	char *command_str;
	int nStringCount, len, pid;

	nStringCount = aux_ext_data->string_count;
	if (nStringCount != 1) return;

	command_str = (char *)aux_ext_data->string_list[0].ptr;
	len = strlen(command_str);
	
	DEBUG_printf("ActionAux_Proc_LE_StartAction_Notify: command_str :%s,  len:%d\n", command_str, len);
	pid = fork();
	if (pid < 0) {
		return;
	} else if (pid == 0) {
		/* in child process */
		execl("/bin/sh", "sh", "-c", command_str, (char *)0);

		/* Exec failed. */
		fprintf (stderr, "Error: Could not exec %s!\n", command_str);
		_exit(1);
	}
	return;
}

/* ================================================================= */
/*             Send information to Language Engine                   */
/* ================================================================= */
void ActionAux_Connect_To_LE_Request(int locale_id)
{
	int nIntegerCount, pIntegerList[2];

	nIntegerCount = 2;
	pIntegerList[0] = ACTIONAUX_CONNECT;
	pIntegerList[1] = locale_id;
	NotifyIntegerListDataToLanguageEngine(gDisplay, nIntegerCount, pIntegerList);
}

NotifyIntegerListDataToLanguageEngine(Display *display, 
int nIntegerCount, int *pIntegerList)
{
	aux_ext_data_t aux_ext_data;

	DEBUG_printf("im_:%d, ic_:%d\n", im_, ic_);

	if (!im_ || !ic_ || !xc_)
		return;

	aux_ext_data.im = im_;
	aux_ext_data.ic = ic_;
	aux_ext_data.integer_count = nIntegerCount;
	aux_ext_data.integer_list = pIntegerList;
	aux_ext_data.string_count = 0;
	aux_ext_data.string_list = NULL;
	aux_ext_data.string_ptr = NULL;
	aux_ext_data.point.x = 0;
	aux_ext_data.point.y = 0;

	xaux_ext_SetValue(display, xc_, &aux_ext_data);
	XFlush(display);
}

NotifyStringListDataToLanguageEngine(Display *display, 
int nIntegerCount, int *pIntegerList,
int nStringCount,  int *pStringLen,
char **pStringList)
{
	int i;

	aux_ext_data_t aux_ext_data;
	aux_ext_string_t *p;

	DEBUG_printf("im_:%d, ic_:%d\n", im_, ic_);

	if (!im_ || !ic_ || !xc_)
		return;

	aux_ext_data.im = im_;
	aux_ext_data.ic = ic_;
	aux_ext_data.integer_count = nIntegerCount;
	aux_ext_data.integer_list = pIntegerList;
	aux_ext_data.point.x = 0;
	aux_ext_data.point.y = 0;

	aux_ext_data.string_count = nStringCount;
	aux_ext_data.string_ptr = NULL;

	if (nStringCount > 0) {
		aux_ext_data.string_list = (aux_ext_string_t *) calloc(nStringCount, sizeof(aux_ext_string_t));
		for (i = 0; i < nStringCount; i++) {
			aux_ext_string_t *p = &aux_ext_data.string_list[i];
			p->length = pStringLen[i];
			p->ptr = (unsigned char *) (pStringList[i]);
		}
	}

	xaux_ext_SetValue(display, xc_, &aux_ext_data);
	XFlush(display);

	free(aux_ext_data.string_list);
}

