/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/
#include "xiiimp.h"
#include "guiIMPre.h"
#include "guiIMSts.h"
#include "XimpIm.h"
#include "xfactory.h"

/* ChangePreedit Methods */
static void
create(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)ic->gui_icpart->preedit;
  Display *display = ic->core.im->core.display;
  XWindowAttributes attr;

  if (!preedit) {
    SetupPreeditExt(ic);
    preedit = (PreeditWin)ic->gui_icpart->preedit;
  }

  if (preedit->parent != 0 && preedit->preedit_areas) {
    /* preedit window is already created  */
    return;
  }

  if (!(ic->ximp_icpart->value_mask & XIMP_CLIENT_WIN)) return;

  XGetWindowAttributes(display, 
		       ic->core.client_window,
		       &attr);
  SetupPreeditWindow(ic, RootWindow(display,
				    XScreenNumberOfScreen(attr.screen)));
  return;
}

static void
set_window(XicCommon ic, XPointer call_data) {
  PreeditWin preedit = (PreeditWin)ic->gui_icpart->preedit;
  Display *display = ic->core.im->core.display;
  PreeditArea preedit_area;

  if (!preedit) {
    create(ic, NULL);
    preedit = (PreeditWin)ic->gui_icpart->preedit;
    if (!preedit) return;
  }
  preedit_area = (PreeditArea)(preedit->preedit_areas);

  if (preedit->active_areas == 1 && preedit_area[0].window) {
    XWindowAttributes win_att;
    XSizeHints  hints;
    XWMHints wm_hints;
    Window frame_window;
    int x_margin = 0, y_margin = 0;
    PreeditChars preedit_chars = (PreeditChars)&(preedit->preedit_chars);
    int wrap_width;

    if (preedit_chars->wchar_len == 0) return;

    frame_window = XFactoryGetFrameWindow(display,
					  ic->core.client_window);

    if (XGetWindowAttributes(display, frame_window,
			     &win_att) > 0) {
      int x, y;
      unsigned int width = 0, height = 0;
      CacheRec *preedit_cache = (CacheRec*)&(preedit->preedit_cache);

      x = win_att.x;
      y = win_att.y;
      y += win_att.height;

      wrap_width = win_att.width;

      if (ic->core.input_style & XIMStatusNothing) {
	Window status_window;
	StatusWin status = (StatusWin)(ic->gui_icpart->status);
	XWindowAttributes swin_att;

	if (status && status->window) {
	  status_window = XFactoryGetFrameWindow(display,
					       status->window);
	  if (XGetWindowAttributes(display, status_window,
				 &swin_att) > 0) {
	    x = swin_att.x;
	    x += swin_att.width;

	    wrap_width -= swin_att.width;
	  }
        }
      }

      if (!preedit->fontset) {
	SetPreeditFont(ic, NULL);
      }
      if (preedit->fontset) {
	XFontSetExtents *fse;
	fse = XExtentsOfFontSet(preedit->fontset);
	width = XwcTextEscapement(preedit->fontset,
				  preedit_chars->wchar,
				  preedit_chars->wchar_len);
	height = fse->max_logical_extent.height;
	if (wrap_width < fse->max_logical_extent.width * 5) {
	  /* too small wrap_width, no more than 5 multibyte
	     characters can be written in a line, not good */
	  wrap_width = fse->max_logical_extent.width * 5;
	}
	/* adjust wrap_width to be mutibyte char boundary */
	wrap_width -= (wrap_width % fse->max_logical_extent.width);
      }
      /* avoid creating 0 width/height */
      if (width == 0) width = 15;
      if (height == 0) height = 15;

#if SET_PREEDIT_XMARGIN
      /* calculate margin */
      x_margin = width/5;
#endif
      y_margin = height/5;

      width += x_margin * 2;

#ifdef MOVE_SPOTLOCATION
      if (XIMP_CHK_PRESPOTLMASK(ic)) {
	XPoint point;
	x = ic->core.preedit_attr.spot_location.x;
	y = ic->core.preedit_attr.spot_location.y;
	XFactoryGetLocationOnScreen(display,
				    ic->core.focus_window, x, y, &point);
	if (preedit->fontset) {
	  XFontSetExtents *fse;
	  fse = XExtentsOfFontSet(preedit->fontset);
	  if (fse) {
	    int height = fse->max_logical_extent.height;
	    point.y += height;
	    wrap_width = fse->max_logical_extent.width * 40;
	  }
	}
	x = point.x;
	y = point.y;
      }
#endif
      if (width <= wrap_width) {
	/* can draw all chars in one line */
	preedit_area[0].x = x_margin;
	preedit_area[0].y = height - y_margin;
	preedit_area[0].char_offset = 0;
	preedit_area[0].char_len = preedit_chars->wchar_len;

        XFactoryAdjustPlacementInsideScreen(ic->core.im->core.display,
					    preedit_area[0].window,
					    x, y, width, height, &x, &y);

	if (preedit_area[0].active_lines != 0) {
	  preedit_area[0].active_lines = 0;
	} else {
	  if (preedit_cache->win_x == x &&
	      preedit_cache->win_y == y &&
	      preedit_cache->win_width == width &&
	      preedit_cache->win_height == height) {
	    return;
	  }
	}
	hints.flags = PSize | PPosition;
	hints.x = x;
	hints.y = y;
	hints.width  = width;
	hints.height = height;
	XSetWMNormalHints(display, preedit_area[0].window, &hints);
	wm_hints.flags = InputHint;
	wm_hints.input = False;
	XSetWMHints(display, preedit_area[0].window, &wm_hints);
	XMoveResizeWindow(ic->core.im->core.display,
			  preedit_area[0].window,
			  x, y, width, height);
	/* data cache */
	preedit_cache->win_x = x;
	preedit_cache->win_y = y;
	preedit_cache->win_width = width;
	preedit_cache->win_height = height;
      } else {
	/* draw more than two lines */
	int left;
	wchar_t *wcstr;
	int n;
	PreeditLine preedit_line;

	if (preedit_area[0].alloc_lines == 0) {
	  preedit_area[0].alloc_lines = 10;
	  preedit_area[0].lines =
	    (PreeditLine)Xmalloc(sizeof(PreeditLineRec) *
				 preedit_area[0].alloc_lines);
	  if (!preedit_area[0].lines) return;
	}

	preedit_line = preedit_area[0].lines;
	left = preedit_chars->wchar_len;
	wcstr = preedit_chars->wchar;
	n = 0;
	while (left) {
	  wchar_t *p = wcstr;
	  int cur_width = 0;
	  int i;
	  for (i = 1; i <= left; i++) {
	    cur_width += XwcTextEscapement(preedit->fontset, p++, 1);
	    if (cur_width > wrap_width) break;
	  }
	  preedit_line[n].x = 0;
	  preedit_line[n].y = height * (n + 1) - y_margin;
	  preedit_line[n].char_offset = wcstr - preedit_chars->wchar;
	  preedit_line[n].char_len = i - 1;
	  n++;
	  left -= (i - 1);
	  wcstr += i - 1;
	  if (left > 0) {
	    if (n == preedit_area[0].alloc_lines) {
	      preedit_area[0].alloc_lines += 10;
	      preedit_area[0].lines =
		(PreeditLine)Xrealloc(preedit_area[0].lines,
				      sizeof(PreeditLineRec) *
				      preedit_area[0].alloc_lines);
	      if (!preedit_area[0].lines) return;
	      preedit_line = preedit_area[0].lines;
	    } else {
	      continue;
	    }
	  }
	}
	preedit_area[0].active_lines = n;
	height = height * n;
        XFactoryAdjustPlacementInsideScreen(ic->core.im->core.display,
					    preedit_area[0].window,
					    x, y, wrap_width, height, &x, &y);
	XMoveResizeWindow(ic->core.im->core.display,
			  preedit_area[0].window,
			  x, y, wrap_width, height);
      }
    }
  }
  return;
}

static void
move(XicCommon ic, XPointer call_data) {
  /* nothing to do */
  return;
}

static PreeditCB preedit_nothing_methods[] = {
  create,			/* PREEDIT_CREATE */
  set_window,			/* PREEDIT_WIN */
  SetPreeditForeground,		/* PREEDIT_FG */
  SetPreeditBackground,		/* PREEDIT_BG */
  SetPreeditFont,		/* PREEDIT_FONT */
  move,				/* PREEDIT_MOVE */
  PreeditStart,			/* PREEDIT_START */
  PreeditDrawText,		/* PREEDIT_DRAW */
  PreeditCaret,			/* PREEDIT_CARET */
  PreeditDone,			/* PREEDIT_DONE */
  DestroyPreedit		/* PREEDIT_DESTROY */
};

void
ChangePreeditNothing(XIC xic, PreeditAttr reason, XPointer call_data) {
  XicCommon ic = (XicCommon)xic;
  if (reason > PREEDIT_DESTROY) return;
  preedit_nothing_methods[reason](ic, call_data);
  return;
}
