/*
Copyright 1990-2001 Sun Microsystems, Inc. All Rights Reserved.

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions: The above copyright notice and this
permission notice shall be included in all copies or substantial
portions of the Software.


THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE OPEN GROUP OR SUN MICROSYSTEMS, INC. BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH
THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE EVEN IF
ADVISED IN ADVANCE OF THE POSSIBILITY OF SUCH DAMAGES.


Except as contained in this notice, the names of The Open Group and/or
Sun Microsystems, Inc. shall not be used in advertising or otherwise to
promote the sale, use or other dealings in this Software without prior
written authorization from The Open Group and/or Sun Microsystems,
Inc., as applicable.


X Window System is a trademark of The Open Group

OSF/1, OSF/Motif and Motif are registered trademarks, and OSF, the OSF
logo, LBX, X Window System, and Xinerama are trademarks of the Open
Group. All other trademarks and registered trademarks mentioned herein
are the property of their respective owners. No right, title or
interest in or to any trademark, service mark, logo or trade name of
Sun Microsystems, Inc. or its licensors is granted.

*/


package sun.awt.im.iiimp;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import com.sun.iiim.*;

/**
 * This class hold one key characterristic from
 * string representation like Control+Shift+a, Alt+Tab.
 */
public class IIIMKeyEvent extends IIIMEvent {

    private int keyCode = KeyEvent.VK_UNDEFINED;
    private char keyChar = KeyEvent.CHAR_UNDEFINED;
    private int modifier = 0;
    private long when = 0;
    private String keyString = null;

    public IIIMKeyEvent(String keyString) {
	super(KEY);
	this.keyString = keyString;
	// parse key representaion string
	// modifir+...+keyrepresentation 
	StringTokenizer st = new StringTokenizer(keyString, "+");
	String lastToken = null;
	while(st.hasMoreTokens()) {
	    String token = st.nextToken();
	    modifier |= getModifier(token);
	    lastToken = token;
	}
	setCharCode(lastToken);
    }

    private boolean triggerPress = false;

    public boolean match(KeyEvent ke) {
	int id = ke.getID();
	switch(id) {
	  case KeyEvent.KEY_PRESSED:
	    if (keyCode == ke.getKeyCode() && ke.getModifiers() == modifier) {
		triggerPress = true;
		return true;
	    }
	    break;
	  case KeyEvent.KEY_TYPED:
	    if (triggerPress) {
		return true;
	    }
	    break;
	  case KeyEvent.KEY_RELEASED:
	    if (keyCode == ke.getKeyCode() && triggerPress) {
		triggerPress = false;
		return true;
	    }
	}
	return false;
    }

    public int getKeyCode() {
	return keyCode;
    }

    public char getKeyChar() {
	return keyChar;
    }

    public long getWhen() {
	return when;
    }

    public String toString() {
	return keyString;
    }

    private int getModifier(String mod) {
	Integer i = (Integer)modifierTable.get(mod.toLowerCase());
	if (i == null) {
	    return 0;
	}
	return i.intValue();
    }

    private void setCharCode(String key) {
	if (key == null || key.length() == 0) {
	    return;
	}
	if (key.length() > 1) {
	    // this is KeyCode string representation
	    Integer I = (Integer)keyTable.get(key.toUpperCase());
	    if (I != null) {
		keyCode = I.intValue();
	    }
	    // need to check UTF-16
	} else {
	    // length == 1
	    keyChar = key.charAt(0);
	}
    }

    static Hashtable modifierTable = null;
    static Hashtable keyTable = null;
    static {
	modifierTable = new Hashtable();
	modifierTable.put("shift", new Integer(InputEvent.SHIFT_MASK));
	modifierTable.put("control", new Integer(InputEvent.CTRL_MASK));
	modifierTable.put("meta", new Integer(InputEvent.META_MASK));
	modifierTable.put("alt", new Integer(InputEvent.ALT_MASK));
	modifierTable.put("alt_graph", new Integer(InputEvent.ALT_GRAPH_MASK));
	modifierTable.put("button1", new Integer(InputEvent.BUTTON1_MASK));
	modifierTable.put("button2", new Integer(InputEvent.BUTTON2_MASK));
	modifierTable.put("button3", new Integer(InputEvent.BUTTON3_MASK));

	keyTable = new Hashtable();
	keyTable.put("ENTER", new Integer(KeyEvent.VK_ENTER));
	keyTable.put("BACK_SPACE", new Integer(KeyEvent.VK_BACK_SPACE));
	keyTable.put("TAB", new Integer(KeyEvent.VK_TAB));
	keyTable.put("CANCEL", new Integer(KeyEvent.VK_CANCEL));
	keyTable.put("CLEAR", new Integer(KeyEvent.VK_CLEAR));
	keyTable.put("SHIFT", new Integer(KeyEvent.VK_SHIFT));
	keyTable.put("CONTROL", new Integer(KeyEvent.VK_CONTROL));
	keyTable.put("ALT", new Integer(KeyEvent.VK_ALT));
	keyTable.put("PAUSE", new Integer(KeyEvent.VK_PAUSE));
	keyTable.put("CAPS_LOCK", new Integer(KeyEvent.VK_CAPS_LOCK));
	keyTable.put("ESCAPE", new Integer(KeyEvent.VK_ESCAPE));
	keyTable.put("SPACE", new Integer(KeyEvent.VK_SPACE));
	keyTable.put("PAGE_UP", new Integer(KeyEvent.VK_PAGE_UP));
	keyTable.put("PAGE_DOWN", new Integer(KeyEvent.VK_PAGE_DOWN));
	keyTable.put("END", new Integer(KeyEvent.VK_END));
	keyTable.put("HOME", new Integer(KeyEvent.VK_HOME));
	keyTable.put("LEFT", new Integer(KeyEvent.VK_LEFT));
	keyTable.put("UP", new Integer(KeyEvent.VK_UP));
	keyTable.put("RIGHT", new Integer(KeyEvent.VK_RIGHT));
	keyTable.put("DOWN", new Integer(KeyEvent.VK_DOWN));
	keyTable.put("COMMA", new Integer(KeyEvent.VK_COMMA));
	keyTable.put("MINUS", new Integer(KeyEvent.VK_MINUS));
	keyTable.put("PERIOD", new Integer(KeyEvent.VK_PERIOD));
	keyTable.put("SLASH", new Integer(KeyEvent.VK_SLASH));

	keyTable.put("SEMICOLON", new Integer(KeyEvent.VK_SEMICOLON));
	keyTable.put("EQUALS", new Integer(KeyEvent.VK_EQUALS));

	keyTable.put("OPEN_BRACKET", new Integer(KeyEvent.VK_OPEN_BRACKET));
	keyTable.put("BACK_SLASH", new Integer(KeyEvent.VK_BACK_SLASH));
	keyTable.put("CLOSE_BRACKET", new Integer(KeyEvent.VK_CLOSE_BRACKET));

	keyTable.put("NUMPAD0", new Integer(KeyEvent.VK_NUMPAD0));
	keyTable.put("NUMPAD1", new Integer(KeyEvent.VK_NUMPAD1));
	keyTable.put("NUMPAD2", new Integer(KeyEvent.VK_NUMPAD2));
	keyTable.put("NUMPAD3", new Integer(KeyEvent.VK_NUMPAD3));
	keyTable.put("NUMPAD4", new Integer(KeyEvent.VK_NUMPAD4));
	keyTable.put("NUMPAD5", new Integer(KeyEvent.VK_NUMPAD5));
	keyTable.put("NUMPAD6", new Integer(KeyEvent.VK_NUMPAD6));
	keyTable.put("NUMPAD7", new Integer(KeyEvent.VK_NUMPAD7));
	keyTable.put("NUMPAD8", new Integer(KeyEvent.VK_NUMPAD8));
	keyTable.put("NUMPAD9", new Integer(KeyEvent.VK_NUMPAD9));
	keyTable.put("MULTIPLY", new Integer(KeyEvent.VK_MULTIPLY));
	keyTable.put("ADD", new Integer(KeyEvent.VK_ADD));
	keyTable.put("SEPARATER", new Integer(KeyEvent.VK_SEPARATER));
	keyTable.put("SUBTRACT", new Integer(KeyEvent.VK_SUBTRACT));
	keyTable.put("DECIMAL", new Integer(KeyEvent.VK_DECIMAL));
	keyTable.put("DIVIDE", new Integer(KeyEvent.VK_DIVIDE));
	keyTable.put("DELETE", new Integer(KeyEvent.VK_DELETE));
	keyTable.put("NUM_LOCK", new Integer(KeyEvent.VK_NUM_LOCK));
	keyTable.put("SCROLL_LOCK", new Integer(KeyEvent.VK_SCROLL_LOCK));

	keyTable.put("F1", new Integer(KeyEvent.VK_F1));
	keyTable.put("F2", new Integer(KeyEvent.VK_F2));
	keyTable.put("F3", new Integer(KeyEvent.VK_F3));
	keyTable.put("F4", new Integer(KeyEvent.VK_F4));
	keyTable.put("F5", new Integer(KeyEvent.VK_F5));
	keyTable.put("F6", new Integer(KeyEvent.VK_F6));
	keyTable.put("F7", new Integer(KeyEvent.VK_F7));
	keyTable.put("F8", new Integer(KeyEvent.VK_F8));
	keyTable.put("F9", new Integer(KeyEvent.VK_F9));
	keyTable.put("F10", new Integer(KeyEvent.VK_F10));
	keyTable.put("F11", new Integer(KeyEvent.VK_F11));
	keyTable.put("F12", new Integer(KeyEvent.VK_F12));
	keyTable.put("F13", new Integer(KeyEvent.VK_F13));
	keyTable.put("F14", new Integer(KeyEvent.VK_F14));
	keyTable.put("F15", new Integer(KeyEvent.VK_F15));
	keyTable.put("F16", new Integer(KeyEvent.VK_F16));
	keyTable.put("F17", new Integer(KeyEvent.VK_F17));
	keyTable.put("F18", new Integer(KeyEvent.VK_F18));
	keyTable.put("F19", new Integer(KeyEvent.VK_F19));
	keyTable.put("F20", new Integer(KeyEvent.VK_F20));
	keyTable.put("F21", new Integer(KeyEvent.VK_F21));
	keyTable.put("F22", new Integer(KeyEvent.VK_F22));
	keyTable.put("F23", new Integer(KeyEvent.VK_F23));
	keyTable.put("F24", new Integer(KeyEvent.VK_F24));

	keyTable.put("PRINTSCREEN", new Integer(KeyEvent.VK_PRINTSCREEN));
	keyTable.put("INSERT", new Integer(KeyEvent.VK_INSERT));
	keyTable.put("HELP", new Integer(KeyEvent.VK_HELP));
	keyTable.put("META", new Integer(KeyEvent.VK_META));

	keyTable.put("BACK_QUOTE", new Integer(KeyEvent.VK_BACK_QUOTE));
	keyTable.put("QUOTE", new Integer(KeyEvent.VK_QUOTE));

	keyTable.put("KP_UP", new Integer(KeyEvent.VK_KP_UP));
	keyTable.put("KP_DOWN", new Integer(KeyEvent.VK_KP_DOWN));
	keyTable.put("KP_LEFT", new Integer(KeyEvent.VK_KP_LEFT));
	keyTable.put("KP_RIGHT", new Integer(KeyEvent.VK_KP_RIGHT));

	keyTable.put("DEAD_GRAVE", new Integer(KeyEvent.VK_DEAD_GRAVE));
	keyTable.put("DEAD_ACUTE", new Integer(KeyEvent.VK_DEAD_ACUTE));
	keyTable.put("DEAD_CIRCUMFLEX", new Integer(KeyEvent.VK_DEAD_CIRCUMFLEX));
	keyTable.put("DEAD_TILDE", new Integer(KeyEvent.VK_DEAD_TILDE));
	keyTable.put("DEAD_MACRON", new Integer(KeyEvent.VK_DEAD_MACRON));
	keyTable.put("DEAD_BREVE", new Integer(KeyEvent.VK_DEAD_BREVE));
	keyTable.put("DEAD_ABOVEDOT", new Integer(KeyEvent.VK_DEAD_ABOVEDOT));
	keyTable.put("DEAD_DIAERESIS", new Integer(KeyEvent.VK_DEAD_DIAERESIS));
	keyTable.put("DEAD_ABOVERING", new Integer(KeyEvent.VK_DEAD_ABOVERING));
	keyTable.put("DEAD_DOUBLEACUTE", new Integer(KeyEvent.VK_DEAD_DOUBLEACUTE));
	keyTable.put("DEAD_CARON", new Integer(KeyEvent.VK_DEAD_CARON));
	keyTable.put("DEAD_CEDILLA", new Integer(KeyEvent.VK_DEAD_CEDILLA));
	keyTable.put("DEAD_OGONEK", new Integer(KeyEvent.VK_DEAD_OGONEK));
	keyTable.put("DEAD_IOTA", new Integer(KeyEvent.VK_DEAD_IOTA));
	keyTable.put("DEAD_VOICED_SOUND", new Integer(KeyEvent.VK_DEAD_VOICED_SOUND));
	keyTable.put("DEAD_SEMIVOICED_SOUND", new Integer(KeyEvent.VK_DEAD_SEMIVOICED_SOUND));

	keyTable.put("AMPERSAND", new Integer(KeyEvent.VK_AMPERSAND));
	keyTable.put("ASTERISK", new Integer(KeyEvent.VK_ASTERISK));
	keyTable.put("QUOTEDBL", new Integer(KeyEvent.VK_QUOTEDBL));
	keyTable.put("LESS", new Integer(KeyEvent.VK_LESS));
	
	keyTable.put("GREATER", new Integer(KeyEvent.VK_GREATER));
	keyTable.put("BRACELEFT", new Integer(KeyEvent.VK_BRACELEFT));
	keyTable.put("BRACERIGHT", new Integer(KeyEvent.VK_BRACERIGHT));

	keyTable.put("AT", new Integer(KeyEvent.VK_AT));
	keyTable.put("COLON", new Integer(KeyEvent.VK_COLON));
	keyTable.put("CIRCUMFLEX", new Integer(KeyEvent.VK_CIRCUMFLEX));
	keyTable.put("DOLLAR", new Integer(KeyEvent.VK_DOLLAR));
	keyTable.put("EURO_SIGN", new Integer(KeyEvent.VK_EURO_SIGN));
	keyTable.put("EXCLAMATION_MARK", new Integer(KeyEvent.VK_EXCLAMATION_MARK));
	keyTable.put("INVERTED_EXCLAMATION_MARK", new Integer(KeyEvent.VK_INVERTED_EXCLAMATION_MARK));
	keyTable.put("LEFT_PARENTHESIS", new Integer(KeyEvent.VK_LEFT_PARENTHESIS));
	keyTable.put("NUMBER_SIGN", new Integer(KeyEvent.VK_NUMBER_SIGN));
	keyTable.put("PLUS", new Integer(KeyEvent.VK_PLUS));
	keyTable.put("RIGHT_PARENTHESIS", new Integer(KeyEvent.VK_RIGHT_PARENTHESIS));
	keyTable.put("UNDERSCORE", new Integer(KeyEvent.VK_UNDERSCORE));

	keyTable.put("FINAL", new Integer(KeyEvent.VK_FINAL));
	keyTable.put("CONVERT", new Integer(KeyEvent.VK_CONVERT));
	keyTable.put("NONCONVERT", new Integer(KeyEvent.VK_NONCONVERT));
	keyTable.put("ACCEPT", new Integer(KeyEvent.VK_ACCEPT));
	keyTable.put("MODECHANGE", new Integer(KeyEvent.VK_MODECHANGE));
	keyTable.put("KANA", new Integer(KeyEvent.VK_KANA));
	keyTable.put("KANJI", new Integer(KeyEvent.VK_KANJI));

	keyTable.put("ALPHANUMERIC", new Integer(KeyEvent.VK_ALPHANUMERIC));
	keyTable.put("KATAKANA", new Integer(KeyEvent.VK_KATAKANA));
	keyTable.put("HIRAGANA", new Integer(KeyEvent.VK_HIRAGANA));
	keyTable.put("FULL_WIDTH", new Integer(KeyEvent.VK_FULL_WIDTH));
	keyTable.put("HALF_WIDTH", new Integer(KeyEvent.VK_HALF_WIDTH));
	keyTable.put("ROMAN_CHARACTERS", new Integer(KeyEvent.VK_ROMAN_CHARACTERS));
	keyTable.put("ALL_CANDIDATES", new Integer(KeyEvent.VK_ALL_CANDIDATES));
	keyTable.put("PREVIOUS_CONDIDATE", new Integer(KeyEvent.VK_PREVIOUS_CANDIDATE));
	keyTable.put("CODE_INPUT", new Integer(KeyEvent.VK_CODE_INPUT));
	keyTable.put("JAPANESE_KATAKANA", new Integer(KeyEvent.VK_JAPANESE_KATAKANA));
	keyTable.put("JAPANESE_HIRAGANA", new Integer(KeyEvent.VK_JAPANESE_HIRAGANA));
	keyTable.put("JAPANESE_ROMAN", new Integer(KeyEvent.VK_JAPANESE_ROMAN));

	keyTable.put("CUT", new Integer(KeyEvent.VK_CUT));
	keyTable.put("COPY", new Integer(KeyEvent.VK_COPY));
	keyTable.put("PASTE", new Integer(KeyEvent.VK_PASTE));
	keyTable.put("UNDO", new Integer(KeyEvent.VK_UNDO));
	keyTable.put("AGAIN", new Integer(KeyEvent.VK_AGAIN));
	keyTable.put("FIND", new Integer(KeyEvent.VK_FIND));
	keyTable.put("PROPS", new Integer(KeyEvent.VK_PROPS));
	keyTable.put("STOP", new Integer(KeyEvent.VK_STOP));
	
	keyTable.put("COMPOSE", new Integer(KeyEvent.VK_COMPOSE));
	keyTable.put("ALT_GRAPH", new Integer(KeyEvent.VK_ALT_GRAPH));
    }
}
