/* IIWU Synth  A soundfont synthesizer
 *
 * Copyright (C)  2001 Peter Hanappe
 * Author: Peter Hanappe, peter@hanappe.com
 *
 * Author: Peter Hanappe, peter@hanappe.com
 *
 * This file is part of the Varese program. 
 * Varese is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
 * USA.
 *
 */
/* iiwu_winmidi.c
 *
 * Drivers for Windows MIDI
 */

#include "iiwu_auport.h"
#include "iiwu_midi.h"
#include <windows.h>

#if WINMIDI_SUPPORT

#define BUFFER_LENGTH 512

typedef struct {
  HANDLE thread;
  DWORD threadID;
  int cont;
  unsigned char buffer[BUFFER_LENGTH];
  iiwu_midi_parser_t* parser;
  iiwu_synth_t* synth;
} iiwu_win_midi_driver_t;

iiwu_midi_driver_t* new_iiwu_win_midi_driver(iiwu_synth_t* synth, char* device);
int delete_iiwu_win_midi_driver(iiwu_midi_driver_t* p);
int iiwu_win_midi_driver_join(iiwu_midi_driver_t* p);
static void* iiwu_win_midi_run(void* d);

/*
 * new_iiwu_win_midi_driver
 */
iiwu_midi_driver_t* new_iiwu_win_midi_driver(iiwu_synth_t* synth, char* device)
{
  return NULL;
}

/*
 * delete_iiwu_win_midi_driver
 */
int delete_iiwu_win_midi_driver(iiwu_midi_driver_t* p)
{
  return IIWU_OK;
}

/*
 * iiwu_win_midi_run
 */
void* iiwu_win_midi_run(void* d)
{
}

/*
 * iiwu_win_midi_driver_join
 */
int iiwu_win_midi_driver_join(iiwu_midi_driver_t* d)
{
  return IIWU_OK;
}

#endif /*#if WINMIDI_SUPPORT */
