/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggframeboxsize.h"


#include "ierror.h"
#include "iviewmodule.h"

#include "iggwidgetkeybutton.h"
#include "iggwidgetkeylineedit.h"

//
//  Templates (needed for some compilers)
//
#include "iarraytemplate.h"


using namespace iParameter;


namespace iggFrameBoxSize_Private
{
	
	class LineEdit : public iggWidgetKeyFloatLineEdit
	{
		
	public:
		
		LineEdit(iggWidgetKeyCheckBox *cb, const iString &label, const iObjectKey &key, iggFrameBoxSize *parent) : iggWidgetKeyFloatLineEdit(label,key,RenderMode::UseGlobal,parent)
		{
			mRealParent = parent;
			mCheckBox = cb;
		}

	protected:

		virtual void UpdateWidgetBody()
		{
			bool val;
			mCheckBox->QueryValue(val);
			if(val)
			{
				this->Enable(false);
			}
			else
			{
				this->iggWidgetKeyFloatLineEdit::UpdateWidgetBody();
			}
		}

		virtual void OnVoid1Body()
		{
			iggWidgetKeyFloatLineEdit::OnVoid1Body();
			if(mRealParent != 0)
			{
				mRealParent->UpdatePositions();
			}
		}

		virtual void OnString1Body(const iString &s)
		{
			iggWidgetKeyFloatLineEdit::OnString1Body(s);
			if(mRealParent!=0 && this->GetRenderMode()==RenderMode::Immediate)
			{
				mRealParent->UpdatePositions();
			}
		}

	private:

		iggFrameBoxSize *mRealParent;
		iggWidgetKeyCheckBox *mCheckBox;
	};
	

	class CheckBox : public iggWidgetKeyCheckBox
	{
		
	public:
		
		CheckBox(const char* text, const iObjectKey &key, iggFrameBoxSize *parent) : iggWidgetKeyCheckBox(text,key,parent)
		{
			mRealParent = parent;
		}

	protected:

		virtual void OnVoid1Body()
		{
			iggWidgetKeyCheckBox::OnVoid1Body();
			if(mRealParent != 0)
			{
				mRealParent->UpdatePositions();
			}
		}

	private:

		iggFrameBoxSize *mRealParent;
	};
};


using namespace iggFrameBoxSize_Private;


iggFrameBoxSize::iggFrameBoxSize(iggFrame *parent) : iggFrame("Coordinates",parent,1)
{
	CheckBox *cb = new CheckBox("Use OpenGL coordinates",iViewModule::KeyOpenGLCoordinates(),this);
	LineEdit *le = new LineEdit(cb,"Box size",iViewModule::KeyBoxSize(),this);
	cb->AddDependent(le);

	this->AddLine(cb);
	this->AddLine(le);
}


void iggFrameBoxSize::UpdatePositions()
{
	int i;
	iPointerArray<iggWidgetKeyHandlerBase> &list = iggWidgetKeyHandlerBase::PositionList();

	for(i=0; i<list.Size(); i++)
	{
		list[i]->UpdateWidget();
	}
}

#endif
