/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

#ifndef ICELISTVIEW_H
#define ICELISTVIEW_H

#include "IceMC.h"

#include <qlistview.h>
#include <qcolor.h>

class IceListViewItem; // hmmm ... kann man so forward-deklarieren?

class IceListView : public QListView
{
public:
	// data
  static QColor executable;
  static QColor notExecutable;
  static QString path;
  static QString iconPath; 
	// methods
  IceListView(QWidget* parent=0, const char* name=0);
  virtual ~IceListView();
  virtual IceListViewItem* selectedItem() const;
  virtual IceListViewItem* currentItem() const;
  virtual IceListViewItem* firstChild() const;
  virtual IceListViewItem* createItem(IceListViewItem* after, QString info = QString::null);
  virtual void updateList();
  virtual void updateFolder(IceListViewItem*);
  virtual void updateRootFolder(IceListViewItem*);

protected:
  // data
  QColor dragColor;
  QColor dropColor;
	//methods
  virtual bool updateListRec(IceListViewItem*);
  virtual void contentsMousePressEvent(QMouseEvent*);
  virtual void contentsMouseMoveEvent(QMouseEvent*);
  virtual void contentsMouseReleaseEvent(QMouseEvent*);
  virtual void dropItem(IceListViewItem* after,bool cut=true);

private:
  // data
  IceListViewItem* dndItem;
  bool dnd;
};

class IceListViewItem : public QListViewItem
{
public:
  IceListViewItem ( IceListView * parent);
  IceListViewItem ( IceListView * parent, QString infoStr,
		    QString label1 = QString::null, QString label2 = QString::null,
		    QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null,
		    QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null );
  IceListViewItem ( IceListView * parent, IceListViewItem * after, QString infoStr,
		    QString label1 = QString::null, QString label2 = QString::null,
		    QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null,
		    QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null );
  IceListViewItem ( IceListViewItem * parent, IceListViewItem * after, QString infoStr,
		    QString label1 = QString::null, QString label2 = QString::null,
		    QString label3 = QString::null, QString label4 = QString::null, QString label5 = QString::null,
		    QString label6 = QString::null, QString label7 = QString::null, QString label8 = QString::null );
  virtual ~IceListViewItem();

  virtual void setInfo(QString);
  virtual QString getInfo() const;
  virtual void setColor(QColor color);
  virtual QColor getColor() const;
  virtual IceListViewItem* firstChild() const;
  virtual IceListViewItem* nextSibling() const;
  virtual IceListViewItem* parent() const;
  virtual IceListViewItem* itemAbove();
  virtual IceListViewItem* itemBelow();
  virtual bool setExecState();
  virtual void setIcon();
  virtual void paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align );
  virtual void deepCopy(IceListViewItem* copy);

 protected:
  virtual void deepCopyFolder(IceListViewItem* copy);

 private:
	//data
  QString info;
  QColor color;

};

#endif
