#include "hx_types.h"
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

void strexpand (char *);
void chrexpand (char *);

void
strexpand (char *str)
{
	register char c, *p, *sk;

	for (p = str; *p; p++) {
		if (*p != '\\' || !p[1])
			continue;
		sk = &(p[2]);
		switch (p[1]) {
			case 'n': c = '\n'; break;
			case 'r': c = '\r'; break;
			case 't': c = '\t'; break;
#ifdef __STDC__
			case 'a': c = '\a'; break;
			case 'v': c = '\v'; break;
#else
			case 'a': c = '\007'; break;
			case 'v': c = 0x0b; break;
#endif
			case 'b': c = '\b'; break;
			case 'f': c = '\f'; break;
			case 'e': c = '\033'; break;
			case 'E': c = '\033'; break;
			case '0': case '1': case '2': case '3':
			case '4': case '5': case '6': case '7':
				c = p[1] - '0';
				if (p[2] >= '0' && p[2] <= '7') {
        				c = c * 8 + (p[2] - '0');
					sk++;
				}
      				if (p[3] >= '0' && p[3] <= '7') {
        				c = c * 8 + (p[3] - '0');
					sk++;
				}
				break;
			case 'x':
				if (isxdigit(p[2])) {
					char xstr[6] = " 0x";
					xstr[3] = p[2];
					if (isxdigit(p[3])) {
						xstr[4] = p[3];
						xstr[5] = 0;
						sk = &(p[4]);
					} else {
						xstr[4] = 0;
						sk = &(p[3]);
					}
					c = (char)strtoul(xstr, 0, 16);
				} else
					c = 'x';
				break;
			default: c = p[1];
		}
		*p = c;
		strcpy(&(p[1]), sk);
	}
}

void
chrexpand (char *p)
{
	register char c, *sk = &(p[2]);

	switch (p[1]) {
		case 'n': c = '\n'; break;
		case 'r': c = '\r'; break;
		case 't': c = '\t'; break;
#ifdef __STDC__
		case 'a': c = '\a'; break;
		case 'v': c = '\v'; break;
#else
		case 'a': c = '\007'; break;
		case 'v': c = 0x0b; break;
#endif
		case 'b': c = '\b'; break;
		case 'f': c = '\f'; break;
		case 'e': c = '\033'; break;
		case 'E': c = '\033'; break;
		case '0': case '1': case '2': case '3':
		case '4': case '5': case '6': case '7':
			c = p[1] - '0';
			if (p[2] >= '0' && p[2] <= '7') {
        			c = c * 8 + (p[2] - '0');
				sk++;
			}
      			if (p[3] >= '0' && p[3] <= '7') {
        			c = c * 8 + (p[3] - '0');
				sk++;
			}
			break;
		case 'x':
			{
				char xstr[6] = " 0x";
				xstr[3] = p[2];
				xstr[4] = p[3];
				xstr[5] = 0;
				if (p[3])
					sk = &(p[4]);
				else
					sk = &(p[3]);
				c = (char)strtoul(xstr, 0, 16);
			}
			break;
		default: c = p[1];
	}
	*p = c;
	strcpy(&(p[1]), sk);
}
