#include "hx_types.h"
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include "cmd.h"
#include "screen.h"
#include "hxlib.h"
#include "htlc.h"
#include "xmalloc.h"

int cmd_load (int argc, char *const *argv);
int cmd_type (int argc, char *const *argv);

int
cmd_load (int argc, char *const *argv)
{
	FILE *fp;
	char buf[4096];
	register int i, len;

	if (argc < 2) {
		curscr_printf("\nusage: %s <file1> [file2...]", argv[0]);
		return 0;
	}
	memset(buf, 0, sizeof buf);
	for (i = 1; i < argc; i++) {
		expand_tilde(buf, argv[i]);
		if (!(fp = fopen(buf, "r"))) {
			curscr_printf("\n%s: %s: %s", argv[0], buf, strerror(errno));
			continue;
		}
		while (fgets(buf, sizeof buf - 1, fp)) {
			len = strlen(buf);
			if (buf[len - 1] == '\n')
				buf[--len] = 0;
			cmd_exec(buf, 0);
			memset(buf, 0, sizeof buf);
		}
		fclose(fp);
	}

	return 0;
}

int
cmd_type (int argc, char *const *argv)
{
	FILE *fp;
	char buf[4096], *b = 0;
	register int i, len, full_len;
	register char fun = 'c';

	if (argc < 2) {
		curscr_printf("\nusage: %s [-c] [-l] [-n] <file1> [file2...]", argv[0]);
		return 0;
	}
	memset(buf, 0, sizeof buf);
	for (i = 1; i < argc; i++) {
		if (argv[i][0] == '-') {
			fun = argv[i][1];
			continue;
		}
		expand_tilde(buf, argv[i]);
		if (!(fp = fopen(buf, "r"))) {
			curscr_printf("\n%s: %s: %s", argv[0], buf, strerror(errno));
			continue;
		}
		full_len = 0;
		while ((len = fread(buf, sizeof *buf, sizeof buf - 1, fp)) > 0) {
			b = xrealloc(b, full_len + len);
			memcpy(&(b[full_len]), buf, len);
			full_len += len;
		}
		fclose(fp);
		switch (fun) {
			case 'c':
				if (!curchat)
					htlc_snd_chat(b, (u_int16_t)full_len);
				else
					htlc_snd_chat_chat(curchat->ref, b, (u_int16_t)full_len);
				break;
			case 'n':
				task_new(hx_trans, 0, 0, 0);
				htlc_snd_news_post(b, (u_int16_t)full_len);
				break;
			case 'l':
			{	register char *p;
				register u_int16_t plen;
				p = strtok(b, "\n");
				do {
					plen = strlen(p);
					if (!curchat)
						htlc_snd_chat(p, plen);
					else
						htlc_snd_chat_chat(curchat->ref, p, plen);
				} while ((p = strtok(0, "\n")));
				break;
			}
		}
		xfree(b);
	}

	return 0;
}
