///////
   //    Link.cc
   //    Link Class definitions
   //
   //    Class for links
   //
   //    Copyright (c) 1999-2004 Comune di Prato - Prato - Italy
   //    Author: Gabriele Bartolini - Prato - Italy <angusgb@users.sourceforge.net>
   //
   //    For copyright details, see the file COPYING in your distribution
   //    or the GNU General Public License version 2 or later 
   //    <http://www.gnu.org/copyleft/gpl.html>
   //
   //    $Id: Link.cc,v 1.17 2003/12/30 09:38:47 angusgb Exp $
   //
   //    G.Bartolini
   //    started: 05.10.1999
///////

#ifdef HAVE_CONFIG_H
#include "htconfig.h"
#endif /* HAVE_CONFIG_H */

#include "Link.h"

   // Static variables initialization
      int Link::debug = 0;

///////
   //    Construction
///////

Link::Link()
:
IDUrlSrc(0),
IDUrlDest(0),
TagPosition(0),
AttrPosition(0),
Anchor(0),
LinkType(Link_Normal),
LinkResult(Link_NotChecked),
LinkDomain(Link_Unknown)
{
   Reset();
}

///////
   //    Destruction
///////

Link::~Link ()
{
}

///////
   //    Reset the schedule content
///////

void Link::Reset()
{
   IDUrlSrc = 0;
   IDUrlDest = 0;
   TagPosition = 0;
   AttrPosition = 0;
   Anchor.trunc();
   LinkType = Link_Normal;
   LinkResult = Link_NotChecked;
   LinkDomain = Link_Unknown;
}


///////
   //    Output Link object
///////

ostream &operator<<( ostream &output, const Link &s)

{
   output << s.IDUrlSrc << " -> " << s.IDUrlDest;
   
   if (s.debug < 3) return output;
   
   // Only if debug level is greater than 2
   
   output << " (Tag n.: " << s.TagPosition << " - Attribute n. "
      << s.AttrPosition << " - Anchor " << s.Anchor << ")";
   
   return output;
}


///////
   //    Managing the Link Type of the Link
///////

///////
   //    Converts the Link_Type value into the corresponding
   //    String value
///////

void Link::RetrieveLinkType(String &Type) const
{

   switch(GetLinkType())
   {
      case (Link_Normal):
         Type="Normal";
         break;
      case (Link_Direct):
         Type="Direct";
         break;
      case (Link_Redirection):
         Type="Redirection";
         break;
   }

}

///////
   //    Converts the Type string value
   //    into the corresponding Link_Type value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkType(const String& Type)
{

   if (Type == static_cast<String> ("Normal"))
      SetLinkType (Link_Normal);
   else if (Type == static_cast<String> ("Direct"))
      SetLinkType (Link_Direct);
   else if (Type == static_cast<String> ("Redirection"))
      SetLinkType (Link_Redirection);
   else return 0;
   
   return 1;
}

///////
   //    Managing the result of the link
///////

///////
   //    Converts the Link_Result value into the corresponding
   //    String value
///////

void Link::RetrieveLinkResult(String &Result) const
{

   switch(GetLinkResult())
   {
      case (Link_NotChecked):
         Result="NotChecked";
         break;
      case (Link_NotRetrieved):
         Result="NotRetrieved";
         break;
      case (Link_OK):
         Result="OK";
         break;
      case (Link_Broken):
         Result="Broken";
         break;
      case (Link_Redirected):
         Result="Redirected";
         break;
      case (Link_AnchorNotFound):
         Result="AnchorNotFound";
         break;
      case (Link_NotAuthorized):
         Result="NotAuthorized";
         break;
      case (Link_EMail):
         Result="EMail";
         break;
      case (Link_Javascript):
         Result="Javascript";
         break;
      case (Link_BadEncoded):
         Result="BadEncoded";
         break;
   }

}

///////
   //    Converts the Result string value
   //    into the corresponding Link_Result value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkResult(const String& Result)
{

   if (Result == static_cast<String> ("NotChecked"))
      SetLinkResult (Link_NotChecked);
   else if (Result == static_cast<String> ("NotRetrieved"))
      SetLinkResult (Link_NotRetrieved);
   else if (Result == static_cast<String> ("OK"))
      SetLinkResult (Link_OK);
   else if (Result == static_cast<String> ("Broken"))
      SetLinkResult (Link_Broken);
   else if (Result == static_cast<String> ("Redirected"))
      SetLinkResult (Link_Redirected);
   else if (Result == static_cast<String> ("AnchorNotFound"))
      SetLinkResult (Link_AnchorNotFound);
   else if (Result == static_cast<String> ("NotAuthorized"))
      SetLinkResult (Link_NotAuthorized);
   else if (Result == static_cast<String> ("EMail"))
      SetLinkResult (Link_EMail);
   else if (Result == static_cast<String> ("Javascript"))
      SetLinkResult (Link_Javascript);
   else if (Result == static_cast<String> ("BadEncoded"))
      SetLinkResult (Link_BadEncoded);
   else return 0;
   
   return 1;
}

///////
   //    Managing the domain of the link
///////

///////
   //    Converts the Link_Domain value into the corresponding
   //    String value
///////

void Link::RetrieveLinkDomain(String &Domain) const
{

   switch(GetLinkDomain())
   {
      case (Link_Unknown):
         Domain.trunc();
         break;
      case (Link_SameServer):
         Domain="SameServer";
         break;
      case (Link_Internal):
         Domain="Internal";
         break;
      case (Link_External):
         Domain="External";
         break;
   }

}

///////
   //    Converts the Domain string value
   //    into the corresponding Link_Domain value 
   //    Returns 0 if an error occurs, 1 if OK.
///////

int Link::SetLinkDomain(const String& Domain)
{

   if (Domain.length() == 0)
      SetLinkDomain (Link_Unknown);
   else if (Domain == static_cast<String> ("SameServer"))
      SetLinkDomain (Link_Unknown);
   else if (Domain == static_cast<String> ("Internal"))
      SetLinkDomain (Link_Internal);
   else if (Domain == static_cast<String> ("External"))
      SetLinkDomain (Link_External);
   else return 0;
   
   return 1;
}
