/* 
 *	HT Editor
 *	htnenms.cc
 *
 *	Copyright (C) 1999, 2000, 2001 Stefan Weyergraf (stefan@weyergraf.de)
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License version 2 as
 *	published by the Free Software Foundation.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "htatom.h"
#include "htne.h"
#include "htnenms.h"
#include "httag.h"
#include "formats.h"

#include <stdlib.h>

ht_view *htnenames_init(bounds *b, ht_streamfile *file, ht_format_group *group)
{
	ht_ne_shared_data *ne_shared=(ht_ne_shared_data *)group->get_shared_data();

	dword h=ne_shared->hdr_ofs;
	ht_uformat_viewer *v=new ht_uformat_viewer();
	v->init(b, DESC_NE_NAMES, VC_EDIT, file, group);
	ht_mask_sub *m=new ht_mask_sub();
	m->init(file, 0);

	char line[1024];	/* possible buffer overflow */
	char *n;
	int i;

	sprintf(line, "* NE resident names table at offset %08x", h+ne_shared->hdr.restab);
	m->add_mask(line);

	file->seek(h+ne_shared->hdr.restab);
	i=0;
	while (*(n=getstrp(file))) {
		word ent;
		file->read(&ent, 2);
		if (!i) {
			sprintf(line, "description: %s", n);
		} else {
			sprintf(line, "%04x %s", ent, n);
		}
		free(n);
		m->add_mask(line);
		i++;
	}
	free(n);

	m->add_mask("----------------------------------------------------------------");
	sprintf(line, "* NE non-resident names table at offset %08x", ne_shared->hdr.nrestab);
	m->add_mask(line);

	file->seek(ne_shared->hdr.nrestab);
	i=0;
	while (*(n=getstrp(file))) {
		word ent;
		file->read(&ent, 2);
		if (!i) {
			sprintf(line, "description: %s", n);
		} else {
			sprintf(line, "%04x %s", ent, n);
		}
		free(n);
		m->add_mask(line);
		i++;
	}
	free(n);

	v->insertsub(m);

	return v;
}

format_viewer_if htnenames_if = {
	htnenames_init,
	0
};
