/* ptal -- Peripheral Transport Abstraction Library */

/* Copyright (C) 2000-2001 Hewlett-Packard Company
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston,
 * MA 02111-1307, USA.
 */

/* Original author: David Paschal */

#ifndef PTAL_INTERNAL_H
#define PTAL_INTERNAL_H

#include "ptal.h"


struct ptalProvider_s {
	char *name;

	int sizeofDevice;
	int sizeofChannel;

	ptalDevice_t (*deviceOpen)(char *name);
	void (*deviceConstructor)(ptalDevice_t dev,void *cbd);
	void (*deviceDestructor)(ptalDevice_t dev);
	void (*deviceDump)(ptalDevice_t dev,int level);
	int (*deviceGetDeviceIDString)(ptalDevice_t dev,
		char *buffer,int maxlen);

	void (*channelConstructor)(ptalChannel_t chan);
	void (*channelDestructor)(ptalChannel_t chan);
	void (*channelDump)(ptalChannel_t chan,int level);

	int (*channelIsOpen)(ptalChannel_t chan);
	int (*channelOpen)(ptalChannel_t chan);
	int (*channelClose)(ptalChannel_t chan);

	int (*channelSelect)(ptalChannel_t chan,int *pr,int *pw,int *px,
		struct timeval *timeout);

	int (*channelRead)(ptalChannel_t chan,char *buffer,int count);
	int (*channelWrite)(ptalChannel_t chan,char *buffer,int count);

	int (*pmlOpen)(ptalDevice_t dev);
	int (*pmlClose)(ptalDevice_t dev);
	int (*pmlGet)(ptalPmlObject_t obj,ptalPmlObject_t next);
	int (*pmlSet)(ptalPmlObject_t obj);
	int (*pmlSetTrap)(ptalPmlObject_t obj,int enable);
	int (*pmlServiceTraps)(ptalDevice_t dev);
};

extern ptalProvider_t ptalProviders[];


struct ptalDevice_s {
	ptalDevice_t prev,next;

	ptalProvider_t provider;
	char *name;		/* dynamically allocated */

	ptalChannel_t firstChannel;
	ptalChannel_t lastChannel;

	ptalChannel_t pmlChannel;
	ptalPmlObject_t firstPmlObject;
	ptalPmlObject_t lastPmlObject;
};



struct ptalChannel_s {
	ptalChannel_t prev,next;

	ptalDevice_t dev;
	ptalProvider_t provider;

	/* What to connect to on this device. */
	int serviceType;	/* PTAL_STYPE_* */
	int socketID;
	char serviceName[PTAL_MAX_SERVICE_NAME_LEN+1];

	/* Transport channel configuration. */
	int desiredHPSize;
	int desiredPHSize;
	int actualHPSize;
	int actualPHSize;

	/* Connection retry parameters. */
	int retryCount;
	int retryDelay;

	/* State. */		/* 0 <= fd < FD_SETSIZE */
	int fd;			/* PTAL_NO_FD if not open */
};




ptalDevice_t ptalDeviceAdd(ptalProvider_t provider,char *name,void *cbd);
int ptalPmlSetStatus(ptalPmlObject_t obj,int status);




#define PTAL_PML_MAX_OID_VALUES	2

typedef struct ptalPmlValue_s {
	int type;
	int len;
	char value[PTAL_PML_MAX_VALUE_LEN+1];	/* null terminated */
} *ptalPmlValue_t;

struct ptalPmlObject_s {
	ptalPmlObject_t prev,next;

	ptalDevice_t dev;

	char oid[PTAL_PML_MAX_OID_LEN+1];	/* binary, null terminated */

	int indexOfLastValue;
	int numberOfValidValues;
	struct ptalPmlValue_s value[PTAL_PML_MAX_OID_VALUES];
	int status;

	int trapEnabled;
	int trapCount;	/* trap increments, enable/hasTrapped zeroes */
	ptalPmlObjectEnumerate_f *trapCallback; /* may be 0 even if trapped */
	void *cbd;	/* callback data */
};

#define PTAL_PML_REQUEST_GET		0x00
#define PTAL_PML_REQUEST_GETNEXT	0x01
#define PTAL_PML_REQUEST_SET		0x04
#define PTAL_PML_REQUEST_TRAP_ENABLE	0x05
#define PTAL_PML_REQUEST_TRAP_DISABLE	0x06
#define PTAL_PML_REQUEST_TRAP		0x07
#define PTAL_PML_COMMAND_MASK		0x7F
#define PTAL_PML_COMMAND_REPLY		0x80


#endif
