/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_ITEM_AUDIO_H
#define _HRN_ITEM_AUDIO_H

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_ITEM_AUDIO    hrn_item_audio_get_type ()

#define HRN_ITEM_AUDIO(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_ITEM_AUDIO, HrnItemAudio))

#define HRN_ITEM_AUDIO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass),  HRN_TYPE_ITEM_AUDIO, HrnItemAudioClass))

#define HRN_IS_ITEM_AUDIO(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_ITEM_AUDIO))

#define HRN_IS_ITEM_AUDIO_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),  HRN_TYPE_ITEM_AUDIO))

#define HRN_ITEM_AUDIO_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),  HRN_TYPE_ITEM_AUDIO, HrnItemAudioClass))

typedef struct _HrnItemAudio HrnItemAudio;
typedef struct _HrnItemAudioClass HrnItemAudioClass;
typedef struct _HrnItemAudioPrivate HrnItemAudioPrivate;

struct _HrnItemAudio
{
  HrnItem              parent_instance;
  HrnItemAudioPrivate *priv;
};

struct _HrnItemAudioClass
{
  /*< private >*/
  HrnItemClass parent_class;
};

GType         hrn_item_audio_get_type (void) G_GNUC_CONST;
HrnItemAudio *hrn_item_audio_create   (BklItem *item,
                                       gboolean square);

G_END_DECLS

#endif
