/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_CONTROLS_H
#define _HRN_CONTROLS_H

#include <clutter/clutter.h>
#include <bickley/bkl-item.h>
#include <bognor/br-queue.h>

G_BEGIN_DECLS

#define HRN_TYPE_CONTROLS    hrn_controls_get_type ()

#define HRN_CONTROLS(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_CONTROLS, HrnControls))

#define HRN_CONTROLS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_CONTROLS, HrnControlsClass))

#define HRN_IS_CONTROLS(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_CONTROLS))

#define HRN_IS_CONTROLS_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_CONTROLS))

#define HRN_CONTROLS_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_CONTROLS, HrnControlsClass))

typedef struct _HrnControls HrnControls;
typedef struct _HrnControlsClass HrnControlsClass;
typedef struct _HrnControlsPrivate HrnControlsPrivate;

struct _HrnControls
{
  NbtkBin       parent_instance;
  HrnControlsPrivate *priv;
};

struct _HrnControlsClass
{
  /*< private >*/
  NbtkBinClass parent_class;
};

GType     hrn_controls_get_type (void) G_GNUC_CONST;

HrnControls *hrn_controls_new (void);
void hrn_controls_set_title (HrnControls *controls,
                             const char  *title);
void hrn_controls_set_playing (HrnControls *controls,
                               gboolean     playing);
void hrn_controls_set_duration (HrnControls *controls,
                                guint64      duration);
void hrn_controls_show_progress (HrnControls *controls,
                                 gboolean     shown);
void hrn_controls_set_position  (HrnControls *controls,
                                 double       position);

G_END_DECLS

#endif
