#ifndef __HRN_CLUSTER_NODE_H__
#define __HRN_CLUSTER_NODE_H__

#include <glib-object.h>
#include <bickley/bkl-item.h>

G_BEGIN_DECLS

#define HRN_TYPE_CLUSTER_NODE                                           \
   (hrn_cluster_node_get_type())
#define HRN_CLUSTER_NODE(obj)                                           \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_CLUSTER_NODE,                  \
                                HrnClusterNode))
#define HRN_CLUSTER_NODE_CLASS(klass)                                   \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_CLUSTER_NODE,                     \
                             HrnClusterNodeClass))
#define IS_HRN_CLUSTER_NODE(obj)                                        \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_CLUSTER_NODE))
#define IS_HRN_CLUSTER_NODE_CLASS(klass)                                \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_CLUSTER_NODE))
#define HRN_CLUSTER_NODE_GET_CLASS(obj)                                 \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_CLUSTER_NODE,                   \
                               HrnClusterNodeClass))

/* FIXME: These should be subclasses or something */
typedef enum _HrnClusterNodeType {
    HRN_CLUSTER_NODE_TYPE_AUDIO_ROOT,
    HRN_CLUSTER_NODE_TYPE_ARTIST,
    HRN_CLUSTER_NODE_TYPE_ALBUM,
    HRN_CLUSTER_NODE_TYPE_TRACK,

    HRN_CLUSTER_NODE_TYPE_IMAGE_ROOT,
    HRN_CLUSTER_NODE_TYPE_YEAR,
    HRN_CLUSTER_NODE_TYPE_MONTH,
    HRN_CLUSTER_NODE_TYPE_IMAGE,

    HRN_CLUSTER_NODE_TYPE_VIDEO_ROOT,
    HRN_CLUSTER_NODE_TYPE_VIDEO,
} HrnClusterNodeType;

typedef struct _AudioCluster {
    GHashTable *name_to_artist;
    GHashTable *name_to_album;
} AudioCluster;

typedef struct _ArtistCluster {
    char *thumbnail_uri;
} ArtistCluster;

typedef struct _AlbumCluster {
    char *thumbnail_uri;
    GPtrArray *artists;
    int year;
} AlbumCluster;

typedef struct _TrackCluster {
    BklItem *item;
} TrackCluster;

typedef struct _ImageCluster {
    GHashTable *year_to_cluster;
    GHashTable *month_to_cluster;
} ImageCluster;

typedef struct _YearCluster {
    char *thumbnail_uri;
    char *orient;
    int year;
} YearCluster;

typedef struct _MonthCluster {
    char *thumbnail_uri;
    char *orient;
    int month;
} MonthCluster;

typedef struct _PictureCluster {
    BklItem *item;
} PictureCluster;

typedef struct _VideoCluster {
    BklItem *item;
} VideoCluster;

typedef struct _HrnClusterNodePrivate HrnClusterNodePrivate;
typedef struct _HrnClusterNode      HrnClusterNode;
typedef struct _HrnClusterNodeClass HrnClusterNodeClass;

struct _HrnClusterNode
{
    GObject parent_object;

    HrnClusterNodeType type;

    HrnClusterNode *parent;
    guint visibility_id;
    GSequenceIter *iter; /* An iter into this->parent->children */

    GSequence *children;
    GCompareDataFunc sorter; /* How we insert into children */
    int visible_children;

    char *name;
    char *canonical_name;

    gboolean hidden; /* Is this node hidden */

    gpointer data;
};

struct _HrnClusterNodeClass
{
    GObjectClass parent_class;
};

GType hrn_cluster_node_get_type (void) G_GNUC_CONST;

HrnClusterNode *hrn_cluster_node_new (HrnClusterNodeType type,
                                      GCompareDataFunc   sorter);
void hrn_cluster_node_free (HrnClusterNode *node);
void hrn_cluster_node_add_child (HrnClusterNode *parent,
                                 HrnClusterNode *child);
void hrn_cluster_node_remove_child (HrnClusterNode *parent,
                                    HrnClusterNode *child);
void hrn_cluster_node_set_hidden (HrnClusterNode *node,
                                  gboolean        hidden);
void hrn_cluster_node_flatten_reversed (HrnClusterNode *node,
                                        GList         **flat);
HrnClusterNode *hrn_cluster_node_get_first_leaf (HrnClusterNode *parent);
HrnClusterNode *hrn_cluster_node_get_next_leaf (HrnClusterNode *node);
HrnClusterNode *hrn_cluster_node_get_next_leaf (HrnClusterNode *node);
HrnClusterNode *hrn_cluster_node_get_previous_leaf (HrnClusterNode *node);

void hrn_cluster_node_set_children_hidden (HrnClusterNode *node,
                                           gboolean        hidden);


G_END_DECLS

#endif /* __HRN_CLUSTER_NODE_H__ */
