<?php
/**
 * $Horde: sam/lib/base.php,v 1.29 2006/01/01 21:11:50 jan Exp $
 * Copyright 2002-2006 Chris Bowlby <excalibur@hub.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

// Check for a prior definition of HORDE_BASE (perhaps by an
// auto_prepend_file definition for site customization).
if (!defined('HORDE_BASE')) {
    @define('HORDE_BASE', dirname(__FILE__) . '/../..');
}

// Load the Horde Framework core, and set up inclusion paths.
require_once HORDE_BASE . '/lib/core.php';

// Registry.
$registry = &Registry::singleton();
if (is_a(($pushed = $registry->pushApp('sam', !defined('AUTH_HANDLER'))), 'PEAR_Error')) {
    if ($pushed->getCode() == 'permission_denied') {
        Horde::authenticationFailureRedirect();
    }
    Horde::fatal($pushed, __FILE__, __LINE__, false);
}
$conf = &$GLOBALS['conf'];
@define('SAM_TEMPLATES', $registry->get('templates'));

// Notification system.
$notification = &Notification::singleton();
$notification->attach('status');

// Redirect the user to the Horde login page if they haven't
// authenticated.
if (!Auth::isAuthenticated()) {
    Horde::authenticationFailureRedirect();
}

// Find the base file path of SAM.
@define('SAM_BASE', dirname(__FILE__) . '/..');

// SAM base library.
require_once SAM_BASE . '/lib/SAM.php';

// Help.
require_once 'Horde/Help.php';

// Start compression.
Horde::compressOutput();

// Load the storage driver. It appears in the global variable
// $sam_driver.
require_once SAM_BASE . '/lib/Driver.php';
$backend = SAM::getBackend();
$user = SAM::mapUser($backend['hordeauth']);
$GLOBALS['sam_driver'] = &SAM_Driver::singleton($backend['driver'], $user,
                                                $backend['params']);
