@echo off

REM hfontfli.bat
REM ------------

set fli_opt=

:next_arg
if "%1"=="/v" goto set_v
if "%1"=="" goto usage
if "%2"=="" goto usage
if "%3"=="" goto usage
if "%4"=="" goto usage
if "%5"=="" goto usage
if "%6"=="" goto start

:usage
echo Usage:   hfontfli [/v] DEVICE RESOLUTION FLIDIR HANGUL MJ
echo Example: hfontfli lj 300 c:\newfonts hangul mj
goto error

:set_v
set fli_opt=/v
shift
goto next_arg

:start
if %4/ == hsymbol/ goto hsymbol
if %4/ == hangul/ goto hangul
if %4/ == hanja/ goto hanja
if %4/ == jamo/ goto jamo
if %4/ == johab/ goto johab
goto error

:hangul
set fli_opt=%fli_opt% /b%2 /fhfont.lst %3\ws_%5
echo *0.5 +ws%5*.pk *0.6 +ws%5*.pk *0.7 +ws%5*.pk *0.8 +ws%5*.pk *0.9 +ws%5*.pk > ws_%5.rsp
echo :0 +ws%5*.pk :h +ws%5*.pk :1 +ws%5*.pk :2 +ws%5*.pk :3 +ws%5*.pk :4 +ws%5*.pk :5 +ws%5*.pk >> ws_%5.rsp
set rsp=@ws_%5.rsp
goto fontlib

:jamo
set fli_opt=%fli_opt% /b%2 /fhfont.lst %3\jamo
echo *0.5 +*.pk *0.6 +*.pk *0.7 +*.pk *0.8 +*.pk *0.9 +*.pk > jamo.rsp
echo :0 +*.pk :h +*.pk :1 +*.pk :2 +*.pk :3 +*.pk :4 +*.pk :5 +*.pk >> jamo.rsp
set rsp=@jamo.rsp
goto fontlib

:hanja
set fli_opt=%fli_opt% /b%2 /fhfont.lst %3\hh_%5
echo *0.6944 +%5*.pk *0.8333 +%5*.pk *0.9129 +%5*.pk > hh_%5.rsp
echo :0 +%5*.pk :h +%5*.pk :1 +%5*.pk :2 +%5*.pk :3 +%5*.pk :4 +%5*.pk :5 +%5*.pk >> hh_%5.rsp
set rsp=@hh_%5.rsp
goto fontlib

:johab
set fli_opt=%fli_opt% /b%2 /fhfont.lst %3\johab
echo *0.5 +*.pk *0.6 +*.pk *0.7 +*.pk *0.8 +*.pk *0.9 +*.pk > johab.rsp
echo :0 +*.pk :h +*.pk :1 +*.pk :2 +*.pk :3 +*.pk :4 +*.pk :5 +*.pk >> johab.rsp
set rsp=@johab.rsp
goto fontlib

:hsymbol
set fli_opt=%fli_opt% /b%2 /fhfont.lst %3\hs_%5
echo *0.5 +%5*.pk *0.6 +%5*.pk *0.7 +%5*.pk *0.8 +%5*.pk *0.9 +%5*.pk > hs_%5.rsp
echo :0 +%5*.pk :h +%5*.pk :1 +%5*.pk :2 +%5*.pk :3 +%5*.pk :4 +%5*.pk :5 +%5*.pk >> hs_%5.rsp
set rsp=@hs_%5.rsp
goto fontlib

:fontlib
fontlib /c %fli_opt% =pk\%4\%%rdpi %rsp%

if errorlevel 1 goto error
goto end

:error
echo *** Error!
:end
set fli_opt=
set rsp=
