{- This module was generated from data in the Kate syntax
   highlighting file texinfo.xml, version 0.2, by Daniel Franke (franke.daniel@gmail.com) -}

module Text.Highlighting.Kate.Syntax.Texinfo
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Alert
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Texinfo"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.texi"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Texinfo","Normal Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Texinfo","Normal Text") -> return ()
      ("Texinfo","singleLineComment") -> (popContext) >> pEndLine
      ("Texinfo","multiLineComment") -> return ()
      ("Texinfo","nodeFolding") -> return ()
      ("Texinfo","folding") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'40c'28omment'29'3f'5cb = compileRegex True "@c(omment)?\\b"
regex_'40ignore'5cb = compileRegex True "@ignore\\b"
regex_'40node'5cb = compileRegex True "@node\\b"
regex_'40'28menu'7csmallexample'7ctable'7cmultitable'29'5cb = compileRegex True "@(menu|smallexample|table|multitable)\\b"
regex_'40'5b'5cw'5d'2b'28'5c'7b'28'5b'5cw'5d'2b'5b'5cs'5d'2a'29'2b'5c'7d'29'3f = compileRegex True "@[\\w]+(\\{([\\w]+[\\s]*)+\\})?"
regex_'40end_'28menu'7csmallexample'7ctable'7cmultitable'29'5cb = compileRegex True "@end (menu|smallexample|table|multitable)\\b"

parseRules ("Texinfo","Normal Text") =
  (((pRegExpr regex_'40c'28omment'29'3f'5cb >>= withAttribute CommentTok) >>~ pushContext ("Texinfo","singleLineComment"))
   <|>
   ((pRegExpr regex_'40ignore'5cb >>= withAttribute CommentTok) >>~ pushContext ("Texinfo","multiLineComment"))
   <|>
   ((pRegExpr regex_'40node'5cb >>= withAttribute FunctionTok) >>~ pushContext ("Texinfo","nodeFolding"))
   <|>
   ((pRegExpr regex_'40'28menu'7csmallexample'7ctable'7cmultitable'29'5cb >>= withAttribute FunctionTok) >>~ pushContext ("Texinfo","folding"))
   <|>
   ((pRegExpr regex_'40'5b'5cw'5d'2b'28'5c'7b'28'5b'5cw'5d'2b'5b'5cs'5d'2a'29'2b'5c'7d'29'3f >>= withAttribute FunctionTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Texinfo","Normal Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Texinfo","singleLineComment") =
  (((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Texinfo","singleLineComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Texinfo","multiLineComment") =
  (((pString False "@end ignore" >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Alert.parseExpression (Just ("Alerts","")) >>= ((withAttribute CommentTok) . snd)))
   <|>
   (currentContext >>= \x -> guard (x == ("Texinfo","multiLineComment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Texinfo","nodeFolding") =
  (((lookAhead (pRegExpr regex_'40node'5cb) >> (popContext) >> currentContext >>= parseRules))
   <|>
   ((parseRules ("Texinfo","Normal Text")))
   <|>
   (currentContext >>= \x -> guard (x == ("Texinfo","nodeFolding")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Texinfo","folding") =
  (((pRegExpr regex_'40end_'28menu'7csmallexample'7ctable'7cmultitable'29'5cb >>= withAttribute FunctionTok) >>~ (popContext))
   <|>
   ((parseRules ("Texinfo","Normal Text")))
   <|>
   (currentContext >>= \x -> guard (x == ("Texinfo","folding")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Alerts", _) = Text.Highlighting.Kate.Syntax.Alert.parseExpression Nothing

parseRules x = parseRules ("Texinfo","Normal Text") <|> fail ("Unknown context" ++ show x)
