/*
 * Hexxagon board game.
 * Copyright (C) 2001 Erik Jonsson.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 * Email erik@nesqi.homeip.net
 * 
 */

#include "rendering.h"
#include "convert_xpm.h" 

#include <string.h>
#include <gtk/gtk.h>

/* pictures */
#include "pictures/thinking.xpm"
#include "pictures/hexxagonboard.xpm"
#include "pictures/numfont.xpm"
#include "pictures/playerone.xpm"
#include "pictures/playertwo.xpm"

/* Pictures */
guchar *window_rgb;  /* The visual picture */

guchar *board_rgb;   /* Reference pictures */
guchar *thinking_rgb;
guchar *numfont_rgb;
guchar *player1_rgb; 
guchar *player2_rgb;

struct point
{
	int x;
	int y;
};

struct point cell_pos[61];

int init_board_graphics()
{
	board_rgb    = convert_xpm_to_rgb(hexxagonboard_xpm);
	window_rgb   = convert_xpm_to_rgb(hexxagonboard_xpm);
	thinking_rgb = convert_xpm_to_rgb(thinking_xpm);
	numfont_rgb  = convert_xpm_to_rgb(numfont_xpm);
	player1_rgb  = convert_xpm_to_rgb(playerone_xpm);
	player2_rgb  = convert_xpm_to_rgb(playertwo_xpm);

	find_all_cells();

	return 0;
}

void clear_board()
{
	memcpy(window_rgb, board_rgb, BOARD_WIDTH * BOARD_HEIGHT * 3);
}

void render_thinking()
{
	draw_rgb_to_board(thinking_rgb, 114, 279, 367, 72);
}

int get_cell_from_pos(int x, int y)
{
	int color;

	if(board_rgb[(x + y * BOARD_WIDTH) * 3] != 79
	   || board_rgb[(x + y * BOARD_WIDTH) * 3 + 1] != 90)
		return -1;

	color = board_rgb[(x + y * BOARD_WIDTH) * 3 + 2];
	
	if(color >= 158 && color <= 218)
		return color - 158;
	else 
		return -1;
}

void find_all_cells()
{
	memset(cell_pos, 0, sizeof(cell_pos));

	int i, j, c;

	for(i = 0; i < BOARD_HEIGHT; i++)
	{
		for(j = 0; j < BOARD_WIDTH; j++)
		{
			if((c = get_cell_from_pos(j, i)) >= 0)
			{
				if(cell_pos[c].x == 0 && cell_pos[c].y == 0)
				{
					cell_pos[c].x = j; // Position it as a square not a hexxagon.
					cell_pos[c].y = i;
				}
			}
		}
	}
}

void render_piece_to_board(int no, int pl)
{
	if(pl == 0)
		draw_rgb_to_board(player1_rgb, cell_pos[no].x - 18, cell_pos[no].y, 73, 65);
	else
		draw_rgb_to_board(player2_rgb, cell_pos[no].x - 19, cell_pos[no].y - 3, 72, 64);
}

void render_digit_to_board(int dig, int x, int y)
{
	draw_rgb_to_board(numfont_rgb + (dig * 56 * 48 * 3), x , y, 48, 56);
}

void draw_rgb_to_board(guchar *src, int x, int y, int w, int h)
{
	guchar *dest = window_rgb + (y * BOARD_WIDTH + x) * 3;

	for(int ys = 0; ys < h; ys++)
	{
		for(int xs = 0; xs < w; xs++)
		{
			/* remove if color key... */
			if((src[0] == 255) && (src[1] == 0) && (src[2] == 255))
			{
				src += 3;
				dest += 3;
				continue;
			}
			else
			{
				*(dest++) = *(src++);
				*(dest++) = *(src++);
				*(dest++) = *(src++);
			}
		}

		dest += (BOARD_WIDTH - w) * 3;
	}
}

void fill_cell(int no, int color)
{
	guchar r, g, b, col;
	guchar *pos1, *pos2;
	int offs;
	
	if(color == 1) /* clone */
	{
		r = 117; g = 183; b = 117;              
	}
	else if(color == 2) /* jump */
	{
		r = 85; g = 150; b = 85;                
	}
	
	pos1 = board_rgb + (cell_pos[no].x + cell_pos[no].y * BOARD_WIDTH + 5) * 3;
	col = pos1[2];
	
	while(pos1[2] == col)
	{
		pos2 = pos1;
		
		while(*(pos2 - 1) == col)
			pos2 -= 3;
		
		while(pos2[2] == col)
		{
			offs = pos2 - board_rgb;
			(window_rgb + offs)[0] = r;
			(window_rgb + offs)[1] = g;
			(window_rgb + offs)[2] = b;
			pos2 += 3;              
		}
		
		pos1 += BOARD_WIDTH * 3;
	}
	
}

void reset_cell(int no)
{
	guchar *pos1, *pos2;
	guchar col;
	int offs;
	
	pos1 = board_rgb + (cell_pos[no].x + cell_pos[no].y * BOARD_WIDTH + 5) * 3;
	col = pos1[2];
	
	while(pos1[2] == col)
	{
		pos2 = pos1;
		
		while(*(pos2 - 1) == col)
			pos2 -= 3;
		
		while(pos2[2] == col)
		{
			offs = pos2 - board_rgb;
			(window_rgb + offs)[0] = (board_rgb + offs)[0];
			(window_rgb + offs)[1] = (board_rgb + offs)[1];
			(window_rgb + offs)[2] = (board_rgb + offs)[2];
			pos2 += 3;              
		}
		
		pos1 += BOARD_WIDTH * 3;
	}
}
