/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: color.cpp,v 1.2.24.1 2004/07/09 01:52:03 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include <stdio.h>

#include "hxtypes.h"
#include "hxcom.h"
#include "hxcomm.h"
#include "hxstring.h"
#include "baseobj.h"
#include "color.h"
#include "rpfilobj.h"

#include "hxheap.h"
#ifdef _DEBUG
#undef HX_THIS_FILE		
static char HX_THIS_FILE[] = __FILE__;
#endif

CIMFColor::CIMFColor()
{
    m_ucRed   = (unsigned char) ((kDefaultColor >> 16) & 0x000000FF);
    m_ucGreen = (unsigned char) ((kDefaultColor >>  8) & 0x000000FF);
    m_ucBlue  = (unsigned char) ( kDefaultColor        & 0x000000FF);
};

CIMFColor::CIMFColor(unsigned char ucRed, unsigned char ucGreen, unsigned char ucBlue)
{
    m_ucRed   = ucRed;
    m_ucGreen = ucGreen;
    m_ucBlue  = ucBlue;
};

CIMFColor::CIMFColor(const CIMFColor &rColor)
{
    m_ucRed   = rColor.m_ucRed;
    m_ucGreen = rColor.m_ucGreen;
    m_ucBlue  = rColor.m_ucBlue;
};

CIMFColor::CIMFColor(ULONG32 ulColor)
{
    m_ucRed   = (unsigned char) ((ulColor >> 16) & 0x000000FF);
    m_ucGreen = (unsigned char) ((ulColor >>  8) & 0x000000FF);
    m_ucBlue  = (unsigned char) ( ulColor        & 0x000000FF);
};

CIMFColor::~CIMFColor() 
{
};

char CIMFColor::m_pszColorAttribute[] = "color";

CIMFColor::ColorPair CIMFColor::m_cPredefinedColorPair[kNumPredefinedColors] =
{
    "black",  0x000000,  "green", 0x008000, "silver",  0xC0C0C0, "lime",   0x00FF00,
    "gray",   0x808080,  "olive", 0x808000, "white",   0xFFFFFF, "yellow", 0xFFFF00,
    "maroon", 0x800000,  "navy",  0x000080, "red",     0xFF0000, "blue",   0x0000FF,
    "purple", 0x800080,  "teal",  0x008080, "fuchsia", 0xFF00FF, "aqua",   0x00FFFF
};

void CIMFColor::RenderText(GString &rText)
{
    rText += m_pszColorAttribute;
    rText += "=";

    ULONG32 ulColor = ((m_ucRed <<  16) & 0x00FF0000) |
                      ((m_ucGreen << 8) & 0x0000FF00) |
                      ( m_ucBlue        & 0x000000FF);

    // First check to see if it's a predefined color
    UINT32 i;
    for (i = 0; i < kNumPredefinedColors; i++)
    {
        if (ulColor == m_cPredefinedColorPair[i].m_ulColorValue)
        {
            break;
        }
    }
        
    if (i < kNumPredefinedColors)
    {
        // The color WAS a predefined color
        rText += m_cPredefinedColorPair[i].m_pszColorName;
    }
    else
    {
        // The color WAS NOT a predefined color
        char cTmp[16];
            
        sprintf(cTmp, "\"#%02X%02X%02X\"", m_ucRed, m_ucGreen, m_ucBlue); /* Flawfinder: ignore */
        rText += cTmp;
    }

    // Add a trailing space
    rText += " ";
}

BOOL CIMFColor::InitFromText(GString &rText)
{
    // Get the attribute string
    ULONG32 ulColor = kDefaultColor;
    GString cColorStr;
    BOOL    bRet = CIMFFileObject::GetAttributeSubstring(rText,
                                                         m_pszColorAttribute,
                                                         cColorStr);
    // If a color attribute was present, then parse the string
    if (bRet == TRUE)
    {
        // First check to see if it's a hex color
        LONG32 lNumRet = sscanf(cColorStr.c_str(), "#%06X", &ulColor);
        if (lNumRet != 1)
        {
            // It was not a hex color, so check the predefined colors
            for (ULONG32 i = 0; i < kNumPredefinedColors; i++)
            {
                if (cColorStr == m_cPredefinedColorPair[i].m_pszColorName)
                {
                    ulColor = m_cPredefinedColorPair[i].m_ulColorValue;
                    break;
                }
            }
        }
    }

    m_ucRed   = (unsigned char) ((ulColor >> 16) & 0x000000FF);
    m_ucGreen = (unsigned char) ((ulColor >>  8) & 0x000000FF);
    m_ucBlue  = (unsigned char) ( ulColor        & 0x000000FF);

    return TRUE;
}

