/* ***** BEGIN LICENSE BLOCK *****
 * Source last modified: $Id: minisitebuild.cpp,v 1.7.4.1 2004/07/09 01:59:28 hubbe Exp $
 * 
 * Portions Copyright (c) 1995-2004 RealNetworks, Inc. All Rights Reserved.
 * 
 * The contents of this file, and the files included with this file,
 * are subject to the current version of the RealNetworks Public
 * Source License (the "RPSL") available at
 * http://www.helixcommunity.org/content/rpsl unless you have licensed
 * the file under the current version of the RealNetworks Community
 * Source License (the "RCSL") available at
 * http://www.helixcommunity.org/content/rcsl, in which case the RCSL
 * will apply. You may also obtain the license terms directly from
 * RealNetworks.  You may not use this file except in compliance with
 * the RPSL or, if you have a valid RCSL with RealNetworks applicable
 * to this file, the RCSL.  Please see the applicable RPSL or RCSL for
 * the rights, obligations and limitations governing use of the
 * contents of the file.
 * 
 * Alternatively, the contents of this file may be used under the
 * terms of the GNU General Public License Version 2 or later (the
 * "GPL") in which case the provisions of the GPL are applicable
 * instead of those above. If you wish to allow use of your version of
 * this file only under the terms of the GPL, and not to allow others
 * to use your version of this file under the terms of either the RPSL
 * or RCSL, indicate your decision by deleting the provisions above
 * and replace them with the notice and other provisions required by
 * the GPL. If you do not delete the provisions above, a recipient may
 * use your version of this file under the terms of any one of the
 * RPSL, the RCSL or the GPL.
 * 
 * This file is part of the Helix DNA Technology. RealNetworks is the
 * developer of the Original Code and owns the copyrights in the
 * portions it created.
 * 
 * This file, and the files included with this file, is distributed
 * and made available on an 'AS IS' basis, WITHOUT WARRANTY OF ANY
 * KIND, EITHER EXPRESS OR IMPLIED, AND REALNETWORKS HEREBY DISCLAIMS
 * ALL SUCH WARRANTIES, INCLUDING WITHOUT LIMITATION, ANY WARRANTIES
 * OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, QUIET
 * ENJOYMENT OR NON-INFRINGEMENT.
 * 
 * Technology Compatibility Kit Test Suite(s) Location:
 *    http://www.helixcommunity.org/content/tck
 * 
 * Contributor(s):
 * 
 * ***** END LICENSE BLOCK ***** */

#include "minisite.h"
#include "minisurf.h"

#ifdef _WINDOWS
#include "mwinsite.h"
#include "mwinsurf.h"
#endif

#ifdef _UNIX
# ifdef HELIX_FEATURE_LINUX_FB_SITE
#  include "linux_fb_site.h"
#  include "linux_fb_surf.h"
# elif defined(HELIX_FEATURE_AA_SITE)
#  include "munixsite.h"
#  include <aalib.h>
#  include "maasurf.h"
# else
#  include "munixsite.h"
#  include "munixsurf.h"
# endif
#endif

#ifdef _MACINTOSH
#include "mmacsite.h"
#include "mmacsurf.h"
#endif

#ifdef _SYMBIAN
#include "minisymbiansite.h"
#include "minisymbiansurf.h"
#endif

#ifdef _OPENWAVE
#include "miniopenwavesite.h"
#include "miniopenwavesurf.h"
#endif

CMiniBaseSite* CMiniBaseSite::CreateSite(IUnknown* pContext,
                                         IUnknown* pUnkOuter,
                                         INT32 lZorder)
{
// need to create OS spcific subclass
#if defined(_WINDOWS)
    return new CHXWinSite(pContext, pUnkOuter, lZorder);    
#elif defined(_UNIX)
# if defined(HELIX_FEATURE_LINUX_FB_SITE)
    return new CHXLinuxFrameBufferSite(pContext, pUnkOuter, lZorder);
# else
    return new CHXUnixSite(pContext, pUnkOuter, lZorder);
# endif /* HELIX_FEATURE_LINUX_FB_SITE */
#elif defined(_MACINTOSH)
    return new CHXMacSite(pContext, pUnkOuter, lZorder);
#elif defined(_SYMBIAN)
    return new CHXSymbianSite(pContext, pUnkOuter, lZorder);
#elif defined(_OPENWAVE)
	return new CHXOpenwaveSite(pContext, pUnkOuter, lZorder);
#else
    return new CMiniBaseSite(pContext, pUnkOuter, lZorder);    
#endif
}

CMiniBaseSurface* CMiniBaseSurface::Create(IUnknown* pContext, 
					   CMiniBaseSite* pSite)
{
#if defined(_WINDOWS)
    return new CMiniWinSurface(pContext, pSite );
#elif defined(_UNIX)
# if defined(HELIX_FEATURE_LINUX_FB_SITE)
    return new CLinuxFrameBufferSurface(pContext, pSite);
# else
    return new CMiniUnixSurface(pContext, pSite);
#endif /* HELIX_FEATURE_LINUX_FB_SITE */
#elif defined(_SYMBIAN)
    return new CMiniSymbianSurface(pContext, pSite);
#elif defined(_OPENWAVE)
	return new CMiniOpenwaveSurface(pContext, pSite);
#endif   
}
