// chooseset.c	- as choose.c but uses ack set
// ------------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Implementation of class: see choose.h for spec.
// Different implementations will try different policies.
// The class is instantiatied ONCE.

#include "node.h"
#include "choose.h"
#include <stream.h>

extern node nodes[];
extern int cube_size;
extern const int bitmask[];	// bitmask[i] is 2**i

chooseclass choose;		// ONLY INSTANCE

struct mynode {
	int set;
};
struct mynode mynodes[ MAX_CUBE_SIZE ];
static boolean  printed = false;
/*************************************************/
chooseclass::chooseclass()
{
	for( nodenum n = 0; n < MAX_CUBE_SIZE; n++ ) mynodes[n].set = 0;
}
void chooseclass::start()
{
}
/*******************************************/
void chooseclass::sanitycheck()
{
	if( printed == false )
		cout << "Choose algorithm: ack set.\n";
	printed = true;
}
/*******************************************/
void chooseclass::noteack( nodenum here, linknum lout, struct message *pm )
{
	mynodes[here].set |= bitmask[lout];	// turn on bit
}
/*******************************************/
void chooseclass::notenak( nodenum here, linknum lout, struct message *pm )
{
	mynodes[here].set |= bitmask[lout];	// turn on bit
	mynodes[here].set -= bitmask[lout];	// turn off bit
}
/*****************************************/
//
// rightmost returns the bit position (0..15) of the rightmost set bit.
// Returns -1 if no bit set.

linknum rightmost( int mask )
{
	if( (mask <0) || (mask > cube_size)){
		cout << "ERROR: rightmost invalid argument " << mask NL;
		return 1;
	}
	if( mask == 0 ) return -1;
	int i;
	for( i=0;; i++ ) {
		if( mask & 1 ) break;
		mask >>= 1;
	}
	return i;
}
/*****************************************/
// chooselink returns a link# that is free at that node,
// and that is in both the linkset and the okset.
// Returns -1 if no such.
// The search is done right-to-left (LS -> MS).

linknum out( nodenum here, int linkset, int okset )
{
	struct node *phere = &nodes[ here ];
	linknum l;
	linkset &= okset;				// bitwise and
	for(;;) {
		l = rightmost( linkset );		// index of bit
		if( l < 0 ) break;
		if( phere->links[l].busy == false ) break;	// found one
		linkset ^= bitmask[l];			// turn off bit l
	}
	return l;
}
// The above is unchanged from the normal case, except for being renamed.
// The below calls it with the set of preferred linkes, and if that fails,
// with the normal case.
linknum chooseclass::outlink( nodenum here, int linkset, int okset )
{
	int trialset = okset & mynodes[here].set;
	linknum trialanswer = out( here, linkset, trialset );
	if( trialanswer >= 0 ) return trialanswer;
	return out( here, linkset, okset );
}
/*******************************************/
//	int goodlinkset, badlinkset;
//	linknum lastlink;
//	char bestlink[ MAX_CUBE_SIZE ];
