// machine.h
// ---------
//		Copyright 1988 D.C. Lindsay at Carnegie Mellon University
//
// Defines the hypercube being simulated.
// The code also assumes that:
// - each node's crossbar can support CUBE_ORDER/2 messages flowing through
// - The destination's checksum ACK/NAK (actually, in our case, always ACK)
//	causes path teardown.

#ifndef MACHINE_DEF
#define MACHINE_DEF 0

#define NL << "\n"
#define MAX_CUBE_ORDER 12
#define MAX_CUBE_SIZE  4096

// time (and latency) is measured in nano's for convenient printout.
// bandwith is measured in nanos/bit: 1 == 1Gb/s, 8== 128Mb/s
// size is measured in bits

#define LINK_LATENCY		62	/* 1 clk @ 16mhz (pretty arbitrary)*/
#define XBAR_LATENCY		63	/* 1 clk @ 16mhz (a possible design)*/
#define LINK_BANDWIDTH		8	/* 8 bits every clock @ 16mhz */
					// (also, value in 1 of JPL articles)
#define HEADER_SIZE		32
#define HEADER_BAND		(HEADER_SIZE * LINK_BANDWIDTH)
#define HEADER_LATENCY		(LINK_LATENCY + XBAR_LATENCY + HEADER_BAND)
#define SWITCH_LATENCY	(780 - HEADER_BAND - 3 * (LINK_LATENCY+XBAR_LATENCY))
#define DEFAULT_MESG_LEN	(192*8)
#define SEND_LATENCY		35000	/* thru kernel to comm chip */
#define RECEIVE_LATENCY		60000	/* last bit of mesg to exec'ing it */
#define QUEUE_LATENCY		2000	/* "coproc send overhead" */
					// (wait time for retry)

#endif /*MACHINE_DEF*/
