{-# LANGUAGE PatternSynonyms #-}
--------------------------------------------------------------------------------
-- |
-- Module      :  Graphics.GL.EXT.DirectStateAccess
-- Copyright   :  (c) Sven Panne 2016
-- License     :  BSD3
--
-- Maintainer  :  Sven Panne <svenpanne@gmail.com>
-- Stability   :  stable
-- Portability :  portable
--
--------------------------------------------------------------------------------

module Graphics.GL.EXT.DirectStateAccess (
  -- * Extension Support
  glGetEXTDirectStateAccess,
  gl_EXT_direct_state_access,
  -- * Enums
  pattern GL_PROGRAM_MATRIX_EXT,
  pattern GL_PROGRAM_MATRIX_STACK_DEPTH_EXT,
  pattern GL_TRANSPOSE_PROGRAM_MATRIX_EXT,
  -- * Functions
  glBindMultiTextureEXT,
  glCheckNamedFramebufferStatusEXT,
  glClearNamedBufferDataEXT,
  glClearNamedBufferSubDataEXT,
  glClientAttribDefaultEXT,
  glCompressedMultiTexImage1DEXT,
  glCompressedMultiTexImage2DEXT,
  glCompressedMultiTexImage3DEXT,
  glCompressedMultiTexSubImage1DEXT,
  glCompressedMultiTexSubImage2DEXT,
  glCompressedMultiTexSubImage3DEXT,
  glCompressedTextureImage1DEXT,
  glCompressedTextureImage2DEXT,
  glCompressedTextureImage3DEXT,
  glCompressedTextureSubImage1DEXT,
  glCompressedTextureSubImage2DEXT,
  glCompressedTextureSubImage3DEXT,
  glCopyMultiTexImage1DEXT,
  glCopyMultiTexImage2DEXT,
  glCopyMultiTexSubImage1DEXT,
  glCopyMultiTexSubImage2DEXT,
  glCopyMultiTexSubImage3DEXT,
  glCopyTextureImage1DEXT,
  glCopyTextureImage2DEXT,
  glCopyTextureSubImage1DEXT,
  glCopyTextureSubImage2DEXT,
  glCopyTextureSubImage3DEXT,
  glDisableClientStateIndexedEXT,
  glDisableClientStateiEXT,
  glDisableIndexedEXT,
  glDisableVertexArrayAttribEXT,
  glDisableVertexArrayEXT,
  glEnableClientStateIndexedEXT,
  glEnableClientStateiEXT,
  glEnableIndexedEXT,
  glEnableVertexArrayAttribEXT,
  glEnableVertexArrayEXT,
  glFlushMappedNamedBufferRangeEXT,
  glFramebufferDrawBufferEXT,
  glFramebufferDrawBuffersEXT,
  glFramebufferReadBufferEXT,
  glGenerateMultiTexMipmapEXT,
  glGenerateTextureMipmapEXT,
  glGetBooleanIndexedvEXT,
  glGetCompressedMultiTexImageEXT,
  glGetCompressedTextureImageEXT,
  glGetDoubleIndexedvEXT,
  glGetDoublei_vEXT,
  glGetFloatIndexedvEXT,
  glGetFloati_vEXT,
  glGetFramebufferParameterivEXT,
  glGetIntegerIndexedvEXT,
  glGetMultiTexEnvfvEXT,
  glGetMultiTexEnvivEXT,
  glGetMultiTexGendvEXT,
  glGetMultiTexGenfvEXT,
  glGetMultiTexGenivEXT,
  glGetMultiTexImageEXT,
  glGetMultiTexLevelParameterfvEXT,
  glGetMultiTexLevelParameterivEXT,
  glGetMultiTexParameterIivEXT,
  glGetMultiTexParameterIuivEXT,
  glGetMultiTexParameterfvEXT,
  glGetMultiTexParameterivEXT,
  glGetNamedBufferParameterivEXT,
  glGetNamedBufferPointervEXT,
  glGetNamedBufferSubDataEXT,
  glGetNamedFramebufferAttachmentParameterivEXT,
  glGetNamedFramebufferParameterivEXT,
  glGetNamedProgramLocalParameterIivEXT,
  glGetNamedProgramLocalParameterIuivEXT,
  glGetNamedProgramLocalParameterdvEXT,
  glGetNamedProgramLocalParameterfvEXT,
  glGetNamedProgramStringEXT,
  glGetNamedProgramivEXT,
  glGetNamedRenderbufferParameterivEXT,
  glGetPointerIndexedvEXT,
  glGetPointeri_vEXT,
  glGetTextureImageEXT,
  glGetTextureLevelParameterfvEXT,
  glGetTextureLevelParameterivEXT,
  glGetTextureParameterIivEXT,
  glGetTextureParameterIuivEXT,
  glGetTextureParameterfvEXT,
  glGetTextureParameterivEXT,
  glGetVertexArrayIntegeri_vEXT,
  glGetVertexArrayIntegervEXT,
  glGetVertexArrayPointeri_vEXT,
  glGetVertexArrayPointervEXT,
  glIsEnabledIndexedEXT,
  glMapNamedBufferEXT,
  glMapNamedBufferRangeEXT,
  glMatrixFrustumEXT,
  glMatrixLoadIdentityEXT,
  glMatrixLoadTransposedEXT,
  glMatrixLoadTransposefEXT,
  glMatrixLoaddEXT,
  glMatrixLoadfEXT,
  glMatrixMultTransposedEXT,
  glMatrixMultTransposefEXT,
  glMatrixMultdEXT,
  glMatrixMultfEXT,
  glMatrixOrthoEXT,
  glMatrixPopEXT,
  glMatrixPushEXT,
  glMatrixRotatedEXT,
  glMatrixRotatefEXT,
  glMatrixScaledEXT,
  glMatrixScalefEXT,
  glMatrixTranslatedEXT,
  glMatrixTranslatefEXT,
  glMultiTexBufferEXT,
  glMultiTexCoordPointerEXT,
  glMultiTexEnvfEXT,
  glMultiTexEnvfvEXT,
  glMultiTexEnviEXT,
  glMultiTexEnvivEXT,
  glMultiTexGendEXT,
  glMultiTexGendvEXT,
  glMultiTexGenfEXT,
  glMultiTexGenfvEXT,
  glMultiTexGeniEXT,
  glMultiTexGenivEXT,
  glMultiTexImage1DEXT,
  glMultiTexImage2DEXT,
  glMultiTexImage3DEXT,
  glMultiTexParameterIivEXT,
  glMultiTexParameterIuivEXT,
  glMultiTexParameterfEXT,
  glMultiTexParameterfvEXT,
  glMultiTexParameteriEXT,
  glMultiTexParameterivEXT,
  glMultiTexRenderbufferEXT,
  glMultiTexSubImage1DEXT,
  glMultiTexSubImage2DEXT,
  glMultiTexSubImage3DEXT,
  glNamedBufferDataEXT,
  glNamedBufferStorageEXT,
  glNamedBufferSubDataEXT,
  glNamedCopyBufferSubDataEXT,
  glNamedFramebufferParameteriEXT,
  glNamedFramebufferRenderbufferEXT,
  glNamedFramebufferTexture1DEXT,
  glNamedFramebufferTexture2DEXT,
  glNamedFramebufferTexture3DEXT,
  glNamedFramebufferTextureEXT,
  glNamedFramebufferTextureFaceEXT,
  glNamedFramebufferTextureLayerEXT,
  glNamedProgramLocalParameter4dEXT,
  glNamedProgramLocalParameter4dvEXT,
  glNamedProgramLocalParameter4fEXT,
  glNamedProgramLocalParameter4fvEXT,
  glNamedProgramLocalParameterI4iEXT,
  glNamedProgramLocalParameterI4ivEXT,
  glNamedProgramLocalParameterI4uiEXT,
  glNamedProgramLocalParameterI4uivEXT,
  glNamedProgramLocalParameters4fvEXT,
  glNamedProgramLocalParametersI4ivEXT,
  glNamedProgramLocalParametersI4uivEXT,
  glNamedProgramStringEXT,
  glNamedRenderbufferStorageEXT,
  glNamedRenderbufferStorageMultisampleCoverageEXT,
  glNamedRenderbufferStorageMultisampleEXT,
  glProgramUniform1dEXT,
  glProgramUniform1dvEXT,
  glProgramUniform1fEXT,
  glProgramUniform1fvEXT,
  glProgramUniform1iEXT,
  glProgramUniform1ivEXT,
  glProgramUniform1uiEXT,
  glProgramUniform1uivEXT,
  glProgramUniform2dEXT,
  glProgramUniform2dvEXT,
  glProgramUniform2fEXT,
  glProgramUniform2fvEXT,
  glProgramUniform2iEXT,
  glProgramUniform2ivEXT,
  glProgramUniform2uiEXT,
  glProgramUniform2uivEXT,
  glProgramUniform3dEXT,
  glProgramUniform3dvEXT,
  glProgramUniform3fEXT,
  glProgramUniform3fvEXT,
  glProgramUniform3iEXT,
  glProgramUniform3ivEXT,
  glProgramUniform3uiEXT,
  glProgramUniform3uivEXT,
  glProgramUniform4dEXT,
  glProgramUniform4dvEXT,
  glProgramUniform4fEXT,
  glProgramUniform4fvEXT,
  glProgramUniform4iEXT,
  glProgramUniform4ivEXT,
  glProgramUniform4uiEXT,
  glProgramUniform4uivEXT,
  glProgramUniformMatrix2dvEXT,
  glProgramUniformMatrix2fvEXT,
  glProgramUniformMatrix2x3dvEXT,
  glProgramUniformMatrix2x3fvEXT,
  glProgramUniformMatrix2x4dvEXT,
  glProgramUniformMatrix2x4fvEXT,
  glProgramUniformMatrix3dvEXT,
  glProgramUniformMatrix3fvEXT,
  glProgramUniformMatrix3x2dvEXT,
  glProgramUniformMatrix3x2fvEXT,
  glProgramUniformMatrix3x4dvEXT,
  glProgramUniformMatrix3x4fvEXT,
  glProgramUniformMatrix4dvEXT,
  glProgramUniformMatrix4fvEXT,
  glProgramUniformMatrix4x2dvEXT,
  glProgramUniformMatrix4x2fvEXT,
  glProgramUniformMatrix4x3dvEXT,
  glProgramUniformMatrix4x3fvEXT,
  glPushClientAttribDefaultEXT,
  glTextureBufferEXT,
  glTextureBufferRangeEXT,
  glTextureImage1DEXT,
  glTextureImage2DEXT,
  glTextureImage3DEXT,
  glTexturePageCommitmentEXT,
  glTextureParameterIivEXT,
  glTextureParameterIuivEXT,
  glTextureParameterfEXT,
  glTextureParameterfvEXT,
  glTextureParameteriEXT,
  glTextureParameterivEXT,
  glTextureRenderbufferEXT,
  glTextureStorage1DEXT,
  glTextureStorage2DEXT,
  glTextureStorage2DMultisampleEXT,
  glTextureStorage3DEXT,
  glTextureStorage3DMultisampleEXT,
  glTextureSubImage1DEXT,
  glTextureSubImage2DEXT,
  glTextureSubImage3DEXT,
  glUnmapNamedBufferEXT,
  glVertexArrayBindVertexBufferEXT,
  glVertexArrayColorOffsetEXT,
  glVertexArrayEdgeFlagOffsetEXT,
  glVertexArrayFogCoordOffsetEXT,
  glVertexArrayIndexOffsetEXT,
  glVertexArrayMultiTexCoordOffsetEXT,
  glVertexArrayNormalOffsetEXT,
  glVertexArraySecondaryColorOffsetEXT,
  glVertexArrayTexCoordOffsetEXT,
  glVertexArrayVertexAttribBindingEXT,
  glVertexArrayVertexAttribDivisorEXT,
  glVertexArrayVertexAttribFormatEXT,
  glVertexArrayVertexAttribIFormatEXT,
  glVertexArrayVertexAttribIOffsetEXT,
  glVertexArrayVertexAttribLFormatEXT,
  glVertexArrayVertexAttribLOffsetEXT,
  glVertexArrayVertexAttribOffsetEXT,
  glVertexArrayVertexBindingDivisorEXT,
  glVertexArrayVertexOffsetEXT
) where

import Graphics.GL.ExtensionPredicates
import Graphics.GL.Tokens
import Graphics.GL.Functions
