
//
// $Id: session.cc,v 1.2 2002/07/17 07:13:28 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/session.cc,v $
// $Revision: 1.2 $
// $Date: 2002/07/17 07:13:28 $
// $State: Exp $
//
//
// Class Session
// PURPOSE: store an "individual"s (simulated) session information
//
// Author: Geoff Wong
//

#include <sys/types.h>
#include <unistd.h>

#include "str.h"

#include "session.h"
#include "scenario.h"
#include "if.h"

void 
Session::printSummary(void)
{
	printSummary(0, 0);
}

void
Session::printSummary(Scenario * scn)
{
	printSummary(scn, 0);
}

void
Session::printSummary(Scenario * scn, Result *res)
{
	int timetaken, response, commenceTime, size;
	int returnCode;
	String server;

    if (scn == 0) scn = scenario;
    if (scn == 0) return;

	if (res == 0) 
    {
		commenceTime = -1;
		timetaken = -1;
		response = -1;
		size = 0;
		returnCode = -1;
		server = "unknown";
	} 
    else 
    {
		commenceTime = res->commenceTime;
		timetaken = res->timetaken;
		response = res->response;
		size = res->readLength;
		server = res->serverUsed;
		returnCode = res->returnCode;
	}

    // update totals
    requestTot += requestCnt;
    noResultTot += noResultCnt;
    noVerifyTot += noVerifyCnt;
    elapsedTot += elapsedSubTot;

    if (requestCnt == 0) requestCnt = 1;
    if (requestTot == 0) requestTot = 1;
    
    // calculate times
    //long elapsedSubAvg = elapsedSubTot/requestCnt/1000;
    //long elapsedAvg = elapsedTot/requestTot/1000;
    
    scn->Log(" Pid: " + 
				 itoa(pin) + " " +
				 "Scenario:" + " " +
				 scn->name + " " +
				 //"Delta: " +
                 //itoa(requestCnt) + " " +
                 //itoa(noResultCnt) + " " +
                 //itoa(noVerifyCnt) + " " +
                 //itoa(elapsedSubAvg) + " " +

				 //"Total: " +
                 //itoa(requestTot) + " " +
                 //itoa(noResultTot) + " " +
                 //itoa(elapsedAvg) + " " +
                 //itoa(noVerifyTot) + " " +

				 "Times: " +
				 itoa(commenceTime) + " " +
				 itoa(response) + " " +
				 itoa(timetaken) + " " +

				 "Size: " +
				 itoa(size) + " " +

				 "ReturnCode: " +
				 itoa(returnCode) + " " +

				 "Server: " +	
				 server +
				 "");

    requestCnt = noResultCnt = noVerifyCnt = 0;
    elapsedSubTot = 0;
}    


If * Session::Interface()
{
    return altIf;
}

void Session::AltInterface(long aif)
{
    altIf = new If(aif);
}

Session::Session()
    : altIf(NULL), requestCnt(0), noResultCnt(0), noVerifyCnt(0), 
      elapsedSubTot(0), requestTot(0), noResultTot(0), noVerifyTot(0), 
      elapsedTot(0)
{
    pin = getpid();
}

Session::Session(int x)
    : altIf(NULL), requestCnt(0), noResultCnt(0), noVerifyCnt(0), 
      elapsedSubTot(0), requestTot(0), noResultTot(0), noVerifyTot(0), 
      elapsedTot(0)
{
	pin = x;
}

