 /*
 *  GWBrowser.h: Interface and declarations for the GWBrowser Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef _GWBROWSER_H_
#define _GWBROWSER_H_

#import <AppKit/NSControl.h>

@class NSString;
@class NSArray;
@class NSCell;
@class GWBrowserCell;
@class NSMatrix;
@class NSScrollView;
@class NSScroller;
@class ColumnIcon;

@interface GWBrowserColumn : NSObject
{
  BOOL isLoaded;
  NSScrollView *columnScrollView;
  NSMatrix *columnMatrix;
	ColumnIcon *columnIcon;
  int numberOfRows;
}

- (void)setIsLoaded:(BOOL)flag;
- (BOOL)isLoaded;
- (void)setColumnScrollView:(NSScrollView *)aView;
- (NSScrollView *)columnScrollView;
- (void)setColumnMatrix:(NSMatrix *)aMatrix;
- (NSMatrix *)columnMatrix;
- (void)setColumnIcon:(ColumnIcon *)aIcon;
- (ColumnIcon *)columnIcon;
- (void)setNumberOfRows:(int)num;
- (int)numberOfRows;

@end

@interface GWBrowser : NSControl
{
  GWBrowserCell *cellPrototype;
  NSString *pathSeparator;
	NSString *basePath;
  BOOL isLoaded;
  int maxVisibleColumns;
  float minColumnWidth;
  
  NSScroller *horizontalScroller;
  BOOL skipUpdateScroller;

  id browserDelegate;
  SEL doubleAction;
  NSMutableArray *browserColumns;
  NSSize columnSize;
  NSRect scrollerRect;
  int lastColumnLoaded;
  int firstVisibleColumn;
  int lastVisibleColumn;
	int currentshift;
  id target;
  SEL action;
	NSTimeInterval lastKeyPressed;
  NSString *charBuffer;
  int alphaNumericalLastColumn;
}

//
// Init & C.
//
- (id)initWithFrame:(NSRect)rect basePath:(NSString *)bpath;
- (BOOL)setPath:(NSString *)path;
- (void)setPathSeparator:(NSString *)aString;
- (id)delegate;
- (void)setDelegate:(id)anObject;
- (void)setDoubleAction:(SEL)aSelector;

//
// Manipulating Columns 
//
- (void)addColumn;
- (GWBrowserColumn *)createColumn;
- (void)performLoadOfColumn:(int)column;
- (ColumnIcon *)addIconForColumn:(int)column;
- (void)updateIconOfColumn:(int)column;		
- (void)setLeafIconAtColumn:(int)column;
- (int)columnOfIcon:(ColumnIcon *)icon;
- (void)unloadFromColumn:(int)column;
- (void)emptyMatrix:(NSMatrix *)matrix inColumn:(int)column;
- (void)addCellsWithNames:(NSArray *)names 
                 inColumn:(int)column 
                   dimmed:(BOOL)dimm;
- (void)removeCellsWithNames:(NSArray *)names inColumn:(int)column;
- (int)columnOfMatrix:(NSMatrix *)matrix;
- (int)columnWithPath:(NSString *)path;
- (int)lastValidColumn;
- (void)selectRow:(int)row inColumn:(int)column;
- (GWBrowserCell *)loadedCellAtRow:(int)row column:(int)column;
- (ColumnIcon *)lastIcon;
- (NSPoint)lastIconPosition;
- (void)displayAllColumns;
- (int)firstVisibleColumn;
- (BOOL)isLoaded;
- (int)lastColumn;
- (int)lastVisibleColumn;
- (void)loadColumnZero;
- (int)numberOfVisibleColumns;
- (void)reloadColumn:(int)column;
- (int)selectedColumn;
- (void)setLastColumn:(int)column;
- (NSMatrix *)matrixInColumn:(int)column;
- (GWBrowserCell *)selectedCell;
- (GWBrowserCell *)selectedCellInColumn:(int)column;
- (GWBrowserCell *)cellWithTitle:(NSString *)title inColumn:(int)column;
- (NSArray *)selectionInColumn:(int)column;
- (NSArray *)selectedCells;
- (void)selectCellWithTitle:(NSString *)title 
                   inColumn:(int)column 
                 sendAction:(BOOL)act;
- (void)selectCells:(NSArray *)cells 
           inColumn:(int)column 
      	 sendAction:(BOOL)act;								 
- (void)setMultipleSelection:(NSArray *)titles 
                    inColumn:(int)column 
                  sendAction:(BOOL)act;								 
- (NSString *)pathToColumn:(int)column;
- (NSRect)frameOfColumn:(int)column;
- (void)selectAllInLastColumn;

//
// Arranging an Browser's Components 
//
- (void)setMaxVisibleColumns:(int)columnCount;
- (int)maxVisibleColumns;
- (void)setMinColumnWidth:(int)columnWidth;
- (int)minColumnWidth;
- (void)tile;
- (void)remapColumnSubviews:(BOOL)flag;
- (void)adjustMatrixOfColumn:(int)column;
- (void)setShift:(int)s;
- (int)currentshift;
- (void)scrollColumnsLeftBy:(int)shiftAmount;
- (void)scrollColumnsRightBy:(int)shiftAmount;
- (void)scrollColumnToVisible:(int)column;
- (void)scrollViaScroller:(NSScroller *)sender;
- (void)updateScroller;

//
// Events & Actions
//
- (void)doClick:(id)sender;
- (void)doDoubleClick:(id)sender;
- (SEL)action;
- (SEL)doubleAction;
- (BOOL)sendAction;
- (void)moveLeft:(id)sender;
- (void)moveRight:(id)sender;

@end

//
// Methods Implemented by the Delegate 
//
@interface NSObject (GWBrowserDelegate)

- (void)gwbrowser:(GWBrowser *)sender createRowsForColumn:(int)column
  																					 inMatrix:(NSMatrix *)matrix;
	
- (void)currentSelectedPaths:(NSArray *)paths;

- (void)openSelectedPaths:(NSArray *)paths newViewer:(BOOL)isnew;
																									
- (void)performFileOperationWithDictionary:(id)opdict;

- (NSString *)getTrashPath;																									

- (int)getSortTypeForDirectoryAtPath:(NSString *)path;

@end

//
// ColumnIcon Delegate Methods
//

@interface GWBrowser (ColumnIconDelegateMethods)

- (void)icon:(ColumnIcon *)sender setFrameOfLabel:(NSTextField *)label;

- (void)unselectOtherIcons:(ColumnIcon *)selicon;

- (void)clickOnIcon:(ColumnIcon *)clicked;

- (void)doubleClickOnIcon:(ColumnIcon *)clicked newViewer:(BOOL)isnew;

- (void)performFileOperationWithDictionary:(id)opdict;

- (NSString *)getTrashPath;
	
@end

#endif // _GWBROWSER_H_
