/*  -*-objc-*-
 *  PermissionsPanel.m: Implementation of the PermissionsPanel Class 
 *  of the GNUstep GWorkspace application
 *
 *  Copyright (c) 2001 Enrico Sersale <enrico@imago.ro>
 *  
 *  Author: Enrico Sersale
 *  Date: August 2001
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#import <Foundation/Foundation.h>
#import <AppKit/AppKit.h>
#include "PermissionsPanel.h"
#include "PermsBox.h"
#include "Functions.h"
#include "GNUstep.h"
#include <unistd.h>
#include <sys/types.h>

@implementation PermissionsPanel

- (void)dealloc
{
	RELEASE (insppaths);
	RELEASE (currentPath);
	RELEASE (multipleIcon);	
	RELEASE (attributes);
	RELEASE (fileIcon);
	RELEASE (namefield);
	RELEASE (pathfield);
	RELEASE (permissionsBox);	
	RELEASE (insidefield);	
	RELEASE (insidelabel);	
	RELEASE (insidebutt);	
	RELEASE (revertbutt);
	RELEASE (okbutt);		
  [super dealloc];
}

- (id)init
{
	id label;
		
	self = [super init];
	if(self) {
		[self setFrame: NSMakeRect(0, 0, 274, 385)];	
			
		multipleIcon = [NSImage imageNamed: @"MultipleSelection.tiff"];
    RETAIN (multipleIcon);

		fm = [NSFileManager defaultManager];
		insppaths = nil;
		fileIcon = nil;
		
		recursive = NO;

		MAKE_LABEL (namefield, NSMakeRect(66, 343, 200, 25), nil, 'l', NO, self);		
		[namefield setFont: [NSFont systemFontOfSize: 18]];				
		MAKE_LOCALIZED_LABEL (label, NSMakeRect(9, 301, 40, 20), @"Path:", @"", 'l', YES, self);		
		MAKE_LABEL (pathfield, NSMakeRect(44, 301, 215, 20), nil, 'l', NO, self);		

    permissionsBox = [[PermsBox2 alloc] initInPanel: self];																	
		[permissionsBox setFrameOrigin: NSMakePoint(30, 141)];
		[self addSubview: permissionsBox]; 		

		insidefield = nil;
		insidebutt = nil;
		insidelabel = nil;
	
 		revertbutt = [[NSButton alloc] initWithFrame: NSMakeRect(17, 10, 115, 24)];
		[revertbutt setButtonType: NSMomentaryLight];
		[revertbutt setTitle: NSLocalizedString(@"Revert", @"")];		
		[revertbutt setTarget: self];
		[revertbutt setAction: @selector(revertToOldPermissions:)];
		[self addSubview: revertbutt]; 

		okbutt = [[NSButton alloc] initWithFrame: NSMakeRect(140, 10, 115, 24)];
		[okbutt setButtonType: NSMomentaryLight];
		[okbutt setTitle: NSLocalizedString(@"OK", @"")];	
		[okbutt setKeyEquivalent: @"\r"];
		[okbutt setImagePosition: NSImageRight];
		[okbutt setImage: [NSImage imageNamed: @"common_ret"]];	
		[okbutt setTarget: self];
		[okbutt setAction: @selector(changePermissions:)];
		[self addSubview: okbutt]; 
	}
	return self;
}

- (void)activateForPaths:(NSArray *)paths
{
	NSString *fpath;
	NSString *ftype, *s;
	NSString *usr, *grp, *tmpusr;
	NSDictionary *attrs;
	int perms;
	BOOL sameOwner;
	int i;
		
	attrs = [fm fileAttributesAtPath: [paths objectAtIndex: 0] traverseLink: NO];
	if ([attrs isEqualToDictionary: attributes] && [paths isEqualToArray: insppaths] == YES) {
		return;
	}

	ASSIGN (insppaths, paths);	
	pathscount = [insppaths count];	
	ASSIGN (currentPath, [insppaths objectAtIndex: 0]);		
	ASSIGN (attributes, attrs);	

	[revertbutt setEnabled: NO];
	[okbutt setEnabled: NO];
	
	if(pathscount == 1) {   // Single Selection
		usr = [attributes objectForKey: NSFileOwnerAccountName];
		grp = [attributes objectForKey: NSFileGroupOwnerAccountName];
		perms = [[attributes objectForKey: NSFilePosixPermissions] intValue];			

		iamRoot = (geteuid() == 0);
		isMyFile = ([NSUserName() isEqualToString: usr]);

		ASSIGN (fileIcon, [[NSWorkspace sharedWorkspace] iconForFile: currentPath]);

		[namefield setStringValue: [currentPath lastPathComponent]];

		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];

		[permissionsBox setPermissions: perms isActive: (iamRoot || isMyFile)];

		ftype = [attributes objectForKey: NSFileType];
		if ([ftype isEqualToString: NSFileTypeDirectory] == NO) {		
			if (insidefield != nil) {
				[insidefield removeFromSuperview];
				[insidebutt setState: NSOffState];
				[insidebutt removeFromSuperview];
			}
			if (insidelabel != nil) {
				[insidelabel removeFromSuperview];
      }
		} else {
			if (insidefield == nil) {					
				MAKE_LOCALIZED_LABEL (insidefield, NSMakeRect(6, 115, 210, 20), @"Also apply to files inside selection", @"", 'r', NO, self);		
			}
			if (insidebutt == nil) {		
				insidebutt = [[NSButton alloc] initWithFrame: NSMakeRect(224, 118, 16, 16)];
				[insidebutt setButtonType: NSSwitchButton];
				[insidebutt setBordered: NO];
				[insidebutt setTarget: self];
				[insidebutt setAction: @selector(insideButtonClicked:)];
			}
			[self addSubview: insidefield]; 
			[insidebutt setEnabled: (iamRoot || isMyFile)];	
			[self addSubview: insidebutt]; 
			[self insideButtonClicked: insidebutt];
		}

	} else {	   // Multiple Selection
	
		ftype = [attributes objectForKey: NSFileType];
		
		usr = [attributes objectForKey: NSFileOwnerAccountName];
		grp = [attributes objectForKey: NSFileGroupOwnerAccountName];
		perms = [[attributes objectForKey: NSFilePosixPermissions] intValue];			

		sameOwner = YES;	
		for (i = 0; i < [insppaths count]; i++) {
			fpath = [insppaths objectAtIndex: i];
			attrs = [fm fileAttributesAtPath: fpath traverseLink: NO];
			tmpusr = [attrs objectForKey: NSFileOwnerAccountName];
			if ([tmpusr isEqualToString: usr] == NO) {
				sameOwner = NO;
			}
		}
		
		if(sameOwner == NO) {
			usr = @"";
    }
    
		iamRoot = (geteuid() == 0);
		isMyFile = ([NSUserName() isEqualToString: usr]);
	
		ASSIGN (fileIcon, multipleIcon);
		
		[namefield setStringValue: [NSString stringWithFormat: @"%i items", pathscount]];

		s = [currentPath stringByDeletingLastPathComponent];
		s = relativePathFittingInContainer(pathfield, s);
		[pathfield setStringValue: s];

		[permissionsBox setPermissions: 0 isActive: (iamRoot || isMyFile)];

		if (insidefield == nil) {			
			MAKE_LOCALIZED_LABEL (insidefield, NSMakeRect(6, 115, 210, 20), @"Also apply to files inside selection", @"", 'r', NO, self);		
		}
		if (insidebutt == nil) {		
			insidebutt = [[NSButton alloc] initWithFrame: NSMakeRect(224, 118, 16, 16)];
			[insidebutt setButtonType: NSSwitchButton];
			[insidebutt setBordered: NO];
			[insidebutt setTarget: self];
			[insidebutt setAction: @selector(insideButtonClicked:)];		
		}
		[self addSubview: insidefield]; 
		[insidebutt setEnabled: (iamRoot || isMyFile)];	
		[self addSubview: insidebutt]; 
		[self insideButtonClicked: insidebutt];
	}
	
	[self setNeedsDisplay: YES];
}

- (void)deactivate
{
	[self removeFromSuperview];
}

- (NSString *)inspname
{
	return NSLocalizedString(@"Access Control", @"");
}

- (NSString *)winname
{
	return NSLocalizedString(@"UNIX Permissions", @"");
}

- (NSButton *)revertButton
{
	return revertbutt;
}

- (NSButton *)okButton
{
	return okbutt;
}

- (void)insideButtonClicked:(id)sender
{
	int perms;
	
	if ([sender state] == NSOnState) {
		recursive = YES;
		[permissionsBox setPermissions: 0 isActive: YES];
		if (insidelabel == nil) {
			MAKE_LABEL (insidelabel, NSMakeRect(10, 72, 254, 40), @"Click OK to change permissions\nrecursively in selection", 'c', NO, self);		
			[insidelabel setTextColor: [NSColor grayColor]];
		}
		[self addSubview: insidelabel];
	} else {
		recursive = NO;
		if (pathscount == 1) {
			perms = [[attributes objectForKey: NSFilePosixPermissions] intValue];
			[permissionsBox setPermissions: perms isActive: YES];
		} else {
			[permissionsBox setPermissions: 0 isActive: YES];
		}
		if(insidelabel != nil) 
			[insidelabel removeFromSuperview];
	}	 
	
	[self setNeedsDisplay: YES];
}

- (void)permsButtonClicked
{
	if((iamRoot || isMyFile) == NO) {
		return;
	}
	[revertbutt setEnabled: YES];	
	[okbutt setEnabled: YES];
}

- (void)changePermissions:(id)sender
{
	NSMutableDictionary *attrs;
	NSDirectoryEnumerator *enumerator;	
	NSString *path, *fpath, *ftype;
	int oldperms, newperms, i;
	BOOL isdir;
	
	if(pathscount == 1) {
		[fm fileExistsAtPath: currentPath isDirectory: &isdir];

		if ((recursive == YES) && (isdir == YES)) {
			enumerator = [fm enumeratorAtPath: currentPath];
			while ((fpath = [enumerator nextObject])) {
				fpath = [currentPath stringByAppendingPathComponent: fpath];
				attrs = [[fm fileAttributesAtPath: fpath traverseLink: NO] mutableCopy];
				if (attrs != nil) {			
					oldperms = [[attrs objectForKey: NSFilePosixPermissions] intValue];	
					newperms = [permissionsBox getPermissions: oldperms];			
					[attrs setObject: [NSNumber numberWithInt: newperms] forKey: NSFilePosixPermissions];
					[fm changeFileAttributes: attrs atPath: fpath];
					ftype = [attrs objectForKey: NSFileType];
					if ([ftype isEqualToString: NSFileTypeDirectory]) {		
						[[NSNotificationCenter defaultCenter]
 									postNotificationName: @"GWDidSetFileAttributesNotification"
	 					  							  object: (id)fpath];
					}
				}
			}
			RELEASE (attributes);
			attributes = [fm fileAttributesAtPath: currentPath traverseLink: NO];	
      RETAIN (attributes);
			[permissionsBox setPermissions: 0 isActive: YES];

		} else {
			oldperms = [[attributes objectForKey: NSFilePosixPermissions] intValue];
			newperms = [permissionsBox getPermissions: oldperms];		
			attrs = [attributes mutableCopy];
			[attrs setObject: [NSNumber numberWithInt: newperms] forKey: NSFilePosixPermissions];
			[fm changeFileAttributes: attrs atPath: currentPath];	
			RELEASE (attributes);
			attributes = [fm fileAttributesAtPath: currentPath traverseLink: NO];	
      RETAIN (attributes);
			newperms = [[attributes objectForKey: NSFilePosixPermissions] intValue];				
			[permissionsBox setPermissions: newperms isActive: YES];
		}
	
	} else {
	
		for (i = 0; i < [insppaths count]; i++) {
			path = [insppaths objectAtIndex: i];
			[fm fileExistsAtPath: path isDirectory: &isdir];
			
			if ((recursive == YES) && (isdir == YES)) {
				enumerator = [fm enumeratorAtPath: path];
				while ((fpath = [enumerator nextObject])) {
					fpath = [path stringByAppendingPathComponent: fpath];
					attrs = [[fm fileAttributesAtPath: fpath traverseLink: NO] mutableCopy];
					if (attrs != nil) {			
						oldperms = [[attrs objectForKey: NSFilePosixPermissions] intValue];	
						newperms = [permissionsBox getPermissions: oldperms];			
						[attrs setObject: [NSNumber numberWithInt: newperms] forKey: NSFilePosixPermissions];
						[fm changeFileAttributes: attrs atPath: fpath];
						ftype = [attrs objectForKey: NSFileType];
						if ([ftype isEqualToString: NSFileTypeDirectory]) {		
							[[NSNotificationCenter defaultCenter]
 										postNotificationName: @"GWDidSetFileAttributesNotification"
	 					  								  object: (id)fpath];
						}
					}
				}
				
			} else {
				attrs = [[fm fileAttributesAtPath: path traverseLink: NO] mutableCopy];
				oldperms = [[attrs objectForKey: NSFilePosixPermissions] intValue];	
				newperms = [permissionsBox getPermissions: oldperms];			
				[attrs setObject: [NSNumber numberWithInt: newperms] forKey: NSFilePosixPermissions];
				[fm changeFileAttributes: attrs atPath: path];				
			}
		}
		
		RELEASE (attributes);
		attributes = [fm fileAttributesAtPath: currentPath traverseLink: NO];	
    RETAIN (attributes);
		[permissionsBox setPermissions: 0 isActive: YES];
	}

	[[NSNotificationCenter defaultCenter]
 		postNotificationName: @"GWDidSetFileAttributesNotification"
	 					  object: (id)[currentPath stringByDeletingLastPathComponent]];

	[okbutt setEnabled: NO];
	[revertbutt setEnabled: NO];
	[self setNeedsDisplay: YES];
}

- (void)revertToOldPermissions:(id)sender
{
	if (pathscount == 1) {
		int perms = [[attributes objectForKey: NSFilePosixPermissions] intValue];
		[permissionsBox setPermissions: perms isActive: YES];	
	} else {
		[permissionsBox setPermissions: 0 isActive: YES];
	}
	
	[revertbutt setEnabled: NO];
	[okbutt setEnabled: NO];
}

- (void)drawRect:(NSRect)rect
{
	STROKE_LINE (darkGrayColor, 0, 385, 274, 385);
	STROKE_LINE (whiteColor, 0, 384, 274, 384);

	if(fileIcon != nil) {
    [fileIcon compositeToPoint: NSMakePoint(8, 325) operation: NSCompositeSourceOver];
  }

	STROKE_LINE (darkGrayColor, 0, 294, 274, 294);
	STROKE_LINE (whiteColor, 0, 293, 274, 293);
}

@end
