/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/
#ifndef MAINWINDOW_H
#define MAINWINDOW_H


#include <kdockwidget.h>


class KAction;
class KAccel;

class FileView;
class DirView;
class GVPixmap;
class PixmapView;
class StatusBarProgress;


class MainWindow : public KDockMainWindow {
Q_OBJECT
public:
	MainWindow();
	~MainWindow();

	FileView* fileView() const { return mFileView; }
	PixmapView* pixmapView() const { return mPixmapView; }

public slots:
	void setPath(QString);
	void setFilename(QString);

private:
	KDockWidget* mFolderDock;
	KDockWidget* mFileDock;
	KDockWidget* mPixmapDock;
	StatusBarProgress* mProgress;

	FileView* mFileView;
	DirView* mDirView;
	PixmapView* mPixmapView;

	bool mFullScreen;
	QString mFolder,mFilename;
	GVPixmap* mGVPixmap;

	KAction* mOpenFile;
	KAction* mRenameFile;
	KAction* mCopyFile;
	KAction* mMoveFile;
	KAction* mDeleteFile;
	KAction* mOpenWithEditor;
	KAction* mShowConfigDialog;
	KAction* mShowKeyDialog;
	KAction* mToggleFullScreen;
	KAction* mStop;
	KAccel* mAccel;

	void createWidgets();
	void createActions();
	void createAccels();
	void createMenu();
	void createToolBar();
	void createFileViewPopupMenu();
	void createScrollPixmapViewPopupMenu();

private slots:
	void openFile();
	void toggleFullScreen();
	void showConfigDialog();
	void showKeyDialog();
	void pixmapLoading();
	void pixmapLoaded();
	void openWithEditor();

// Status bar update
	/**
	 * Update both folder and file status bar
	 */
	void updateStatusBar();

	/**
	 * Update only file status bar, allows setting file info
	 * when folder info is not available yet
	 */
	void updateFileStatusBar();

	void thumbnailUpdateStarted(int);
	void thumbnailUpdateEnded();
	void thumbnailUpdateProcessedOne();

	/**
	 * Allow quitting full screen mode by pressing Escape key.
	 */
	void escapePressed();
};


#endif
