/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef FULLSCREENWIDGET_H
#define FULLSCREENWIDGET_H


// QT includes
#include <qwidget.h>


class GVPixmap;
class KConfig;
class QPainter;


class FullScreenView : public QWidget {
Q_OBJECT
public:
	FullScreenView(QWidget* parent,GVPixmap* image,bool);
	void enableView(bool);

	void readConfig(KConfig*,const QString&);
	void writeConfig(KConfig*,const QString&) const;

	void setShowPath(bool);
	bool showPath() const { return mShowPath; }
	
public slots:
	void updateView();

protected:
	void keyReleaseEvent(QKeyEvent* event);
	void paintEvent(QPaintEvent *event);
	void mouseReleaseEvent(QMouseEvent *event);
	void wheelEvent(QWheelEvent *event);

private:
	GVPixmap* mGVPixmap;
	int mPosX,mPosY;
	bool mShowPath;
	
	void paintPixmap(QPainter*);
	void paintPath(QPainter*);

signals:
	void selectPrevious();
	void selectNext();
	void escapePressed();
};



#endif
