/* $Id: guile-ext.h,v 1.3 2001/08/20 04:27:58 sgt Exp $
 * guile-ext.h
 * 
 * Extensions I hope will become a part of guile
 * Organized here by Steve Tell, with  inspiration 
 * from libguile/snarf.h and SCWM's documentation system.
 * 

 */


#ifndef GUILE_EXT_H__
#define GUILE_EXT_H__

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/* three ways of making a hook, taken from SCWM's compatibility layer */
#ifndef HAVE_SCM_MAKE_HOOK
#define SCM__INIT_HOOK(var, name, nargs) do { var = scm_sysintern(name, SCM_EOL); } while (0)
#else
#ifdef HAVE_SCM_CREATE_HOOK
#define SCM__INIT_HOOK(var, name, nargs) do { var = scm_create_hook(name,nargs); } while (0)
#else
#define SCM__INIT_HOOK(var, name, nargs) do { var = scm_make_named_hook(name,nargs); } while (0)
#endif
#endif

#include <libguile/snarf.h>


/*
 * Guile 1.4 snarfing features that we rely on.  This lets us work
 * with guile-1.3.4, at least.
 */
#ifndef SCM_SNARF_HERE
#ifndef SCM_MAGIC_SNARFER
#  define SCM_SNARF_HERE(X) X
#  define SCM_SNARF_INIT(X)
#  define SCM_SNARF_DOCS(X)
#else
#  define SCM_SNARF_HERE(X)
#  define SCM_SNARF_INIT(X) SCM__I X
#  define SCM_SNARF_DOCS(X) X
#endif
#endif

#ifndef SCM_FUNC_CAST_ARBITRARY_ARGS
#define SCM_FUNC_CAST_ARBITRARY_ARGS SCM (*)()
#endif

#ifndef SCM_DEFINE
#define SCM_DEFINE(FNAME, PRIMNAME, REQ, OPT, VAR, ARGLIST, DOCSTRING) \
SCM_SNARF_HERE(\
static const char s_ ## FNAME [] = PRIMNAME; \
SCM FNAME ARGLIST\
)\
SCM_SNARF_INIT(\
scm_make_gsubr (s_ ## FNAME, REQ, OPT, VAR, \
                (SCM_FUNC_CAST_ARBITRARY_ARGS) FNAME); \
)\
SCM_SNARF_DOCS(\
SCM__DP PRIMNAME #ARGLIST | REQ | OPT | VAR | __FILE__:__LINE__ | SCM__S DOCSTRING SCM__E \
)
#endif

#define SCM_HOOK(var, name, nargs, arglist, docstring) \
SCM_SNARF_HERE(static SCM var)\
SCM_SNARF_INIT( SCM__INIT_HOOK(var, name, nargs) ); \
SCM_SNARF_DOCS(\
SCM__DH name #arglist | nargs | 0 | 0 | __FILE__:__LINE__ | SCM__S docstring SCM__E \
)

#define SCM_GLOBAL_HOOK(var, name, nargs, arglist, docstring) \
SCM_SNARF_HERE(SCM var)\
SCM_SNARF_INIT( SCM__INIT_HOOK(var, name, nargs) ); \
SCM_SNARF_DOCS(\
SCM__DH name #arglist | args | 0 | 0 | __FILE__:__LINE__ | SCM__S docstring SCM__E \
)

#define SCM_CONCEPT(name, docstring)\
SCM_SNARF_DOCS(\
SCM__XC name | __FILE__:__LINE__ | SCM__S docstring SCM__E\
)

/* override SCM_VCELL and friends from snarf.h with our documenting
 * versions.
 */
#undef SCM_VCELL
#undef SCM_VCELL_INIT
#undef SCM_GLOBAL_VCELL
#undef SCM_GLOBAL_VCELL_INIT

#define SCM_VCELL(c_name, scheme_name, docstring) \
SCM_SNARF_HERE(static SCM c_name) \
SCM_SNARF_INIT(c_name = scm_permanent_object (scm_intern0 (scheme_name)); SCM_SETCDR (c_name, SCM_BOOL_F)); \
SCM_SNARF_DOCS(\
SCM__XV scheme_name | __FILE__:__LINE__ | SCM__S docstring SCM__E\
\
)

#define SCM_GLOBAL_VCELL(c_name, scheme_name, docstring) \
SCM_SNARF_HERE(SCM c_name) \
SCM_SNARF_INIT(c_name = scm_permanent_object (scm_intern0 (scheme_name)); SCM_SETCDR (c_name, SCM_BOOL_F)); \
SCM_SNARF_DOCS(\
SCM__XV scheme_name | __FILE__:__LINE__ | SCM__S docstring SCM__E\
\
)

#define SCM_VCELL_INIT(c_name, scheme_name, init_val, docstring) \
SCM_SNARF_HERE(static SCM c_name) \
SCM_SNARF_INIT(c_name = scm_permanent_object (scm_intern0 (scheme_name)); SCM_SETCDR (c_name, init_val));\
SCM_SNARF_DOCS(\
SCM__XV scheme_name | __FILE__:__LINE__ | SCM__S docstring SCM__E\
\
)

#define SCM_GLOBAL_VCELL_INIT(c_name, scheme_name, init_val, docstring) \
SCM_SNARF_HERE(SCM c_name) \
SCM_SNARF_INIT(c_name = scm_permanent_object (scm_intern0 (scheme_name)); SCM_SETCDR (c_name, init_val));\
SCM_SNARF_DOCS(\
SCM__XV scheme_name | __FILE__:__LINE__ | SCM__S docstring SCM__E\
\
)

#endif /* GUILE_EXT_H__ */

